/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket;

import io.netty.buffer.Unpooled;
import io.netty.util.collection.IntObjectHashMap;
import io.rsocket.DuplexConnection;
import io.rsocket.Frame;
import io.rsocket.FrameType;
import io.rsocket.Payload;
import io.rsocket.RSocket;
import io.rsocket.StreamIdSupplier;
import io.rsocket.exceptions.ConnectionException;
import io.rsocket.exceptions.Exceptions;
import io.rsocket.internal.LimitableRequestPublisher;
import io.rsocket.internal.UnboundedProcessor;
import io.rsocket.util.ExceptionUtil;
import java.nio.channels.ClosedChannelException;
import java.time.Duration;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;
import reactor.core.publisher.SignalType;
import reactor.core.publisher.UnicastProcessor;

class RSocketClient
implements RSocket {
    private static final ClosedChannelException CLOSED_CHANNEL_EXCEPTION = ExceptionUtil.noStacktrace(new ClosedChannelException());
    private final DuplexConnection connection;
    private final Function<Frame, ? extends Payload> frameDecoder;
    private final Consumer<Throwable> errorConsumer;
    private final StreamIdSupplier streamIdSupplier;
    private final MonoProcessor<Void> started;
    private final IntObjectHashMap<LimitableRequestPublisher> senders;
    private final IntObjectHashMap<Subscriber<Payload>> receivers;
    private final AtomicInteger missedAckCounter;
    private final UnboundedProcessor<Frame> sendProcessor;
    @Nullable
    private Disposable keepAliveSendSub;
    private volatile long timeLastTickSentMs;

    RSocketClient(DuplexConnection connection, Function<Frame, ? extends Payload> frameDecoder, Consumer<Throwable> errorConsumer, StreamIdSupplier streamIdSupplier) {
        this(connection, frameDecoder, errorConsumer, streamIdSupplier, Duration.ZERO, Duration.ZERO, 0);
    }

    RSocketClient(DuplexConnection connection, Function<Frame, ? extends Payload> frameDecoder, Consumer<Throwable> errorConsumer, StreamIdSupplier streamIdSupplier, Duration tickPeriod, Duration ackTimeout, int missedAcks) {
        this.connection = connection;
        this.frameDecoder = frameDecoder;
        this.errorConsumer = errorConsumer;
        this.streamIdSupplier = streamIdSupplier;
        this.started = MonoProcessor.create();
        this.senders = new IntObjectHashMap(256, 0.9f);
        this.receivers = new IntObjectHashMap(256, 0.9f);
        this.missedAckCounter = new AtomicInteger();
        this.sendProcessor = new UnboundedProcessor();
        if (!Duration.ZERO.equals(tickPeriod)) {
            long ackTimeoutMs = ackTimeout.toMillis();
            this.keepAliveSendSub = this.started.thenMany((Publisher)Flux.interval((Duration)tickPeriod)).doOnSubscribe(s -> {
                this.timeLastTickSentMs = System.currentTimeMillis();
            }).concatMap(i -> this.sendKeepAlive(ackTimeoutMs, missedAcks)).doOnError(t -> {
                errorConsumer.accept((Throwable)t);
                connection.close().subscribe();
            }).subscribe();
        }
        connection.onClose().doFinally(signalType -> this.cleanup()).doOnError(errorConsumer).subscribe();
        connection.send((Publisher<Frame>)this.sendProcessor).doOnError(this::handleSendProcessorError).doFinally(this::handleSendProcessorCancel).subscribe();
        connection.receive().doOnSubscribe(subscription -> this.started.onComplete()).doOnNext(this::handleIncomingFrames).doOnError(errorConsumer).subscribe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSendProcessorError(Throwable t) {
        Collection values1;
        Collection values;
        Iterator iterator = this;
        synchronized (iterator) {
            values = this.receivers.values();
            values1 = this.senders.values();
        }
        for (Subscriber subscriber : values) {
            try {
                subscriber.onError(t);
            }
            catch (Throwable e) {
                this.errorConsumer.accept(e);
            }
        }
        for (LimitableRequestPublisher p : values1) {
            p.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSendProcessorCancel(SignalType t) {
        Collection values1;
        Collection values;
        if (SignalType.ON_ERROR == t) {
            return;
        }
        Iterator iterator = this;
        synchronized (iterator) {
            values = this.receivers.values();
            values1 = this.senders.values();
        }
        for (Subscriber subscriber : values) {
            try {
                subscriber.onError(new Throwable("closed connection"));
            }
            catch (Throwable e) {
                this.errorConsumer.accept(e);
            }
        }
        for (LimitableRequestPublisher p : values1) {
            p.cancel();
        }
    }

    private Mono<Void> sendKeepAlive(long ackTimeoutMs, int missedAcks) {
        return Mono.fromRunnable(() -> {
            int count;
            long now = System.currentTimeMillis();
            if (now - this.timeLastTickSentMs > ackTimeoutMs && (count = this.missedAckCounter.incrementAndGet()) >= missedAcks) {
                String message = String.format("Missed %d keep-alive acks with a threshold of %d and a ack timeout of %d ms", count, missedAcks, ackTimeoutMs);
                throw new ConnectionException(message);
            }
            this.sendProcessor.onNext(Frame.Keepalive.from(Unpooled.EMPTY_BUFFER, true));
        });
    }

    @Override
    public Mono<Void> fireAndForget(Payload payload) {
        Mono defer = Mono.fromRunnable(() -> {
            int streamId = this.streamIdSupplier.nextStreamId();
            Frame requestFrame = Frame.Request.from(streamId, FrameType.FIRE_AND_FORGET, payload, 1);
            payload.release();
            this.sendProcessor.onNext(requestFrame);
        });
        return this.started.then(defer);
    }

    @Override
    public Mono<Payload> requestResponse(Payload payload) {
        return this.handleRequestResponse(payload);
    }

    @Override
    public Flux<Payload> requestStream(Payload payload) {
        return this.handleRequestStream(payload);
    }

    @Override
    public Flux<Payload> requestChannel(Publisher<Payload> payloads) {
        return this.handleChannel((Flux<Payload>)Flux.from(payloads), FrameType.REQUEST_CHANNEL);
    }

    @Override
    public Mono<Void> metadataPush(Payload payload) {
        Frame requestFrame = Frame.Request.from(0, FrameType.METADATA_PUSH, payload, 1);
        payload.release();
        this.sendProcessor.onNext(requestFrame);
        return Mono.empty();
    }

    @Override
    public double availability() {
        return this.connection.availability();
    }

    @Override
    public Mono<Void> close() {
        return this.connection.close();
    }

    @Override
    public Mono<Void> onClose() {
        return this.connection.onClose();
    }

    public Flux<Payload> handleRequestStream(Payload payload) {
        return this.started.thenMany((Publisher)Flux.defer(() -> {
            int streamId = this.streamIdSupplier.nextStreamId();
            UnicastProcessor receiver = UnicastProcessor.create();
            RSocketClient rSocketClient = this;
            synchronized (rSocketClient) {
                this.receivers.put(streamId, (Object)receiver);
            }
            AtomicBoolean first = new AtomicBoolean(false);
            return receiver.doOnRequest(l -> {
                if (first.compareAndSet(false, true) && !receiver.isTerminated()) {
                    Frame requestFrame = Frame.Request.from(streamId, FrameType.REQUEST_STREAM, payload, l);
                    payload.release();
                    this.sendProcessor.onNext(requestFrame);
                } else if (this.contains(streamId) && !receiver.isTerminated()) {
                    this.sendProcessor.onNext(Frame.RequestN.from(streamId, l));
                }
                this.sendProcessor.drain();
            }).doOnError(t -> {
                if (this.contains(streamId) && !receiver.isTerminated()) {
                    this.sendProcessor.onNext(Frame.Error.from(streamId, t));
                }
            }).doOnCancel(() -> {
                if (this.contains(streamId) && !receiver.isTerminated()) {
                    this.sendProcessor.onNext(Frame.Cancel.from(streamId));
                }
            }).doFinally(s -> this.removeReceiver(streamId));
        }));
    }

    private Mono<Payload> handleRequestResponse(Payload payload) {
        return this.started.then(Mono.defer(() -> {
            int streamId = this.streamIdSupplier.nextStreamId();
            Frame requestFrame = Frame.Request.from(streamId, FrameType.REQUEST_RESPONSE, payload, 1);
            payload.release();
            MonoProcessor receiver = MonoProcessor.create();
            RSocketClient rSocketClient = this;
            synchronized (rSocketClient) {
                this.receivers.put(streamId, (Object)receiver);
            }
            this.sendProcessor.onNext(requestFrame);
            return receiver.doOnError(t -> this.sendProcessor.onNext(Frame.Error.from(streamId, t))).doOnCancel(() -> this.sendProcessor.onNext(Frame.Cancel.from(streamId))).doFinally(s -> this.removeReceiver(streamId));
        }));
    }

    private Flux<Payload> handleChannel(final Flux<Payload> request, final FrameType requestType) {
        return this.started.thenMany((Publisher)Flux.defer((Supplier)new Supplier<Flux<Payload>>(){
            final UnicastProcessor<Payload> receiver = UnicastProcessor.create();
            final int streamId = RSocketClient.access$000(RSocketClient.this).nextStreamId();
            @Nullable
            volatile MonoProcessor<Void> subscribedRequests;
            boolean firstRequest = true;

            boolean isValidToSendFrame() {
                return RSocketClient.this.contains(this.streamId) && !this.receiver.isTerminated();
            }

            void sendOneFrame(Frame frame) {
                if (this.isValidToSendFrame()) {
                    RSocketClient.this.sendProcessor.onNext(frame);
                }
            }

            @Override
            public Flux<Payload> get() {
                return this.receiver.doOnRequest(l -> {
                    boolean _firstRequest = false;
                    RSocketClient rSocketClient = RSocketClient.this;
                    synchronized (rSocketClient) {
                        if (this.firstRequest) {
                            _firstRequest = true;
                            this.firstRequest = false;
                        }
                    }
                    if (_firstRequest) {
                        final AtomicBoolean firstPayload = new AtomicBoolean(true);
                        Flux requestFrames = request.transform(f -> {
                            LimitableRequestPublisher wrapped = LimitableRequestPublisher.wrap(f);
                            wrapped.increaseRequestLimit(1L);
                            RSocketClient rSocketClient = RSocketClient.this;
                            synchronized (rSocketClient) {
                                RSocketClient.this.senders.put(this.streamId, wrapped);
                                RSocketClient.this.receivers.put(this.streamId, this.receiver);
                            }
                            return wrapped;
                        }).map((Function)new Function<Payload, Frame>(){

                            @Override
                            public Frame apply(Payload payload) {
                                Frame requestFrame = firstPayload.compareAndSet(true, false) ? Frame.Request.from(streamId, requestType, payload, l) : Frame.PayloadFrame.from(streamId, FrameType.NEXT, payload);
                                payload.release();
                                return requestFrame;
                            }
                        }).doOnComplete(() -> {
                            if (FrameType.REQUEST_CHANNEL == requestType) {
                                this.sendOneFrame(Frame.PayloadFrame.from(this.streamId, FrameType.COMPLETE));
                                if (firstPayload.get()) {
                                    this.receiver.onComplete();
                                }
                            }
                        });
                        requestFrames.doOnNext(RSocketClient.this.sendProcessor::onNext).doOnError(t -> {
                            RSocketClient.this.errorConsumer.accept(t);
                            this.receiver.dispose();
                        }).subscribe();
                    } else {
                        this.sendOneFrame(Frame.RequestN.from(this.streamId, l));
                    }
                }).doOnError(t -> this.sendOneFrame(Frame.Error.from(this.streamId, t))).doOnCancel(() -> {
                    this.sendOneFrame(Frame.Cancel.from(this.streamId));
                    if (this.subscribedRequests != null) {
                        this.subscribedRequests.cancel();
                    }
                }).doFinally(s -> {
                    RSocketClient.this.removeReceiver(this.streamId);
                    RSocketClient.this.removeSender(this.streamId);
                });
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean contains(int streamId) {
        RSocketClient rSocketClient = this;
        synchronized (rSocketClient) {
            return this.receivers.containsKey(streamId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanup() {
        Collection publishers;
        Collection subscribers;
        RSocketClient rSocketClient = this;
        synchronized (rSocketClient) {
            subscribers = this.receivers.values();
            publishers = this.senders.values();
            this.senders.clear();
            this.receivers.clear();
        }
        subscribers.forEach(this::cleanUpSubscriber);
        publishers.forEach(this::cleanUpLimitableRequestPublisher);
        if (null != this.keepAliveSendSub) {
            this.keepAliveSendSub.dispose();
        }
    }

    private synchronized void cleanUpLimitableRequestPublisher(LimitableRequestPublisher<?> limitableRequestPublisher) {
        try {
            limitableRequestPublisher.cancel();
        }
        catch (Throwable t) {
            this.errorConsumer.accept(t);
        }
    }

    private synchronized void cleanUpSubscriber(Subscriber<?> subscriber) {
        try {
            subscriber.onError((Throwable)CLOSED_CHANNEL_EXCEPTION);
        }
        catch (Throwable t) {
            this.errorConsumer.accept(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleIncomingFrames(Frame frame) {
        try {
            int streamId = frame.getStreamId();
            FrameType type = frame.getType();
            if (streamId == 0) {
                this.handleStreamZero(type, frame);
            } else {
                this.handleFrame(streamId, type, frame);
            }
        }
        finally {
            frame.release();
        }
    }

    private void handleStreamZero(FrameType type, Frame frame) {
        switch (type) {
            case ERROR: {
                throw Exceptions.from(frame);
            }
            case LEASE: {
                break;
            }
            case KEEPALIVE: {
                if (Frame.Keepalive.hasRespondFlag(frame)) break;
                this.timeLastTickSentMs = System.currentTimeMillis();
                break;
            }
            default: {
                this.errorConsumer.accept(new IllegalStateException("Client received supported frame on stream 0: " + frame.toString()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleFrame(int streamId, FrameType type, Frame frame) {
        Subscriber receiver;
        RSocketClient rSocketClient = this;
        synchronized (rSocketClient) {
            receiver = (Subscriber)this.receivers.get(streamId);
        }
        if (receiver == null) {
            this.handleMissingResponseProcessor(streamId, type, frame);
        } else {
            switch (type) {
                case ERROR: {
                    receiver.onError((Throwable)Exceptions.from(frame));
                    this.removeReceiver(streamId);
                    break;
                }
                case NEXT_COMPLETE: {
                    receiver.onNext((Object)this.frameDecoder.apply(frame));
                    receiver.onComplete();
                    break;
                }
                case CANCEL: {
                    LimitableRequestPublisher sender;
                    RSocketClient rSocketClient2 = this;
                    synchronized (rSocketClient2) {
                        sender = (LimitableRequestPublisher)((Object)this.senders.remove(streamId));
                        this.removeReceiver(streamId);
                    }
                    if (sender == null) break;
                    sender.cancel();
                    break;
                }
                case NEXT: {
                    receiver.onNext((Object)this.frameDecoder.apply(frame));
                    break;
                }
                case REQUEST_N: {
                    LimitableRequestPublisher sender;
                    RSocketClient rSocketClient3 = this;
                    synchronized (rSocketClient3) {
                        sender = (LimitableRequestPublisher)((Object)this.senders.get(streamId));
                    }
                    if (sender == null) break;
                    int n = Frame.RequestN.requestN(frame);
                    sender.increaseRequestLimit(n);
                    this.sendProcessor.drain();
                    break;
                }
                case COMPLETE: {
                    receiver.onComplete();
                    rSocketClient = this;
                    synchronized (rSocketClient) {
                        this.receivers.remove(streamId);
                        break;
                    }
                }
                default: {
                    throw new IllegalStateException("Client received supported frame on stream " + streamId + ": " + frame.toString());
                }
            }
        }
    }

    private void handleMissingResponseProcessor(int streamId, FrameType type, Frame frame) {
        if (!this.streamIdSupplier.isBeforeOrCurrent(streamId)) {
            if (type == FrameType.ERROR) {
                String errorMessage = frame.getDataUtf8();
                throw new IllegalStateException("Client received error for non-existent stream: " + streamId + " Message: " + errorMessage);
            }
            throw new IllegalStateException("Client received message for non-existent stream: " + streamId + ", frame type: " + (Object)((Object)type));
        }
    }

    private synchronized void removeReceiver(int streamId) {
        this.receivers.remove(streamId);
    }

    private synchronized void removeSender(int streamId) {
        this.senders.remove(streamId);
    }

    static /* synthetic */ StreamIdSupplier access$000(RSocketClient x0) {
        return x0.streamIdSupplier;
    }
}

