/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.AbstractReferenceCounted;
import io.rsocket.Frame;
import io.rsocket.FrameType;
import io.rsocket.Payload;

public abstract class ConnectionSetupPayload
extends AbstractReferenceCounted
implements Payload {
    public static final int NO_FLAGS = 0;
    public static final int HONOR_LEASE = 64;
    public static final int STRICT_INTERPRETATION = 32;

    public static ConnectionSetupPayload create(String metadataMimeType, String dataMimeType) {
        return new DefaultConnectionSetupPayload(metadataMimeType, dataMimeType, Unpooled.EMPTY_BUFFER, Unpooled.EMPTY_BUFFER, 0);
    }

    public static ConnectionSetupPayload create(String metadataMimeType, String dataMimeType, Payload payload) {
        return new DefaultConnectionSetupPayload(metadataMimeType, dataMimeType, payload.sliceData(), payload.sliceMetadata(), payload.hasMetadata() ? 256 : 0);
    }

    public static ConnectionSetupPayload create(String metadataMimeType, String dataMimeType, int flags) {
        return new DefaultConnectionSetupPayload(metadataMimeType, dataMimeType, Unpooled.EMPTY_BUFFER, Unpooled.EMPTY_BUFFER, flags);
    }

    public static ConnectionSetupPayload create(Frame setupFrame) {
        Frame.ensureFrameType(FrameType.SETUP, setupFrame);
        return new DefaultConnectionSetupPayload(Frame.Setup.metadataMimeType(setupFrame), Frame.Setup.dataMimeType(setupFrame), setupFrame.sliceData(), setupFrame.sliceMetadata(), Frame.Setup.getFlags(setupFrame));
    }

    public abstract String metadataMimeType();

    public abstract String dataMimeType();

    public abstract int getFlags();

    public boolean willClientHonorLease() {
        return Frame.isFlagSet(this.getFlags(), 64);
    }

    public boolean doesClientRequestStrictInterpretation() {
        return 32 == (this.getFlags() & 0x20);
    }

    @Override
    public boolean hasMetadata() {
        return Frame.isFlagSet(this.getFlags(), 256);
    }

    @Override
    public ConnectionSetupPayload retain() {
        super.retain();
        return this;
    }

    @Override
    public ConnectionSetupPayload retain(int increment) {
        super.retain(increment);
        return this;
    }

    @Override
    public abstract ConnectionSetupPayload touch();

    @Override
    public abstract ConnectionSetupPayload touch(Object var1);

    private static final class DefaultConnectionSetupPayload
    extends ConnectionSetupPayload {
        private final String metadataMimeType;
        private final String dataMimeType;
        private final ByteBuf data;
        private final ByteBuf metadata;
        private final int flags;

        public DefaultConnectionSetupPayload(String metadataMimeType, String dataMimeType, ByteBuf data, ByteBuf metadata, int flags) {
            this.metadataMimeType = metadataMimeType;
            this.dataMimeType = dataMimeType;
            this.data = data;
            this.metadata = metadata;
            this.flags = flags;
            if (!this.hasMetadata() && metadata.readableBytes() > 0) {
                throw new IllegalArgumentException("metadata flag incorrect");
            }
        }

        @Override
        public String metadataMimeType() {
            return this.metadataMimeType;
        }

        @Override
        public String dataMimeType() {
            return this.dataMimeType;
        }

        @Override
        public ByteBuf sliceData() {
            return this.data;
        }

        @Override
        public ByteBuf sliceMetadata() {
            return this.metadata;
        }

        @Override
        public int getFlags() {
            return this.flags;
        }

        @Override
        public ConnectionSetupPayload touch() {
            this.data.touch();
            this.metadata.touch();
            return this;
        }

        @Override
        public ConnectionSetupPayload touch(Object hint) {
            this.data.touch(hint);
            this.metadata.touch(hint);
            return this;
        }

        protected void deallocate() {
            this.data.release();
            this.metadata.release();
        }
    }
}

