/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.fragmentation;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import io.rsocket.frame.FragmentationFlyweight;
import io.rsocket.frame.FrameHeaderFlyweight;
import io.rsocket.frame.FrameType;
import io.rsocket.frame.PayloadFrameFlyweight;
import io.rsocket.frame.RequestChannelFrameFlyweight;
import io.rsocket.frame.RequestFireAndForgetFrameFlyweight;
import io.rsocket.frame.RequestResponseFrameFlyweight;
import io.rsocket.frame.RequestStreamFrameFlyweight;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.SynchronousSink;

final class FrameReassembler
extends AtomicBoolean
implements Disposable {
    private static final Logger logger = LoggerFactory.getLogger(FrameReassembler.class);
    final IntObjectMap<ByteBuf> headers;
    final IntObjectMap<CompositeByteBuf> metadata;
    final IntObjectMap<CompositeByteBuf> data;
    private final ByteBufAllocator allocator;

    public FrameReassembler(ByteBufAllocator allocator) {
        this.allocator = allocator;
        this.headers = new IntObjectHashMap();
        this.metadata = new IntObjectHashMap();
        this.data = new IntObjectHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.compareAndSet(false, true)) {
            FrameReassembler frameReassembler = this;
            synchronized (frameReassembler) {
                for (ByteBuf byteBuf : this.headers.values()) {
                    ReferenceCountUtil.safeRelease((Object)byteBuf);
                }
                this.headers.clear();
                for (ByteBuf byteBuf : this.metadata.values()) {
                    ReferenceCountUtil.safeRelease((Object)byteBuf);
                }
                this.metadata.clear();
                for (ByteBuf byteBuf : this.data.values()) {
                    ReferenceCountUtil.safeRelease((Object)byteBuf);
                }
                this.data.clear();
            }
        }
    }

    public boolean isDisposed() {
        return this.get();
    }

    synchronized ByteBuf getHeader(int streamId) {
        return (ByteBuf)this.headers.get(streamId);
    }

    synchronized CompositeByteBuf getMetadata(int streamId) {
        CompositeByteBuf byteBuf = (CompositeByteBuf)this.metadata.get(streamId);
        if (byteBuf == null) {
            byteBuf = this.allocator.compositeBuffer();
            this.metadata.put(streamId, (Object)byteBuf);
        }
        return byteBuf;
    }

    synchronized CompositeByteBuf getData(int streamId) {
        CompositeByteBuf byteBuf = (CompositeByteBuf)this.data.get(streamId);
        if (byteBuf == null) {
            byteBuf = this.allocator.compositeBuffer();
            this.data.put(streamId, (Object)byteBuf);
        }
        return byteBuf;
    }

    synchronized ByteBuf removeHeader(int streamId) {
        return (ByteBuf)this.headers.remove(streamId);
    }

    synchronized CompositeByteBuf removeMetadata(int streamId) {
        return (CompositeByteBuf)this.metadata.remove(streamId);
    }

    synchronized CompositeByteBuf removeData(int streamId) {
        return (CompositeByteBuf)this.data.remove(streamId);
    }

    synchronized void putHeader(int streamId, ByteBuf header) {
        this.headers.put(streamId, (Object)header);
    }

    void cancelAssemble(int streamId) {
        ByteBuf header = this.removeHeader(streamId);
        CompositeByteBuf metadata = this.removeMetadata(streamId);
        CompositeByteBuf data = this.removeData(streamId);
        if (header != null) {
            ReferenceCountUtil.safeRelease((Object)header);
        }
        if (metadata != null) {
            ReferenceCountUtil.safeRelease((Object)metadata);
        }
        if (data != null) {
            ReferenceCountUtil.safeRelease((Object)data);
        }
    }

    void handleNoFollowsFlag(ByteBuf frame, SynchronousSink<ByteBuf> sink, int streamId) {
        ByteBuf header = this.removeHeader(streamId);
        if (header != null) {
            if (FrameHeaderFlyweight.hasMetadata(header)) {
                ByteBuf assembledFrame = this.assembleFrameWithMetadata(frame, streamId, header);
                sink.next((Object)assembledFrame);
            } else {
                ByteBuf data = this.assembleData(frame, streamId);
                ByteBuf assembledFrame = FragmentationFlyweight.encode(this.allocator, header, data);
                sink.next((Object)assembledFrame);
            }
        } else {
            sink.next((Object)frame);
        }
    }

    void handleFollowsFlag(ByteBuf frame, int streamId, FrameType frameType) {
        ByteBuf data;
        ByteBuf header = this.getHeader(streamId);
        if (header == null) {
            header = frame.copy(frame.readerIndex(), FrameHeaderFlyweight.size());
            if (frameType == FrameType.REQUEST_CHANNEL || frameType == FrameType.REQUEST_STREAM) {
                int i = RequestChannelFrameFlyweight.initialRequestN(frame);
                header.writeInt(i);
            }
            this.putHeader(streamId, header);
        }
        if (FrameHeaderFlyweight.hasMetadata(frame)) {
            CompositeByteBuf metadata = this.getMetadata(streamId);
            switch (frameType) {
                case REQUEST_FNF: {
                    metadata.addComponents(true, new ByteBuf[]{RequestFireAndForgetFrameFlyweight.metadata(frame).retain()});
                    break;
                }
                case REQUEST_STREAM: {
                    metadata.addComponents(true, new ByteBuf[]{RequestStreamFrameFlyweight.metadata(frame).retain()});
                    break;
                }
                case REQUEST_RESPONSE: {
                    metadata.addComponents(true, new ByteBuf[]{RequestResponseFrameFlyweight.metadata(frame).retain()});
                    break;
                }
                case REQUEST_CHANNEL: {
                    metadata.addComponents(true, new ByteBuf[]{RequestChannelFrameFlyweight.metadata(frame).retain()});
                    break;
                }
                case PAYLOAD: 
                case NEXT: 
                case NEXT_COMPLETE: 
                case COMPLETE: {
                    metadata.addComponents(true, new ByteBuf[]{PayloadFrameFlyweight.metadata(frame).retain()});
                    break;
                }
                default: {
                    throw new IllegalStateException("unsupported fragment type");
                }
            }
        }
        switch (frameType) {
            case REQUEST_FNF: {
                data = RequestFireAndForgetFrameFlyweight.data(frame).retain();
                break;
            }
            case REQUEST_STREAM: {
                data = RequestStreamFrameFlyweight.data(frame).retain();
                break;
            }
            case REQUEST_RESPONSE: {
                data = RequestResponseFrameFlyweight.data(frame).retain();
                break;
            }
            case REQUEST_CHANNEL: {
                data = RequestChannelFrameFlyweight.data(frame).retain();
                break;
            }
            case PAYLOAD: 
            case NEXT: 
            case NEXT_COMPLETE: 
            case COMPLETE: {
                data = PayloadFrameFlyweight.data(frame).retain();
                break;
            }
            default: {
                throw new IllegalStateException("unsupported fragment type");
            }
        }
        if (data != Unpooled.EMPTY_BUFFER) {
            this.getData(streamId).addComponents(true, new ByteBuf[]{data});
        }
    }

    void reassembleFrame(ByteBuf frame, SynchronousSink<ByteBuf> sink) {
        try {
            FrameType frameType = FrameHeaderFlyweight.frameType(frame);
            int streamId = FrameHeaderFlyweight.streamId(frame);
            switch (frameType) {
                case CANCEL: 
                case ERROR: {
                    this.cancelAssemble(streamId);
                }
            }
            if (!frameType.isFragmentable()) {
                sink.next((Object)frame);
                return;
            }
            boolean hasFollows = FrameHeaderFlyweight.hasFollows(frame);
            if (hasFollows) {
                this.handleFollowsFlag(frame, streamId, frameType);
            } else {
                this.handleNoFollowsFlag(frame, sink, streamId);
            }
        }
        catch (Throwable t) {
            logger.error("error reassemble frame", t);
            sink.error(t);
        }
    }

    private ByteBuf assembleFrameWithMetadata(ByteBuf frame, int streamId, ByteBuf header) {
        ByteBuf metadata;
        CompositeByteBuf cm = this.removeMetadata(streamId);
        if (cm != null) {
            ByteBuf m = PayloadFrameFlyweight.metadata(frame);
            metadata = cm.addComponents(true, new ByteBuf[]{m});
        } else {
            metadata = PayloadFrameFlyweight.metadata(frame);
        }
        ByteBuf data = this.assembleData(frame, streamId);
        return FragmentationFlyweight.encode(this.allocator, header, metadata.retain(), data);
    }

    private ByteBuf assembleData(ByteBuf frame, int streamId) {
        ByteBuf data;
        CompositeByteBuf cd = this.removeData(streamId);
        if (cd != null) {
            ByteBuf d = PayloadFrameFlyweight.data(frame);
            if (d != null) {
                cd.addComponents(true, new ByteBuf[]{d});
            }
            data = cd;
        } else {
            data = Unpooled.EMPTY_BUFFER;
        }
        return data;
    }
}

