/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.buffer;

import io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.util.internal.SystemPropertyUtil;
import io.rsocket.buffer.BufferUtil;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;

abstract class AbstractTupleByteBuf
extends AbstractReferenceCountedByteBuf {
    static final int DEFAULT_DIRECT_MEMORY_CACHE_ALIGNMENT = SystemPropertyUtil.getInt((String)"io.netty.allocator.directMemoryCacheAlignment", (int)0);
    static final ByteBuffer EMPTY_NIO_BUFFER = Unpooled.EMPTY_BUFFER.nioBuffer();
    final ByteBufAllocator allocator;
    final int capacity;

    AbstractTupleByteBuf(ByteBufAllocator allocator, int capacity) {
        super(Integer.MAX_VALUE);
        this.capacity = capacity;
        this.allocator = allocator;
        super.writerIndex(capacity);
    }

    abstract long calculateRelativeIndex(int var1);

    abstract ByteBuf getPart(int var1);

    public ByteBuffer nioBuffer(int index, int length) {
        this.checkIndex(index, length);
        ByteBuffer[] buffers = this.nioBuffers(index, length);
        if (buffers.length == 1) {
            return buffers[0].duplicate();
        }
        ByteBuffer merged = BufferUtil.allocateDirectAligned(length, DEFAULT_DIRECT_MEMORY_CACHE_ALIGNMENT).order(this.order());
        for (ByteBuffer buf : buffers) {
            merged.put(buf);
        }
        merged.flip();
        return merged;
    }

    protected byte _getByte(int index) {
        long ri = this.calculateRelativeIndex(index);
        ByteBuf byteBuf = this.getPart(index);
        index = (int)(ri & Integer.MAX_VALUE);
        return byteBuf.getByte(index);
    }

    protected short _getShort(int index) {
        long ri = this.calculateRelativeIndex(index);
        ByteBuf byteBuf = this.getPart(index);
        index = (int)(ri & Integer.MAX_VALUE);
        return byteBuf.getShort(index);
    }

    protected short _getShortLE(int index) {
        long ri = this.calculateRelativeIndex(index);
        ByteBuf byteBuf = this.getPart(index);
        index = (int)(ri & Integer.MAX_VALUE);
        return byteBuf.getShortLE(index);
    }

    protected int _getUnsignedMedium(int index) {
        long ri = this.calculateRelativeIndex(index);
        ByteBuf byteBuf = this.getPart(index);
        index = (int)(ri & Integer.MAX_VALUE);
        return byteBuf.getUnsignedMedium(index);
    }

    protected int _getUnsignedMediumLE(int index) {
        long ri = this.calculateRelativeIndex(index);
        ByteBuf byteBuf = this.getPart(index);
        index = (int)(ri & Integer.MAX_VALUE);
        return byteBuf.getUnsignedMediumLE(index);
    }

    protected int _getInt(int index) {
        long ri = this.calculateRelativeIndex(index);
        ByteBuf byteBuf = this.getPart(index);
        index = (int)(ri & Integer.MAX_VALUE);
        return byteBuf.getInt(index);
    }

    protected int _getIntLE(int index) {
        long ri = this.calculateRelativeIndex(index);
        ByteBuf byteBuf = this.getPart(index);
        index = (int)(ri & Integer.MAX_VALUE);
        return byteBuf.getIntLE(index);
    }

    protected long _getLong(int index) {
        long ri = this.calculateRelativeIndex(index);
        ByteBuf byteBuf = this.getPart(index);
        index = (int)(ri & Integer.MAX_VALUE);
        return byteBuf.getLong(index);
    }

    protected long _getLongLE(int index) {
        long ri = this.calculateRelativeIndex(index);
        ByteBuf byteBuf = this.getPart(index);
        index = (int)(ri & Integer.MAX_VALUE);
        return byteBuf.getLongLE(index);
    }

    public ByteBufAllocator alloc() {
        return this.allocator;
    }

    public int capacity() {
        return this.capacity;
    }

    public ByteBuf capacity(int newCapacity) {
        throw new UnsupportedOperationException();
    }

    public int maxCapacity() {
        return this.capacity;
    }

    public ByteOrder order() {
        return ByteOrder.LITTLE_ENDIAN;
    }

    public ByteBuf order(ByteOrder endianness) {
        return this;
    }

    public ByteBuf unwrap() {
        throw new UnsupportedOperationException();
    }

    public boolean isReadOnly() {
        return true;
    }

    public ByteBuf asReadOnly() {
        return this;
    }

    public boolean isWritable() {
        return false;
    }

    public boolean isWritable(int size) {
        return false;
    }

    public ByteBuf writerIndex(int writerIndex) {
        return this;
    }

    public final int writerIndex() {
        return this.capacity;
    }

    public ByteBuf setIndex(int readerIndex, int writerIndex) {
        return this;
    }

    public ByteBuf clear() {
        throw new UnsupportedOperationException();
    }

    public ByteBuf discardReadBytes() {
        return this;
    }

    public ByteBuf discardSomeReadBytes() {
        return this;
    }

    public ByteBuf ensureWritable(int minWritableBytes) {
        return this;
    }

    public int ensureWritable(int minWritableBytes, boolean force) {
        return 0;
    }

    public ByteBuf setFloatLE(int index, float value) {
        throw new UnsupportedOperationException();
    }

    public ByteBuf setDoubleLE(int index, double value) {
        throw new UnsupportedOperationException();
    }

    public ByteBuf setBoolean(int index, boolean value) {
        throw new UnsupportedOperationException();
    }

    public ByteBuf setByte(int index, int value) {
        throw new UnsupportedOperationException();
    }

    public ByteBuf setShort(int index, int value) {
        throw new UnsupportedOperationException();
    }

    public ByteBuf setShortLE(int index, int value) {
        throw new UnsupportedOperationException();
    }

    public ByteBuf setMedium(int index, int value) {
        throw new UnsupportedOperationException();
    }

    public ByteBuf setMediumLE(int index, int value) {
        throw new UnsupportedOperationException();
    }

    public ByteBuf setInt(int index, int value) {
        throw new UnsupportedOperationException();
    }

    public ByteBuf setIntLE(int index, int value) {
        throw new UnsupportedOperationException();
    }

    public ByteBuf setLong(int index, long value) {
        throw new UnsupportedOperationException();
    }

    public ByteBuf setLongLE(int index, long value) {
        throw new UnsupportedOperationException();
    }

    public ByteBuf setChar(int index, int value) {
        throw new UnsupportedOperationException();
    }

    public ByteBuf setFloat(int index, float value) {
        throw new UnsupportedOperationException();
    }

    public ByteBuf setDouble(int index, double value) {
        throw new UnsupportedOperationException();
    }

    public ByteBuf setBytes(int index, ByteBuf src) {
        throw new UnsupportedOperationException();
    }

    public ByteBuf setBytes(int index, ByteBuf src, int length) {
        throw new UnsupportedOperationException();
    }

    public ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
        throw new UnsupportedOperationException();
    }

    public ByteBuf setBytes(int index, byte[] src) {
        throw new UnsupportedOperationException();
    }

    public ByteBuf setBytes(int index, byte[] src, int srcIndex, int length) {
        throw new UnsupportedOperationException();
    }

    public ByteBuf setBytes(int index, ByteBuffer src) {
        throw new UnsupportedOperationException();
    }

    public int setBytes(int index, InputStream in, int length) {
        throw new UnsupportedOperationException();
    }

    public int setBytes(int index, ScatteringByteChannel in, int length) {
        throw new UnsupportedOperationException();
    }

    public int setBytes(int index, FileChannel in, long position, int length) {
        throw new UnsupportedOperationException();
    }

    public int setCharSequence(int index, CharSequence sequence, Charset charset) {
        throw new UnsupportedOperationException();
    }

    public ByteBuf setZero(int index, int length) {
        throw new UnsupportedOperationException();
    }

    public ByteBuf writeBoolean(boolean value) {
        throw new UnsupportedOperationException();
    }

    public ByteBuf writeByte(int value) {
        throw new UnsupportedOperationException();
    }

    public ByteBuf writeShort(int value) {
        throw new UnsupportedOperationException();
    }

    public ByteBuf writeShortLE(int value) {
        throw new UnsupportedOperationException();
    }

    public ByteBuf writeMedium(int value) {
        throw new UnsupportedOperationException();
    }

    public ByteBuf writeMediumLE(int value) {
        throw new UnsupportedOperationException();
    }

    public ByteBuf writeInt(int value) {
        throw new UnsupportedOperationException();
    }

    public ByteBuf writeIntLE(int value) {
        throw new UnsupportedOperationException();
    }

    public ByteBuf writeLong(long value) {
        throw new UnsupportedOperationException();
    }

    public ByteBuf writeLongLE(long value) {
        throw new UnsupportedOperationException();
    }

    public ByteBuf writeChar(int value) {
        throw new UnsupportedOperationException();
    }

    public ByteBuf writeFloat(float value) {
        throw new UnsupportedOperationException();
    }

    public ByteBuf writeDouble(double value) {
        throw new UnsupportedOperationException();
    }

    public ByteBuf writeBytes(ByteBuf src) {
        throw new UnsupportedOperationException();
    }

    public ByteBuf writeBytes(ByteBuf src, int length) {
        throw new UnsupportedOperationException();
    }

    public ByteBuf writeBytes(ByteBuf src, int srcIndex, int length) {
        throw new UnsupportedOperationException();
    }

    public ByteBuf writeBytes(byte[] src) {
        throw new UnsupportedOperationException();
    }

    public ByteBuf writeBytes(byte[] src, int srcIndex, int length) {
        throw new UnsupportedOperationException();
    }

    public ByteBuf writeBytes(ByteBuffer src) {
        throw new UnsupportedOperationException();
    }

    public int writeBytes(InputStream in, int length) {
        throw new UnsupportedOperationException();
    }

    public int writeBytes(ScatteringByteChannel in, int length) {
        throw new UnsupportedOperationException();
    }

    public int writeBytes(FileChannel in, long position, int length) {
        throw new UnsupportedOperationException();
    }

    public ByteBuf writeZero(int length) {
        throw new UnsupportedOperationException();
    }

    public int writeCharSequence(CharSequence sequence, Charset charset) {
        throw new UnsupportedOperationException();
    }

    public ByteBuffer internalNioBuffer(int index, int length) {
        throw new UnsupportedOperationException();
    }

    public boolean hasArray() {
        return false;
    }

    public byte[] array() {
        throw new UnsupportedOperationException();
    }

    public int arrayOffset() {
        throw new UnsupportedOperationException();
    }

    public boolean hasMemoryAddress() {
        return false;
    }

    public long memoryAddress() {
        throw new UnsupportedOperationException();
    }

    public int compareTo(ByteBuf buffer) {
        return 0;
    }

    protected void _setByte(int index, int value) {
    }

    protected void _setShort(int index, int value) {
    }

    protected void _setShortLE(int index, int value) {
    }

    protected void _setMedium(int index, int value) {
    }

    protected void _setMediumLE(int index, int value) {
    }

    protected void _setInt(int index, int value) {
    }

    protected void _setIntLE(int index, int value) {
    }

    protected void _setLong(int index, long value) {
    }

    protected void _setLongLE(int index, long value) {
    }
}

