/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.framing;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.Recycler;
import io.netty.util.ReferenceCountUtil;
import io.rsocket.framing.AbstractRecyclableFragmentableFrame;
import io.rsocket.framing.FrameType;
import io.rsocket.util.NumberUtils;
import io.rsocket.util.RecyclerFactory;
import java.util.Objects;
import reactor.util.annotation.Nullable;

public final class RequestChannelFrame
extends AbstractRecyclableFragmentableFrame<RequestChannelFrame> {
    private static final int FLAG_COMPLETE = 64;
    private static final int OFFSET_INITIAL_REQUEST_N = 2;
    private static final int OFFSET_METADATA_LENGTH = 6;
    private static final Recycler<RequestChannelFrame> RECYCLER = RecyclerFactory.createRecycler(RequestChannelFrame::new);

    private RequestChannelFrame(Recycler.Handle<RequestChannelFrame> handle) {
        super(handle);
    }

    public static RequestChannelFrame createRequestChannelFrame(ByteBuf byteBuf) {
        Objects.requireNonNull(byteBuf, "byteBuf must not be null");
        return (RequestChannelFrame)((RequestChannelFrame)RECYCLER.get()).setByteBuf(byteBuf.retain());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RequestChannelFrame createRequestChannelFrame(ByteBufAllocator byteBufAllocator, boolean follows, boolean complete, int initialRequestN, @Nullable String metadata, @Nullable String data) {
        ByteBuf metadataByteBuf = RequestChannelFrame.getUtf8AsByteBuf(metadata);
        ByteBuf dataByteBuf = RequestChannelFrame.getUtf8AsByteBuf(data);
        try {
            RequestChannelFrame requestChannelFrame = RequestChannelFrame.createRequestChannelFrame(byteBufAllocator, follows, complete, initialRequestN, metadataByteBuf, dataByteBuf);
            return requestChannelFrame;
        }
        finally {
            ReferenceCountUtil.release((Object)metadataByteBuf);
            ReferenceCountUtil.release((Object)dataByteBuf);
        }
    }

    public static RequestChannelFrame createRequestChannelFrame(ByteBufAllocator byteBufAllocator, boolean follows, boolean complete, int initialRequestN, @Nullable ByteBuf metadata, @Nullable ByteBuf data) {
        NumberUtils.requirePositive(initialRequestN, "initialRequestN must be positive");
        ByteBuf byteBuf = RequestChannelFrame.createFrameTypeAndFlags(byteBufAllocator, FrameType.REQUEST_CHANNEL);
        if (follows) {
            byteBuf = RequestChannelFrame.setFollowsFlag(byteBuf);
        }
        if (complete) {
            byteBuf = RequestChannelFrame.setFlag(byteBuf, 64);
        }
        byteBuf = byteBuf.writeInt(initialRequestN);
        byteBuf = RequestChannelFrame.appendMetadata(byteBufAllocator, byteBuf, metadata);
        byteBuf = RequestChannelFrame.appendData(byteBuf, data);
        return (RequestChannelFrame)((RequestChannelFrame)RECYCLER.get()).setByteBuf(byteBuf);
    }

    @Override
    public RequestChannelFrame createFragment(ByteBufAllocator byteBufAllocator, @Nullable ByteBuf metadata, @Nullable ByteBuf data) {
        return RequestChannelFrame.createRequestChannelFrame(byteBufAllocator, true, this.isCompleteFlagSet(), this.getInitialRequestN(), metadata, data);
    }

    @Override
    public RequestChannelFrame createNonFragment(ByteBufAllocator byteBufAllocator, @Nullable ByteBuf metadata, @Nullable ByteBuf data) {
        return RequestChannelFrame.createRequestChannelFrame(byteBufAllocator, false, this.isCompleteFlagSet(), this.getInitialRequestN(), metadata, data);
    }

    public int getInitialRequestN() {
        return this.getByteBuf().getInt(2);
    }

    @Override
    public ByteBuf getUnsafeData() {
        return this.getData(6);
    }

    @Override
    @Nullable
    public ByteBuf getUnsafeMetadata() {
        return this.getMetadata(6);
    }

    public boolean isCompleteFlagSet() {
        return this.isFlagSet(64);
    }

    public String toString() {
        return "RequestChannelFrame{follows=" + this.isFollowsFlagSet() + ", complete=" + this.isCompleteFlagSet() + ", initialRequestN=" + this.getInitialRequestN() + ", metadata=" + this.mapMetadata(ByteBufUtil::hexDump) + ", data=" + (String)this.mapData(ByteBufUtil::hexDump) + '}';
    }
}

