/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.Recycler;
import io.rsocket.Payload;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import javax.annotation.Nullable;

public final class ByteBufPayload
extends AbstractReferenceCounted
implements Payload {
    private static final Recycler<ByteBufPayload> RECYCLER = new Recycler<ByteBufPayload>(){

        protected ByteBufPayload newObject(Recycler.Handle<ByteBufPayload> handle) {
            return new ByteBufPayload(handle);
        }
    };
    private final Recycler.Handle<ByteBufPayload> handle;
    private ByteBuf data;
    private ByteBuf metadata;

    private ByteBufPayload(Recycler.Handle<ByteBufPayload> handle) {
        this.handle = handle;
    }

    @Override
    public boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public ByteBuf sliceMetadata() {
        return this.metadata == null ? Unpooled.EMPTY_BUFFER : this.metadata.slice();
    }

    @Override
    public ByteBuf sliceData() {
        return this.data.slice();
    }

    @Override
    public ByteBufPayload retain() {
        super.retain();
        return this;
    }

    @Override
    public ByteBufPayload retain(int increment) {
        super.retain(increment);
        return this;
    }

    @Override
    public ByteBufPayload touch() {
        this.data.touch();
        if (this.metadata != null) {
            this.metadata.touch();
        }
        return this;
    }

    @Override
    public ByteBufPayload touch(Object hint) {
        this.data.touch(hint);
        if (this.metadata != null) {
            this.metadata.touch(hint);
        }
        return this;
    }

    protected void deallocate() {
        this.data.release();
        this.data = null;
        if (this.metadata != null) {
            this.metadata.release();
            this.metadata = null;
        }
        this.handle.recycle((Object)this);
    }

    public static Payload create(String data) {
        return ByteBufPayload.create(ByteBufUtil.writeUtf8((ByteBufAllocator)ByteBufAllocator.DEFAULT, (CharSequence)data), null);
    }

    public static Payload create(String data, @Nullable String metadata) {
        return ByteBufPayload.create(ByteBufUtil.writeUtf8((ByteBufAllocator)ByteBufAllocator.DEFAULT, (CharSequence)data), metadata == null ? null : ByteBufUtil.writeUtf8((ByteBufAllocator)ByteBufAllocator.DEFAULT, (CharSequence)metadata));
    }

    public static Payload create(CharSequence data, Charset dataCharset) {
        return ByteBufPayload.create(ByteBufUtil.encodeString((ByteBufAllocator)ByteBufAllocator.DEFAULT, (CharBuffer)CharBuffer.wrap(data), (Charset)dataCharset), null);
    }

    public static Payload create(CharSequence data, Charset dataCharset, @Nullable CharSequence metadata, Charset metadataCharset) {
        return ByteBufPayload.create(ByteBufUtil.encodeString((ByteBufAllocator)ByteBufAllocator.DEFAULT, (CharBuffer)CharBuffer.wrap(data), (Charset)dataCharset), metadata == null ? null : ByteBufUtil.encodeString((ByteBufAllocator)ByteBufAllocator.DEFAULT, (CharBuffer)CharBuffer.wrap(metadata), (Charset)metadataCharset));
    }

    public static Payload create(byte[] data) {
        return ByteBufPayload.create(Unpooled.wrappedBuffer((byte[])data), null);
    }

    public static Payload create(byte[] data, @Nullable byte[] metadata) {
        return ByteBufPayload.create(Unpooled.wrappedBuffer((byte[])data), metadata == null ? null : Unpooled.wrappedBuffer((byte[])metadata));
    }

    public static Payload create(ByteBuffer data) {
        return ByteBufPayload.create(Unpooled.wrappedBuffer((ByteBuffer)data), null);
    }

    public static Payload create(ByteBuffer data, @Nullable ByteBuffer metadata) {
        return ByteBufPayload.create(Unpooled.wrappedBuffer((ByteBuffer)data), metadata == null ? null : Unpooled.wrappedBuffer((ByteBuffer)metadata));
    }

    public static Payload create(ByteBuf data) {
        return ByteBufPayload.create(data, null);
    }

    public static Payload create(ByteBuf data, @Nullable ByteBuf metadata) {
        ByteBufPayload payload = (ByteBufPayload)RECYCLER.get();
        payload.setRefCnt(1);
        payload.data = data;
        payload.metadata = metadata;
        return payload;
    }

    public static Payload create(Payload payload) {
        return ByteBufPayload.create(payload.sliceData(), payload.hasMetadata() ? payload.sliceMetadata() : null);
    }
}

