/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.framing;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.Recycler;
import io.rsocket.framing.AbstractRecyclableFrame;
import io.rsocket.framing.MetadataFrame;
import java.util.Objects;
import reactor.util.annotation.Nullable;

abstract class AbstractRecyclableMetadataFrame<SELF extends AbstractRecyclableMetadataFrame<SELF>>
extends AbstractRecyclableFrame<SELF>
implements MetadataFrame {
    private static final int FLAG_METADATA = 256;

    AbstractRecyclableMetadataFrame(Recycler.Handle<SELF> handle) {
        super(handle);
    }

    static ByteBuf appendMetadata(ByteBuf byteBuf, @Nullable ByteBuf metadata) {
        Objects.requireNonNull(byteBuf, "byteBuf must not be null");
        if (metadata == null) {
            return byteBuf;
        }
        AbstractRecyclableMetadataFrame.setFlag(byteBuf, 256);
        return Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{byteBuf, metadata.retain()});
    }

    @Nullable
    final ByteBuf getMetadata(int metadataOffset) {
        if (!this.isFlagSet(256)) {
            return null;
        }
        ByteBuf byteBuf = this.getByteBuf();
        return byteBuf.slice(metadataOffset, byteBuf.readableBytes() - metadataOffset).asReadOnly();
    }
}

