/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.uri;

import io.rsocket.transport.ClientTransport;
import io.rsocket.transport.ServerTransport;
import io.rsocket.uri.UriHandler;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import reactor.core.publisher.Mono;

public class UriTransportRegistry {
    private static final ClientTransport FAILED_CLIENT_LOOKUP = () -> Mono.error((Throwable)new UnsupportedOperationException());
    private static final ServerTransport FAILED_SERVER_LOOKUP = acceptor -> Mono.error((Throwable)new UnsupportedOperationException());
    private List<UriHandler> handlers = new ArrayList<UriHandler>();

    public UriTransportRegistry(ServiceLoader<UriHandler> services) {
        services.forEach(this.handlers::add);
    }

    public static UriTransportRegistry fromServices() {
        ServiceLoader<UriHandler> services = UriHandler.loadServices();
        return new UriTransportRegistry(services);
    }

    public static ClientTransport clientForUri(String uri) {
        return UriTransportRegistry.fromServices().findClient(uri);
    }

    private ClientTransport findClient(String uriString) {
        URI uri = URI.create(uriString);
        for (UriHandler h : this.handlers) {
            Optional<ClientTransport> r = h.buildClient(uri);
            if (!r.isPresent()) continue;
            return r.get();
        }
        return FAILED_CLIENT_LOOKUP;
    }

    public static ServerTransport serverForUri(String uri) {
        return UriTransportRegistry.fromServices().findServer(uri);
    }

    private ServerTransport findServer(String uriString) {
        URI uri = URI.create(uriString);
        for (UriHandler h : this.handlers) {
            Optional<ServerTransport> r = h.buildServer(uri);
            if (!r.isPresent()) continue;
            return r.get();
        }
        return FAILED_SERVER_LOOKUP;
    }
}

