/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.framing;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.util.Recycler;
import io.netty.util.ReferenceCountUtil;
import io.rsocket.framing.AbstractRecyclableMetadataAndDataFrame;
import io.rsocket.framing.FrameType;
import io.rsocket.framing.LengthUtils;
import io.rsocket.util.NumberUtils;
import io.rsocket.util.RecyclerFactory;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import reactor.util.annotation.Nullable;

public final class SetupFrame
extends AbstractRecyclableMetadataAndDataFrame<SetupFrame> {
    private static final int FLAG_LEASE = 64;
    private static final int FLAG_RESUME_ENABLED = 128;
    private static final int OFFSET_MAJOR_VERSION = 2;
    private static final int OFFSET_MINOR_VERSION = 4;
    private static final int OFFSET_KEEPALIVE_INTERVAL = 6;
    private static final int OFFSET_MAX_LIFETIME = 10;
    private static final int OFFSET_RESUME_IDENTIFICATION_TOKEN_LENGTH = 14;
    private static final Recycler<SetupFrame> RECYCLER = RecyclerFactory.createRecycler(SetupFrame::new);

    private SetupFrame(Recycler.Handle<SetupFrame> handle) {
        super(handle);
    }

    public static SetupFrame createSetupFrame(ByteBuf byteBuf) {
        Objects.requireNonNull(byteBuf, "byteBuf must not be null");
        return (SetupFrame)((SetupFrame)RECYCLER.get()).setByteBuf(byteBuf.retain());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SetupFrame createSetupFrame(ByteBufAllocator byteBufAllocator, boolean lease, Duration keepAliveInterval, Duration maxLifetime, @Nullable String resumeIdentificationToken, String metadataMimeType, String dataMimeType, @Nullable String metadata, @Nullable String data) {
        ByteBuf resumeIdentificationTokenByteBuf = SetupFrame.getUtf8AsByteBuf(resumeIdentificationToken);
        ByteBuf metadataByteBuf = SetupFrame.getUtf8AsByteBuf(metadata);
        ByteBuf dataByteBuf = SetupFrame.getUtf8AsByteBuf(data);
        try {
            SetupFrame setupFrame = SetupFrame.createSetupFrame(byteBufAllocator, lease, keepAliveInterval, maxLifetime, resumeIdentificationTokenByteBuf, metadataMimeType, dataMimeType, metadataByteBuf, dataByteBuf);
            return setupFrame;
        }
        finally {
            ReferenceCountUtil.release((Object)resumeIdentificationTokenByteBuf);
            ReferenceCountUtil.release((Object)metadataByteBuf);
            ReferenceCountUtil.release((Object)dataByteBuf);
        }
    }

    public static SetupFrame createSetupFrame(ByteBufAllocator byteBufAllocator, boolean lease, Duration keepAliveInterval, Duration maxLifetime, @Nullable ByteBuf resumeIdentificationToken, String metadataMimeType, String dataMimeType, @Nullable ByteBuf metadata, @Nullable ByteBuf data) {
        return SetupFrame.createSetupFrame(byteBufAllocator, lease, 1, 0, keepAliveInterval, maxLifetime, resumeIdentificationToken, metadataMimeType, dataMimeType, metadata, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SetupFrame createSetupFrame(ByteBufAllocator byteBufAllocator, boolean lease, int majorVersion, int minorVersion, Duration keepAliveInterval, Duration maxLifetime, @Nullable ByteBuf resumeIdentificationToken, String metadataMimeType, String dataMimeType, @Nullable ByteBuf metadata, @Nullable ByteBuf data) {
        Objects.requireNonNull(keepAliveInterval, "keepAliveInterval must not be null");
        NumberUtils.requirePositive(keepAliveInterval.toMillis(), "keepAliveInterval must be a positive duration");
        Objects.requireNonNull(maxLifetime, "maxLifetime must not be null");
        NumberUtils.requirePositive(maxLifetime.toMillis(), "maxLifetime must be a positive duration");
        ByteBuf metadataMimeTypeByteBuf = SetupFrame.getUtf8AsByteBufRequired(metadataMimeType, "metadataMimeType must not be null");
        ByteBuf dataMimeTypeByteBuf = SetupFrame.getUtf8AsByteBufRequired(dataMimeType, "dataMimeType must not be null");
        try {
            ByteBuf byteBuf = SetupFrame.createFrameTypeAndFlags(byteBufAllocator, FrameType.SETUP);
            if (lease) {
                byteBuf = SetupFrame.setFlag(byteBuf, 64);
            }
            byteBuf = byteBuf.writeShort(NumberUtils.requireUnsignedShort(majorVersion)).writeShort(NumberUtils.requireUnsignedShort(minorVersion)).writeInt(Math.toIntExact(keepAliveInterval.toMillis())).writeInt(Math.toIntExact(maxLifetime.toMillis()));
            if (resumeIdentificationToken != null) {
                byteBuf = SetupFrame.setFlag(byteBuf, 128).writeShort(LengthUtils.getLengthAsUnsignedShort(resumeIdentificationToken));
                byteBuf = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{byteBuf, resumeIdentificationToken.retain(), byteBufAllocator.buffer()});
            }
            byteBuf = byteBuf.writeByte(LengthUtils.getLengthAsUnsignedByte(metadataMimeTypeByteBuf));
            byteBuf = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{byteBuf, metadataMimeTypeByteBuf.retain(), byteBufAllocator.buffer()});
            byteBuf = byteBuf.writeByte(LengthUtils.getLengthAsUnsignedByte(dataMimeTypeByteBuf));
            byteBuf = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{byteBuf, dataMimeTypeByteBuf.retain(), byteBufAllocator.buffer()});
            byteBuf = SetupFrame.appendMetadata(byteBufAllocator, byteBuf, metadata);
            byteBuf = SetupFrame.appendData(byteBuf, data);
            SetupFrame setupFrame = (SetupFrame)((SetupFrame)RECYCLER.get()).setByteBuf(byteBuf);
            return setupFrame;
        }
        finally {
            ReferenceCountUtil.release((Object)metadataMimeTypeByteBuf);
            ReferenceCountUtil.release((Object)dataMimeTypeByteBuf);
        }
    }

    public String getDataMimeType() {
        return this.getDataMimeType(StandardCharsets.UTF_8);
    }

    public String getDataMimeType(Charset charset) {
        return this.getByteBuf().slice(this.getDataMimeTypeOffset(), this.getDataMimeTypeLength()).toString(charset);
    }

    public Duration getKeepAliveInterval() {
        return Duration.ofMillis(this.getByteBuf().getInt(6));
    }

    public int getMajorVersion() {
        return this.getByteBuf().getUnsignedShort(2);
    }

    public Duration getMaxLifetime() {
        return Duration.ofMillis(this.getByteBuf().getInt(10));
    }

    public String getMetadataMimeType() {
        return this.getMetadataMimeType(StandardCharsets.UTF_8);
    }

    public String getMetadataMimeType(Charset charset) {
        return this.getByteBuf().slice(this.getMetadataMimeTypeOffset(), this.getMetadataMimeTypeLength()).toString(charset);
    }

    public int getMinorVersion() {
        return this.getByteBuf().getUnsignedShort(4);
    }

    public Optional<String> getResumeIdentificationTokenAsUtf8() {
        return Optional.ofNullable(this.getUnsafeResumeIdentificationTokenAsUtf8());
    }

    @Override
    public ByteBuf getUnsafeData() {
        return this.getData(this.getMetadataLengthOffset());
    }

    @Override
    @Nullable
    public ByteBuf getUnsafeMetadata() {
        return this.getMetadata(this.getMetadataLengthOffset());
    }

    @Nullable
    public ByteBuf getUnsafeResumeIdentificationToken() {
        if (!this.isFlagSet(128)) {
            return null;
        }
        ByteBuf byteBuf = this.getByteBuf();
        return byteBuf.slice(this.getResumeIdentificationTokenOffset(), this.getResumeIdentificationTokenLength());
    }

    @Nullable
    public String getUnsafeResumeIdentificationTokenAsUtf8() {
        ByteBuf byteBuf = this.getUnsafeResumeIdentificationToken();
        return byteBuf == null ? null : byteBuf.toString(StandardCharsets.UTF_8);
    }

    public boolean isLeaseFlagSet() {
        return this.isFlagSet(64);
    }

    public <T> Optional<T> mapResumeIdentificationToken(Function<ByteBuf, T> function) {
        Objects.requireNonNull(function, "function must not be null");
        return Optional.ofNullable(this.getUnsafeResumeIdentificationToken()).map(function);
    }

    public String toString() {
        return "SetupFrame{lease=" + this.isLeaseFlagSet() + ", majorVersion=" + this.getMajorVersion() + ", minorVersion=" + this.getMinorVersion() + ", keepAliveInterval=" + this.getKeepAliveInterval() + ", maxLifetime=" + this.getMaxLifetime() + ", resumeIdentificationToken=" + this.mapResumeIdentificationToken(ByteBufUtil::hexDump) + ", metadataMimeType=" + this.getMetadataMimeType() + ", dataMimeType=" + this.getDataMimeType() + ", metadata=" + this.mapMetadata(ByteBufUtil::hexDump) + ", data=" + (String)this.mapData(ByteBufUtil::hexDump) + '}';
    }

    private int getDataMimeTypeLength() {
        return this.getByteBuf().getUnsignedByte(this.getDataMimeTypeLengthOffset());
    }

    private int getDataMimeTypeLengthOffset() {
        return this.getMetadataMimeTypeOffset() + this.getMetadataMimeTypeLength();
    }

    private int getDataMimeTypeOffset() {
        return this.getDataMimeTypeLengthOffset() + 1;
    }

    private int getMetadataLengthOffset() {
        return this.getDataMimeTypeOffset() + this.getDataMimeTypeLength();
    }

    private int getMetadataMimeTypeLength() {
        return this.getByteBuf().getUnsignedByte(this.getMetadataMimeTypeLengthOffset());
    }

    private int getMetadataMimeTypeLengthOffset() {
        return this.getResumeIdentificationTokenOffset() + this.getResumeIdentificationTokenLength();
    }

    private int getMetadataMimeTypeOffset() {
        return this.getMetadataMimeTypeLengthOffset() + 1;
    }

    private int getResumeIdentificationTokenLength() {
        if (this.isFlagSet(128)) {
            return this.getByteBuf().getUnsignedShort(14);
        }
        return 0;
    }

    private int getResumeIdentificationTokenOffset() {
        if (this.isFlagSet(128)) {
            return 16;
        }
        return 14;
    }
}

