/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.framing;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.Recycler;
import io.rsocket.framing.AbstractRecyclableFrame;
import io.rsocket.framing.FrameType;
import io.rsocket.util.NumberUtils;
import io.rsocket.util.RecyclerFactory;
import java.util.Objects;

public final class RequestNFrame
extends AbstractRecyclableFrame<RequestNFrame> {
    private static final int OFFSET_REQUEST_N = 2;
    private static final Recycler<RequestNFrame> RECYCLER = RecyclerFactory.createRecycler(RequestNFrame::new);

    private RequestNFrame(Recycler.Handle<RequestNFrame> handle) {
        super(handle);
    }

    public static RequestNFrame createRequestNFrame(ByteBuf byteBuf) {
        Objects.requireNonNull(byteBuf, "byteBuf must not be null");
        return (RequestNFrame)((RequestNFrame)RECYCLER.get()).setByteBuf(byteBuf.retain());
    }

    public static RequestNFrame createRequestNFrame(ByteBufAllocator byteBufAllocator, int requestN) {
        NumberUtils.requirePositive(requestN, "requestN must be positive");
        ByteBuf byteBuf = RequestNFrame.createFrameTypeAndFlags(byteBufAllocator, FrameType.REQUEST_N).writeInt(requestN);
        return (RequestNFrame)((RequestNFrame)RECYCLER.get()).setByteBuf(byteBuf);
    }

    public String toString() {
        return "RequestNFrame{requestN=" + this.getRequestN() + '}';
    }

    int getRequestN() {
        return this.getByteBuf().getInt(2);
    }
}

