/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.framing;

import java.util.Arrays;
import java.util.EnumSet;

public enum FrameType {
    RESERVED(0),
    SETUP(1, EnumSet.of(Flags.CAN_HAVE_DATA, Flags.CAN_HAVE_METADATA)),
    LEASE(2, EnumSet.of(Flags.CAN_HAVE_METADATA)),
    KEEPALIVE(3, EnumSet.of(Flags.CAN_HAVE_DATA)),
    REQUEST_RESPONSE(4, EnumSet.of(Flags.CAN_HAVE_DATA, Flags.CAN_HAVE_METADATA, Flags.IS_FRAGMENTABLE, Flags.IS_REQUEST_TYPE)),
    REQUEST_FNF(5, EnumSet.of(Flags.CAN_HAVE_DATA, Flags.CAN_HAVE_METADATA, Flags.IS_FRAGMENTABLE, Flags.IS_REQUEST_TYPE)),
    REQUEST_STREAM(6, EnumSet.of(Flags.CAN_HAVE_METADATA, Flags.CAN_HAVE_DATA, Flags.HAS_INITIAL_REQUEST_N, Flags.IS_FRAGMENTABLE, Flags.IS_REQUEST_TYPE)),
    REQUEST_CHANNEL(7, EnumSet.of(Flags.CAN_HAVE_METADATA, Flags.CAN_HAVE_DATA, Flags.HAS_INITIAL_REQUEST_N, Flags.IS_FRAGMENTABLE, Flags.IS_REQUEST_TYPE)),
    REQUEST_N(8),
    CANCEL(9),
    PAYLOAD(10, EnumSet.of(Flags.CAN_HAVE_DATA, Flags.CAN_HAVE_METADATA, Flags.IS_FRAGMENTABLE)),
    ERROR(11, EnumSet.of(Flags.CAN_HAVE_DATA)),
    METADATA_PUSH(12, EnumSet.of(Flags.CAN_HAVE_METADATA)),
    RESUME(13),
    RESUME_OK(14),
    NEXT(160, EnumSet.of(Flags.CAN_HAVE_DATA, Flags.CAN_HAVE_METADATA, Flags.IS_FRAGMENTABLE)),
    COMPLETE(176),
    NEXT_COMPLETE(192, EnumSet.of(Flags.CAN_HAVE_DATA, Flags.CAN_HAVE_METADATA, Flags.IS_FRAGMENTABLE)),
    EXT(63, EnumSet.of(Flags.CAN_HAVE_DATA, Flags.CAN_HAVE_METADATA));

    static final int ENCODED_SIZE = 6;
    private static final FrameType[] FRAME_TYPES_BY_ENCODED_TYPE;
    private final int encodedType;
    private final EnumSet<Flags> flags;

    private FrameType(int encodedType) {
        this(encodedType, EnumSet.noneOf(Flags.class));
    }

    private FrameType(int encodedType, EnumSet<Flags> flags) {
        this.encodedType = encodedType;
        this.flags = flags;
    }

    public static FrameType fromEncodedType(int encodedType) {
        FrameType frameType = FRAME_TYPES_BY_ENCODED_TYPE[encodedType];
        if (frameType == null) {
            throw new IllegalArgumentException(String.format("Frame type %d is unknown", encodedType));
        }
        return frameType;
    }

    public boolean canHaveData() {
        return this.flags.contains((Object)Flags.CAN_HAVE_DATA);
    }

    public boolean canHaveMetadata() {
        return this.flags.contains((Object)Flags.CAN_HAVE_METADATA);
    }

    public int getEncodedType() {
        return this.encodedType;
    }

    public boolean hasInitialRequestN() {
        return this.flags.contains((Object)Flags.HAS_INITIAL_REQUEST_N);
    }

    public boolean isFragmentable() {
        return this.flags.contains((Object)Flags.IS_FRAGMENTABLE);
    }

    public boolean isRequestType() {
        return this.flags.contains((Object)Flags.IS_REQUEST_TYPE);
    }

    private static int getMaximumEncodedType() {
        return Arrays.stream(FrameType.values()).mapToInt(frameType -> frameType.encodedType).max().orElse(0);
    }

    static {
        FRAME_TYPES_BY_ENCODED_TYPE = new FrameType[FrameType.getMaximumEncodedType() + 1];
        FrameType[] frameTypeArray = FrameType.values();
        int n = frameTypeArray.length;
        for (int i = 0; i < n; ++i) {
            FrameType frameType;
            FrameType.FRAME_TYPES_BY_ENCODED_TYPE[frameType.encodedType] = frameType = frameTypeArray[i];
        }
    }

    private static enum Flags {
        CAN_HAVE_DATA,
        CAN_HAVE_METADATA,
        HAS_INITIAL_REQUEST_N,
        IS_FRAGMENTABLE,
        IS_REQUEST_TYPE;

    }
}

