/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.internal;

import io.netty.util.ReferenceCountUtil;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiFunction;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Operators;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

public final class SwitchTransformFlux<T, R>
extends Flux<R> {
    final Publisher<? extends T> source;
    final BiFunction<T, Flux<T>, Publisher<? extends R>> transformer;

    public SwitchTransformFlux(Publisher<? extends T> source, BiFunction<T, Flux<T>, Publisher<? extends R>> transformer) {
        this.source = Objects.requireNonNull(source, "source");
        this.transformer = Objects.requireNonNull(transformer, "transformer");
    }

    public int getPrefetch() {
        return 1;
    }

    public void subscribe(CoreSubscriber<? super R> actual) {
        if (actual instanceof Fuseable.ConditionalSubscriber) {
            this.source.subscribe(new SwitchTransformConditionalOperator<T, R>((Fuseable.ConditionalSubscriber)actual, this.transformer));
            return;
        }
        this.source.subscribe(new SwitchTransformOperator<T, R>(actual, this.transformer));
    }

    static final class ConditionalSubscriberAdapter<T>
    implements Fuseable.ConditionalSubscriber<T> {
        final CoreSubscriber<T> delegate;

        ConditionalSubscriberAdapter(CoreSubscriber<T> delegate) {
            this.delegate = delegate;
        }

        public Context currentContext() {
            return this.delegate.currentContext();
        }

        public void onSubscribe(Subscription s) {
            this.delegate.onSubscribe(s);
        }

        public void onNext(T t) {
            this.delegate.onNext(t);
        }

        public void onError(Throwable t) {
            this.delegate.onError(t);
        }

        public void onComplete() {
            this.delegate.onComplete();
        }

        public boolean tryOnNext(T t) {
            this.delegate.onNext(t);
            return true;
        }
    }

    static final class SwitchTransformConditionalOperator<T, R>
    extends Flux<T>
    implements Fuseable.ConditionalSubscriber<T>,
    Subscription,
    Scannable {
        final Fuseable.ConditionalSubscriber<? super R> outer;
        final BiFunction<T, Flux<T>, Publisher<? extends R>> transformer;
        Subscription s;
        Throwable throwable;
        volatile boolean done;
        volatile T first;
        volatile Fuseable.ConditionalSubscriber<? super T> inner;
        static final AtomicReferenceFieldUpdater<SwitchTransformConditionalOperator, Fuseable.ConditionalSubscriber> INNER = AtomicReferenceFieldUpdater.newUpdater(SwitchTransformConditionalOperator.class, Fuseable.ConditionalSubscriber.class, "inner");
        volatile int wip;
        static final AtomicIntegerFieldUpdater<SwitchTransformConditionalOperator> WIP = AtomicIntegerFieldUpdater.newUpdater(SwitchTransformConditionalOperator.class, "wip");
        volatile int once;
        static final AtomicIntegerFieldUpdater<SwitchTransformConditionalOperator> ONCE = AtomicIntegerFieldUpdater.newUpdater(SwitchTransformConditionalOperator.class, "once");

        SwitchTransformConditionalOperator(Fuseable.ConditionalSubscriber<? super R> outer, BiFunction<T, Flux<T>, Publisher<? extends R>> transformer) {
            this.outer = outer;
            this.transformer = transformer;
        }

        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.CANCELLED) {
                return this.s == Operators.cancelledSubscription();
            }
            if (key == Scannable.Attr.PREFETCH) {
                return 1;
            }
            return null;
        }

        public Context currentContext() {
            Fuseable.ConditionalSubscriber<? super T> actual = this.inner;
            if (actual != null) {
                return actual.currentContext();
            }
            return this.outer.currentContext();
        }

        public void cancel() {
            if (this.s != Operators.cancelledSubscription()) {
                Subscription s = this.s;
                this.s = Operators.cancelledSubscription();
                ReferenceCountUtil.safeRelease(this.first);
                if (WIP.getAndIncrement(this) == 0) {
                    INNER.lazySet(this, null);
                    this.first = null;
                }
                s.cancel();
            }
        }

        public void subscribe(CoreSubscriber<? super T> actual) {
            if (this.once == 0 && ONCE.compareAndSet(this, 0, 1)) {
                if (actual instanceof Fuseable.ConditionalSubscriber) {
                    INNER.lazySet(this, (Fuseable.ConditionalSubscriber)actual);
                } else {
                    INNER.lazySet(this, new ConditionalSubscriberAdapter<T>(actual));
                }
                actual.onSubscribe((Subscription)this);
            } else {
                Operators.error(actual, (Throwable)new IllegalStateException("SwitchTransform allows only one Subscriber"));
            }
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate((Subscription)this.s, (Subscription)s)) {
                this.s = s;
                s.request(1L);
            }
        }

        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t, (Context)this.currentContext());
                return;
            }
            Fuseable.ConditionalSubscriber<? super T> i = this.inner;
            if (i == null) {
                try {
                    this.first = t;
                    Publisher<? extends R> result = Objects.requireNonNull(this.transformer.apply(t, this), "The transformer returned a null value");
                    result.subscribe(this.outer);
                    return;
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError((Subscription)this.s, (Throwable)e, t, (Context)this.currentContext()));
                    ReferenceCountUtil.safeRelease(t);
                    return;
                }
            }
            i.onNext(t);
        }

        public boolean tryOnNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t, (Context)this.currentContext());
                return false;
            }
            Fuseable.ConditionalSubscriber<? super T> i = this.inner;
            if (i == null) {
                try {
                    this.first = t;
                    Publisher<? extends R> result = Objects.requireNonNull(this.transformer.apply(t, this), "The transformer returned a null value");
                    result.subscribe(this.outer);
                    return true;
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError((Subscription)this.s, (Throwable)e, t, (Context)this.currentContext()));
                    ReferenceCountUtil.safeRelease(t);
                    return false;
                }
            }
            return i.tryOnNext(t);
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped((Throwable)t, (Context)this.currentContext());
                return;
            }
            this.throwable = t;
            this.done = true;
            Fuseable.ConditionalSubscriber<? super T> i = this.inner;
            if (i != null) {
                if (this.first == null) {
                    this.drainRegular();
                }
            } else {
                Operators.error(this.outer, (Throwable)t);
            }
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            Fuseable.ConditionalSubscriber<? super T> i = this.inner;
            if (i != null) {
                if (this.first == null) {
                    this.drainRegular();
                }
            } else {
                Operators.complete(this.outer);
            }
        }

        public void request(long n) {
            if (this.first != null && this.drainRegular() && n != Long.MAX_VALUE) {
                if (--n > 0L) {
                    this.s.request(n);
                }
            } else {
                this.s.request(n);
            }
        }

        boolean drainRegular() {
            if (WIP.getAndIncrement(this) != 0) {
                return false;
            }
            T f = this.first;
            int m = 1;
            boolean sent = false;
            Subscription s = this.s;
            Fuseable.ConditionalSubscriber<? super T> a = this.inner;
            do {
                if (f != null) {
                    this.first = null;
                    ReferenceCountUtil.safeRelease(f);
                    if (s == Operators.cancelledSubscription()) {
                        Operators.onNextDropped(f, (Context)a.currentContext());
                        return true;
                    }
                    a.onNext(f);
                    f = null;
                    sent = true;
                }
                if (s == Operators.cancelledSubscription()) {
                    return sent;
                }
                if (!this.done) continue;
                Throwable t = this.throwable;
                if (t != null) {
                    a.onError(t);
                } else {
                    a.onComplete();
                }
                return sent;
            } while ((m = WIP.addAndGet(this, -m)) != 0);
            return sent;
        }
    }

    static final class SwitchTransformOperator<T, R>
    extends Flux<T>
    implements CoreSubscriber<T>,
    Subscription,
    Scannable {
        final CoreSubscriber<? super R> outer;
        final BiFunction<T, Flux<T>, Publisher<? extends R>> transformer;
        Subscription s;
        Throwable throwable;
        volatile boolean done;
        volatile T first;
        volatile CoreSubscriber<? super T> inner;
        static final AtomicReferenceFieldUpdater<SwitchTransformOperator, CoreSubscriber> INNER = AtomicReferenceFieldUpdater.newUpdater(SwitchTransformOperator.class, CoreSubscriber.class, "inner");
        volatile int wip;
        static final AtomicIntegerFieldUpdater<SwitchTransformOperator> WIP = AtomicIntegerFieldUpdater.newUpdater(SwitchTransformOperator.class, "wip");
        volatile int once;
        static final AtomicIntegerFieldUpdater<SwitchTransformOperator> ONCE = AtomicIntegerFieldUpdater.newUpdater(SwitchTransformOperator.class, "once");

        SwitchTransformOperator(CoreSubscriber<? super R> outer, BiFunction<T, Flux<T>, Publisher<? extends R>> transformer) {
            this.outer = outer;
            this.transformer = transformer;
        }

        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.CANCELLED) {
                return this.s == Operators.cancelledSubscription();
            }
            if (key == Scannable.Attr.PREFETCH) {
                return 1;
            }
            return null;
        }

        public Context currentContext() {
            CoreSubscriber<? super T> actual = this.inner;
            if (actual != null) {
                return actual.currentContext();
            }
            return this.outer.currentContext();
        }

        public void cancel() {
            if (this.s != Operators.cancelledSubscription()) {
                Subscription s = this.s;
                this.s = Operators.cancelledSubscription();
                ReferenceCountUtil.safeRelease(this.first);
                if (WIP.getAndIncrement(this) == 0) {
                    INNER.lazySet(this, null);
                    this.first = null;
                }
                s.cancel();
            }
        }

        public void subscribe(CoreSubscriber<? super T> actual) {
            if (this.once == 0 && ONCE.compareAndSet(this, 0, 1)) {
                INNER.lazySet(this, actual);
                actual.onSubscribe((Subscription)this);
            } else {
                Operators.error(actual, (Throwable)new IllegalStateException("SwitchTransform allows only one Subscriber"));
            }
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate((Subscription)this.s, (Subscription)s)) {
                this.s = s;
                s.request(1L);
            }
        }

        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t, (Context)this.currentContext());
                return;
            }
            CoreSubscriber<? super T> i = this.inner;
            if (i == null) {
                try {
                    this.first = t;
                    Publisher<? extends R> result = Objects.requireNonNull(this.transformer.apply(t, this), "The transformer returned a null value");
                    result.subscribe(this.outer);
                    return;
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError((Subscription)this.s, (Throwable)e, t, (Context)this.currentContext()));
                    ReferenceCountUtil.safeRelease(t);
                    return;
                }
            }
            i.onNext(t);
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped((Throwable)t, (Context)this.currentContext());
                return;
            }
            this.throwable = t;
            this.done = true;
            CoreSubscriber<? super T> i = this.inner;
            if (i != null) {
                if (this.first == null) {
                    this.drainRegular();
                }
            } else {
                Operators.error(this.outer, (Throwable)t);
            }
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            CoreSubscriber<? super T> i = this.inner;
            if (i != null) {
                if (this.first == null) {
                    this.drainRegular();
                }
            } else {
                Operators.complete(this.outer);
            }
        }

        public void request(long n) {
            if (this.first != null && this.drainRegular() && n != Long.MAX_VALUE) {
                if ((n = Operators.addCap((long)n, (long)-1L)) > 0L) {
                    this.s.request(n);
                }
            } else {
                this.s.request(n);
            }
        }

        boolean drainRegular() {
            if (WIP.getAndIncrement(this) != 0) {
                return false;
            }
            T f = this.first;
            int m = 1;
            boolean sent = false;
            Subscription s = this.s;
            CoreSubscriber<? super T> a = this.inner;
            do {
                if (f != null) {
                    this.first = null;
                    ReferenceCountUtil.safeRelease(f);
                    if (s == Operators.cancelledSubscription()) {
                        Operators.onNextDropped(f, (Context)a.currentContext());
                        return true;
                    }
                    a.onNext(f);
                    f = null;
                    sent = true;
                }
                if (s == Operators.cancelledSubscription()) {
                    return sent;
                }
                if (!this.done) continue;
                Throwable t = this.throwable;
                if (t != null) {
                    a.onError(t);
                } else {
                    a.onComplete();
                }
                return sent;
            } while ((m = WIP.addAndGet(this, -m)) != 0);
            return sent;
        }
    }
}

