/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket;

import io.netty.buffer.Unpooled;
import io.rsocket.DuplexConnection;
import io.rsocket.Frame;
import io.rsocket.Payload;
import io.rsocket.RSocket;
import io.rsocket.StreamIdSupplier;
import io.rsocket.exceptions.ConnectionErrorException;
import io.rsocket.exceptions.Exceptions;
import io.rsocket.framing.FrameType;
import io.rsocket.internal.LimitableRequestPublisher;
import io.rsocket.internal.UnboundedProcessor;
import io.rsocket.shadowed.org.jctools.maps.NonBlockingHashMapLong;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;
import reactor.core.publisher.SignalType;
import reactor.core.publisher.UnicastProcessor;

class RSocketClient
implements RSocket {
    private final DuplexConnection connection;
    private final Function<Frame, ? extends Payload> frameDecoder;
    private final Consumer<Throwable> errorConsumer;
    private final StreamIdSupplier streamIdSupplier;
    private final MonoProcessor<Void> started;
    private final NonBlockingHashMapLong<LimitableRequestPublisher> senders;
    private final NonBlockingHashMapLong<UnicastProcessor<Payload>> receivers;
    private final AtomicInteger missedAckCounter;
    private final UnboundedProcessor<Frame> sendProcessor;
    @Nullable
    private Disposable keepAliveSendSub;
    private volatile long timeLastTickSentMs;

    RSocketClient(DuplexConnection connection, Function<Frame, ? extends Payload> frameDecoder, Consumer<Throwable> errorConsumer, StreamIdSupplier streamIdSupplier) {
        this(connection, frameDecoder, errorConsumer, streamIdSupplier, Duration.ZERO, Duration.ZERO, 0);
    }

    RSocketClient(DuplexConnection connection, Function<Frame, ? extends Payload> frameDecoder, Consumer<Throwable> errorConsumer, StreamIdSupplier streamIdSupplier, Duration tickPeriod, Duration ackTimeout, int missedAcks) {
        this.connection = connection;
        this.frameDecoder = frameDecoder;
        this.errorConsumer = errorConsumer;
        this.streamIdSupplier = streamIdSupplier;
        this.started = MonoProcessor.create();
        this.senders = new NonBlockingHashMapLong(256);
        this.receivers = new NonBlockingHashMapLong(256);
        this.missedAckCounter = new AtomicInteger();
        this.sendProcessor = new UnboundedProcessor();
        if (!Duration.ZERO.equals(tickPeriod)) {
            long ackTimeoutMs = ackTimeout.toMillis();
            this.keepAliveSendSub = this.started.thenMany((Publisher)Flux.interval((Duration)tickPeriod)).doOnSubscribe(s -> {
                this.timeLastTickSentMs = System.currentTimeMillis();
            }).subscribe(i -> this.sendKeepAlive(ackTimeoutMs, missedAcks), t -> {
                errorConsumer.accept((Throwable)t);
                connection.dispose();
            });
        }
        connection.onClose().doFinally(signalType -> this.cleanup()).subscribe(null, errorConsumer);
        connection.send((Publisher<Frame>)this.sendProcessor).doFinally(this::handleSendProcessorCancel).subscribe(null, this::handleSendProcessorError);
        connection.receive().doOnSubscribe(subscription -> this.started.onComplete()).subscribe(this::handleIncomingFrames, errorConsumer);
    }

    private void handleSendProcessorError(Throwable t) {
        for (Subscriber subscriber : this.receivers.values()) {
            try {
                subscriber.onError(t);
            }
            catch (Throwable e) {
                this.errorConsumer.accept(e);
            }
        }
        for (LimitableRequestPublisher limitableRequestPublisher : this.senders.values()) {
            limitableRequestPublisher.cancel();
        }
    }

    private void handleSendProcessorCancel(SignalType t) {
        if (SignalType.ON_ERROR == t) {
            return;
        }
        for (Subscriber subscriber : this.receivers.values()) {
            try {
                subscriber.onError(new Throwable("closed connection"));
            }
            catch (Throwable e) {
                this.errorConsumer.accept(e);
            }
        }
        for (LimitableRequestPublisher limitableRequestPublisher : this.senders.values()) {
            limitableRequestPublisher.cancel();
        }
    }

    private void sendKeepAlive(long ackTimeoutMs, int missedAcks) {
        int count;
        long now = System.currentTimeMillis();
        if (now - this.timeLastTickSentMs > ackTimeoutMs && (count = this.missedAckCounter.incrementAndGet()) >= missedAcks) {
            String message = String.format("Missed %d keep-alive acks with a threshold of %d and a ack timeout of %d ms", count, missedAcks, ackTimeoutMs);
            throw new ConnectionErrorException(message);
        }
        this.sendProcessor.onNext(Frame.Keepalive.from(Unpooled.EMPTY_BUFFER, true));
    }

    @Override
    public Mono<Void> fireAndForget(Payload payload) {
        Mono defer = Mono.fromRunnable(() -> {
            int streamId = this.streamIdSupplier.nextStreamId();
            Frame requestFrame = Frame.Request.from(streamId, FrameType.REQUEST_FNF, payload, 1);
            payload.release();
            this.sendProcessor.onNext(requestFrame);
        });
        return this.started.then(defer);
    }

    @Override
    public Mono<Payload> requestResponse(Payload payload) {
        return this.handleRequestResponse(payload);
    }

    @Override
    public Flux<Payload> requestStream(Payload payload) {
        return this.handleRequestStream(payload);
    }

    @Override
    public Flux<Payload> requestChannel(Publisher<Payload> payloads) {
        return this.handleChannel((Flux<Payload>)Flux.from(payloads), FrameType.REQUEST_CHANNEL);
    }

    @Override
    public Mono<Void> metadataPush(Payload payload) {
        Mono defer = Mono.fromRunnable(() -> {
            Frame requestFrame = Frame.Request.from(0, FrameType.METADATA_PUSH, payload, 1);
            payload.release();
            this.sendProcessor.onNext(requestFrame);
        });
        return this.started.then(defer);
    }

    @Override
    public double availability() {
        return this.connection.availability();
    }

    public void dispose() {
        this.connection.dispose();
    }

    public boolean isDisposed() {
        return this.connection.isDisposed();
    }

    @Override
    public Mono<Void> onClose() {
        return this.connection.onClose();
    }

    public Flux<Payload> handleRequestStream(Payload payload) {
        return this.started.thenMany((Publisher)Flux.defer(() -> {
            int streamId = this.streamIdSupplier.nextStreamId();
            UnicastProcessor receiver = UnicastProcessor.create();
            this.receivers.put(streamId, (UnicastProcessor<Payload>)receiver);
            AtomicBoolean first = new AtomicBoolean(false);
            return receiver.doOnRequest(l -> {
                if (first.compareAndSet(false, true) && !receiver.isDisposed()) {
                    Frame requestFrame = Frame.Request.from(streamId, FrameType.REQUEST_STREAM, payload, l);
                    payload.release();
                    this.sendProcessor.onNext(requestFrame);
                } else if (this.contains(streamId) && !receiver.isDisposed()) {
                    this.sendProcessor.onNext(Frame.RequestN.from(streamId, l));
                }
                this.sendProcessor.drain();
            }).doOnError(t -> {
                if (this.contains(streamId) && !receiver.isDisposed()) {
                    this.sendProcessor.onNext(Frame.Error.from(streamId, t));
                }
            }).doOnCancel(() -> {
                if (this.contains(streamId) && !receiver.isDisposed()) {
                    this.sendProcessor.onNext(Frame.Cancel.from(streamId));
                }
            }).doFinally(s -> this.receivers.remove(streamId));
        }));
    }

    private Mono<Payload> handleRequestResponse(Payload payload) {
        return this.started.then(Mono.defer(() -> {
            int streamId = this.streamIdSupplier.nextStreamId();
            Frame requestFrame = Frame.Request.from(streamId, FrameType.REQUEST_RESPONSE, payload, 1);
            payload.release();
            UnicastProcessor receiver = UnicastProcessor.create();
            this.receivers.put(streamId, (UnicastProcessor<Payload>)receiver);
            this.sendProcessor.onNext(requestFrame);
            return receiver.singleOrEmpty().doOnError(t -> this.sendProcessor.onNext(Frame.Error.from(streamId, t))).doOnCancel(() -> this.sendProcessor.onNext(Frame.Cancel.from(streamId))).doFinally(s -> this.receivers.remove(streamId));
        }));
    }

    private Flux<Payload> handleChannel(final Flux<Payload> request, final FrameType requestType) {
        return this.started.thenMany((Publisher)Flux.defer((Supplier)new Supplier<Flux<Payload>>(){
            final UnicastProcessor<Payload> receiver = UnicastProcessor.create();
            final int streamId = RSocketClient.access$000(RSocketClient.this).nextStreamId();
            @Nullable
            volatile MonoProcessor<Void> subscribedRequests;
            boolean firstRequest = true;

            boolean isValidToSendFrame() {
                return RSocketClient.this.contains(this.streamId) && !this.receiver.isDisposed();
            }

            void sendOneFrame(Frame frame) {
                if (this.isValidToSendFrame()) {
                    RSocketClient.this.sendProcessor.onNext(frame);
                }
            }

            @Override
            public Flux<Payload> get() {
                return this.receiver.doOnRequest(l -> {
                    boolean _firstRequest = false;
                    RSocketClient rSocketClient = RSocketClient.this;
                    synchronized (rSocketClient) {
                        if (this.firstRequest) {
                            _firstRequest = true;
                            this.firstRequest = false;
                        }
                    }
                    if (_firstRequest) {
                        final AtomicBoolean firstPayload = new AtomicBoolean(true);
                        Flux requestFrames = request.transform(f -> {
                            LimitableRequestPublisher wrapped = LimitableRequestPublisher.wrap(f);
                            wrapped.increaseRequestLimit(1L);
                            RSocketClient.this.senders.put(this.streamId, wrapped);
                            RSocketClient.this.receivers.put(this.streamId, this.receiver);
                            return wrapped;
                        }).map((Function)new Function<Payload, Frame>(){

                            @Override
                            public Frame apply(Payload payload) {
                                Frame requestFrame = firstPayload.compareAndSet(true, false) ? Frame.Request.from(streamId, requestType, payload, l) : Frame.PayloadFrame.from(streamId, FrameType.NEXT, payload);
                                payload.release();
                                return requestFrame;
                            }
                        }).doOnComplete(() -> {
                            if (FrameType.REQUEST_CHANNEL == requestType) {
                                this.sendOneFrame(Frame.PayloadFrame.from(this.streamId, FrameType.COMPLETE));
                                if (firstPayload.get()) {
                                    this.receiver.onComplete();
                                }
                            }
                        });
                        requestFrames.subscribe(RSocketClient.this.sendProcessor::onNext, t -> {
                            RSocketClient.this.errorConsumer.accept(t);
                            this.receiver.dispose();
                        });
                    } else {
                        this.sendOneFrame(Frame.RequestN.from(this.streamId, l));
                    }
                }).doOnError(t -> this.sendOneFrame(Frame.Error.from(this.streamId, t))).doOnCancel(() -> {
                    this.sendOneFrame(Frame.Cancel.from(this.streamId));
                    if (this.subscribedRequests != null) {
                        this.subscribedRequests.cancel();
                    }
                }).doFinally(s -> {
                    RSocketClient.this.receivers.remove(this.streamId);
                    RSocketClient.this.senders.remove(this.streamId);
                });
            }
        }));
    }

    private boolean contains(int streamId) {
        return this.receivers.containsKey(streamId);
    }

    protected void cleanup() {
        try {
            for (UnicastProcessor<Payload> subscriber : this.receivers.values()) {
                this.cleanUpSubscriber(subscriber);
            }
            for (LimitableRequestPublisher p : this.senders.values()) {
                this.cleanUpLimitableRequestPublisher(p);
            }
            if (null != this.keepAliveSendSub) {
                this.keepAliveSendSub.dispose();
            }
        }
        finally {
            this.senders.clear();
            this.receivers.clear();
        }
    }

    private synchronized void cleanUpLimitableRequestPublisher(LimitableRequestPublisher<?> limitableRequestPublisher) {
        try {
            limitableRequestPublisher.cancel();
        }
        catch (Throwable t) {
            this.errorConsumer.accept(t);
        }
    }

    private synchronized void cleanUpSubscriber(UnicastProcessor<?> subscriber) {
        try {
            subscriber.cancel();
        }
        catch (Throwable t) {
            this.errorConsumer.accept(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleIncomingFrames(Frame frame) {
        try {
            int streamId = frame.getStreamId();
            FrameType type = frame.getType();
            if (streamId == 0) {
                this.handleStreamZero(type, frame);
            } else {
                this.handleFrame(streamId, type, frame);
            }
        }
        finally {
            frame.release();
        }
    }

    private void handleStreamZero(FrameType type, Frame frame) {
        switch (type) {
            case ERROR: {
                throw Exceptions.from(frame);
            }
            case LEASE: {
                break;
            }
            case KEEPALIVE: {
                if (Frame.Keepalive.hasRespondFlag(frame)) break;
                this.timeLastTickSentMs = System.currentTimeMillis();
                break;
            }
            default: {
                this.errorConsumer.accept(new IllegalStateException("Client received supported frame on stream 0: " + frame.toString()));
            }
        }
    }

    private void handleFrame(int streamId, FrameType type, Frame frame) {
        Subscriber receiver = (Subscriber)this.receivers.get(streamId);
        if (receiver == null) {
            this.handleMissingResponseProcessor(streamId, type, frame);
        } else {
            switch (type) {
                case ERROR: {
                    receiver.onError((Throwable)Exceptions.from(frame));
                    this.receivers.remove(streamId);
                    break;
                }
                case NEXT_COMPLETE: {
                    receiver.onNext((Object)this.frameDecoder.apply(frame));
                    receiver.onComplete();
                    break;
                }
                case CANCEL: {
                    LimitableRequestPublisher sender = this.senders.remove(streamId);
                    this.receivers.remove(streamId);
                    if (sender == null) break;
                    sender.cancel();
                    break;
                }
                case NEXT: {
                    receiver.onNext((Object)this.frameDecoder.apply(frame));
                    break;
                }
                case REQUEST_N: {
                    LimitableRequestPublisher sender = this.senders.get(streamId);
                    if (sender == null) break;
                    int n = Frame.RequestN.requestN(frame);
                    sender.increaseRequestLimit(n);
                    this.sendProcessor.drain();
                    break;
                }
                case COMPLETE: {
                    receiver.onComplete();
                    this.receivers.remove(streamId);
                    break;
                }
                default: {
                    throw new IllegalStateException("Client received supported frame on stream " + streamId + ": " + frame.toString());
                }
            }
        }
    }

    private void handleMissingResponseProcessor(int streamId, FrameType type, Frame frame) {
        if (!this.streamIdSupplier.isBeforeOrCurrent(streamId)) {
            if (type == FrameType.ERROR) {
                String errorMessage = frame.getDataUtf8();
                throw new IllegalStateException("Client received error for non-existent stream: " + streamId + " Message: " + errorMessage);
            }
            throw new IllegalStateException("Client received message for non-existent stream: " + streamId + ", frame type: " + (Object)((Object)type));
        }
    }

    static /* synthetic */ StreamIdSupplier access$000(RSocketClient x0) {
        return x0.streamIdSupplier;
    }
}

