/*
 * Decompiled with CFR 0.152.
 */
package io.restassured.module.mockmvc.internal;

import io.restassured.authentication.AuthenticationScheme;
import io.restassured.authentication.NoAuthScheme;
import io.restassured.config.LogConfig;
import io.restassured.filter.log.LogDetail;
import io.restassured.filter.log.RequestLoggingFilter;
import io.restassured.internal.LogSpecificationImpl;
import io.restassured.internal.RequestSpecificationImpl;
import io.restassured.module.mockmvc.internal.MockMvcRequestSpecificationImpl;
import io.restassured.module.mockmvc.specification.MockMvcRequestLogSpecification;
import io.restassured.module.mockmvc.specification.MockMvcRequestSpecification;
import io.restassured.specification.RequestSpecification;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Set;

public class MockMvcRequestLogSpecificationImpl
extends LogSpecificationImpl
implements MockMvcRequestLogSpecification {
    private MockMvcRequestSpecificationImpl requestSpecification;

    public MockMvcRequestLogSpecificationImpl(MockMvcRequestSpecificationImpl requestSpecification) {
        this.requestSpecification = requestSpecification;
    }

    @Override
    public MockMvcRequestSpecification params() {
        return this.logWith(LogDetail.PARAMS);
    }

    @Override
    public MockMvcRequestSpecification parameters() {
        return this.logWith(LogDetail.PARAMS);
    }

    public MockMvcRequestSpecification body() {
        return this.body(this.shouldPrettyPrint((RequestSpecification)this.toRequestSpecification()));
    }

    public MockMvcRequestSpecification body(boolean shouldPrettyPrint) {
        return this.logWith(LogDetail.BODY, shouldPrettyPrint);
    }

    public MockMvcRequestSpecification all(boolean shouldPrettyPrint) {
        return this.logWith(LogDetail.ALL, shouldPrettyPrint);
    }

    public MockMvcRequestSpecification everything(boolean shouldPrettyPrint) {
        return this.all(shouldPrettyPrint);
    }

    public MockMvcRequestSpecification all() {
        return this.all(this.shouldPrettyPrint((RequestSpecification)this.toRequestSpecification()));
    }

    public MockMvcRequestSpecification everything() {
        return this.all();
    }

    public MockMvcRequestSpecification headers() {
        return this.logWith(LogDetail.HEADERS);
    }

    public MockMvcRequestSpecification cookies() {
        return this.logWith(LogDetail.COOKIES);
    }

    public MockMvcRequestSpecification ifValidationFails() {
        return this.ifValidationFails(LogDetail.ALL);
    }

    public MockMvcRequestSpecification ifValidationFails(LogDetail logDetail) {
        return this.ifValidationFails(logDetail, this.shouldPrettyPrint((RequestSpecification)this.toRequestSpecification()));
    }

    public MockMvcRequestSpecification ifValidationFails(LogDetail logDetail, boolean shouldPrettyPrint) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.requestSpecification.getLogRepository().registerRequestLog(baos);
        return this.logWith(logDetail, shouldPrettyPrint, ps);
    }

    private MockMvcRequestSpecification logWith(LogDetail logDetail) {
        RequestSpecificationImpl reqSpec = this.toRequestSpecification();
        return this.logWith(logDetail, this.shouldPrettyPrint((RequestSpecification)reqSpec));
    }

    private MockMvcRequestSpecification logWith(LogDetail logDetail, boolean prettyPrintingEnabled) {
        return this.logWith(logDetail, prettyPrintingEnabled, this.getPrintStream((RequestSpecification)this.toRequestSpecification()));
    }

    private MockMvcRequestSpecification logWith(LogDetail logDetail, boolean prettyPrintingEnabled, PrintStream printStream) {
        LogConfig logConfig = this.requestSpecification.getRestAssuredMockMvcConfig().getLogConfig();
        boolean shouldUrlEncodeRequestUri = logConfig.shouldUrlEncodeRequestUri();
        Set blacklistedHeaders = logConfig.blacklistedHeaders();
        this.requestSpecification.setRequestLoggingFilter(new RequestLoggingFilter(logDetail, prettyPrintingEnabled, printStream, shouldUrlEncodeRequestUri, blacklistedHeaders));
        return this.requestSpecification;
    }

    private RequestSpecificationImpl toRequestSpecification() {
        return new RequestSpecificationImpl("", 8080, "", (AuthenticationScheme)new NoAuthScheme(), Collections.emptyList(), null, true, this.requestSpecification.getRestAssuredConfig(), this.requestSpecification.getLogRepository(), null);
    }
}

