/*
 * Decompiled with CFR 0.152.
 */
package io.restassured.module.spring.commons;

import io.restassured.config.EncoderConfig;
import io.restassured.config.HeaderConfig;
import io.restassured.http.Header;
import io.restassured.http.Headers;
import io.restassured.internal.common.assertion.AssertParameter;
import io.restassured.module.spring.commons.Serializer;
import io.restassured.module.spring.commons.config.SpecificationConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class HeaderHelper {
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String CHARSET = "charset";

    private HeaderHelper() {
    }

    public static Headers headers(Headers requestHeaders, Map<String, ?> headers, SpecificationConfig config) {
        AssertParameter.notNull(headers, (String)"headers");
        ArrayList<Header> headerList = new ArrayList<Header>();
        if (requestHeaders.exist()) {
            for (Header requestHeader : requestHeaders) {
                headerList.add(requestHeader);
            }
        }
        for (Map.Entry<String, ?> stringEntry : headers.entrySet()) {
            Object value = stringEntry.getValue();
            if (value instanceof List) {
                List values = (List)value;
                for (Object headerValue : values) {
                    headerList.add(new Header(stringEntry.getKey(), Serializer.serializeIfNeeded(headerValue, HeaderHelper.getRequestContentType(requestHeaders), config)));
                }
                continue;
            }
            headerList.add(new Header(stringEntry.getKey(), Serializer.serializeIfNeeded(value, HeaderHelper.getRequestContentType(requestHeaders), config)));
        }
        return new Headers(headerList);
    }

    public static String getRequestContentType(Headers requestHeaders) {
        Header header = requestHeaders.get(CONTENT_TYPE);
        if (header != null) {
            return header.getValue();
        }
        return null;
    }

    public static Headers headers(Headers requestHeaders, Headers headersToAdd, HeaderConfig headerConfig) {
        AssertParameter.notNull((Object)headersToAdd, (String)"Headers");
        if (headersToAdd.exist()) {
            ArrayList<Header> headerList = new ArrayList<Header>();
            if (requestHeaders.exist()) {
                for (Header requestHeader : requestHeaders) {
                    headerList.add(requestHeader);
                }
            }
            for (Header requestHeader : headersToAdd) {
                headerList.add(requestHeader);
            }
            return new Headers(HeaderHelper.removeMergedHeadersIfNeeded(headerList, headerConfig));
        }
        return requestHeaders;
    }

    public static String findContentType(Headers headers, List<Object> multiParts, SpecificationConfig config) {
        String baseContentType = headers.getValue(CONTENT_TYPE);
        if (StringUtils.isBlank((CharSequence)baseContentType) && !multiParts.isEmpty()) {
            baseContentType = "multipart/" + config.getMultiPartConfig().defaultSubtype();
        }
        EncoderConfig encoderConfig = config.getEncoderConfig();
        if (!(!StringUtils.equalsIgnoreCase((CharSequence)baseContentType, (CharSequence)"application/json") || encoderConfig.hasDefaultCharsetForContentType("application/json") && encoderConfig.isUserConfigured())) {
            return baseContentType;
        }
        if (StringUtils.containsIgnoreCase((CharSequence)baseContentType, (CharSequence)CHARSET)) {
            return baseContentType;
        }
        return HeaderHelper.appendCharsetToContentType(baseContentType, encoderConfig);
    }

    public static String buildApplicationFormEncodedContentType(SpecificationConfig config, String baseContentType) {
        return HeaderHelper.appendCharsetToContentType(baseContentType, config.getEncoderConfig());
    }

    public static Object[] mapToArray(Map<String, ?> map) {
        if (map == null) {
            return new Object[0];
        }
        return map.values().toArray(new Object[map.values().size()]);
    }

    private static List<Header> removeMergedHeadersIfNeeded(List<Header> headerList, HeaderConfig headerConfig) {
        ArrayList<Header> filteredList = new ArrayList<Header>();
        for (Header header : headerList) {
            String headerName = header.getName();
            if (headerConfig.shouldOverwriteHeaderWithName(headerName)) {
                int index = -1;
                for (int i = 0; i < filteredList.size(); ++i) {
                    Header filteredHeader = (Header)filteredList.get(i);
                    if (!filteredHeader.hasSameNameAs(header)) continue;
                    index = i;
                    break;
                }
                if (index != -1) {
                    filteredList.remove(index);
                }
            }
            filteredList.add(header);
        }
        return filteredList;
    }

    public static Headers headers(final Headers requestHeaders, final String headerName, final Object headerValue, final SpecificationConfig config, Object ... additionalHeaderValues) {
        AssertParameter.notNull((Object)headerName, (String)"Header name");
        AssertParameter.notNull((Object)headerValue, (String)"Header value");
        ArrayList<Header> headerList = new ArrayList<Header>(){
            {
                this.add(new Header(headerName, Serializer.serializeIfNeeded(headerValue, HeaderHelper.getRequestContentType(requestHeaders), config)));
            }
        };
        if (additionalHeaderValues != null) {
            for (Object additionalHeaderValue : additionalHeaderValues) {
                headerList.add(new Header(headerName, Serializer.serializeIfNeeded(additionalHeaderValue, HeaderHelper.getRequestContentType(requestHeaders), config)));
            }
        }
        return new Headers((List)headerList);
    }

    private static String appendCharsetToContentType(String baseContentType, EncoderConfig encoderConfig) {
        if (baseContentType == null || !encoderConfig.shouldAppendDefaultContentCharsetToContentTypeIfUndefined()) {
            return baseContentType;
        }
        String contentType = baseContentType + "; charset=";
        contentType = encoderConfig.hasDefaultCharsetForContentType(baseContentType) ? contentType + encoderConfig.defaultCharsetForContentType(baseContentType) : contentType + encoderConfig.defaultContentCharset();
        return contentType;
    }
}

