/*
 * Decompiled with CFR 0.152.
 */
package io.requery.android.database.sqlite;

import android.annotation.SuppressLint;
import android.content.ContentValues;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabaseCorruptException;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteTransactionListener;
import android.os.CancellationSignal;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import android.util.EventLog;
import android.util.Log;
import android.util.Pair;
import android.util.Printer;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.os.CancellationSignal;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteProgram;
import androidx.sqlite.db.SupportSQLiteQuery;
import io.requery.android.database.DatabaseErrorHandler;
import io.requery.android.database.DefaultDatabaseErrorHandler;
import io.requery.android.database.sqlite.CloseGuard;
import io.requery.android.database.sqlite.SQLiteClosable;
import io.requery.android.database.sqlite.SQLiteConnection;
import io.requery.android.database.sqlite.SQLiteConnectionPool;
import io.requery.android.database.sqlite.SQLiteCursor;
import io.requery.android.database.sqlite.SQLiteCursorDriver;
import io.requery.android.database.sqlite.SQLiteCustomFunction;
import io.requery.android.database.sqlite.SQLiteDatabaseConfiguration;
import io.requery.android.database.sqlite.SQLiteDebug;
import io.requery.android.database.sqlite.SQLiteDirectCursorDriver;
import io.requery.android.database.sqlite.SQLiteFunction;
import io.requery.android.database.sqlite.SQLiteGlobal;
import io.requery.android.database.sqlite.SQLiteQuery;
import io.requery.android.database.sqlite.SQLiteQueryBuilder;
import io.requery.android.database.sqlite.SQLiteSession;
import io.requery.android.database.sqlite.SQLiteStatement;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;

@SuppressLint(value={"ShiftFlags"})
public final class SQLiteDatabase
extends SQLiteClosable
implements SupportSQLiteDatabase {
    public static final String LIBRARY_NAME = "sqlite3x";
    private static final String TAG = "SQLiteDatabase";
    private static final int EVENT_DB_CORRUPT = 75004;
    private static final WeakHashMap<SQLiteDatabase, Object> sActiveDatabases;
    private final ThreadLocal<SQLiteSession> mThreadSession = new ThreadLocal<SQLiteSession>(){

        @Override
        protected SQLiteSession initialValue() {
            return SQLiteDatabase.this.createSession();
        }
    };
    private final CursorFactory mCursorFactory;
    private final DatabaseErrorHandler mErrorHandler;
    private final Object mLock = new Object();
    private final CloseGuard mCloseGuardLocked = CloseGuard.get();
    private final SQLiteDatabaseConfiguration mConfigurationLocked;
    private SQLiteConnectionPool mConnectionPoolLocked;
    public static final int CONFLICT_ROLLBACK = 1;
    public static final int CONFLICT_ABORT = 2;
    public static final int CONFLICT_FAIL = 3;
    public static final int CONFLICT_IGNORE = 4;
    public static final int CONFLICT_REPLACE = 5;
    public static final int CONFLICT_NONE = 0;
    private static final String[] CONFLICT_VALUES;
    public static final int OPEN_READONLY = 1;
    public static final int OPEN_READWRITE = 2;
    public static final int OPEN_CREATE = 4;
    public static final int OPEN_URI = 64;
    public static final int OPEN_NOMUTEX = 32768;
    public static final int OPEN_FULLMUTEX = 65536;
    public static final int OPEN_SHAREDCACHE = 131072;
    public static final int OPEN_PRIVATECACHE = 262144;
    public static final int CREATE_IF_NECESSARY = 6;
    public static final int ENABLE_WRITE_AHEAD_LOGGING = 0x20000000;
    public static final int MAX_SQL_CACHE_SIZE = 100;

    private SQLiteDatabase(SQLiteDatabaseConfiguration configuration, CursorFactory cursorFactory, DatabaseErrorHandler errorHandler) {
        this.mCursorFactory = cursorFactory;
        this.mErrorHandler = errorHandler != null ? errorHandler : new DefaultDatabaseErrorHandler();
        this.mConfigurationLocked = configuration;
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose(true);
        }
        finally {
            super.finalize();
        }
    }

    @Override
    protected void onAllReferencesReleased() {
        this.dispose(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispose(boolean finalized) {
        SQLiteConnectionPool pool;
        WeakHashMap<SQLiteDatabase, Object> weakHashMap = this.mLock;
        synchronized (weakHashMap) {
            if (this.mCloseGuardLocked != null) {
                if (finalized) {
                    this.mCloseGuardLocked.warnIfOpen();
                }
                this.mCloseGuardLocked.close();
            }
            pool = this.mConnectionPoolLocked;
            this.mConnectionPoolLocked = null;
        }
        if (!finalized) {
            weakHashMap = sActiveDatabases;
            synchronized (weakHashMap) {
                sActiveDatabases.remove(this);
            }
            if (pool != null) {
                pool.close();
            }
        }
    }

    public static int releaseMemory() {
        return SQLiteGlobal.releaseMemory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getLabel() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mConfigurationLocked.label;
        }
    }

    void onCorruption() {
        EventLog.writeEvent((int)75004, (String)this.getLabel());
        this.mErrorHandler.onCorruption(this);
    }

    SQLiteSession getThreadSession() {
        return this.mThreadSession.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SQLiteSession createSession() {
        SQLiteConnectionPool pool;
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotOpenLocked();
            pool = this.mConnectionPoolLocked;
        }
        return new SQLiteSession(pool);
    }

    int getThreadDefaultConnectionFlags(boolean readOnly) {
        int flags;
        int n = flags = readOnly ? 1 : 2;
        if (SQLiteDatabase.isMainThread()) {
            flags |= 4;
        }
        return flags;
    }

    private static boolean isMainThread() {
        Looper looper = Looper.myLooper();
        return looper != null && looper == Looper.getMainLooper();
    }

    public void beginTransaction() {
        this.beginTransaction(null, 2);
    }

    public void beginTransactionNonExclusive() {
        this.beginTransaction(null, 1);
    }

    public void beginTransactionDeferred() {
        this.beginTransaction(null, 0);
    }

    public void beginTransactionWithListenerDeferred(SQLiteTransactionListener transactionListener) {
        this.beginTransaction(transactionListener, 0);
    }

    public void beginTransactionWithListener(SQLiteTransactionListener transactionListener) {
        this.beginTransaction(transactionListener, 2);
    }

    public void beginTransactionWithListenerNonExclusive(SQLiteTransactionListener transactionListener) {
        this.beginTransaction(transactionListener, 1);
    }

    private void beginTransaction(SQLiteTransactionListener transactionListener, int mode) {
        this.acquireReference();
        try {
            this.getThreadSession().beginTransaction(mode, transactionListener, this.getThreadDefaultConnectionFlags(false), null);
        }
        finally {
            this.releaseReference();
        }
    }

    public void endTransaction() {
        this.acquireReference();
        try {
            this.getThreadSession().endTransaction(null);
        }
        finally {
            this.releaseReference();
        }
    }

    public void setTransactionSuccessful() {
        this.acquireReference();
        try {
            this.getThreadSession().setTransactionSuccessful();
        }
        finally {
            this.releaseReference();
        }
    }

    public boolean inTransaction() {
        this.acquireReference();
        try {
            boolean bl = this.getThreadSession().hasTransaction();
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    public boolean isDbLockedByCurrentThread() {
        this.acquireReference();
        try {
            boolean bl = this.getThreadSession().hasConnection();
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    public boolean yieldIfContendedSafely() {
        return this.yieldIfContendedHelper(true, -1L);
    }

    public boolean yieldIfContendedSafely(long sleepAfterYieldDelay) {
        return this.yieldIfContendedHelper(true, sleepAfterYieldDelay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean yieldIfContendedHelper(boolean throwIfUnsafe, long sleepAfterYieldDelay) {
        this.acquireReference();
        try {
            boolean bl = this.getThreadSession().yieldTransaction(sleepAfterYieldDelay, throwIfUnsafe, null);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    public static SQLiteDatabase openDatabase(String path, CursorFactory factory, int flags) {
        return SQLiteDatabase.openDatabase(path, factory, flags, null);
    }

    public static SQLiteDatabase openDatabase(String path, CursorFactory factory, int flags, DatabaseErrorHandler errorHandler) {
        SQLiteDatabaseConfiguration configuration = new SQLiteDatabaseConfiguration(path, flags);
        SQLiteDatabase db = new SQLiteDatabase(configuration, factory, errorHandler);
        db.open();
        return db;
    }

    public static SQLiteDatabase openDatabase(SQLiteDatabaseConfiguration configuration, CursorFactory factory, DatabaseErrorHandler errorHandler) {
        SQLiteDatabase db = new SQLiteDatabase(configuration, factory, errorHandler);
        db.open();
        return db;
    }

    public static SQLiteDatabase openOrCreateDatabase(File file, CursorFactory factory) {
        return SQLiteDatabase.openOrCreateDatabase(file.getPath(), factory);
    }

    public static SQLiteDatabase openOrCreateDatabase(String path, CursorFactory factory) {
        return SQLiteDatabase.openDatabase(path, factory, 6, null);
    }

    public static SQLiteDatabase openOrCreateDatabase(String path, CursorFactory factory, DatabaseErrorHandler errorHandler) {
        return SQLiteDatabase.openDatabase(path, factory, 6, errorHandler);
    }

    public static boolean deleteDatabase(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file must not be null");
        }
        boolean deleted = file.delete();
        deleted |= new File(file.getPath() + "-journal").delete();
        deleted |= new File(file.getPath() + "-shm").delete();
        deleted |= new File(file.getPath() + "-wal").delete();
        File dir = file.getParentFile();
        if (dir != null) {
            final String prefix = file.getName() + "-mj";
            FileFilter filter = new FileFilter(){

                @Override
                public boolean accept(File candidate) {
                    return candidate.getName().startsWith(prefix);
                }
            };
            for (File masterJournal : dir.listFiles(filter)) {
                deleted |= masterJournal.delete();
            }
        }
        return deleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reopenReadWrite() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotOpenLocked();
            if (!this.isReadOnlyLocked()) {
                return;
            }
            int oldOpenFlags = this.mConfigurationLocked.openFlags;
            this.mConfigurationLocked.openFlags &= 0xFFFFFFFE;
            try {
                this.mConnectionPoolLocked.reconfigure(this.mConfigurationLocked);
            }
            catch (RuntimeException ex) {
                this.mConfigurationLocked.openFlags = oldOpenFlags;
                throw ex;
            }
        }
    }

    private void open() {
        try {
            if (!this.mConfigurationLocked.isInMemoryDb() && (this.mConfigurationLocked.openFlags & 4) != 0) {
                SQLiteDatabase.ensureFile(this.mConfigurationLocked.path);
            }
            try {
                this.openInner();
            }
            catch (SQLiteDatabaseCorruptException ex) {
                this.onCorruption();
                this.openInner();
            }
        }
        catch (SQLiteException ex) {
            Log.e((String)TAG, (String)("Failed to open database '" + this.getLabel() + "'."), (Throwable)ex);
            this.close();
            throw ex;
        }
    }

    private static void ensureFile(String path) {
        File file = new File(path);
        if (!file.exists()) {
            try {
                if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                    Log.e((String)TAG, (String)("Couldn't mkdirs " + file));
                }
                if (!file.createNewFile()) {
                    Log.e((String)TAG, (String)("Couldn't create " + file));
                }
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)("Couldn't ensure file " + file), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openInner() {
        WeakHashMap<SQLiteDatabase, Object> weakHashMap = this.mLock;
        synchronized (weakHashMap) {
            assert (this.mConnectionPoolLocked == null);
            this.mConnectionPoolLocked = SQLiteConnectionPool.open(this.mConfigurationLocked);
            this.mCloseGuardLocked.open("close");
        }
        weakHashMap = sActiveDatabases;
        synchronized (weakHashMap) {
            sActiveDatabases.put(this, null);
        }
    }

    public static SQLiteDatabase create(CursorFactory factory) {
        return SQLiteDatabase.openDatabase(":memory:", factory, 6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void addCustomFunction(String name, int numArgs, CustomFunction function) {
        SQLiteCustomFunction wrapper = new SQLiteCustomFunction(name, numArgs, function);
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotOpenLocked();
            this.mConfigurationLocked.customFunctions.add(wrapper);
            try {
                this.mConnectionPoolLocked.reconfigure(this.mConfigurationLocked);
            }
            catch (RuntimeException ex) {
                this.mConfigurationLocked.customFunctions.remove(wrapper);
                throw ex;
            }
        }
    }

    public void addFunction(String name, int numArgs, Function function) {
        this.addFunction(name, numArgs, function, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFunction(String name, int numArgs, Function function, int flags) {
        SQLiteFunction wrapper = new SQLiteFunction(name, numArgs, function, flags);
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotOpenLocked();
            this.mConfigurationLocked.functions.add(wrapper);
            try {
                this.mConnectionPoolLocked.reconfigure(this.mConfigurationLocked);
            }
            catch (RuntimeException ex) {
                this.mConfigurationLocked.functions.remove(wrapper);
                throw ex;
            }
        }
    }

    public int getVersion() {
        return Long.valueOf(this.longForQuery("PRAGMA user_version;", null)).intValue();
    }

    public void setVersion(int version) {
        this.execSQL("PRAGMA user_version = " + version);
    }

    public long getMaximumSize() {
        long pageCount = this.longForQuery("PRAGMA max_page_count;", null);
        return pageCount * this.getPageSize();
    }

    public long setMaximumSize(long numBytes) {
        long pageSize = this.getPageSize();
        long numPages = numBytes / pageSize;
        if (numBytes % pageSize != 0L) {
            ++numPages;
        }
        long newPageCount = this.longForQuery("PRAGMA max_page_count = " + numPages, null);
        return newPageCount * pageSize;
    }

    public long getPageSize() {
        return this.longForQuery("PRAGMA page_size;", null);
    }

    public void setPageSize(long numBytes) {
        this.execSQL("PRAGMA page_size = " + numBytes);
    }

    public static String findEditTable(String tables) {
        if (!TextUtils.isEmpty((CharSequence)tables)) {
            int spacepos = tables.indexOf(32);
            int commapos = tables.indexOf(44);
            if (spacepos > 0 && (spacepos < commapos || commapos < 0)) {
                return tables.substring(0, spacepos);
            }
            if (commapos > 0 && (commapos < spacepos || spacepos < 0)) {
                return tables.substring(0, commapos);
            }
            return tables;
        }
        throw new IllegalStateException("Invalid tables");
    }

    public SQLiteStatement compileStatement(String sql) throws SQLException {
        this.acquireReference();
        try {
            SQLiteStatement sQLiteStatement = new SQLiteStatement(this, sql, null);
            return sQLiteStatement;
        }
        finally {
            this.releaseReference();
        }
    }

    public Cursor query(boolean distinct, String table, String[] columns, String selection, Object[] selectionArgs, String groupBy, String having, String orderBy, String limit) {
        return this.queryWithFactory(null, distinct, table, columns, selection, selectionArgs, groupBy, having, orderBy, limit, null);
    }

    public Cursor query(boolean distinct, String table, String[] columns, String selection, Object[] selectionArgs, String groupBy, String having, String orderBy, String limit, CancellationSignal cancellationSignal) {
        return this.queryWithFactory(null, distinct, table, columns, selection, selectionArgs, groupBy, having, orderBy, limit, cancellationSignal);
    }

    public Cursor queryWithFactory(CursorFactory cursorFactory, boolean distinct, String table, String[] columns, String selection, Object[] selectionArgs, String groupBy, String having, String orderBy, String limit) {
        return this.queryWithFactory(cursorFactory, distinct, table, columns, selection, selectionArgs, groupBy, having, orderBy, limit, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor queryWithFactory(CursorFactory cursorFactory, boolean distinct, String table, String[] columns, String selection, Object[] selectionArgs, String groupBy, String having, String orderBy, String limit, CancellationSignal cancellationSignal) {
        this.acquireReference();
        try {
            String sql = SQLiteQueryBuilder.buildQueryString(distinct, table, columns, selection, groupBy, having, orderBy, limit);
            Cursor cursor = this.rawQueryWithFactory(cursorFactory, sql, selectionArgs, SQLiteDatabase.findEditTable(table), cancellationSignal);
            return cursor;
        }
        finally {
            this.releaseReference();
        }
    }

    public Cursor query(String table, String[] columns, String selection, Object[] selectionArgs, String groupBy, String having, String orderBy) {
        return this.query(false, table, columns, selection, selectionArgs, groupBy, having, orderBy, null);
    }

    public Cursor query(String table, String[] columns, String selection, Object[] selectionArgs, String groupBy, String having, String orderBy, String limit) {
        return this.query(false, table, columns, selection, selectionArgs, groupBy, having, orderBy, limit);
    }

    public Cursor query(String query) {
        return this.rawQueryWithFactory(null, query, null, null, null);
    }

    public Cursor query(String query, Object[] selectionArgs) {
        return this.rawQueryWithFactory(null, query, selectionArgs, null, null);
    }

    public Cursor query(SupportSQLiteQuery supportQuery) {
        return this.query(supportQuery, (CancellationSignal)null);
    }

    @RequiresApi(api=16)
    public Cursor query(SupportSQLiteQuery supportQuery, android.os.CancellationSignal signal) {
        if (signal != null) {
            final CancellationSignal supportCancellationSignal = new CancellationSignal();
            signal.setOnCancelListener(new CancellationSignal.OnCancelListener(){

                public void onCancel() {
                    supportCancellationSignal.cancel();
                }
            });
            return this.query(supportQuery, supportCancellationSignal);
        }
        return this.query(supportQuery, (CancellationSignal)null);
    }

    public Cursor query(final SupportSQLiteQuery supportQuery, CancellationSignal signal) {
        return this.rawQueryWithFactory(new CursorFactory(){

            @Override
            public Cursor newCursor(SQLiteDatabase db, SQLiteCursorDriver masterQuery, String editTable, SQLiteQuery query) {
                supportQuery.bindTo((SupportSQLiteProgram)query);
                return new SQLiteCursor(masterQuery, editTable, query);
            }
        }, supportQuery.getSql(), new String[0], null, signal);
    }

    public Cursor rawQuery(String sql, Object[] selectionArgs) {
        return this.rawQueryWithFactory(null, sql, selectionArgs, null, null);
    }

    public Cursor rawQuery(String sql, Object[] selectionArgs, CancellationSignal cancellationSignal) {
        return this.rawQueryWithFactory(null, sql, selectionArgs, null, cancellationSignal);
    }

    public Cursor rawQueryWithFactory(CursorFactory cursorFactory, String sql, Object[] selectionArgs, String editTable) {
        return this.rawQueryWithFactory(cursorFactory, sql, selectionArgs, editTable, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor rawQueryWithFactory(CursorFactory cursorFactory, String sql, Object[] selectionArgs, String editTable, CancellationSignal cancellationSignal) {
        this.acquireReference();
        try {
            SQLiteDirectCursorDriver driver = new SQLiteDirectCursorDriver(this, sql, editTable, cancellationSignal);
            Cursor cursor = driver.query(cursorFactory != null ? cursorFactory : this.mCursorFactory, selectionArgs);
            return cursor;
        }
        finally {
            this.releaseReference();
        }
    }

    public long insert(String table, String nullColumnHack, ContentValues values) {
        try {
            return this.insertWithOnConflict(table, nullColumnHack, values, 0);
        }
        catch (SQLException e) {
            Log.e((String)TAG, (String)("Error inserting " + values), (Throwable)e);
            return -1L;
        }
    }

    public long insertOrThrow(String table, String nullColumnHack, ContentValues values) throws SQLException {
        return this.insertWithOnConflict(table, nullColumnHack, values, 0);
    }

    public long replace(String table, String nullColumnHack, ContentValues initialValues) {
        try {
            return this.insertWithOnConflict(table, nullColumnHack, initialValues, 5);
        }
        catch (SQLException e) {
            Log.e((String)TAG, (String)("Error inserting " + initialValues), (Throwable)e);
            return -1L;
        }
    }

    public long replaceOrThrow(String table, String nullColumnHack, ContentValues initialValues) throws SQLException {
        return this.insertWithOnConflict(table, nullColumnHack, initialValues, 5);
    }

    public long insert(String table, int conflictAlgorithm, ContentValues values) throws SQLException {
        return this.insertWithOnConflict(table, null, values, conflictAlgorithm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long insertWithOnConflict(String table, String nullColumnHack, ContentValues initialValues, int conflictAlgorithm) {
        this.acquireReference();
        try {
            long l;
            int size;
            StringBuilder sql = new StringBuilder();
            sql.append("INSERT");
            sql.append(CONFLICT_VALUES[conflictAlgorithm]);
            sql.append(" INTO ");
            sql.append(table);
            sql.append('(');
            Object[] bindArgs = null;
            int n = size = initialValues != null && initialValues.size() > 0 ? initialValues.size() : 0;
            if (size > 0) {
                bindArgs = new Object[size];
                int i = 0;
                for (Map.Entry entry : initialValues.valueSet()) {
                    sql.append(i > 0 ? "," : "");
                    sql.append((String)entry.getKey());
                    bindArgs[i++] = entry.getValue();
                }
                sql.append(')');
                sql.append(" VALUES (");
                for (i = 0; i < size; ++i) {
                    sql.append(i > 0 ? ",?" : "?");
                }
            } else {
                sql.append(nullColumnHack + ") VALUES (NULL");
            }
            sql.append(')');
            SQLiteStatement statement = new SQLiteStatement(this, sql.toString(), bindArgs);
            try {
                l = statement.executeInsert();
            }
            catch (Throwable throwable) {
                statement.close();
                throw throwable;
            }
            statement.close();
            return l;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete(String table, String whereClause, String[] whereArgs) {
        this.acquireReference();
        try {
            int n;
            SQLiteStatement statement = new SQLiteStatement(this, "DELETE FROM " + table + (!TextUtils.isEmpty((CharSequence)whereClause) ? " WHERE " + whereClause : ""), whereArgs);
            try {
                n = statement.executeUpdateDelete();
            }
            catch (Throwable throwable) {
                statement.close();
                throw throwable;
            }
            statement.close();
            return n;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete(String table, String whereClause, Object[] whereArgs) {
        this.acquireReference();
        try {
            int n;
            SQLiteStatement statement = new SQLiteStatement(this, "DELETE FROM " + table + (!TextUtils.isEmpty((CharSequence)whereClause) ? " WHERE " + whereClause : ""), whereArgs);
            try {
                n = statement.executeUpdateDelete();
            }
            catch (Throwable throwable) {
                statement.close();
                throw throwable;
            }
            statement.close();
            return n;
        }
        finally {
            this.releaseReference();
        }
    }

    public int update(String table, ContentValues values, String whereClause, String[] whereArgs) {
        return this.updateWithOnConflict(table, values, whereClause, whereArgs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(String table, int conflictAlgorithm, ContentValues values, String whereClause, Object[] whereArgs) {
        if (values == null || values.size() == 0) {
            throw new IllegalArgumentException("Empty values");
        }
        this.acquireReference();
        try {
            int n;
            StringBuilder sql = new StringBuilder(120);
            sql.append("UPDATE ");
            sql.append(CONFLICT_VALUES[conflictAlgorithm]);
            sql.append(table);
            sql.append(" SET ");
            int setValuesSize = values.size();
            int bindArgsSize = whereArgs == null ? setValuesSize : setValuesSize + whereArgs.length;
            Object[] bindArgs = new Object[bindArgsSize];
            int i = 0;
            for (Map.Entry entry : values.valueSet()) {
                sql.append(i > 0 ? "," : "");
                sql.append((String)entry.getKey());
                bindArgs[i++] = entry.getValue();
                sql.append("=?");
            }
            if (whereArgs != null) {
                for (i = setValuesSize; i < bindArgsSize; ++i) {
                    bindArgs[i] = whereArgs[i - setValuesSize];
                }
            }
            if (!TextUtils.isEmpty((CharSequence)whereClause)) {
                sql.append(" WHERE ");
                sql.append(whereClause);
            }
            SQLiteStatement statement = new SQLiteStatement(this, sql.toString(), bindArgs);
            try {
                n = statement.executeUpdateDelete();
            }
            catch (Throwable throwable) {
                statement.close();
                throw throwable;
            }
            statement.close();
            return n;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateWithOnConflict(String table, ContentValues values, String whereClause, String[] whereArgs, int conflictAlgorithm) {
        if (values == null || values.size() == 0) {
            throw new IllegalArgumentException("Empty values");
        }
        this.acquireReference();
        try {
            int n;
            StringBuilder sql = new StringBuilder(120);
            sql.append("UPDATE ");
            sql.append(CONFLICT_VALUES[conflictAlgorithm]);
            sql.append(table);
            sql.append(" SET ");
            int setValuesSize = values.size();
            int bindArgsSize = whereArgs == null ? setValuesSize : setValuesSize + whereArgs.length;
            Object[] bindArgs = new Object[bindArgsSize];
            int i = 0;
            for (Map.Entry entry : values.valueSet()) {
                sql.append(i > 0 ? "," : "");
                sql.append((String)entry.getKey());
                bindArgs[i++] = entry.getValue();
                sql.append("=?");
            }
            if (whereArgs != null) {
                for (i = setValuesSize; i < bindArgsSize; ++i) {
                    bindArgs[i] = whereArgs[i - setValuesSize];
                }
            }
            if (!TextUtils.isEmpty((CharSequence)whereClause)) {
                sql.append(" WHERE ");
                sql.append(whereClause);
            }
            SQLiteStatement statement = new SQLiteStatement(this, sql.toString(), bindArgs);
            try {
                n = statement.executeUpdateDelete();
            }
            catch (Throwable throwable) {
                statement.close();
                throw throwable;
            }
            statement.close();
            return n;
        }
        finally {
            this.releaseReference();
        }
    }

    public void execSQL(String sql) throws SQLException {
        this.executeSql(sql, null);
    }

    public void execSQL(String sql, Object[] bindArgs) throws SQLException {
        if (bindArgs == null) {
            throw new IllegalArgumentException("Empty bindArgs");
        }
        this.executeSql(sql, bindArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeSql(String sql, Object[] bindArgs) throws SQLException {
        this.acquireReference();
        try {
            int n;
            SQLiteStatement statement = new SQLiteStatement(this, sql, bindArgs);
            try {
                n = statement.executeUpdateDelete();
            }
            catch (Throwable throwable) {
                statement.close();
                throw throwable;
            }
            statement.close();
            return n;
        }
        finally {
            this.releaseReference();
        }
    }

    public void validateSql(@NonNull String sql, @Nullable CancellationSignal cancellationSignal) {
        this.getThreadSession().prepare(sql, this.getThreadDefaultConnectionFlags(true), cancellationSignal, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReadOnly() {
        Object object = this.mLock;
        synchronized (object) {
            return this.isReadOnlyLocked();
        }
    }

    private boolean isReadOnlyLocked() {
        return (this.mConfigurationLocked.openFlags & 1) == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInMemoryDatabase() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mConfigurationLocked.isInMemoryDb();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mConnectionPoolLocked != null;
        }
    }

    public boolean needUpgrade(int newVersion) {
        return newVersion > this.getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getPath() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mConfigurationLocked.path;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocale(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("locale must not be null.");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotOpenLocked();
            Locale oldLocale = this.mConfigurationLocked.locale;
            this.mConfigurationLocked.locale = locale;
            try {
                this.mConnectionPoolLocked.reconfigure(this.mConfigurationLocked);
            }
            catch (RuntimeException ex) {
                this.mConfigurationLocked.locale = oldLocale;
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxSqlCacheSize(int cacheSize) {
        if (cacheSize > 100 || cacheSize < 0) {
            throw new IllegalStateException("expected value between 0 and 100");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotOpenLocked();
            int oldMaxSqlCacheSize = this.mConfigurationLocked.maxSqlCacheSize;
            this.mConfigurationLocked.maxSqlCacheSize = cacheSize;
            try {
                this.mConnectionPoolLocked.reconfigure(this.mConfigurationLocked);
            }
            catch (RuntimeException ex) {
                this.mConfigurationLocked.maxSqlCacheSize = oldMaxSqlCacheSize;
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setForeignKeyConstraintsEnabled(boolean enable) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotOpenLocked();
            if (this.mConfigurationLocked.foreignKeyConstraintsEnabled == enable) {
                return;
            }
            this.mConfigurationLocked.foreignKeyConstraintsEnabled = enable;
            try {
                this.mConnectionPoolLocked.reconfigure(this.mConfigurationLocked);
            }
            catch (RuntimeException ex) {
                this.mConfigurationLocked.foreignKeyConstraintsEnabled = !enable;
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enableWriteAheadLogging() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotOpenLocked();
            if ((this.mConfigurationLocked.openFlags & 0x20000000) != 0) {
                return true;
            }
            if (this.isReadOnlyLocked()) {
                return false;
            }
            if (this.mConfigurationLocked.isInMemoryDb()) {
                Log.i((String)TAG, (String)"can't enable WAL for memory databases.");
                return false;
            }
            this.mConfigurationLocked.openFlags |= 0x20000000;
            try {
                this.mConnectionPoolLocked.reconfigure(this.mConfigurationLocked);
            }
            catch (RuntimeException ex) {
                this.mConfigurationLocked.openFlags &= 0xDFFFFFFF;
                throw ex;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableWriteAheadLogging() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotOpenLocked();
            if ((this.mConfigurationLocked.openFlags & 0x20000000) == 0) {
                return;
            }
            this.mConfigurationLocked.openFlags &= 0xDFFFFFFF;
            try {
                this.mConnectionPoolLocked.reconfigure(this.mConfigurationLocked);
            }
            catch (RuntimeException ex) {
                this.mConfigurationLocked.openFlags |= 0x20000000;
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWriteAheadLoggingEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotOpenLocked();
            return (this.mConfigurationLocked.openFlags & 0x20000000) != 0;
        }
    }

    static ArrayList<SQLiteDebug.DbStats> getDbStats() {
        ArrayList<SQLiteDebug.DbStats> dbStatsList = new ArrayList<SQLiteDebug.DbStats>();
        for (SQLiteDatabase db : SQLiteDatabase.getActiveDatabases()) {
            db.collectDbStats(dbStatsList);
        }
        return dbStatsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectDbStats(ArrayList<SQLiteDebug.DbStats> dbStatsList) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mConnectionPoolLocked != null) {
                this.mConnectionPoolLocked.collectDbStats(dbStatsList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList<SQLiteDatabase> getActiveDatabases() {
        ArrayList<SQLiteDatabase> databases = new ArrayList<SQLiteDatabase>();
        WeakHashMap<SQLiteDatabase, Object> weakHashMap = sActiveDatabases;
        synchronized (weakHashMap) {
            databases.addAll(sActiveDatabases.keySet());
        }
        return databases;
    }

    static void dumpAll(Printer printer, boolean verbose) {
        for (SQLiteDatabase db : SQLiteDatabase.getActiveDatabases()) {
            db.dump(printer, verbose);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dump(Printer printer, boolean verbose) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mConnectionPoolLocked != null) {
                printer.println("");
                this.mConnectionPoolLocked.dump(printer, verbose);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Pair<String, String>> getAttachedDbs() {
        ArrayList<Pair<String, String>> attachedDbs = new ArrayList<Pair<String, String>>();
        Object object = this.mLock;
        synchronized (object) {
            if (this.mConnectionPoolLocked == null) {
                return null;
            }
            this.acquireReference();
        }
        try {
            try (Cursor c = null;){
                c = this.rawQuery("pragma database_list;", null);
                while (c.moveToNext()) {
                    attachedDbs.add((Pair<String, String>)new Pair((Object)c.getString(1), (Object)c.getString(2)));
                }
            }
            ArrayList<Pair<String, String>> arrayList = attachedDbs;
            return arrayList;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDatabaseIntegrityOk() {
        this.acquireReference();
        try {
            List<Pair<String, String>> attachedDbs;
            try {
                attachedDbs = this.getAttachedDbs();
                if (attachedDbs == null) {
                    throw new IllegalStateException("databaselist for: " + this.getPath() + " couldn't be retrieved. probably because the database is closed");
                }
            }
            catch (SQLiteException e) {
                attachedDbs = new ArrayList<Pair<String, String>>();
                attachedDbs.add((Pair<String, String>)new Pair((Object)"main", (Object)this.getPath()));
            }
            for (Pair<String, String> p : attachedDbs) {
                SQLiteClosable prog = null;
                try {
                    prog = this.compileStatement("PRAGMA " + (String)p.first + ".integrity_check(1);");
                    String rslt = ((SQLiteStatement)prog).simpleQueryForString();
                    if (rslt.equalsIgnoreCase("ok")) continue;
                    Log.e((String)TAG, (String)("PRAGMA integrity_check on " + (String)p.second + " returned: " + rslt));
                    boolean bl = false;
                    return bl;
                }
                finally {
                    if (prog == null) continue;
                    prog.close();
                }
            }
        }
        finally {
            this.releaseReference();
        }
        return true;
    }

    public String toString() {
        return "SQLiteDatabase: " + this.getPath();
    }

    private void throwIfNotOpenLocked() {
        if (this.mConnectionPoolLocked == null) {
            throw new IllegalStateException("The database '" + this.mConfigurationLocked.label + "' is not open.");
        }
    }

    static boolean hasCodec() {
        return SQLiteConnection.hasCodec();
    }

    void enableLocalizedCollators() {
        this.mConnectionPoolLocked.enableLocalizedCollators();
    }

    public long queryNumEntries(String table) {
        return this.queryNumEntries(table, null, null);
    }

    public long queryNumEntries(String table, String selection) {
        return this.queryNumEntries(table, selection, null);
    }

    public long queryNumEntries(String table, String selection, String[] selectionArgs) {
        String s = !TextUtils.isEmpty((CharSequence)selection) ? " where " + selection : "";
        return this.longForQuery("select count(*) from " + table + s, selectionArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long longForQuery(String query, String[] selectionArgs) {
        try (SQLiteStatement prog = this.compileStatement(query);){
            long l = SQLiteDatabase.longForQuery(prog, selectionArgs);
            return l;
        }
    }

    private static long longForQuery(SQLiteStatement prog, String[] selectionArgs) {
        prog.bindAllArgsAsStrings(selectionArgs);
        return prog.simpleQueryForLong();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String stringForQuery(String query, String[] selectionArgs) {
        try (SQLiteStatement prog = this.compileStatement(query);){
            String string = SQLiteDatabase.stringForQuery(prog, selectionArgs);
            return string;
        }
    }

    public static String stringForQuery(SQLiteStatement prog, String[] selectionArgs) {
        prog.bindAllArgsAsStrings(selectionArgs);
        return prog.simpleQueryForString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParcelFileDescriptor blobFileDescriptorForQuery(String query, String[] selectionArgs) {
        try (SQLiteStatement prog = this.compileStatement(query);){
            ParcelFileDescriptor parcelFileDescriptor = SQLiteDatabase.blobFileDescriptorForQuery(prog, selectionArgs);
            return parcelFileDescriptor;
        }
    }

    public static ParcelFileDescriptor blobFileDescriptorForQuery(SQLiteStatement prog, String[] selectionArgs) {
        prog.bindAllArgsAsStrings(selectionArgs);
        return prog.simpleQueryForBlobFileDescriptor();
    }

    static {
        System.loadLibrary(LIBRARY_NAME);
        sActiveDatabases = new WeakHashMap();
        CONFLICT_VALUES = new String[]{"", " OR ROLLBACK ", " OR ABORT ", " OR FAIL ", " OR IGNORE ", " OR REPLACE "};
    }

    public static interface Function {
        public static final int FLAG_DETERMINISTIC = 2048;

        public void callback(Args var1, Result var2);

        public static interface Result {
            public void set(byte[] var1);

            public void set(double var1);

            public void set(int var1);

            public void set(long var1);

            public void set(String var1);

            public void setError(String var1);

            public void setNull();
        }

        public static interface Args {
            public byte[] getBlob(int var1);

            public String getString(int var1);

            public double getDouble(int var1);

            public int getInt(int var1);

            public long getLong(int var1);
        }
    }

    @Deprecated
    public static interface CustomFunction {
        public String callback(String[] var1);
    }

    public static interface CursorFactory {
        public Cursor newCursor(SQLiteDatabase var1, SQLiteCursorDriver var2, String var3, SQLiteQuery var4);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @SuppressLint(value={"UniqueConstants"})
    public static @interface OpenFlags {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ConflictAlgorithm {
    }
}

