/*
 * Decompiled with CFR 0.152.
 */
package io.requery.android.database.sqlite;

import io.requery.android.database.sqlite.SQLiteDatabase;

public class SQLiteFunction {
    public final String name;
    public final int numArgs;
    public final SQLiteDatabase.Function callback;
    final int flags;
    private final MyArgs args = new MyArgs();
    private final MyResult result = new MyResult();

    public SQLiteFunction(String name, int numArgs, SQLiteDatabase.Function callback) {
        this(name, numArgs, callback, 0);
    }

    public SQLiteFunction(String name, int numArgs, SQLiteDatabase.Function callback, int flags) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null.");
        }
        this.name = name;
        this.numArgs = numArgs;
        this.callback = callback;
        this.flags = flags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchCallback(long contextPtr, long argsPtr, int argsCount) {
        this.result.contextPtr = contextPtr;
        this.args.argsPtr = argsPtr;
        this.args.argsCount = argsCount;
        try {
            this.callback.callback(this.args, this.result);
            if (!this.result.isSet) {
                this.result.setNull();
            }
        }
        finally {
            this.result.contextPtr = 0L;
            this.result.isSet = false;
            this.args.argsPtr = 0L;
            this.args.argsCount = 0;
        }
    }

    static native byte[] nativeGetArgBlob(long var0, int var2);

    static native String nativeGetArgString(long var0, int var2);

    static native double nativeGetArgDouble(long var0, int var2);

    static native int nativeGetArgInt(long var0, int var2);

    static native long nativeGetArgLong(long var0, int var2);

    static native void nativeSetResultBlob(long var0, byte[] var2);

    static native void nativeSetResultString(long var0, String var2);

    static native void nativeSetResultDouble(long var0, double var2);

    static native void nativeSetResultInt(long var0, int var2);

    static native void nativeSetResultLong(long var0, long var2);

    static native void nativeSetResultError(long var0, String var2);

    static native void nativeSetResultNull(long var0);

    private static class MyResult
    implements SQLiteDatabase.Function.Result {
        long contextPtr;
        boolean isSet;

        private MyResult() {
        }

        @Override
        public void set(byte[] value) {
            this.checkSet();
            SQLiteFunction.nativeSetResultBlob(this.contextPtr, value);
        }

        @Override
        public void set(double value) {
            this.checkSet();
            SQLiteFunction.nativeSetResultDouble(this.contextPtr, value);
        }

        @Override
        public void set(int value) {
            this.checkSet();
            SQLiteFunction.nativeSetResultInt(this.contextPtr, value);
        }

        @Override
        public void set(long value) {
            this.checkSet();
            SQLiteFunction.nativeSetResultLong(this.contextPtr, value);
        }

        @Override
        public void set(String value) {
            this.checkSet();
            SQLiteFunction.nativeSetResultString(this.contextPtr, value);
        }

        @Override
        public void setError(String error) {
            this.checkSet();
            SQLiteFunction.nativeSetResultError(this.contextPtr, error);
        }

        @Override
        public void setNull() {
            this.checkSet();
            SQLiteFunction.nativeSetResultNull(this.contextPtr);
        }

        private void checkSet() {
            if (this.isSet) {
                throw new IllegalStateException("Result is already set");
            }
            this.isSet = true;
        }
    }

    private static class MyArgs
    implements SQLiteDatabase.Function.Args {
        long argsPtr;
        int argsCount;

        private MyArgs() {
        }

        @Override
        public byte[] getBlob(int arg) {
            return SQLiteFunction.nativeGetArgBlob(this.argsPtr, this.checkArg(arg));
        }

        @Override
        public String getString(int arg) {
            return SQLiteFunction.nativeGetArgString(this.argsPtr, this.checkArg(arg));
        }

        @Override
        public double getDouble(int arg) {
            return SQLiteFunction.nativeGetArgDouble(this.argsPtr, this.checkArg(arg));
        }

        @Override
        public int getInt(int arg) {
            return SQLiteFunction.nativeGetArgInt(this.argsPtr, this.checkArg(arg));
        }

        @Override
        public long getLong(int arg) {
            return SQLiteFunction.nativeGetArgLong(this.argsPtr, this.checkArg(arg));
        }

        private int checkArg(int arg) {
            if (arg < 0 || arg >= this.argsCount) {
                throw new IllegalArgumentException("Requested arg " + arg + " but had " + this.argsCount);
            }
            return arg;
        }
    }
}

