/*
 * Decompiled with CFR 0.152.
 */
package io.requery.android.database.sqlite;

import android.arch.persistence.db.SupportSQLiteDatabase;
import android.arch.persistence.db.SupportSQLiteOpenHelper;
import android.content.Context;
import io.requery.android.database.DatabaseErrorHandler;
import io.requery.android.database.sqlite.SQLiteDatabase;
import io.requery.android.database.sqlite.SQLiteOpenHelper;

public final class RequerySQLiteOpenHelperFactory
implements SupportSQLiteOpenHelper.Factory {
    public SupportSQLiteOpenHelper create(SupportSQLiteOpenHelper.Configuration config) {
        return new CallbackSQLiteOpenHelper(config.context, config.name, config.callback);
    }

    private static final class CallbackDatabaseErrorHandler
    implements DatabaseErrorHandler {
        private final SupportSQLiteOpenHelper.Callback callback;

        CallbackDatabaseErrorHandler(SupportSQLiteOpenHelper.Callback callback) {
            this.callback = callback;
        }

        @Override
        public void onCorruption(SQLiteDatabase db) {
            this.callback.onCorruption((SupportSQLiteDatabase)db);
        }
    }

    private static final class CallbackSQLiteOpenHelper
    extends SQLiteOpenHelper {
        private final SupportSQLiteOpenHelper.Callback callback;

        CallbackSQLiteOpenHelper(Context context, String name, SupportSQLiteOpenHelper.Callback cb) {
            super(context, name, null, cb.version, new CallbackDatabaseErrorHandler(cb));
            this.callback = cb;
        }

        @Override
        public void onConfigure(SQLiteDatabase db) {
            this.callback.onConfigure((SupportSQLiteDatabase)db);
        }

        @Override
        public void onCreate(SQLiteDatabase db) {
            this.callback.onCreate((SupportSQLiteDatabase)db);
        }

        @Override
        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            this.callback.onUpgrade((SupportSQLiteDatabase)db, oldVersion, newVersion);
        }

        @Override
        public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            this.callback.onDowngrade((SupportSQLiteDatabase)db, oldVersion, newVersion);
        }

        @Override
        public void onOpen(SQLiteDatabase db) {
            this.callback.onOpen((SupportSQLiteDatabase)db);
        }
    }
}

