/*
 * Decompiled with CFR 0.152.
 */
package io.requery.android.database.sqlite;

import java.util.Locale;

class SQLiteStatementType {
    public static final int STATEMENT_SELECT = 1;
    public static final int STATEMENT_UPDATE = 2;
    public static final int STATEMENT_ATTACH = 3;
    public static final int STATEMENT_BEGIN = 4;
    public static final int STATEMENT_COMMIT = 5;
    public static final int STATEMENT_ABORT = 6;
    public static final int STATEMENT_PRAGMA = 7;
    public static final int STATEMENT_DDL = 8;
    public static final int STATEMENT_UNPREPARED = 9;
    public static final int STATEMENT_OTHER = 99;

    private SQLiteStatementType() {
    }

    public static int getSqlStatementType(String sql) {
        String prefixSql;
        if ((sql = sql.trim()).length() < 3) {
            return 99;
        }
        switch (prefixSql = sql.substring(0, 3).toUpperCase(Locale.US)) {
            case "SEL": {
                return 1;
            }
            case "INS": 
            case "UPD": 
            case "REP": 
            case "DEL": {
                return 2;
            }
            case "ATT": {
                return 3;
            }
            case "COM": {
                return 5;
            }
            case "END": {
                return 5;
            }
            case "ROL": {
                return 6;
            }
            case "BEG": {
                return 4;
            }
            case "PRA": {
                return 7;
            }
            case "CRE": 
            case "DRO": 
            case "ALT": {
                return 8;
            }
            case "ANA": 
            case "DET": {
                return 9;
            }
        }
        return 99;
    }
}

