/*
 * Decompiled with CFR 0.152.
 */
package io.requery.android.database.sqlite;

import android.content.Context;
import android.database.sqlite.SQLiteException;
import android.util.Log;
import io.requery.android.database.DatabaseErrorHandler;
import io.requery.android.database.sqlite.SQLiteDatabase;
import io.requery.android.database.sqlite.SQLiteDatabaseConfiguration;

public abstract class SQLiteOpenHelper {
    private static final String TAG = SQLiteOpenHelper.class.getSimpleName();
    private static final boolean DEBUG_STRICT_READONLY = false;
    private final Context mContext;
    private final String mName;
    private final SQLiteDatabase.CursorFactory mFactory;
    private final int mNewVersion;
    private SQLiteDatabase mDatabase;
    private boolean mIsInitializing;
    private boolean mEnableWriteAheadLogging;
    private final DatabaseErrorHandler mErrorHandler;

    public SQLiteOpenHelper(Context context, String name, SQLiteDatabase.CursorFactory factory, int version) {
        this(context, name, factory, version, null);
    }

    public SQLiteOpenHelper(Context context, String name, SQLiteDatabase.CursorFactory factory, int version, DatabaseErrorHandler errorHandler) {
        if (version < 1) {
            throw new IllegalArgumentException("Version must be >= 1, was " + version);
        }
        this.mContext = context;
        this.mName = name;
        this.mFactory = factory;
        this.mNewVersion = version;
        this.mErrorHandler = errorHandler;
    }

    public String getDatabaseName() {
        return this.mName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWriteAheadLoggingEnabled(boolean enabled) {
        SQLiteOpenHelper sQLiteOpenHelper = this;
        synchronized (sQLiteOpenHelper) {
            if (this.mEnableWriteAheadLogging != enabled) {
                if (this.mDatabase != null && this.mDatabase.isOpen() && !this.mDatabase.isReadOnly()) {
                    if (enabled) {
                        this.mDatabase.enableWriteAheadLogging();
                    } else {
                        this.mDatabase.disableWriteAheadLogging();
                    }
                }
                this.mEnableWriteAheadLogging = enabled;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLiteDatabase getWritableDatabase() {
        SQLiteOpenHelper sQLiteOpenHelper = this;
        synchronized (sQLiteOpenHelper) {
            return this.getDatabaseLocked(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLiteDatabase getReadableDatabase() {
        SQLiteOpenHelper sQLiteOpenHelper = this;
        synchronized (sQLiteOpenHelper) {
            return this.getDatabaseLocked(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SQLiteDatabase getDatabaseLocked(boolean writable) {
        if (this.mDatabase != null) {
            if (!this.mDatabase.isOpen()) {
                this.mDatabase = null;
            } else if (!writable || !this.mDatabase.isReadOnly()) {
                return this.mDatabase;
            }
        }
        if (this.mIsInitializing) {
            throw new IllegalStateException("getDatabase called recursively");
        }
        SQLiteDatabase db = this.mDatabase;
        try {
            this.mIsInitializing = true;
            if (db != null) {
                if (db.isReadOnly()) {
                    db.reopenReadWrite();
                }
            } else if (this.mName == null) {
                db = SQLiteDatabase.create(null);
            } else {
                try {
                    String path = this.mContext.getDatabasePath(this.mName).getPath();
                    int flags = this.mEnableWriteAheadLogging ? 0x20000000 : 0;
                    SQLiteDatabaseConfiguration configuration = this.createConfiguration(path, flags |= 0x10000000);
                    db = SQLiteDatabase.openDatabase(configuration, this.mFactory, this.mErrorHandler);
                }
                catch (SQLiteException ex) {
                    if (writable) {
                        throw ex;
                    }
                    Log.e((String)TAG, (String)("Couldn't open " + this.mName + " for writing (will try read-only):"), (Throwable)ex);
                    String path = this.mContext.getDatabasePath(this.mName).getPath();
                    SQLiteDatabaseConfiguration configuration = this.createConfiguration(path, 1);
                    db = SQLiteDatabase.openDatabase(configuration, this.mFactory, this.mErrorHandler);
                }
            }
            this.onConfigure(db);
            int version = db.getVersion();
            if (version != this.mNewVersion) {
                if (db.isReadOnly()) {
                    throw new SQLiteException("Can't upgrade read-only database from version " + db.getVersion() + " to " + this.mNewVersion + ": " + this.mName);
                }
                db.beginTransaction();
                try {
                    if (version == 0) {
                        this.onCreate(db);
                    } else if (version > this.mNewVersion) {
                        this.onDowngrade(db, version, this.mNewVersion);
                    } else {
                        this.onUpgrade(db, version, this.mNewVersion);
                    }
                    db.setVersion(this.mNewVersion);
                    db.setTransactionSuccessful();
                }
                finally {
                    db.endTransaction();
                }
            }
            this.onOpen(db);
            if (db.isReadOnly()) {
                Log.w((String)TAG, (String)("Opened " + this.mName + " in read-only mode"));
            }
            this.mDatabase = db;
            SQLiteDatabase sQLiteDatabase = db;
            return sQLiteDatabase;
        }
        finally {
            this.mIsInitializing = false;
            if (db != null && db != this.mDatabase) {
                db.close();
            }
        }
    }

    public synchronized void close() {
        if (this.mIsInitializing) {
            throw new IllegalStateException("Closed during initialization");
        }
        if (this.mDatabase != null && this.mDatabase.isOpen()) {
            this.mDatabase.close();
            this.mDatabase = null;
        }
    }

    public void onConfigure(SQLiteDatabase db) {
    }

    public abstract void onCreate(SQLiteDatabase var1);

    public abstract void onUpgrade(SQLiteDatabase var1, int var2, int var3);

    public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        throw new SQLiteException("Can't downgrade database from version " + oldVersion + " to " + newVersion);
    }

    public void onOpen(SQLiteDatabase db) {
    }

    protected SQLiteDatabaseConfiguration createConfiguration(String path, int openFlags) {
        return new SQLiteDatabaseConfiguration(path, openFlags);
    }
}

