/*
 * Decompiled with CFR 0.152.
 */
package io.realm.android.internal.android.crypto.api_legacy;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import io.realm.android.internal.android.crypto.CipherFactory;
import io.realm.android.internal.android.crypto.SyncCrypto;
import io.realm.android.internal.android.crypto.misc.Base64;
import io.realm.android.internal.android.crypto.misc.PRNGFixes;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.SecureRandom;
import java.util.ArrayList;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class SyncCryptoLegacy
implements SyncCrypto {
    private Context context;
    private String alias = "Realm";
    private int mError = 1;
    private SecureRandom random = new SecureRandom();
    private static final String UNLOCK_ACTION = "android.credentials.UNLOCK";
    private static final int NO_ERROR = 1;
    private static final int LOCKED = 2;
    private static final int UNINITIALIZED = 3;
    private static final int PROTOCOL_ERROR = 5;
    private static final LocalSocketAddress sAddress = new LocalSocketAddress("keystore", LocalSocketAddress.Namespace.RESERVED);
    private static final int KEY_LENGTH = 256;
    private static final String DELIMITER = "]";

    public SyncCryptoLegacy(Context context) throws KeyStoreException {
        PRNGFixes.apply();
        this.context = context;
        try {
            PackageInfo pi = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            this.alias = this.alias + "_" + pi.packageName;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String encrypt(String plainText) throws KeyStoreException {
        try {
            Cipher cipher = CipherFactory.get();
            byte[] iv = this.generateIv(cipher.getBlockSize());
            IvParameterSpec ivParams = new IvParameterSpec(iv);
            SecretKeySpec key = new SecretKeySpec(this.get(this.alias), "AES");
            cipher.init(1, (Key)key, ivParams);
            byte[] cipherText = cipher.doFinal(plainText.getBytes("UTF-8"));
            return String.format("%s%s%s", Base64.to(iv), DELIMITER, Base64.to(cipherText));
        }
        catch (GeneralSecurityException e) {
            throw new KeyStoreException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new KeyStoreException(e);
        }
    }

    @Override
    public String decrypt(String cipherText) throws KeyStoreException {
        byte[] keyBytes = this.get(this.alias);
        if (keyBytes == null) {
            return null;
        }
        SecretKeySpec key = new SecretKeySpec(keyBytes, "AES");
        try {
            String[] fields = cipherText.split(DELIMITER);
            if (fields.length != 2) {
                throw new IllegalArgumentException("Invalid encrypted text format");
            }
            byte[] iv = Base64.from(fields[0]);
            byte[] cipherBytes = Base64.from(fields[1]);
            Cipher cipher = CipherFactory.get();
            IvParameterSpec ivParams = new IvParameterSpec(iv);
            cipher.init(2, (Key)key, ivParams);
            byte[] plaintext = cipher.doFinal(cipherBytes);
            return new String(plaintext, "UTF-8");
        }
        catch (GeneralSecurityException e) {
            throw new KeyStoreException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new KeyStoreException(e);
        }
    }

    @Override
    public boolean is_keystore_unlocked() throws KeyStoreException {
        return this.state() == State.UNLOCKED;
    }

    @Override
    public void unlock_keystore() throws KeyStoreException {
        try {
            Intent intent = new Intent(UNLOCK_ACTION);
            intent.addFlags(0x10000000);
            this.context.startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            throw new KeyStoreException(e);
        }
    }

    @Override
    public void create_key_if_not_available() throws KeyStoreException {
        if (this.get(this.alias) == null) {
            try {
                KeyGenerator kg = KeyGenerator.getInstance("AES");
                kg.init(256);
                SecretKey key = kg.generateKey();
                boolean success = this.put(SyncCryptoLegacy.getBytes(this.alias), key.getEncoded());
                if (!success) {
                    throw new KeyStoreException("Keystore error");
                }
            }
            catch (Exception e) {
                throw new KeyStoreException(e);
            }
        }
    }

    private State state() throws KeyStoreException {
        this.execute(116, new byte[0][]);
        switch (this.mError) {
            case 1: {
                return State.UNLOCKED;
            }
            case 2: {
                return State.LOCKED;
            }
            case 3: {
                return State.UNINITIALIZED;
            }
        }
        throw new KeyStoreException("" + this.mError);
    }

    private byte[] get(byte[] key) {
        ArrayList<byte[]> values = this.execute(103, new byte[][]{key});
        return values == null || values.isEmpty() ? null : values.get(0);
    }

    private byte[] get(String key) {
        return this.get(SyncCryptoLegacy.getBytes(key));
    }

    private boolean put(byte[] key, byte[] value) {
        this.execute(105, key, value);
        return this.mError == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ArrayList<byte[]> execute(int code, byte[] ... parameters) {
        this.mError = 5;
        for (byte[] parameter : parameters) {
            if (parameter == null) return null;
            if (parameter.length <= 65535) continue;
            return null;
        }
        LocalSocket socket = new LocalSocket();
        try {
            socket.connect(sAddress);
            OutputStream out = socket.getOutputStream();
            out.write(code);
            for (byte[] parameter : parameters) {
                out.write(parameter.length >> 8);
                out.write(parameter.length);
                out.write(parameter);
            }
            out.flush();
            socket.shutdownOutput();
            InputStream in = socket.getInputStream();
            code = in.read();
            if (code != 1) {
                if (code != -1) {
                    this.mError = code;
                }
                ArrayList<byte[]> parameter = null;
                return parameter;
            }
            ArrayList<byte[]> values = new ArrayList<byte[]>();
            while (true) {
                int i;
                if ((i = in.read()) == -1) {
                    this.mError = 1;
                    ArrayList<byte[]> arrayList = values;
                    return arrayList;
                }
                int j = in.read();
                if (j == -1) {
                    ArrayList<byte[]> arrayList = null;
                    return arrayList;
                }
                byte[] value = new byte[i << 8 | j];
                for (i = 0; i < value.length; i += j) {
                    j = in.read(value, i, value.length - i);
                    if (j != -1) continue;
                    ArrayList<byte[]> arrayList = null;
                    return arrayList;
                }
                values.add(value);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static byte[] getBytes(String string) {
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] generateIv(int length) {
        byte[] b = new byte[length];
        this.random.nextBytes(b);
        return b;
    }

    private static enum State {
        UNLOCKED,
        LOCKED,
        UNINITIALIZED;

    }
}

