/*
 * Decompiled with CFR 0.152.
 */
package io.realm.android.internal.android.crypto.api_23;

import android.annotation.TargetApi;
import android.content.Context;
import android.security.keystore.KeyGenParameterSpec;
import io.realm.android.internal.android.crypto.api_18.SyncCryptoApi18Impl;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPairGenerator;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Calendar;
import javax.security.auth.x500.X500Principal;

public class SyncCryptoApi23Impl
extends SyncCryptoApi18Impl {
    public SyncCryptoApi23Impl(Context context) throws KeyStoreException {
        super(context);
    }

    @Override
    @TargetApi(value=23)
    public void create_key_if_not_available() throws KeyStoreException {
        if (!this.keyStore.containsAlias(this.alias)) {
            try {
                Calendar start = Calendar.getInstance();
                Calendar end = Calendar.getInstance();
                end.add(1, 10);
                KeyPairGenerator keyGenerator = KeyPairGenerator.getInstance("RSA", "AndroidKeyStore");
                KeyGenParameterSpec spec = new KeyGenParameterSpec.Builder(this.alias, 3).setCertificateSubject(new X500Principal("CN=Sync, O=Realm")).setCertificateSerialNumber(BigInteger.ONE).setCertificateNotBefore(start.getTime()).setCertificateNotAfter(end.getTime()).setEncryptionPaddings(new String[]{"PKCS1Padding"}).setRandomizedEncryptionRequired(false).build();
                keyGenerator.initialize((AlgorithmParameterSpec)spec);
                keyGenerator.generateKeyPair();
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
                throw new KeyStoreException(e);
            }
            catch (InvalidAlgorithmParameterException e) {
                e.printStackTrace();
                throw new KeyStoreException(e);
            }
            catch (NoSuchProviderException e) {
                e.printStackTrace();
                throw new KeyStoreException(e);
            }
        }
    }
}

