/*
 * Decompiled with CFR 0.152.
 */
package io.realm.android.internal.android.crypto;

import android.os.Build;
import io.realm.android.internal.android.crypto.ciper.CipherJB;
import io.realm.android.internal.android.crypto.ciper.CipherLegacy;
import io.realm.android.internal.android.crypto.ciper.CipherMM;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;

public class CipherFactory {
    private static final boolean IS_JB43 = Build.VERSION.SDK_INT >= 18;
    private static final boolean IS_MM = Build.VERSION.SDK_INT >= 23;
    private static final boolean IS_GINGERBREAD = Build.VERSION.SDK_INT >= 9;

    public static Cipher get() throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException {
        if (IS_MM) {
            return CipherMM.get();
        }
        if (IS_JB43) {
            return CipherJB.get();
        }
        if (IS_GINGERBREAD) {
            return CipherLegacy.get();
        }
        throw new IllegalArgumentException("Not supported yet");
    }
}

