/*
 * Decompiled with CFR 0.152.
 */
package io.realm.android;

import android.content.Context;
import io.realm.RealmFileUserStore;
import io.realm.SyncUser;
import io.realm.android.CipherClient;
import io.realm.log.RealmLog;
import java.security.KeyStoreException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class SecureUserStore
extends RealmFileUserStore {
    private final CipherClient cipherClient;

    public SecureUserStore(Context context) throws KeyStoreException {
        this.cipherClient = new CipherClient(context);
    }

    public void put(SyncUser user) {
        try {
            String userSerialisedAndEncrypted = this.cipherClient.encrypt(user.toJson());
            SecureUserStore.nativeUpdateOrCreateUser((String)user.getIdentity(), (String)userSerialisedAndEncrypted, (String)user.getAuthenticationUrl().toString());
        }
        catch (KeyStoreException e) {
            RealmLog.error((Throwable)e);
        }
    }

    public SyncUser getCurrent() {
        String userJson = SecureUserStore.nativeGetCurrentUser();
        return this.toDecryptedSyncUserOrNull(userJson);
    }

    public SyncUser get(String identity) {
        String userJson = SecureUserStore.nativeGetUser((String)identity);
        return this.toDecryptedSyncUserOrNull(userJson);
    }

    public Collection<SyncUser> allUsers() {
        String[] allUsers = SecureUserStore.nativeGetAllUsers();
        if (allUsers != null && allUsers.length > 0) {
            ArrayList<SyncUser> users = new ArrayList<SyncUser>(allUsers.length);
            for (String userJson : allUsers) {
                String userSerialisedAndDecrypted = null;
                try {
                    userSerialisedAndDecrypted = this.cipherClient.decrypt(userJson);
                }
                catch (KeyStoreException e) {
                    RealmLog.error((Throwable)e);
                }
                users.add(SyncUser.fromJson((String)userSerialisedAndDecrypted));
            }
            return users;
        }
        return Collections.emptyList();
    }

    public boolean isKeystoreUnlocked() throws KeyStoreException {
        return this.cipherClient.isKeystoreUnlocked();
    }

    public void unlockKeystore() throws KeyStoreException {
        this.cipherClient.unlockKeystore();
    }

    private SyncUser toDecryptedSyncUserOrNull(String userEncryptedJson) {
        if (userEncryptedJson != null) {
            try {
                String userSerialisedAndDecrypted = this.cipherClient.decrypt(userEncryptedJson);
                return SyncUser.fromJson((String)userSerialisedAndDecrypted);
            }
            catch (KeyStoreException e) {
                RealmLog.error((Throwable)e);
                return null;
            }
        }
        return null;
    }
}

