/*
 * Decompiled with CFR 0.152.
 */
package io.realm.android.internal.android.crypto.api_18;

import android.annotation.TargetApi;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.security.KeyPairGeneratorSpec;
import io.realm.android.internal.android.crypto.CipherFactory;
import io.realm.android.internal.android.crypto.SyncCrypto;
import io.realm.android.internal.android.crypto.misc.Base64;
import io.realm.android.internal.android.crypto.misc.PRNGFixes;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Calendar;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.x500.X500Principal;

public class SyncCryptoApi18Impl
implements SyncCrypto {
    private static final String DELIMITER = "]";
    protected KeyStore keyStore;
    protected Context context;
    protected static final String X500_PRINCIPAL = "CN=Sync, O=Realm";
    protected static final String ANDROID_KEYSTORE = "AndroidKeyStore";
    protected String alias = "Realm";
    public static final String UNLOCK_ACTION = "com.android.credentials.UNLOCK";

    public SyncCryptoApi18Impl(Context context) throws KeyStoreException {
        PRNGFixes.apply();
        this.context = context;
        try {
            this.keyStore = KeyStore.getInstance(ANDROID_KEYSTORE);
            this.keyStore.load(null);
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
            throw new KeyStoreException(e);
        }
        catch (CertificateException e) {
            e.printStackTrace();
            throw new KeyStoreException(e);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new KeyStoreException(e);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new KeyStoreException(e);
        }
    }

    @Override
    public String encrypt(String plainText) throws KeyStoreException {
        try {
            SecretKey key = this.generateAESKey();
            byte[] encrypted = this.encryptedUsingAESKey(key, plainText);
            byte[] encryptedKey = this.encryptAESKeyUsingRSA(key);
            return String.format("%s%s%s", Base64.to(encryptedKey), DELIMITER, Base64.to(encrypted));
        }
        catch (Exception e) {
            throw new KeyStoreException(e);
        }
    }

    @Override
    public String decrypt(String cipherText) throws KeyStoreException {
        try {
            String[] fields = cipherText.split(DELIMITER);
            if (fields.length != 2) {
                throw new IllegalArgumentException("Invalid encrypted text format");
            }
            byte[] aesEncWithRSA = Base64.from(fields[0]);
            byte[] encToken = Base64.from(fields[1]);
            SecretKeySpec key = this.decryptAESKeyUsingRSA(aesEncWithRSA);
            return this.decryptedUsingAESKey(key, encToken);
        }
        catch (Exception e) {
            throw new KeyStoreException(e);
        }
    }

    @Override
    public boolean is_keystore_unlocked() throws KeyStoreException {
        try {
            Class<?> keyStoreClass = Class.forName("android.security.KeyStore");
            Method getInstanceMethod = keyStoreClass.getMethod("getInstance", new Class[0]);
            Object invoke = getInstanceMethod.invoke(null, new Object[0]);
            Method isUnlockedMethod = keyStoreClass.getMethod("isUnlocked", new Class[0]);
            boolean isUnlocked = (Boolean)isUnlockedMethod.invoke(invoke, new Object[0]);
            return isUnlocked;
        }
        catch (ClassNotFoundException e) {
            throw new KeyStoreException(e);
        }
        catch (NoSuchMethodException e) {
            throw new KeyStoreException(e);
        }
        catch (IllegalAccessException e) {
            throw new KeyStoreException(e);
        }
        catch (InvocationTargetException e) {
            throw new KeyStoreException(e);
        }
    }

    @Override
    public void unlock_keystore() throws KeyStoreException {
        try {
            Intent intent = new Intent(UNLOCK_ACTION);
            intent.addFlags(0x10000000);
            this.context.startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            throw new KeyStoreException(e);
        }
    }

    @Override
    @TargetApi(value=18)
    public void create_key() throws KeyStoreException {
        try {
            if (this.keyStore.containsAlias(this.alias)) {
                this.keyStore.deleteEntry(this.alias);
            }
            Calendar start = Calendar.getInstance();
            Calendar end = Calendar.getInstance();
            end.add(1, 1);
            KeyPairGeneratorSpec spec = new KeyPairGeneratorSpec.Builder(this.context).setAlias(this.alias).setSubject(new X500Principal(X500_PRINCIPAL)).setSerialNumber(BigInteger.ONE).setStartDate(start.getTime()).setEndDate(end.getTime()).build();
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA", ANDROID_KEYSTORE);
            generator.initialize((AlgorithmParameterSpec)spec);
            generator.generateKeyPair();
        }
        catch (Exception e) {
            throw new KeyStoreException(e);
        }
    }

    private SecretKey generateAESKey() throws NoSuchAlgorithmException {
        int outputKeyLength = 256;
        SecureRandom secureRandom = new SecureRandom();
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
        keyGenerator.init(256, secureRandom);
        SecretKey key = keyGenerator.generateKey();
        return key;
    }

    private byte[] encryptedUsingAESKey(SecretKey key, String plainText) throws KeyStoreException {
        try {
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, key);
            return cipher.doFinal(plainText.getBytes("UTF-8"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyStoreException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new KeyStoreException(e);
        }
        catch (BadPaddingException e) {
            throw new KeyStoreException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new KeyStoreException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new KeyStoreException(e);
        }
        catch (InvalidKeyException e) {
            throw new KeyStoreException(e);
        }
    }

    private String decryptedUsingAESKey(SecretKey key, byte[] cipherText) throws KeyStoreException {
        try {
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, key);
            byte[] encrypted = cipher.doFinal(cipherText);
            return new String(encrypted, "UTF-8");
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyStoreException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new KeyStoreException(e);
        }
        catch (BadPaddingException e) {
            throw new KeyStoreException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new KeyStoreException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new KeyStoreException(e);
        }
        catch (InvalidKeyException e) {
            throw new KeyStoreException(e);
        }
    }

    private byte[] encryptAESKeyUsingRSA(SecretKey key) throws KeyStoreException {
        try {
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)this.keyStore.getEntry(this.alias, null);
            RSAPublicKey publicKey = (RSAPublicKey)privateKeyEntry.getCertificate().getPublicKey();
            Cipher cipher = CipherFactory.get();
            cipher.init(1, publicKey);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            CipherOutputStream cipherOutputStream = new CipherOutputStream(outputStream, cipher);
            cipherOutputStream.write(key.getEncoded());
            cipherOutputStream.close();
            return outputStream.toByteArray();
        }
        catch (NoSuchPaddingException e) {
            throw new KeyStoreException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyStoreException(e);
        }
        catch (NoSuchProviderException e) {
            throw new KeyStoreException(e);
        }
        catch (InvalidKeyException e) {
            throw new KeyStoreException(e);
        }
        catch (KeyStoreException e) {
            throw new KeyStoreException(e);
        }
        catch (UnrecoverableEntryException e) {
            throw new KeyStoreException(e);
        }
        catch (IOException e) {
            throw new KeyStoreException(e);
        }
    }

    private SecretKeySpec decryptAESKeyUsingRSA(byte[] aesEncKey) throws KeyStoreException {
        try {
            int nextByte;
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)this.keyStore.getEntry(this.alias, null);
            Cipher cipher = CipherFactory.get();
            cipher.init(2, privateKeyEntry.getPrivateKey());
            CipherInputStream cipherInputStream = new CipherInputStream(new ByteArrayInputStream(aesEncKey), cipher);
            ArrayList<Byte> values = new ArrayList<Byte>();
            while ((nextByte = cipherInputStream.read()) != -1) {
                values.add((byte)nextByte);
            }
            byte[] bytes = new byte[values.size()];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = (Byte)values.get(i);
            }
            SecretKeySpec originalKey = new SecretKeySpec(bytes, "AES");
            return originalKey;
        }
        catch (NoSuchPaddingException e) {
            throw new KeyStoreException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyStoreException(e);
        }
        catch (NoSuchProviderException e) {
            throw new KeyStoreException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new KeyStoreException(e);
        }
        catch (IOException e) {
            throw new KeyStoreException(e);
        }
        catch (InvalidKeyException e) {
            throw new KeyStoreException(e);
        }
        catch (UnrecoverableEntryException e) {
            throw new KeyStoreException(e);
        }
        catch (KeyStoreException e) {
            throw new KeyStoreException(e);
        }
    }
}

