/*
 * Decompiled with CFR 0.152.
 */
package io.realm.android.internal.android.crypto;

import android.content.Context;
import android.os.Build;
import io.realm.android.internal.android.crypto.SyncCrypto;
import io.realm.android.internal.android.crypto.api_18.SyncCryptoApi18Impl;
import io.realm.android.internal.android.crypto.api_23.SyncCryptoApi23Impl;
import io.realm.android.internal.android.crypto.api_legacy.SyncCryptoLegacy;
import java.security.KeyStoreException;

public class SyncCryptoFactory {
    private static final boolean IS_API_23 = Build.VERSION.SDK_INT >= 23;
    private static final boolean IS_API_18 = Build.VERSION.SDK_INT >= 18;
    private static final boolean IS_API_LEGACY = Build.VERSION.SDK_INT >= 9;

    public static SyncCrypto get(Context context) throws KeyStoreException {
        if (IS_API_23) {
            return new SyncCryptoApi23Impl(context);
        }
        if (IS_API_18) {
            return new SyncCryptoApi18Impl(context);
        }
        if (IS_API_LEGACY) {
            return new SyncCryptoLegacy(context);
        }
        throw new KeyStoreException("Unknown android version");
    }
}

