/*
 * Decompiled with CFR 0.152.
 */
package io.realm.android;

import android.content.Context;
import android.content.SharedPreferences;
import io.realm.SyncUser;
import io.realm.UserStore;
import io.realm.android.CipherClient;
import java.security.KeyStoreException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class SecureUserStore
implements UserStore {
    private static final String REALM_OBJECT_SERVER_USERS = "realm_object_server_users";
    private final CipherClient cipherClient;
    private final SharedPreferences sp;
    private SyncUser cachedCurrentUser;

    public SecureUserStore(Context context) throws KeyStoreException {
        this.cipherClient = new CipherClient(context);
        this.sp = context.getSharedPreferences(REALM_OBJECT_SERVER_USERS, 0);
    }

    public SyncUser put(String key, SyncUser user) {
        String userSerialisedAndEncrypted;
        String previousUser = this.sp.getString(key, null);
        SharedPreferences.Editor editor = this.sp.edit();
        try {
            userSerialisedAndEncrypted = this.cipherClient.encrypt(user.toJson());
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
            return null;
        }
        editor.putString(key, userSerialisedAndEncrypted);
        editor.apply();
        if ("realm$currentUser".equals(key)) {
            this.cachedCurrentUser = user;
        }
        if (previousUser != null) {
            try {
                String userSerialisedAndDecrypted = this.cipherClient.decrypt(previousUser);
                return SyncUser.fromJson((String)userSerialisedAndDecrypted);
            }
            catch (KeyStoreException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public SyncUser get(String key) {
        if (key.equals("realm$currentUser") && this.cachedCurrentUser != null) {
            return this.cachedCurrentUser;
        }
        String userData = this.sp.getString(key, "");
        if (userData.equals("")) {
            return null;
        }
        try {
            String userSerialisedAndDecrypted = this.cipherClient.decrypt(userData);
            SyncUser user = SyncUser.fromJson((String)userSerialisedAndDecrypted);
            if ("realm$currentUser".equals(key)) {
                this.cachedCurrentUser = user;
            }
            return user;
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    public SyncUser remove(String key) {
        String currentUser = this.sp.getString(key, null);
        SharedPreferences.Editor editor = this.sp.edit();
        editor.putString(key, null);
        editor.apply();
        if ("realm$currentUser".equals(key) && this.cachedCurrentUser != null) {
            this.cachedCurrentUser = null;
        }
        if (currentUser != null) {
            try {
                String userSerialisedAndDecrypted = this.cipherClient.decrypt(currentUser);
                return SyncUser.fromJson((String)userSerialisedAndDecrypted);
            }
            catch (KeyStoreException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public Collection<SyncUser> allUsers() {
        Map all = this.sp.getAll();
        ArrayList<SyncUser> users = new ArrayList<SyncUser>(all.size());
        for (Object userJson : all.values()) {
            String userSerialisedAndDecrypted = null;
            try {
                userSerialisedAndDecrypted = this.cipherClient.decrypt((String)userJson);
            }
            catch (KeyStoreException e) {
                e.printStackTrace();
            }
            users.add(SyncUser.fromJson((String)userSerialisedAndDecrypted));
        }
        return users;
    }

    public void clear() {
        Set all = this.sp.getAll().keySet();
        SharedPreferences.Editor editor = this.sp.edit();
        for (String key : all) {
            editor.remove(key);
        }
        editor.apply();
    }
}

