/*
 * Decompiled with CFR 0.152.
 */
package io.realm.android;

import android.content.Context;
import io.realm.android.internal.android.crypto.SyncCrypto;
import io.realm.android.internal.android.crypto.SyncCryptoFactory;
import java.security.KeyStoreException;

public class CipherClient {
    private SyncCrypto syncCrypto;

    public CipherClient(Context context) throws KeyStoreException {
        this.syncCrypto = SyncCryptoFactory.get(context);
    }

    public String encrypt(String user) throws KeyStoreException {
        if (this.syncCrypto.is_keystore_unlocked()) {
            try {
                this.syncCrypto.create_key();
                String encrypted = this.syncCrypto.encrypt(user);
                return encrypted;
            }
            catch (KeyStoreException ex) {
                throw new KeyStoreException(ex);
            }
        }
        throw new KeyStoreException("Trying to use SecureUserStore without an unlocked KeyStore");
    }

    public String decrypt(String user_encrypted) throws KeyStoreException {
        if (this.syncCrypto.is_keystore_unlocked()) {
            try {
                String decrypted = this.syncCrypto.decrypt(user_encrypted);
                return decrypted;
            }
            catch (KeyStoreException ex) {
                throw new KeyStoreException(ex);
            }
        }
        throw new KeyStoreException("Trying to use SecureUserStore without an unlocked KeyStore");
    }

    public boolean isKeystoreUnlocked() throws KeyStoreException {
        return this.syncCrypto.is_keystore_unlocked();
    }

    public void unlockKeystore() throws KeyStoreException {
        this.syncCrypto.unlock_keystore();
    }
}

