/*
 * Decompiled with CFR 0.152.
 */
package io.realm.transformer;

import com.android.build.api.transform.Context;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformOutputProvider;
import io.realm.analytics.RealmAnalytics;
import io.realm.transformer.ProjectMetaData;
import io.realm.transformer.Stopwatch;
import io.realm.transformer.build.BuildTemplate;
import io.realm.transformer.build.FullBuild;
import io.realm.transformer.build.IncrementalBuild;
import io.realm.transformer.ext.ProjectExtKt;
import java.util.Collection;
import java.util.Set;
import javassist.CtClass;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0011H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u001b0\u001aH\u0016J\u0010\u0010\u001c\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u001b0\u001aH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016JD\u0010\u001f\u001a\u00020\f2\b\u0010 \u001a\u0004\u0018\u00010!2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\"2\u000e\u0010#\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lio/realm/transformer/RealmTransformer;", "Lcom/android/build/api/transform/Transform;", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "analytics", "Lio/realm/analytics/RealmAnalytics;", "logger", "Lorg/slf4j/Logger;", "metadata", "Lio/realm/transformer/ProjectMetaData;", "exitTransform", "", "inputs", "", "Lcom/android/build/api/transform/TransformInput;", "outputModelClasses", "", "Ljavassist/CtClass;", "timer", "Lio/realm/transformer/Stopwatch;", "getInputTypes", "Lcom/android/build/api/transform/QualifiedContent$ContentType;", "getName", "", "getReferencedScopes", "", "Lcom/android/build/api/transform/QualifiedContent$Scope;", "getScopes", "isIncremental", "", "transform", "context", "Lcom/android/build/api/transform/Context;", "", "referencedInputs", "outputProvider", "Lcom/android/build/api/transform/TransformOutputProvider;", "realm-transformer"})
public final class RealmTransformer
extends Transform {
    @NotNull
    private final Logger logger;
    private ProjectMetaData metadata;
    @Nullable
    private RealmAnalytics analytics;

    public RealmTransformer(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Logger logger = LoggerFactory.getLogger((String)"realm-logger");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(\"realm-logger\")");
        this.logger = logger;
        project.afterEvaluate(arg_0 -> RealmTransformer._init_$lambda-0(this, project, arg_0));
    }

    @NotNull
    public String getName() {
        return "RealmTransformer";
    }

    @NotNull
    public Set<QualifiedContent.ContentType> getInputTypes() {
        return SetsKt.setOf((Object)QualifiedContent.DefaultContentType.CLASSES);
    }

    public boolean isIncremental() {
        return true;
    }

    @NotNull
    public Set<? super QualifiedContent.Scope> getScopes() {
        Object[] objectArray = new QualifiedContent.Scope[]{QualifiedContent.Scope.PROJECT};
        return SetsKt.mutableSetOf((Object[])objectArray);
    }

    @NotNull
    public Set<? super QualifiedContent.Scope> getReferencedScopes() {
        Object[] objectArray = new QualifiedContent.Scope[]{QualifiedContent.Scope.EXTERNAL_LIBRARIES, QualifiedContent.Scope.PROJECT_LOCAL_DEPS, QualifiedContent.Scope.SUB_PROJECTS, QualifiedContent.Scope.SUB_PROJECTS_LOCAL_DEPS, QualifiedContent.Scope.TESTED_CODE};
        return SetsKt.mutableSetOf((Object[])objectArray);
    }

    public void transform(@Nullable Context context, @Nullable Collection<TransformInput> inputs, @Nullable Collection<? extends TransformInput> referencedInputs, @Nullable TransformOutputProvider outputProvider, boolean isIncremental) {
        BuildTemplate buildTemplate;
        ProjectMetaData projectMetaData;
        Stopwatch timer = new Stopwatch();
        timer.start("Realm Transform time");
        if (isIncremental) {
            ProjectMetaData projectMetaData2;
            projectMetaData = this.metadata;
            if (projectMetaData == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"metadata");
                projectMetaData2 = null;
            } else {
                projectMetaData2 = projectMetaData;
            }
            TransformOutputProvider transformOutputProvider = outputProvider;
            Intrinsics.checkNotNull((Object)transformOutputProvider);
            buildTemplate = new IncrementalBuild(projectMetaData2, transformOutputProvider, this);
        } else {
            ProjectMetaData projectMetaData3;
            projectMetaData = this.metadata;
            if (projectMetaData == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"metadata");
                projectMetaData3 = null;
            } else {
                projectMetaData3 = projectMetaData;
            }
            TransformOutputProvider transformOutputProvider = outputProvider;
            Intrinsics.checkNotNull((Object)transformOutputProvider);
            buildTemplate = new FullBuild(projectMetaData3, transformOutputProvider, this);
        }
        BuildTemplate build = buildTemplate;
        Collection<TransformInput> collection = inputs;
        Intrinsics.checkNotNull(collection);
        build.prepareOutputClasses(collection);
        Stopwatch.splitTime$default(timer, "Prepare output classes", false, 2, null);
        if (build.hasNoOutput()) {
            this.exitTransform(SetsKt.emptySet(), SetsKt.emptySet(), timer);
            return;
        }
        Collection<? extends TransformInput> collection2 = referencedInputs;
        Intrinsics.checkNotNull(collection2);
        build.prepareReferencedClasses(collection2);
        Stopwatch.splitTime$default(timer, "Prepare referenced classes", false, 2, null);
        build.markMediatorsAsTransformed();
        Stopwatch.splitTime$default(timer, "Mark mediators as transformed", false, 2, null);
        build.transformModelClasses();
        Stopwatch.splitTime$default(timer, "Transform model classes", false, 2, null);
        build.transformDirectAccessToModelFields();
        Stopwatch.splitTime$default(timer, "Transform references to model fields", false, 2, null);
        build.copyResourceFiles();
        Stopwatch.splitTime$default(timer, "Copy resource files", false, 2, null);
        this.exitTransform(inputs, build.getOutputModelClasses(), timer);
    }

    private final void exitTransform(Collection<? extends TransformInput> inputs, Set<? extends CtClass> outputModelClasses, Stopwatch timer) {
        timer.stop();
        RealmAnalytics realmAnalytics = this.analytics;
        if (realmAnalytics != null) {
            realmAnalytics.execute();
        }
    }

    private static final void _init_$lambda-0(RealmTransformer this$0, Project $project, Project it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        this$0.metadata = new ProjectMetaData($project.getGradle().getStartParameter().isOffline(), ProjectExtKt.getBootClasspath($project));
        try {
            RealmAnalytics realmAnalytics = this$0.analytics = new RealmAnalytics();
            Intrinsics.checkNotNull((Object)realmAnalytics);
            realmAnalytics.calculateAnalyticsData($project);
        }
        catch (Exception e) {
            this$0.logger.debug(Intrinsics.stringPlus((String)"Could not calculate Realm analytics data:\n", (Object)e));
        }
    }
}

