/*
 * Decompiled with CFR 0.152.
 */
package io.realm.analytics;

import io.realm.analytics.AnalyticsData;
import io.realm.transformer.Utils;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.security.NoSuchAlgorithmException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/realm/analytics/UrlEncodedAnalytics;", "", "prefix", "", "suffix", "(Ljava/lang/String;Ljava/lang/String;)V", "execute", "", "analytics", "Lio/realm/analytics/AnalyticsData;", "getUrl", "Ljava/net/URL;", "Companion", "realm-transformer"})
public final class UrlEncodedAnalytics {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String prefix;
    @NotNull
    private final String suffix;

    private UrlEncodedAnalytics(String prefix, String suffix) {
        this.prefix = prefix;
        this.suffix = suffix;
    }

    public final void execute(@NotNull AnalyticsData analytics) {
        Intrinsics.checkNotNullParameter((Object)analytics, (String)"analytics");
        try {
            URL url = this.getUrl(analytics);
            URLConnection uRLConnection = url.openConnection();
            if (uRLConnection == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
            }
            HttpURLConnection connection = (HttpURLConnection)uRLConnection;
            connection.setRequestMethod("GET");
            connection.connect();
            connection.getResponseCode();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final URL getUrl(AnalyticsData analytics) throws MalformedURLException, SocketException, NoSuchAlgorithmException, UnsupportedEncodingException {
        return new URL(this.prefix + Utils.base64Encode(analytics.generateJson()) + this.suffix);
    }

    public /* synthetic */ UrlEncodedAnalytics(String prefix, String suffix, DefaultConstructorMarker $constructor_marker) {
        this(prefix, suffix);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lio/realm/analytics/UrlEncodedAnalytics$Companion;", "", "()V", "create", "Lio/realm/analytics/UrlEncodedAnalytics;", "realm-transformer"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final UrlEncodedAnalytics create() {
            String ADDRESS_PREFIX = "https://webhooks.mongodb-realm.com/api/client/v2.0/app/realmsdkmetrics-zmhtm/service/metric_webhook/incoming_webhook/metric?data=";
            String ADDRESS_SUFFIX = "";
            return new UrlEncodedAnalytics(ADDRESS_PREFIX, ADDRESS_SUFFIX, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

