/*
 * Decompiled with CFR 0.152.
 */
package io.realm.processor;

import java.util.List;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

public class Utils {
    public static Types typeUtils;
    private static Messager messager;
    private static DeclaredType realmList;
    private static DeclaredType markerInterface;
    private static TypeMirror realmModel;

    public static void initialize(ProcessingEnvironment env) {
        typeUtils = env.getTypeUtils();
        messager = env.getMessager();
        realmList = typeUtils.getDeclaredType(env.getElementUtils().getTypeElement("io.realm.RealmList"), typeUtils.getWildcardType(null, null));
        realmModel = env.getElementUtils().getTypeElement("io.realm.RealmModel").asType();
        markerInterface = env.getTypeUtils().getDeclaredType(env.getElementUtils().getTypeElement("io.realm.RealmModel"), new TypeMirror[0]);
    }

    public static boolean isDefaultConstructor(Element constructor) {
        if (constructor.getModifiers().contains((Object)Modifier.PUBLIC)) {
            return ((ExecutableElement)constructor).getParameters().isEmpty();
        }
        return false;
    }

    public static String lowerFirstChar(String input) {
        return input.substring(0, 1).toLowerCase() + input.substring(1);
    }

    public static String getProxyClassSimpleName(VariableElement field) {
        if (typeUtils.isAssignable(field.asType(), realmList)) {
            return Utils.getProxyClassName(Utils.getGenericTypeSimpleName(field));
        }
        return Utils.getProxyClassName(Utils.getFieldTypeSimpleName(field));
    }

    public static String getProxyClassName(String clazz) {
        return clazz + "RealmProxy";
    }

    public static boolean isString(VariableElement field) {
        if (field == null) {
            throw new IllegalArgumentException("Argument 'field' cannot be null.");
        }
        return Utils.getFieldTypeSimpleName(field).equals("String");
    }

    public static boolean isPrimitiveType(String typeString) {
        if (typeString == null) {
            throw new IllegalArgumentException("Argument 'typeString' cannot be null.");
        }
        return typeString.equals("byte") || typeString.equals("short") || typeString.equals("int") || typeString.equals("long") || typeString.equals("float") || typeString.equals("double") || typeString.equals("boolean") || typeString.equals("char");
    }

    public static boolean isBoxedType(String typeString) {
        if (typeString == null) {
            throw new IllegalArgumentException("Argument 'typeString' cannot be null.");
        }
        return typeString.equals(Byte.class.getName()) || typeString.equals(Short.class.getName()) || typeString.equals(Integer.class.getName()) || typeString.equals(Long.class.getName()) || typeString.equals(Float.class.getName()) || typeString.equals(Double.class.getName()) || typeString.equals(Boolean.class.getName());
    }

    public static boolean isPrimitiveType(VariableElement field) {
        if (field == null) {
            throw new IllegalArgumentException("Argument 'field' cannot be null.");
        }
        return field.asType().getKind().isPrimitive();
    }

    public static boolean isByteArray(VariableElement field) {
        if (field == null) {
            throw new IllegalArgumentException("Argument 'field' cannot be null.");
        }
        return Utils.getFieldTypeSimpleName(field).equals("byte[]");
    }

    public static boolean isString(String fieldType) {
        if (fieldType == null) {
            throw new IllegalArgumentException("Argument 'fieldType' cannot be null.");
        }
        return String.class.getName().equals(fieldType);
    }

    public static boolean isImplementingMarkerInterface(Element classElement) {
        return typeUtils.isAssignable(classElement.asType(), markerInterface);
    }

    public static boolean isRealmList(VariableElement field) {
        return typeUtils.isAssignable(field.asType(), realmList);
    }

    public static boolean isRealmModel(VariableElement field) {
        return typeUtils.isAssignable(field.asType(), realmModel);
    }

    public static String getFieldTypeQualifiedName(VariableElement field) {
        return field.asType().toString();
    }

    public static String getFieldTypeSimpleName(VariableElement field) {
        String fieldTypeQualifiedName = Utils.getFieldTypeQualifiedName(field);
        if (!fieldTypeQualifiedName.contains(".")) {
            return fieldTypeQualifiedName;
        }
        return fieldTypeQualifiedName.substring(fieldTypeQualifiedName.lastIndexOf(46) + 1);
    }

    public static String getGenericTypeQualifiedName(VariableElement field) {
        TypeMirror fieldType = field.asType();
        List<? extends TypeMirror> typeArguments = ((DeclaredType)fieldType).getTypeArguments();
        if (typeArguments.size() == 0) {
            return null;
        }
        return typeArguments.get(0).toString();
    }

    public static String getGenericTypeSimpleName(VariableElement field) {
        String genericTypeName = Utils.getGenericTypeQualifiedName(field);
        if (genericTypeName == null) {
            return null;
        }
        if (!genericTypeName.contains(".")) {
            return genericTypeName;
        }
        return genericTypeName.substring(genericTypeName.lastIndexOf(46) + 1);
    }

    public static String stripPackage(String fullyQualifiedClassName) {
        String[] parts = fullyQualifiedClassName.split("\\.");
        if (parts.length > 0) {
            return parts[parts.length - 1];
        }
        return fullyQualifiedClassName;
    }

    public static void error(String message, Element element) {
        messager.printMessage(Diagnostic.Kind.ERROR, message, element);
    }

    public static void error(String message) {
        messager.printMessage(Diagnostic.Kind.ERROR, message);
    }

    public static void note(String message) {
        messager.printMessage(Diagnostic.Kind.NOTE, message);
    }

    public static Element getSuperClass(TypeElement classType) {
        return typeUtils.asElement(classType.getSuperclass());
    }

    public static String getProxyInterfaceName(String className) {
        return className + "RealmProxyInterface";
    }
}

