/*
 * Decompiled with CFR 0.152.
 */
package io.realm.processor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.annotation.processing.ProcessingEnvironment;
import javax.tools.Diagnostic;

public class RealmVersionChecker {
    public static final String REALM_ANDROID_DOWNLOAD_URL = "http://static.realm.io/downloads/java/latest";
    private static RealmVersionChecker instance = null;
    private static boolean isFirstRound = true;
    private static final String VERSION_URL = "http://static.realm.io/update/java?";
    private static final String REALM_VERSION = "2.0.2";
    private static final String REALM_VERSION_PATTERN = "\\d+\\.\\d+\\.\\d+";
    private static final int READ_TIMEOUT = 2000;
    private static final int CONNECT_TIMEOUT = 4000;
    private ProcessingEnvironment processingEnvironment;

    private RealmVersionChecker(ProcessingEnvironment processingEnvironment) {
        this.processingEnvironment = processingEnvironment;
    }

    public static RealmVersionChecker getInstance(ProcessingEnvironment processingEnvironment) {
        if (instance == null) {
            instance = new RealmVersionChecker(processingEnvironment);
        }
        return instance;
    }

    private void launchRealmCheck() {
        String latestVersionStr = this.checkLatestVersion();
        if (!latestVersionStr.equals(REALM_VERSION)) {
            this.printMessage("Version " + latestVersionStr + " of Realm is now available: " + REALM_ANDROID_DOWNLOAD_URL);
        }
    }

    public void executeRealmVersionUpdate() {
        if (isFirstRound) {
            isFirstRound = false;
            Thread backgroundThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    RealmVersionChecker.this.launchRealmCheck();
                }
            });
            backgroundThread.start();
            try {
                backgroundThread.join(6000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private String checkLatestVersion() {
        String result = REALM_VERSION;
        try {
            URL url = new URL("http://static.realm.io/update/java?2.0.2");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(4000);
            conn.setReadTimeout(2000);
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String latestVersion = rd.readLine();
            if (latestVersion.matches(REALM_VERSION_PATTERN)) {
                result = latestVersion;
            }
            rd.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private void printMessage(String message) {
        this.processingEnvironment.getMessager().printMessage(Diagnostic.Kind.OTHER, message);
    }
}

