/*
 * Decompiled with CFR 0.152.
 */
package io.realm.processor;

import com.squareup.javawriter.JavaWriter;
import io.realm.annotations.RealmModule;
import io.realm.processor.ClassMetaData;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.tools.JavaFileObject;

public class RealmProxyMediatorGenerator {
    private final String className;
    private ProcessingEnvironment processingEnvironment;
    private List<String> qualifiedModelClasses = new ArrayList<String>();
    private List<String> qualifiedProxyClasses = new ArrayList<String>();

    public RealmProxyMediatorGenerator(ProcessingEnvironment processingEnvironment, String className, Set<ClassMetaData> classesToValidate) {
        this.processingEnvironment = processingEnvironment;
        this.className = className;
        for (ClassMetaData metadata : classesToValidate) {
            String simpleName = metadata.getSimpleClassName();
            this.qualifiedModelClasses.add(metadata.getFullyQualifiedClassName());
            this.qualifiedProxyClasses.add("io.realm." + this.getProxyClassName(simpleName));
        }
    }

    public void generate() throws IOException {
        String qualifiedGeneratedClassName = String.format("%s.%sMediator", "io.realm", this.className);
        JavaFileObject sourceFile = this.processingEnvironment.getFiler().createSourceFile(qualifiedGeneratedClassName, new Element[0]);
        JavaWriter writer = new JavaWriter((Writer)new BufferedWriter(sourceFile.openWriter()));
        writer.setIndent("    ");
        writer.emitPackage("io.realm");
        writer.emitEmptyLine();
        writer.emitImports(new String[]{"android.util.JsonReader", "java.io.IOException", "java.util.Collections", "java.util.HashSet", "java.util.List", "java.util.Map", "java.util.IdentityHashMap", "java.util.Set", "java.util.Iterator", "java.util.Collection", "io.realm.internal.ColumnInfo", "io.realm.internal.SharedRealm", "io.realm.internal.RealmObjectProxy", "io.realm.internal.RealmProxyMediator", "io.realm.internal.Row", "io.realm.internal.Table", "io.realm.RealmObjectSchema", "org.json.JSONException", "org.json.JSONObject"});
        writer.emitEmptyLine();
        writer.emitAnnotation(RealmModule.class);
        writer.beginType(qualifiedGeneratedClassName, "class", Collections.emptySet(), "RealmProxyMediator", new String[0]);
        writer.emitEmptyLine();
        this.emitFields(writer);
        this.emitCreateTableMethod(writer);
        this.emitCreateRealmObjectSchema(writer);
        this.emitValidateTableMethod(writer);
        this.emitGetFieldNamesMethod(writer);
        this.emitGetTableNameMethod(writer);
        this.emitNewInstanceMethod(writer);
        this.emitGetClassModelList(writer);
        this.emitCopyToRealmMethod(writer);
        this.emitInsertObjectToRealmMethod(writer);
        this.emitInsertListToRealmMethod(writer);
        this.emitInsertOrUpdateObjectToRealmMethod(writer);
        this.emitInsertOrUpdateListToRealmMethod(writer);
        this.emitCreteOrUpdateUsingJsonObject(writer);
        this.emitCreateUsingJsonStream(writer);
        this.emitCreateDetachedCopyMethod(writer);
        writer.endType();
        writer.close();
    }

    private void emitFields(JavaWriter writer) throws IOException {
        writer.emitField("Set<Class<? extends RealmModel>>", "MODEL_CLASSES", EnumSet.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL));
        writer.beginInitializer(true);
        writer.emitStatement("Set<Class<? extends RealmModel>> modelClasses = new HashSet<Class<? extends RealmModel>>()", new Object[0]);
        for (String clazz : this.qualifiedModelClasses) {
            writer.emitStatement("modelClasses.add(%s.class)", new Object[]{clazz});
        }
        writer.emitStatement("MODEL_CLASSES = Collections.unmodifiableSet(modelClasses)", new Object[0]);
        writer.endInitializer();
        writer.emitEmptyLine();
    }

    private void emitCreateRealmObjectSchema(JavaWriter writer) throws IOException {
        writer.emitAnnotation("Override");
        writer.beginMethod("RealmObjectSchema", "createRealmObjectSchema", EnumSet.of(Modifier.PUBLIC), new String[]{"Class<? extends RealmModel>", "clazz", "RealmSchema", "realmSchema"});
        this.emitMediatorSwitch(new ProxySwitchStatement(){

            @Override
            public void emitStatement(int i, JavaWriter writer) throws IOException {
                writer.emitStatement("return %s.createRealmObjectSchema(realmSchema)", new Object[]{RealmProxyMediatorGenerator.this.qualifiedProxyClasses.get(i)});
            }
        }, writer);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitCreateTableMethod(JavaWriter writer) throws IOException {
        writer.emitAnnotation("Override");
        writer.beginMethod("Table", "createTable", EnumSet.of(Modifier.PUBLIC), new String[]{"Class<? extends RealmModel>", "clazz", "SharedRealm", "sharedRealm"});
        this.emitMediatorSwitch(new ProxySwitchStatement(){

            @Override
            public void emitStatement(int i, JavaWriter writer) throws IOException {
                writer.emitStatement("return %s.initTable(sharedRealm)", new Object[]{RealmProxyMediatorGenerator.this.qualifiedProxyClasses.get(i)});
            }
        }, writer);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitValidateTableMethod(JavaWriter writer) throws IOException {
        writer.emitAnnotation("Override");
        writer.beginMethod("ColumnInfo", "validateTable", EnumSet.of(Modifier.PUBLIC), new String[]{"Class<? extends RealmModel>", "clazz", "SharedRealm", "sharedRealm", "boolean", "allowExtraColumns"});
        this.emitMediatorSwitch(new ProxySwitchStatement(){

            @Override
            public void emitStatement(int i, JavaWriter writer) throws IOException {
                writer.emitStatement("return %s.validateTable(sharedRealm, allowExtraColumns)", new Object[]{RealmProxyMediatorGenerator.this.qualifiedProxyClasses.get(i)});
            }
        }, writer);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitGetFieldNamesMethod(JavaWriter writer) throws IOException {
        writer.emitAnnotation("Override");
        writer.beginMethod("List<String>", "getFieldNames", EnumSet.of(Modifier.PUBLIC), new String[]{"Class<? extends RealmModel>", "clazz"});
        this.emitMediatorSwitch(new ProxySwitchStatement(){

            @Override
            public void emitStatement(int i, JavaWriter writer) throws IOException {
                writer.emitStatement("return %s.getFieldNames()", new Object[]{RealmProxyMediatorGenerator.this.qualifiedProxyClasses.get(i)});
            }
        }, writer);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitGetTableNameMethod(JavaWriter writer) throws IOException {
        writer.emitAnnotation("Override");
        writer.beginMethod("String", "getTableName", EnumSet.of(Modifier.PUBLIC), new String[]{"Class<? extends RealmModel>", "clazz"});
        this.emitMediatorSwitch(new ProxySwitchStatement(){

            @Override
            public void emitStatement(int i, JavaWriter writer) throws IOException {
                writer.emitStatement("return %s.getTableName()", new Object[]{RealmProxyMediatorGenerator.this.qualifiedProxyClasses.get(i)});
            }
        }, writer);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitNewInstanceMethod(JavaWriter writer) throws IOException {
        writer.emitAnnotation("Override");
        writer.beginMethod("<E extends RealmModel> E", "newInstance", EnumSet.of(Modifier.PUBLIC), new String[]{"Class<E>", "clazz", "Object", "baseRealm", "Row", "row", "ColumnInfo", "columnInfo", "boolean", "acceptDefaultValue", "List<String>", "excludeFields"});
        writer.emitStatement("final BaseRealm.RealmObjectContext objectContext = BaseRealm.objectContext.get()", new Object[0]);
        writer.beginControlFlow("try", new Object[0]).emitStatement("objectContext.set((BaseRealm) baseRealm, row, columnInfo, acceptDefaultValue, excludeFields)", new Object[0]);
        this.emitMediatorSwitch(new ProxySwitchStatement(){

            @Override
            public void emitStatement(int i, JavaWriter writer) throws IOException {
                writer.emitStatement("return clazz.cast(new %s())", new Object[]{RealmProxyMediatorGenerator.this.qualifiedProxyClasses.get(i)});
            }
        }, writer);
        writer.nextControlFlow("finally", new Object[0]).emitStatement("objectContext.clear()", new Object[0]).endControlFlow();
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitGetClassModelList(JavaWriter writer) throws IOException {
        writer.emitAnnotation("Override");
        writer.beginMethod("Set<Class<? extends RealmModel>>", "getModelClasses", EnumSet.of(Modifier.PUBLIC), new String[0]);
        writer.emitStatement("return MODEL_CLASSES", new Object[0]);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitCopyToRealmMethod(JavaWriter writer) throws IOException {
        writer.emitAnnotation("Override");
        writer.beginMethod("<E extends RealmModel> E", "copyOrUpdate", EnumSet.of(Modifier.PUBLIC), new String[]{"Realm", "realm", "E", "obj", "boolean", "update", "Map<RealmModel, RealmObjectProxy>", "cache"});
        writer.emitSingleLineComment("This cast is correct because obj is either", new Object[0]);
        writer.emitSingleLineComment("generated by RealmProxy or the original type extending directly from RealmObject", new Object[0]);
        writer.emitStatement("@SuppressWarnings(\"unchecked\") Class<E> clazz = (Class<E>) ((obj instanceof RealmObjectProxy) ? obj.getClass().getSuperclass() : obj.getClass())", new Object[0]);
        writer.emitEmptyLine();
        this.emitMediatorSwitch(new ProxySwitchStatement(){

            @Override
            public void emitStatement(int i, JavaWriter writer) throws IOException {
                writer.emitStatement("return clazz.cast(%s.copyOrUpdate(realm, (%s) obj, update, cache))", new Object[]{RealmProxyMediatorGenerator.this.qualifiedProxyClasses.get(i), RealmProxyMediatorGenerator.this.qualifiedModelClasses.get(i)});
            }
        }, writer, false);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitInsertObjectToRealmMethod(JavaWriter writer) throws IOException {
        writer.emitAnnotation("Override");
        writer.beginMethod("void", "insert", EnumSet.of(Modifier.PUBLIC), new String[]{"Realm", "realm", "RealmModel", "object", "Map<RealmModel, Long>", "cache"});
        writer.emitSingleLineComment("This cast is correct because obj is either", new Object[0]);
        writer.emitSingleLineComment("generated by RealmProxy or the original type extending directly from RealmObject", new Object[0]);
        writer.emitStatement("@SuppressWarnings(\"unchecked\") Class<RealmModel> clazz = (Class<RealmModel>) ((object instanceof RealmObjectProxy) ? object.getClass().getSuperclass() : object.getClass())", new Object[0]);
        writer.emitEmptyLine();
        this.emitMediatorSwitch(new ProxySwitchStatement(){

            @Override
            public void emitStatement(int i, JavaWriter writer) throws IOException {
                writer.emitStatement("%s.insert(realm, (%s) object, cache)", new Object[]{RealmProxyMediatorGenerator.this.qualifiedProxyClasses.get(i), RealmProxyMediatorGenerator.this.qualifiedModelClasses.get(i)});
            }
        }, writer, false);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitInsertOrUpdateObjectToRealmMethod(JavaWriter writer) throws IOException {
        writer.emitAnnotation("Override");
        writer.beginMethod("void", "insertOrUpdate", EnumSet.of(Modifier.PUBLIC), new String[]{"Realm", "realm", "RealmModel", "obj", "Map<RealmModel, Long>", "cache"});
        writer.emitSingleLineComment("This cast is correct because obj is either", new Object[0]);
        writer.emitSingleLineComment("generated by RealmProxy or the original type extending directly from RealmObject", new Object[0]);
        writer.emitStatement("@SuppressWarnings(\"unchecked\") Class<RealmModel> clazz = (Class<RealmModel>) ((obj instanceof RealmObjectProxy) ? obj.getClass().getSuperclass() : obj.getClass())", new Object[0]);
        writer.emitEmptyLine();
        this.emitMediatorSwitch(new ProxySwitchStatement(){

            @Override
            public void emitStatement(int i, JavaWriter writer) throws IOException {
                writer.emitStatement("%s.insertOrUpdate(realm, (%s) obj, cache)", new Object[]{RealmProxyMediatorGenerator.this.qualifiedProxyClasses.get(i), RealmProxyMediatorGenerator.this.qualifiedModelClasses.get(i)});
            }
        }, writer, false);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitInsertOrUpdateListToRealmMethod(JavaWriter writer) throws IOException {
        writer.emitAnnotation("Override");
        writer.beginMethod("void", "insertOrUpdate", EnumSet.of(Modifier.PUBLIC), new String[]{"Realm", "realm", "Collection<? extends RealmModel>", "objects"});
        writer.emitStatement("Iterator<? extends RealmModel> iterator = objects.iterator()", new Object[0]);
        writer.emitStatement("RealmModel object = null", new Object[0]);
        writer.emitStatement("Map<RealmModel, Long> cache = new IdentityHashMap<RealmModel, Long>(objects.size())", new Object[0]);
        writer.beginControlFlow("if (iterator.hasNext())", new Object[0]).emitSingleLineComment(" access the first element to figure out the clazz for the routing below", new Object[0]).emitStatement("object = iterator.next()", new Object[0]).emitSingleLineComment("This cast is correct because obj is either", new Object[0]).emitSingleLineComment("generated by RealmProxy or the original type extending directly from RealmObject", new Object[0]).emitStatement("@SuppressWarnings(\"unchecked\") Class<RealmModel> clazz = (Class<RealmModel>) ((object instanceof RealmObjectProxy) ? object.getClass().getSuperclass() : object.getClass())", new Object[0]).emitEmptyLine();
        this.emitMediatorSwitch(new ProxySwitchStatement(){

            @Override
            public void emitStatement(int i, JavaWriter writer) throws IOException {
                writer.emitStatement("%s.insertOrUpdate(realm, (%s) object, cache)", new Object[]{RealmProxyMediatorGenerator.this.qualifiedProxyClasses.get(i), RealmProxyMediatorGenerator.this.qualifiedModelClasses.get(i)});
            }
        }, writer, false);
        writer.beginControlFlow("if (iterator.hasNext())", new Object[0]);
        this.emitMediatorSwitch(new ProxySwitchStatement(){

            @Override
            public void emitStatement(int i, JavaWriter writer) throws IOException {
                writer.emitStatement("%s.insertOrUpdate(realm, iterator, cache)", new Object[]{RealmProxyMediatorGenerator.this.qualifiedProxyClasses.get(i)});
            }
        }, writer, false);
        writer.endControlFlow();
        writer.endControlFlow();
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitInsertListToRealmMethod(JavaWriter writer) throws IOException {
        writer.emitAnnotation("Override");
        writer.beginMethod("void", "insert", EnumSet.of(Modifier.PUBLIC), new String[]{"Realm", "realm", "Collection<? extends RealmModel>", "objects"});
        writer.emitStatement("Iterator<? extends RealmModel> iterator = objects.iterator()", new Object[0]);
        writer.emitStatement("RealmModel object = null", new Object[0]);
        writer.emitStatement("Map<RealmModel, Long> cache = new IdentityHashMap<RealmModel, Long>(objects.size())", new Object[0]);
        writer.beginControlFlow("if (iterator.hasNext())", new Object[0]).emitSingleLineComment(" access the first element to figure out the clazz for the routing below", new Object[0]).emitStatement("object = iterator.next()", new Object[0]).emitSingleLineComment("This cast is correct because obj is either", new Object[0]).emitSingleLineComment("generated by RealmProxy or the original type extending directly from RealmObject", new Object[0]).emitStatement("@SuppressWarnings(\"unchecked\") Class<RealmModel> clazz = (Class<RealmModel>) ((object instanceof RealmObjectProxy) ? object.getClass().getSuperclass() : object.getClass())", new Object[0]).emitEmptyLine();
        this.emitMediatorSwitch(new ProxySwitchStatement(){

            @Override
            public void emitStatement(int i, JavaWriter writer) throws IOException {
                writer.emitStatement("%s.insert(realm, (%s) object, cache)", new Object[]{RealmProxyMediatorGenerator.this.qualifiedProxyClasses.get(i), RealmProxyMediatorGenerator.this.qualifiedModelClasses.get(i)});
            }
        }, writer, false);
        writer.beginControlFlow("if (iterator.hasNext())", new Object[0]);
        this.emitMediatorSwitch(new ProxySwitchStatement(){

            @Override
            public void emitStatement(int i, JavaWriter writer) throws IOException {
                writer.emitStatement("%s.insert(realm, iterator, cache)", new Object[]{RealmProxyMediatorGenerator.this.qualifiedProxyClasses.get(i)});
            }
        }, writer, false);
        writer.endControlFlow();
        writer.endControlFlow();
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitCreteOrUpdateUsingJsonObject(JavaWriter writer) throws IOException {
        writer.emitAnnotation("Override");
        writer.beginMethod("<E extends RealmModel> E", "createOrUpdateUsingJsonObject", EnumSet.of(Modifier.PUBLIC), Arrays.asList("Class<E>", "clazz", "Realm", "realm", "JSONObject", "json", "boolean", "update"), Arrays.asList("JSONException"));
        this.emitMediatorSwitch(new ProxySwitchStatement(){

            @Override
            public void emitStatement(int i, JavaWriter writer) throws IOException {
                writer.emitStatement("return clazz.cast(%s.createOrUpdateUsingJsonObject(realm, json, update))", new Object[]{RealmProxyMediatorGenerator.this.qualifiedProxyClasses.get(i)});
            }
        }, writer);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitCreateUsingJsonStream(JavaWriter writer) throws IOException {
        writer.emitAnnotation("Override");
        writer.beginMethod("<E extends RealmModel> E", "createUsingJsonStream", EnumSet.of(Modifier.PUBLIC), Arrays.asList("Class<E>", "clazz", "Realm", "realm", "JsonReader", "reader"), Arrays.asList("java.io.IOException"));
        this.emitMediatorSwitch(new ProxySwitchStatement(){

            @Override
            public void emitStatement(int i, JavaWriter writer) throws IOException {
                writer.emitStatement("return clazz.cast(%s.createUsingJsonStream(realm, reader))", new Object[]{RealmProxyMediatorGenerator.this.qualifiedProxyClasses.get(i)});
            }
        }, writer);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitCreateDetachedCopyMethod(JavaWriter writer) throws IOException {
        writer.emitAnnotation("Override");
        writer.beginMethod("<E extends RealmModel> E", "createDetachedCopy", EnumSet.of(Modifier.PUBLIC), new String[]{"E", "realmObject", "int", "maxDepth", "Map<RealmModel, RealmObjectProxy.CacheData<RealmModel>>", "cache"});
        writer.emitSingleLineComment("This cast is correct because obj is either", new Object[0]);
        writer.emitSingleLineComment("generated by RealmProxy or the original type extending directly from RealmObject", new Object[0]);
        writer.emitStatement("@SuppressWarnings(\"unchecked\") Class<E> clazz = (Class<E>) realmObject.getClass().getSuperclass()", new Object[0]);
        writer.emitEmptyLine();
        this.emitMediatorSwitch(new ProxySwitchStatement(){

            @Override
            public void emitStatement(int i, JavaWriter writer) throws IOException {
                writer.emitStatement("return clazz.cast(%s.createDetachedCopy((%s) realmObject, 0, maxDepth, cache))", new Object[]{RealmProxyMediatorGenerator.this.qualifiedProxyClasses.get(i), RealmProxyMediatorGenerator.this.qualifiedModelClasses.get(i)});
            }
        }, writer, false);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitMediatorSwitch(ProxySwitchStatement statement, JavaWriter writer) throws IOException {
        this.emitMediatorSwitch(statement, writer, true);
    }

    private void emitMediatorSwitch(ProxySwitchStatement statement, JavaWriter writer, boolean nullPointerCheck) throws IOException {
        if (nullPointerCheck) {
            writer.emitStatement("checkClass(clazz)", new Object[0]);
            writer.emitEmptyLine();
        }
        if (this.qualifiedModelClasses.size() == 0) {
            writer.emitStatement("throw getMissingProxyClassException(clazz)", new Object[0]);
        } else {
            writer.beginControlFlow("if (clazz.equals(%s.class))", new Object[]{this.qualifiedModelClasses.get(0)});
            statement.emitStatement(0, writer);
            for (int i = 1; i < this.qualifiedModelClasses.size(); ++i) {
                writer.nextControlFlow("else if (clazz.equals(%s.class))", new Object[]{this.qualifiedModelClasses.get(i)});
                statement.emitStatement(i, writer);
            }
            writer.nextControlFlow("else", new Object[0]);
            writer.emitStatement("throw getMissingProxyClassException(clazz)", new Object[0]);
            writer.endControlFlow();
        }
    }

    private String getProxyClassName(String clazz) {
        return clazz + "RealmProxy";
    }

    private static interface ProxySwitchStatement {
        public void emitStatement(int var1, JavaWriter var2) throws IOException;
    }
}

