/*
 * Decompiled with CFR 0.152.
 */
package io.realm.processor;

import com.squareup.javawriter.JavaWriter;
import io.realm.processor.ClassMetaData;
import io.realm.processor.Constants;
import io.realm.processor.RealmJsonTypeHelper;
import io.realm.processor.Utils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.Types;
import javax.tools.JavaFileObject;

public class RealmProxyClassGenerator {
    private ProcessingEnvironment processingEnvironment;
    private ClassMetaData metadata;
    private final String simpleClassName;
    private final String qualifiedClassName;
    private final String interfaceName;
    private final String qualifiedGeneratedClassName;

    public RealmProxyClassGenerator(ProcessingEnvironment processingEnvironment, ClassMetaData metadata) {
        this.processingEnvironment = processingEnvironment;
        this.metadata = metadata;
        this.simpleClassName = metadata.getSimpleClassName();
        this.qualifiedClassName = metadata.getFullyQualifiedClassName();
        this.interfaceName = Utils.getProxyInterfaceName(this.simpleClassName);
        this.qualifiedGeneratedClassName = String.format("%s.%s", "io.realm", Utils.getProxyClassName(this.simpleClassName));
    }

    public void generate() throws IOException, UnsupportedOperationException {
        JavaFileObject sourceFile = this.processingEnvironment.getFiler().createSourceFile(this.qualifiedGeneratedClassName, new Element[0]);
        JavaWriter writer = new JavaWriter((Writer)new BufferedWriter(sourceFile.openWriter()));
        writer.setIndent("    ");
        writer.emitPackage("io.realm").emitEmptyLine();
        ArrayList<String> imports = new ArrayList<String>();
        imports.add("android.annotation.TargetApi");
        imports.add("android.os.Build");
        imports.add("android.util.JsonReader");
        imports.add("android.util.JsonToken");
        imports.add("io.realm.RealmObjectSchema");
        imports.add("io.realm.RealmSchema");
        imports.add("io.realm.exceptions.RealmMigrationNeededException");
        imports.add("io.realm.internal.ColumnInfo");
        imports.add("io.realm.internal.RealmObjectProxy");
        imports.add("io.realm.internal.Row");
        imports.add("io.realm.internal.Table");
        imports.add("io.realm.internal.TableOrView");
        imports.add("io.realm.internal.SharedRealm");
        imports.add("io.realm.internal.LinkView");
        imports.add("io.realm.internal.android.JsonUtils");
        imports.add("io.realm.log.RealmLog");
        imports.add("java.io.IOException");
        imports.add("java.util.ArrayList");
        imports.add("java.util.Collections");
        imports.add("java.util.List");
        imports.add("java.util.Iterator");
        imports.add("java.util.Date");
        imports.add("java.util.Map");
        imports.add("java.util.HashMap");
        imports.add("org.json.JSONObject");
        imports.add("org.json.JSONException");
        imports.add("org.json.JSONArray");
        Collections.sort(imports);
        writer.emitImports(imports);
        writer.emitEmptyLine();
        writer.beginType(this.qualifiedGeneratedClassName, "class", EnumSet.of(Modifier.PUBLIC), this.qualifiedClassName, new String[]{"RealmObjectProxy", this.interfaceName}).emitEmptyLine();
        this.emitColumnIndicesClass(writer);
        this.emitClassFields(writer);
        this.emitConstructor(writer);
        this.emitInjectContextMethod(writer);
        this.emitAccessors(writer);
        this.emitCreateRealmObjectSchemaMethod(writer);
        this.emitInitTableMethod(writer);
        this.emitValidateTableMethod(writer);
        this.emitGetTableNameMethod(writer);
        this.emitGetFieldNamesMethod(writer);
        this.emitCreateOrUpdateUsingJsonObject(writer);
        this.emitCreateUsingJsonStream(writer);
        this.emitCopyOrUpdateMethod(writer);
        this.emitCopyMethod(writer);
        this.emitInsertMethod(writer);
        this.emitInsertListMethod(writer);
        this.emitInsertOrUpdateMethod(writer);
        this.emitInsertOrUpdateListMethod(writer);
        this.emitCreateDetachedCopyMethod(writer);
        this.emitUpdateMethod(writer);
        this.emitToStringMethod(writer);
        this.emitRealmObjectProxyImplementation(writer);
        this.emitHashcodeMethod(writer);
        this.emitEqualsMethod(writer);
        writer.endType();
        writer.close();
    }

    private void emitColumnIndicesClass(JavaWriter writer) throws IOException {
        writer.beginType(this.columnInfoClassName(), "class", EnumSet.of(Modifier.STATIC, Modifier.FINAL), "ColumnInfo", new String[]{"Cloneable"}).emitEmptyLine();
        for (VariableElement variableElement : this.metadata.getFields()) {
            writer.emitField("long", this.columnIndexVarName(variableElement), EnumSet.of(Modifier.PUBLIC));
        }
        writer.emitEmptyLine();
        writer.beginConstructor(EnumSet.noneOf(Modifier.class), new String[]{"String", "path", "Table", "table"});
        writer.emitStatement("final Map<String, Long> indicesMap = new HashMap<String, Long>(%s)", new Object[]{this.metadata.getFields().size()});
        for (VariableElement variableElement : this.metadata.getFields()) {
            String columnName = variableElement.getSimpleName().toString();
            String columnIndexVarName = this.columnIndexVarName(variableElement);
            writer.emitStatement("this.%s = getValidColumnIndex(path, table, \"%s\", \"%s\")", new Object[]{columnIndexVarName, this.simpleClassName, columnName});
            writer.emitStatement("indicesMap.put(\"%s\", this.%s)", new Object[]{columnName, columnIndexVarName});
        }
        writer.emitEmptyLine();
        writer.emitStatement("setIndicesMap(indicesMap)", new Object[0]);
        writer.endConstructor();
        writer.emitEmptyLine();
        writer.emitAnnotation("Override");
        writer.beginMethod("void", "copyColumnInfoFrom", EnumSet.of(Modifier.PUBLIC, Modifier.FINAL), new String[]{"ColumnInfo", "other"});
        writer.emitStatement("final %1$s otherInfo = (%1$s) other", new Object[]{this.columnInfoClassName()});
        for (VariableElement variableElement : this.metadata.getFields()) {
            writer.emitStatement("this.%1$s = otherInfo.%1$s", new Object[]{this.columnIndexVarName(variableElement)});
        }
        writer.emitEmptyLine();
        writer.emitStatement("setIndicesMap(otherInfo.getIndicesMap())", new Object[0]);
        writer.endMethod();
        writer.emitEmptyLine();
        writer.emitAnnotation("Override");
        writer.beginMethod(this.columnInfoClassName(), "clone", EnumSet.of(Modifier.PUBLIC, Modifier.FINAL), new String[0]).emitStatement("return (%1$s) super.clone()", new Object[]{this.columnInfoClassName()}).endMethod().emitEmptyLine();
        writer.endType();
    }

    private void emitClassFields(JavaWriter writer) throws IOException {
        writer.emitField(this.columnInfoClassName(), "columnInfo", EnumSet.of(Modifier.PRIVATE));
        writer.emitField("ProxyState", "proxyState", EnumSet.of(Modifier.PRIVATE));
        for (VariableElement variableElement : this.metadata.getFields()) {
            if (!Utils.isRealmList(variableElement)) continue;
            String genericType = Utils.getGenericTypeQualifiedName(variableElement);
            writer.emitField("RealmList<" + genericType + ">", variableElement.getSimpleName().toString() + "RealmList", EnumSet.of(Modifier.PRIVATE));
        }
        writer.emitField("List<String>", "FIELD_NAMES", EnumSet.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL));
        writer.beginInitializer(true);
        writer.emitStatement("List<String> fieldNames = new ArrayList<String>()", new Object[0]);
        for (VariableElement field : this.metadata.getFields()) {
            writer.emitStatement("fieldNames.add(\"%s\")", new Object[]{field.getSimpleName().toString()});
        }
        writer.emitStatement("FIELD_NAMES = Collections.unmodifiableList(fieldNames)", new Object[0]);
        writer.endInitializer();
        writer.emitEmptyLine();
    }

    private void emitConstructor(JavaWriter writer) throws IOException {
        writer.beginConstructor(EnumSet.noneOf(Modifier.class), new String[0]);
        writer.beginControlFlow("if (proxyState == null)", new Object[0]).emitStatement("injectObjectContext()", new Object[0]).endControlFlow();
        writer.emitStatement("proxyState.setConstructionFinished()", new Object[0]);
        writer.endConstructor();
        writer.emitEmptyLine();
    }

    private void emitAccessors(JavaWriter writer) throws IOException {
        for (final VariableElement field : this.metadata.getFields()) {
            final String fieldName = field.getSimpleName().toString();
            String fieldTypeCanonicalName = field.asType().toString();
            if (Constants.JAVA_TO_REALM_TYPES.containsKey(fieldTypeCanonicalName)) {
                String castingBackType;
                final String realmType = Constants.JAVA_TO_REALM_TYPES.get(fieldTypeCanonicalName);
                writer.emitAnnotation("SuppressWarnings", (Object)"\"cast\"");
                writer.beginMethod(fieldTypeCanonicalName, this.metadata.getGetter(fieldName), EnumSet.of(Modifier.PUBLIC), new String[0]);
                this.emitCodeForInjectingObjectContext(writer);
                writer.emitStatement("proxyState.getRealm$realm().checkIfValid()", new Object[0]);
                if (this.metadata.isNullable(field) && !Utils.isString(field) && !Utils.isByteArray(field)) {
                    writer.beginControlFlow("if (proxyState.getRow$realm().isNull(%s))", new Object[]{this.fieldIndexVariableReference(field)});
                    writer.emitStatement("return null", new Object[0]);
                    writer.endControlFlow();
                }
                if (Utils.isBoxedType(fieldTypeCanonicalName)) {
                    Types typeUtils = this.processingEnvironment.getTypeUtils();
                    castingBackType = typeUtils.unboxedType(field.asType()).toString();
                } else {
                    castingBackType = fieldTypeCanonicalName;
                }
                writer.emitStatement("return (%s) proxyState.getRow$realm().get%s(%s)", new Object[]{castingBackType, realmType, this.fieldIndexVariableReference(field)});
                writer.endMethod();
                writer.emitEmptyLine();
                writer.beginMethod("void", this.metadata.getSetter(fieldName), EnumSet.of(Modifier.PUBLIC), new String[]{fieldTypeCanonicalName, "value"});
                this.emitCodeForInjectingObjectContext(writer);
                this.emitCodeForUnderConstruction(writer, this.metadata.isPrimaryKey(field), new CodeEmitter(){

                    @Override
                    public void emit(JavaWriter writer) throws IOException {
                        writer.emitStatement("final Row row = proxyState.getRow$realm()", new Object[0]);
                        if (RealmProxyClassGenerator.this.metadata.isNullable(field)) {
                            writer.beginControlFlow("if (value == null)", new Object[0]).emitStatement("row.getTable().setNull(%s, row.getIndex(), true)", new Object[]{RealmProxyClassGenerator.this.fieldIndexVariableReference(field)}).emitStatement("return", new Object[0]).endControlFlow();
                        } else if (!RealmProxyClassGenerator.this.metadata.isNullable(field) && !Utils.isPrimitiveType(field)) {
                            writer.beginControlFlow("if (value == null)", new Object[0]).emitStatement("throw new IllegalArgumentException(\"Trying to set non-nullable field '%s' to null.\")", new Object[]{fieldName}).endControlFlow();
                        }
                        writer.emitStatement("row.getTable().set%s(%s, row.getIndex(), value, true)", new Object[]{realmType, RealmProxyClassGenerator.this.fieldIndexVariableReference(field)});
                        writer.emitStatement("return", new Object[0]);
                    }
                });
                writer.emitStatement("proxyState.getRealm$realm().checkIfValid()", new Object[0]);
                if (this.metadata.isPrimaryKey(field)) {
                    writer.emitStatement("throw new io.realm.exceptions.RealmException(\"Primary key field '%s' cannot be changed after object was created.\")", new Object[]{fieldName});
                } else {
                    if (this.metadata.isNullable(field)) {
                        writer.beginControlFlow("if (value == null)", new Object[0]).emitStatement("proxyState.getRow$realm().setNull(%s)", new Object[]{this.fieldIndexVariableReference(field)}).emitStatement("return", new Object[0]).endControlFlow();
                    } else if (!this.metadata.isNullable(field) && !Utils.isPrimitiveType(field)) {
                        writer.beginControlFlow("if (value == null)", new Object[0]).emitStatement("throw new IllegalArgumentException(\"Trying to set non-nullable field '%s' to null.\")", new Object[]{fieldName}).endControlFlow();
                    }
                    writer.emitStatement("proxyState.getRow$realm().set%s(%s, value)", new Object[]{realmType, this.fieldIndexVariableReference(field)});
                }
                writer.endMethod();
            } else if (Utils.isRealmModel(field)) {
                writer.beginMethod(fieldTypeCanonicalName, this.metadata.getGetter(fieldName), EnumSet.of(Modifier.PUBLIC), new String[0]);
                this.emitCodeForInjectingObjectContext(writer);
                writer.emitStatement("proxyState.getRealm$realm().checkIfValid()", new Object[0]);
                writer.beginControlFlow("if (proxyState.getRow$realm().isNullLink(%s))", new Object[]{this.fieldIndexVariableReference(field)});
                writer.emitStatement("return null", new Object[0]);
                writer.endControlFlow();
                writer.emitStatement("return proxyState.getRealm$realm().get(%s.class, proxyState.getRow$realm().getLink(%s), false, Collections.<String>emptyList())", new Object[]{fieldTypeCanonicalName, this.fieldIndexVariableReference(field)});
                writer.endMethod();
                writer.emitEmptyLine();
                writer.beginMethod("void", this.metadata.getSetter(fieldName), EnumSet.of(Modifier.PUBLIC), new String[]{fieldTypeCanonicalName, "value"});
                this.emitCodeForInjectingObjectContext(writer);
                this.emitCodeForUnderConstruction(writer, this.metadata.isPrimaryKey(field), new CodeEmitter(){

                    @Override
                    public void emit(JavaWriter writer) throws IOException {
                        writer.beginControlFlow("if (proxyState.getExcludeFields$realm().contains(\"%1$s\"))", new Object[]{field.getSimpleName().toString()}).emitStatement("return", new Object[0]).endControlFlow();
                        writer.beginControlFlow("if (value != null && !RealmObject.isManaged(value))", new Object[0]).emitStatement("value = ((Realm) proxyState.getRealm$realm()).copyToRealm(value)", new Object[0]).endControlFlow();
                        writer.emitStatement("final Row row = proxyState.getRow$realm()", new Object[0]);
                        writer.beginControlFlow("if (value == null)", new Object[0]).emitSingleLineComment("Table#nullifyLink() does not support default value. Just using Row.", new Object[0]).emitStatement("row.nullifyLink(%s)", new Object[]{RealmProxyClassGenerator.this.fieldIndexVariableReference(field)}).emitStatement("return", new Object[0]).endControlFlow();
                        writer.beginControlFlow("if (!RealmObject.isValid(value))", new Object[0]).emitStatement("throw new IllegalArgumentException(\"'value' is not a valid managed object.\")", new Object[0]).endControlFlow();
                        writer.beginControlFlow("if (((RealmObjectProxy) value).realmGet$proxyState().getRealm$realm() != proxyState.getRealm$realm())", new Object[0]).emitStatement("throw new IllegalArgumentException(\"'value' belongs to a different Realm.\")", new Object[0]).endControlFlow();
                        writer.emitStatement("row.getTable().setLink(%s, row.getIndex(), ((RealmObjectProxy) value).realmGet$proxyState().getRow$realm().getIndex(), true)", new Object[]{RealmProxyClassGenerator.this.fieldIndexVariableReference(field)});
                        writer.emitStatement("return", new Object[0]);
                    }
                });
                writer.emitStatement("proxyState.getRealm$realm().checkIfValid()", new Object[0]);
                writer.beginControlFlow("if (value == null)", new Object[0]);
                writer.emitStatement("proxyState.getRow$realm().nullifyLink(%s)", new Object[]{this.fieldIndexVariableReference(field)});
                writer.emitStatement("return", new Object[0]);
                writer.endControlFlow();
                writer.beginControlFlow("if (!(RealmObject.isManaged(value) && RealmObject.isValid(value)))", new Object[0]);
                writer.emitStatement("throw new IllegalArgumentException(\"'value' is not a valid managed object.\")", new Object[0]);
                writer.endControlFlow();
                writer.beginControlFlow("if (((RealmObjectProxy)value).realmGet$proxyState().getRealm$realm() != proxyState.getRealm$realm())", new Object[0]);
                writer.emitStatement("throw new IllegalArgumentException(\"'value' belongs to a different Realm.\")", new Object[0]);
                writer.endControlFlow();
                writer.emitStatement("proxyState.getRow$realm().setLink(%s, ((RealmObjectProxy)value).realmGet$proxyState().getRow$realm().getIndex())", new Object[]{this.fieldIndexVariableReference(field)});
                writer.endMethod();
            } else if (Utils.isRealmList(field)) {
                String genericType = Utils.getGenericTypeQualifiedName(field);
                writer.beginMethod(fieldTypeCanonicalName, this.metadata.getGetter(fieldName), EnumSet.of(Modifier.PUBLIC), new String[0]);
                this.emitCodeForInjectingObjectContext(writer);
                writer.emitStatement("proxyState.getRealm$realm().checkIfValid()", new Object[0]);
                writer.emitSingleLineComment("use the cached value if available", new Object[0]);
                writer.beginControlFlow("if (" + fieldName + "RealmList != null)", new Object[0]);
                writer.emitStatement("return " + fieldName + "RealmList", new Object[0]);
                writer.nextControlFlow("else", new Object[0]);
                writer.emitStatement("LinkView linkView = proxyState.getRow$realm().getLinkList(%s)", new Object[]{this.fieldIndexVariableReference(field)});
                writer.emitStatement(fieldName + "RealmList = new RealmList<%s>(%s.class, linkView, proxyState.getRealm$realm())", new Object[]{genericType, genericType});
                writer.emitStatement("return " + fieldName + "RealmList", new Object[0]);
                writer.endControlFlow();
                writer.endMethod();
                writer.emitEmptyLine();
                writer.beginMethod("void", this.metadata.getSetter(fieldName), EnumSet.of(Modifier.PUBLIC), new String[]{fieldTypeCanonicalName, "value"});
                this.emitCodeForInjectingObjectContext(writer);
                this.emitCodeForUnderConstruction(writer, this.metadata.isPrimaryKey(field), new CodeEmitter(){

                    @Override
                    public void emit(JavaWriter writer) throws IOException {
                        writer.beginControlFlow("if (proxyState.getExcludeFields$realm().contains(\"%1$s\"))", new Object[]{field.getSimpleName().toString()}).emitStatement("return", new Object[0]).endControlFlow();
                        String modelFqcn = Utils.getGenericTypeQualifiedName(field);
                        writer.beginControlFlow("if (value != null && !value.isManaged())", new Object[0]).emitStatement("final Realm realm = (Realm) proxyState.getRealm$realm()", new Object[0]).emitStatement("final RealmList<%1$s> original = value", new Object[]{modelFqcn}).emitStatement("value = new RealmList<%1$s>()", new Object[]{modelFqcn}).beginControlFlow("for (%1$s item : original)", new Object[]{modelFqcn}).beginControlFlow("if (item == null || RealmObject.isManaged(item))", new Object[0]).emitStatement("value.add(item)", new Object[0]).nextControlFlow("else", new Object[0]).emitStatement("value.add(realm.copyToRealm(item))", new Object[0]).endControlFlow().endControlFlow().endControlFlow();
                    }
                });
                writer.emitStatement("proxyState.getRealm$realm().checkIfValid()", new Object[0]);
                writer.emitStatement("LinkView links = proxyState.getRow$realm().getLinkList(%s)", new Object[]{this.fieldIndexVariableReference(field)});
                writer.emitStatement("links.clear()", new Object[0]);
                writer.beginControlFlow("if (value == null)", new Object[0]);
                writer.emitStatement("return", new Object[0]);
                writer.endControlFlow();
                writer.beginControlFlow("for (RealmModel linkedObject : (RealmList<? extends RealmModel>) value)", new Object[0]);
                writer.beginControlFlow("if (!(RealmObject.isManaged(linkedObject) && RealmObject.isValid(linkedObject)))", new Object[0]);
                writer.emitStatement("throw new IllegalArgumentException(\"Each element of 'value' must be a valid managed object.\")", new Object[0]);
                writer.endControlFlow();
                writer.beginControlFlow("if (((RealmObjectProxy)linkedObject).realmGet$proxyState().getRealm$realm() != proxyState.getRealm$realm())", new Object[0]);
                writer.emitStatement("throw new IllegalArgumentException(\"Each element of 'value' must belong to the same Realm.\")", new Object[0]);
                writer.endControlFlow();
                writer.emitStatement("links.add(((RealmObjectProxy)linkedObject).realmGet$proxyState().getRow$realm().getIndex())", new Object[0]);
                writer.endControlFlow();
                writer.endMethod();
            } else {
                throw new UnsupportedOperationException(String.format("Type '%s' of field '%s' is not supported", fieldTypeCanonicalName, fieldName));
            }
            writer.emitEmptyLine();
        }
    }

    private void emitCodeForInjectingObjectContext(JavaWriter writer) throws IOException {
        writer.beginControlFlow("if (proxyState == null)", new Object[0]);
        writer.emitSingleLineComment("Called from model's constructor. Inject context.", new Object[0]);
        writer.emitStatement("injectObjectContext()", new Object[0]);
        writer.endControlFlow();
        writer.emitEmptyLine();
    }

    private void emitCodeForUnderConstruction(JavaWriter writer, boolean isPrimaryKey, CodeEmitter defaultValueCodeEmitter) throws IOException {
        writer.beginControlFlow("if (proxyState.isUnderConstruction())", new Object[0]);
        if (isPrimaryKey) {
            writer.emitSingleLineComment("default value of the primary key is always ignored.", new Object[0]);
            writer.emitStatement("return", new Object[0]);
        } else {
            writer.beginControlFlow("if (!proxyState.getAcceptDefaultValue$realm())", new Object[0]).emitStatement("return", new Object[0]).endControlFlow();
            defaultValueCodeEmitter.emit(writer);
        }
        writer.endControlFlow();
        writer.emitEmptyLine();
    }

    private void emitInjectContextMethod(JavaWriter writer) throws IOException {
        writer.beginMethod("void", "injectObjectContext", EnumSet.of(Modifier.PRIVATE), new String[0]);
        writer.emitStatement("final BaseRealm.RealmObjectContext context = BaseRealm.objectContext.get()", new Object[0]);
        writer.emitStatement("this.columnInfo = (%1$s) context.getColumnInfo()", new Object[]{this.columnInfoClassName()});
        writer.emitStatement("this.proxyState = new ProxyState(%1$s.class, this)", new Object[]{this.qualifiedClassName});
        writer.emitStatement("proxyState.setRealm$realm(context.getRealm())", new Object[0]);
        writer.emitStatement("proxyState.setRow$realm(context.getRow())", new Object[0]);
        writer.emitStatement("proxyState.setAcceptDefaultValue$realm(context.getAcceptDefaultValue())", new Object[0]);
        writer.emitStatement("proxyState.setExcludeFields$realm(context.getExcludeFields())", new Object[0]);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitRealmObjectProxyImplementation(JavaWriter writer) throws IOException {
        writer.emitAnnotation("Override");
        writer.beginMethod("ProxyState", "realmGet$proxyState", EnumSet.of(Modifier.PUBLIC), new String[0]);
        writer.emitStatement("return proxyState", new Object[0]);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitCreateRealmObjectSchemaMethod(JavaWriter writer) throws IOException {
        writer.beginMethod("RealmObjectSchema", "createRealmObjectSchema", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC), new String[]{"RealmSchema", "realmSchema"});
        writer.beginControlFlow("if (!realmSchema.contains(\"" + this.simpleClassName + "\"))", new Object[0]);
        writer.emitStatement("RealmObjectSchema realmObjectSchema = realmSchema.create(\"%s\")", new Object[]{this.simpleClassName});
        for (VariableElement field : this.metadata.getFields()) {
            String fieldName = field.getSimpleName().toString();
            String fieldTypeCanonicalName = field.asType().toString();
            String fieldTypeSimpleName = Utils.getFieldTypeSimpleName(field);
            if (Constants.JAVA_TO_REALM_TYPES.containsKey(fieldTypeCanonicalName)) {
                String nullableFlag = (this.metadata.isNullable(field) ? "!" : "") + "Property.REQUIRED";
                String indexedFlag = (this.metadata.isIndexed(field) ? "" : "!") + "Property.INDEXED";
                String primaryKeyFlag = (this.metadata.isPrimaryKey(field) ? "" : "!") + "Property.PRIMARY_KEY";
                writer.emitStatement("realmObjectSchema.add(new Property(\"%s\", %s, %s, %s, %s))", new Object[]{fieldName, Constants.JAVA_TO_COLUMN_TYPES.get(fieldTypeCanonicalName), primaryKeyFlag, indexedFlag, nullableFlag});
                continue;
            }
            if (Utils.isRealmModel(field)) {
                writer.beginControlFlow("if (!realmSchema.contains(\"" + fieldTypeSimpleName + "\"))", new Object[0]);
                writer.emitStatement("%s%s.createRealmObjectSchema(realmSchema)", new Object[]{fieldTypeSimpleName, "RealmProxy"});
                writer.endControlFlow();
                writer.emitStatement("realmObjectSchema.add(new Property(\"%s\", RealmFieldType.OBJECT, realmSchema.get(\"%s\")))", new Object[]{fieldName, fieldTypeSimpleName});
                continue;
            }
            if (!Utils.isRealmList(field)) continue;
            String genericTypeSimpleName = Utils.getGenericTypeSimpleName(field);
            writer.beginControlFlow("if (!realmSchema.contains(\"" + genericTypeSimpleName + "\"))", new Object[0]);
            writer.emitStatement("%s%s.createRealmObjectSchema(realmSchema)", new Object[]{genericTypeSimpleName, "RealmProxy"});
            writer.endControlFlow();
            writer.emitStatement("realmObjectSchema.add(new Property(\"%s\", RealmFieldType.LIST, realmSchema.get(\"%s\")))", new Object[]{fieldName, genericTypeSimpleName});
        }
        writer.emitStatement("return realmObjectSchema", new Object[0]);
        writer.endControlFlow();
        writer.emitStatement("return realmSchema.get(\"" + this.simpleClassName + "\")", new Object[0]);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitInitTableMethod(JavaWriter writer) throws IOException {
        String fieldName;
        writer.beginMethod("Table", "initTable", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC), new String[]{"SharedRealm", "sharedRealm"});
        writer.beginControlFlow("if (!sharedRealm.hasTable(\"class_" + this.simpleClassName + "\"))", new Object[0]);
        writer.emitStatement("Table table = sharedRealm.getTable(\"%s%s\")", new Object[]{"class_", this.simpleClassName});
        for (VariableElement field : this.metadata.getFields()) {
            fieldName = field.getSimpleName().toString();
            String fieldTypeCanonicalName = field.asType().toString();
            String fieldTypeSimpleName = Utils.getFieldTypeSimpleName(field);
            if (Constants.JAVA_TO_REALM_TYPES.containsKey(fieldTypeCanonicalName)) {
                String nullableFlag = this.metadata.isNullable(field) ? "Table.NULLABLE" : "Table.NOT_NULLABLE";
                writer.emitStatement("table.addColumn(%s, \"%s\", %s)", new Object[]{Constants.JAVA_TO_COLUMN_TYPES.get(fieldTypeCanonicalName), fieldName, nullableFlag});
                continue;
            }
            if (Utils.isRealmModel(field)) {
                writer.beginControlFlow("if (!sharedRealm.hasTable(\"%s%s\"))", new Object[]{"class_", fieldTypeSimpleName});
                writer.emitStatement("%s%s.initTable(sharedRealm)", new Object[]{fieldTypeSimpleName, "RealmProxy"});
                writer.endControlFlow();
                writer.emitStatement("table.addColumnLink(RealmFieldType.OBJECT, \"%s\", sharedRealm.getTable(\"%s%s\"))", new Object[]{fieldName, "class_", fieldTypeSimpleName});
                continue;
            }
            if (!Utils.isRealmList(field)) continue;
            String genericTypeSimpleName = Utils.getGenericTypeSimpleName(field);
            writer.beginControlFlow("if (!sharedRealm.hasTable(\"%s%s\"))", new Object[]{"class_", genericTypeSimpleName});
            writer.emitStatement("%s.initTable(sharedRealm)", new Object[]{Utils.getProxyClassName(genericTypeSimpleName)});
            writer.endControlFlow();
            writer.emitStatement("table.addColumnLink(RealmFieldType.LIST, \"%s\", sharedRealm.getTable(\"%s%s\"))", new Object[]{fieldName, "class_", genericTypeSimpleName});
        }
        for (VariableElement field : this.metadata.getIndexedFields()) {
            fieldName = field.getSimpleName().toString();
            writer.emitStatement("table.addSearchIndex(table.getColumnIndex(\"%s\"))", new Object[]{fieldName});
        }
        if (this.metadata.hasPrimaryKey()) {
            String fieldName2 = this.metadata.getPrimaryKey().getSimpleName().toString();
            writer.emitStatement("table.setPrimaryKey(\"%s\")", new Object[]{fieldName2});
        } else {
            writer.emitStatement("table.setPrimaryKey(\"\")", new Object[0]);
        }
        writer.emitStatement("return table", new Object[0]);
        writer.endControlFlow();
        writer.emitStatement("return sharedRealm.getTable(\"%s%s\")", new Object[]{"class_", this.simpleClassName});
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitValidateTableMethod(JavaWriter writer) throws IOException {
        writer.beginMethod(this.columnInfoClassName(), "validateTable", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC), new String[]{"SharedRealm", "sharedRealm", "boolean", "allowExtraColumns"});
        writer.beginControlFlow("if (sharedRealm.hasTable(\"class_" + this.simpleClassName + "\"))", new Object[0]);
        writer.emitStatement("Table table = sharedRealm.getTable(\"%s%s\")", new Object[]{"class_", this.simpleClassName});
        writer.emitStatement("final long columnCount = table.getColumnCount()", new Object[0]);
        writer.beginControlFlow("if (columnCount != %d)", new Object[]{this.metadata.getFields().size()});
        writer.beginControlFlow("if (columnCount < %d)", new Object[]{this.metadata.getFields().size()});
        writer.emitStatement("throw new RealmMigrationNeededException(sharedRealm.getPath(), \"Field count is less than expected - expected %d but was \" + columnCount)", new Object[]{this.metadata.getFields().size()});
        writer.endControlFlow();
        writer.beginControlFlow("if (allowExtraColumns)", new Object[0]);
        writer.emitStatement("RealmLog.debug(\"Field count is more than expected - expected %d but was %%1$d\", columnCount)", new Object[]{this.metadata.getFields().size()});
        writer.nextControlFlow("else", new Object[0]);
        writer.emitStatement("throw new RealmMigrationNeededException(sharedRealm.getPath(), \"Field count is more than expected - expected %d but was \" + columnCount)", new Object[]{this.metadata.getFields().size()});
        writer.endControlFlow();
        writer.endControlFlow();
        writer.emitStatement("Map<String, RealmFieldType> columnTypes = new HashMap<String, RealmFieldType>()", new Object[0]);
        writer.beginControlFlow("for (long i = 0; i < " + this.metadata.getFields().size() + "; i++)", new Object[0]);
        writer.emitStatement("columnTypes.put(table.getColumnName(i), table.getColumnType(i))", new Object[0]);
        writer.endControlFlow();
        writer.emitEmptyLine();
        writer.emitStatement("final %1$s columnInfo = new %1$s(sharedRealm.getPath(), table)", new Object[]{this.columnInfoClassName()});
        writer.emitEmptyLine();
        long fieldIndex = 0L;
        for (VariableElement field : this.metadata.getFields()) {
            String fieldName = field.getSimpleName().toString();
            String fieldTypeQualifiedName = Utils.getFieldTypeQualifiedName(field);
            String fieldTypeSimpleName = Utils.getFieldTypeSimpleName(field);
            if (Constants.JAVA_TO_REALM_TYPES.containsKey(fieldTypeQualifiedName)) {
                writer.beginControlFlow("if (!columnTypes.containsKey(\"%s\"))", new Object[]{fieldName});
                writer.emitStatement("throw new RealmMigrationNeededException(sharedRealm.getPath(), \"Missing field '%s' in existing Realm file. Either remove field or migrate using io.realm.internal.Table.addColumn().\")", new Object[]{fieldName});
                writer.endControlFlow();
                writer.beginControlFlow("if (columnTypes.get(\"%s\") != %s)", new Object[]{fieldName, Constants.JAVA_TO_COLUMN_TYPES.get(fieldTypeQualifiedName)});
                writer.emitStatement("throw new RealmMigrationNeededException(sharedRealm.getPath(), \"Invalid type '%s' for field '%s' in existing Realm file.\")", new Object[]{fieldTypeSimpleName, fieldName});
                writer.endControlFlow();
                if (this.metadata.isNullable(field)) {
                    writer.beginControlFlow("if (!table.isColumnNullable(%s))", new Object[]{this.fieldIndexVariableReference(field)});
                    if (this.metadata.isPrimaryKey(field)) {
                        writer.emitStatement("throw new RealmMigrationNeededException(sharedRealm.getPath(),\"@PrimaryKey field '%s' does not support null values in the existing Realm file. Migrate using RealmObjectSchema.setNullable(), or mark the field as @Required.\")", new Object[]{fieldName});
                    } else if (Utils.isBoxedType(fieldTypeQualifiedName)) {
                        writer.emitStatement("throw new RealmMigrationNeededException(sharedRealm.getPath(),\"Field '%s' does not support null values in the existing Realm file. Either set @Required, use the primitive type for field '%s' or migrate using RealmObjectSchema.setNullable().\")", new Object[]{fieldName, fieldName});
                    } else {
                        writer.emitStatement("throw new RealmMigrationNeededException(sharedRealm.getPath(), \"Field '%s' is required. Either set @Required to field '%s' or migrate using RealmObjectSchema.setNullable().\")", new Object[]{fieldName, fieldName});
                    }
                    writer.endControlFlow();
                } else if (this.metadata.isPrimaryKey(field)) {
                    writer.beginControlFlow("if (table.isColumnNullable(%s) && table.findFirstNull(%s) != TableOrView.NO_MATCH)", new Object[]{this.fieldIndexVariableReference(field), this.fieldIndexVariableReference(field)}).emitStatement("throw new IllegalStateException(\"Cannot migrate an object with null value in field '%s'. Either maintain the same type for primary key field '%s', or remove the object with null value before migration.\")", new Object[]{fieldName, fieldName}).endControlFlow();
                } else {
                    writer.beginControlFlow("if (table.isColumnNullable(%s))", new Object[]{this.fieldIndexVariableReference(field)});
                    if (Utils.isPrimitiveType(fieldTypeQualifiedName)) {
                        writer.emitStatement("throw new RealmMigrationNeededException(sharedRealm.getPath(), \"Field '%s' does support null values in the existing Realm file. Use corresponding boxed type for field '%s' or migrate using RealmObjectSchema.setNullable().\")", new Object[]{fieldName, fieldName});
                    } else {
                        writer.emitStatement("throw new RealmMigrationNeededException(sharedRealm.getPath(), \"Field '%s' does support null values in the existing Realm file. Remove @Required or @PrimaryKey from field '%s' or migrate using RealmObjectSchema.setNullable().\")", new Object[]{fieldName, fieldName});
                    }
                    writer.endControlFlow();
                }
                if (this.metadata.isPrimaryKey(field)) {
                    writer.beginControlFlow("if (table.getPrimaryKey() != table.getColumnIndex(\"%s\"))", new Object[]{fieldName});
                    writer.emitStatement("throw new RealmMigrationNeededException(sharedRealm.getPath(), \"Primary key not defined for field '%s' in existing Realm file. Add @PrimaryKey.\")", new Object[]{fieldName});
                    writer.endControlFlow();
                }
                if (this.metadata.getIndexedFields().contains(field)) {
                    writer.beginControlFlow("if (!table.hasSearchIndex(table.getColumnIndex(\"%s\")))", new Object[]{fieldName});
                    writer.emitStatement("throw new RealmMigrationNeededException(sharedRealm.getPath(), \"Index not defined for field '%s' in existing Realm file. Either set @Index or migrate using io.realm.internal.Table.removeSearchIndex().\")", new Object[]{fieldName});
                    writer.endControlFlow();
                }
            } else if (Utils.isRealmModel(field)) {
                writer.beginControlFlow("if (!columnTypes.containsKey(\"%s\"))", new Object[]{fieldName});
                writer.emitStatement("throw new RealmMigrationNeededException(sharedRealm.getPath(), \"Missing field '%s' in existing Realm file. Either remove field or migrate using io.realm.internal.Table.addColumn().\")", new Object[]{fieldName});
                writer.endControlFlow();
                writer.beginControlFlow("if (columnTypes.get(\"%s\") != RealmFieldType.OBJECT)", new Object[]{fieldName});
                writer.emitStatement("throw new RealmMigrationNeededException(sharedRealm.getPath(), \"Invalid type '%s' for field '%s'\")", new Object[]{fieldTypeSimpleName, fieldName});
                writer.endControlFlow();
                writer.beginControlFlow("if (!sharedRealm.hasTable(\"%s%s\"))", new Object[]{"class_", fieldTypeSimpleName});
                writer.emitStatement("throw new RealmMigrationNeededException(sharedRealm.getPath(), \"Missing class '%s%s' for field '%s'\")", new Object[]{"class_", fieldTypeSimpleName, fieldName});
                writer.endControlFlow();
                writer.emitStatement("Table table_%d = sharedRealm.getTable(\"%s%s\")", new Object[]{fieldIndex, "class_", fieldTypeSimpleName});
                writer.beginControlFlow("if (!table.getLinkTarget(%s).hasSameSchema(table_%d))", new Object[]{this.fieldIndexVariableReference(field), fieldIndex});
                writer.emitStatement("throw new RealmMigrationNeededException(sharedRealm.getPath(), \"Invalid RealmObject for field '%s': '\" + table.getLinkTarget(%s).getName() + \"' expected - was '\" + table_%d.getName() + \"'\")", new Object[]{fieldName, this.fieldIndexVariableReference(field), fieldIndex});
                writer.endControlFlow();
            } else if (Utils.isRealmList(field)) {
                String genericTypeSimpleName = Utils.getGenericTypeSimpleName(field);
                writer.beginControlFlow("if (!columnTypes.containsKey(\"%s\"))", new Object[]{fieldName});
                writer.emitStatement("throw new RealmMigrationNeededException(sharedRealm.getPath(), \"Missing field '%s'\")", new Object[]{fieldName});
                writer.endControlFlow();
                writer.beginControlFlow("if (columnTypes.get(\"%s\") != RealmFieldType.LIST)", new Object[]{fieldName});
                writer.emitStatement("throw new RealmMigrationNeededException(sharedRealm.getPath(), \"Invalid type '%s' for field '%s'\")", new Object[]{genericTypeSimpleName, fieldName});
                writer.endControlFlow();
                writer.beginControlFlow("if (!sharedRealm.hasTable(\"%s%s\"))", new Object[]{"class_", genericTypeSimpleName});
                writer.emitStatement("throw new RealmMigrationNeededException(sharedRealm.getPath(), \"Missing class '%s%s' for field '%s'\")", new Object[]{"class_", genericTypeSimpleName, fieldName});
                writer.endControlFlow();
                writer.emitStatement("Table table_%d = sharedRealm.getTable(\"%s%s\")", new Object[]{fieldIndex, "class_", genericTypeSimpleName});
                writer.beginControlFlow("if (!table.getLinkTarget(%s).hasSameSchema(table_%d))", new Object[]{this.fieldIndexVariableReference(field), fieldIndex});
                writer.emitStatement("throw new RealmMigrationNeededException(sharedRealm.getPath(), \"Invalid RealmList type for field '%s': '\" + table.getLinkTarget(%s).getName() + \"' expected - was '\" + table_%d.getName() + \"'\")", new Object[]{fieldName, this.fieldIndexVariableReference(field), fieldIndex});
                writer.endControlFlow();
            }
            ++fieldIndex;
        }
        writer.emitStatement("return %s", new Object[]{"columnInfo"});
        writer.nextControlFlow("else", new Object[0]);
        writer.emitStatement("throw new RealmMigrationNeededException(sharedRealm.getPath(), \"The '%s' class is missing from the schema for this Realm.\")", new Object[]{this.metadata.getSimpleClassName()});
        writer.endControlFlow();
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitGetTableNameMethod(JavaWriter writer) throws IOException {
        writer.beginMethod("String", "getTableName", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC), new String[0]);
        writer.emitStatement("return \"%s%s\"", new Object[]{"class_", this.simpleClassName});
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitGetFieldNamesMethod(JavaWriter writer) throws IOException {
        writer.beginMethod("List<String>", "getFieldNames", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC), new String[0]);
        writer.emitStatement("return FIELD_NAMES", new Object[0]);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitCopyOrUpdateMethod(JavaWriter writer) throws IOException {
        writer.beginMethod(this.qualifiedClassName, "copyOrUpdate", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC), new String[]{"Realm", "realm", this.qualifiedClassName, "object", "boolean", "update", "Map<RealmModel,RealmObjectProxy>", "cache"});
        writer.beginControlFlow("if (object instanceof RealmObjectProxy && ((RealmObjectProxy) object).realmGet$proxyState().getRealm$realm() != null && ((RealmObjectProxy) object).realmGet$proxyState().getRealm$realm().threadId != realm.threadId)", new Object[0]).emitStatement("throw new IllegalArgumentException(\"Objects which belong to Realm instances in other threads cannot be copied into this Realm instance.\")", new Object[0]).endControlFlow();
        writer.beginControlFlow("if (object instanceof RealmObjectProxy && ((RealmObjectProxy)object).realmGet$proxyState().getRealm$realm() != null && ((RealmObjectProxy)object).realmGet$proxyState().getRealm$realm().getPath().equals(realm.getPath()))", new Object[0]).emitStatement("return object", new Object[0]).endControlFlow();
        writer.emitStatement("final BaseRealm.RealmObjectContext objectContext = BaseRealm.objectContext.get()", new Object[0]);
        writer.emitStatement("RealmObjectProxy cachedRealmObject = cache.get(object)", new Object[0]);
        writer.beginControlFlow("if (cachedRealmObject != null)", new Object[0]).emitStatement("return (%s) cachedRealmObject", new Object[]{this.qualifiedClassName}).nextControlFlow("else", new Object[0]);
        if (!this.metadata.hasPrimaryKey()) {
            writer.emitStatement("return copy(realm, object, update, cache)", new Object[0]);
        } else {
            writer.emitStatement("%s realmObject = null", new Object[]{this.qualifiedClassName}).emitStatement("boolean canUpdate = update", new Object[0]).beginControlFlow("if (canUpdate)", new Object[0]).emitStatement("Table table = realm.getTable(%s.class)", new Object[]{this.qualifiedClassName}).emitStatement("long pkColumnIndex = table.getPrimaryKey()", new Object[0]);
            String primaryKeyGetter = this.metadata.getPrimaryKeyGetter();
            VariableElement primaryKeyElement = this.metadata.getPrimaryKey();
            if (this.metadata.isNullable(primaryKeyElement)) {
                if (Utils.isString(primaryKeyElement)) {
                    writer.emitStatement("String value = ((%s) object).%s()", new Object[]{this.interfaceName, primaryKeyGetter}).emitStatement("long rowIndex = TableOrView.NO_MATCH", new Object[0]).beginControlFlow("if (value == null)", new Object[0]).emitStatement("rowIndex = table.findFirstNull(pkColumnIndex)", new Object[0]).nextControlFlow("else", new Object[0]).emitStatement("rowIndex = table.findFirstString(pkColumnIndex, value)", new Object[0]).endControlFlow();
                } else {
                    writer.emitStatement("Number value = ((%s) object).%s()", new Object[]{this.interfaceName, primaryKeyGetter}).emitStatement("long rowIndex = TableOrView.NO_MATCH", new Object[0]).beginControlFlow("if (value == null)", new Object[0]).emitStatement("rowIndex = table.findFirstNull(pkColumnIndex)", new Object[0]).nextControlFlow("else", new Object[0]).emitStatement("rowIndex = table.findFirstLong(pkColumnIndex, value.longValue())", new Object[0]).endControlFlow();
                }
            } else {
                String pkType = Utils.isString(this.metadata.getPrimaryKey()) ? "String" : "Long";
                writer.emitStatement("long rowIndex = table.findFirst%s(pkColumnIndex, ((%s) object).%s())", new Object[]{pkType, this.interfaceName, primaryKeyGetter});
            }
            writer.beginControlFlow("if (rowIndex != TableOrView.NO_MATCH)", new Object[0]).beginControlFlow("try", new Object[0]).emitStatement("objectContext.set(realm, table.getUncheckedRow(rowIndex), realm.schema.getColumnInfo(%s.class), false, Collections.<String> emptyList())", new Object[]{this.qualifiedClassName}).emitStatement("realmObject = new %s()", new Object[]{this.qualifiedGeneratedClassName}).emitStatement("cache.put(object, (RealmObjectProxy) realmObject)", new Object[0]).nextControlFlow("finally", new Object[0]).emitStatement("objectContext.clear()", new Object[0]).endControlFlow().nextControlFlow("else", new Object[0]).emitStatement("canUpdate = false", new Object[0]).endControlFlow();
            writer.endControlFlow();
            writer.emitEmptyLine().beginControlFlow("if (canUpdate)", new Object[0]).emitStatement("return update(realm, realmObject, object, cache)", new Object[0]).nextControlFlow("else", new Object[0]).emitStatement("return copy(realm, object, update, cache)", new Object[0]).endControlFlow();
        }
        writer.endControlFlow();
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void setTableValues(JavaWriter writer, String fieldType, String fieldName, String interfaceName, String getter, boolean isUpdate) throws IOException {
        if ("long".equals(fieldType) || "int".equals(fieldType) || "short".equals(fieldType) || "byte".equals(fieldType)) {
            writer.emitStatement("Table.nativeSetLong(tableNativePtr, columnInfo.%sIndex, rowIndex, ((%s)object).%s(), false)", new Object[]{fieldName, interfaceName, getter});
        } else if ("java.lang.Long".equals(fieldType) || "java.lang.Integer".equals(fieldType) || "java.lang.Short".equals(fieldType) || "java.lang.Byte".equals(fieldType)) {
            writer.emitStatement("Number %s = ((%s)object).%s()", new Object[]{getter, interfaceName, getter}).beginControlFlow("if (%s != null)", new Object[]{getter}).emitStatement("Table.nativeSetLong(tableNativePtr, columnInfo.%sIndex, rowIndex, %s.longValue(), false)", new Object[]{fieldName, getter});
            if (isUpdate) {
                writer.nextControlFlow("else", new Object[0]).emitStatement("Table.nativeSetNull(tableNativePtr, columnInfo.%sIndex, rowIndex, false)", new Object[]{fieldName});
            }
            writer.endControlFlow();
        } else if ("double".equals(fieldType)) {
            writer.emitStatement("Table.nativeSetDouble(tableNativePtr, columnInfo.%sIndex, rowIndex, ((%s)object).%s(), false)", new Object[]{fieldName, interfaceName, getter});
        } else if ("java.lang.Double".equals(fieldType)) {
            writer.emitStatement("Double %s = ((%s)object).%s()", new Object[]{getter, interfaceName, getter}).beginControlFlow("if (%s != null)", new Object[]{getter}).emitStatement("Table.nativeSetDouble(tableNativePtr, columnInfo.%sIndex, rowIndex, %s, false)", new Object[]{fieldName, getter});
            if (isUpdate) {
                writer.nextControlFlow("else", new Object[0]).emitStatement("Table.nativeSetNull(tableNativePtr, columnInfo.%sIndex, rowIndex, false)", new Object[]{fieldName});
            }
            writer.endControlFlow();
        } else if ("float".equals(fieldType)) {
            writer.emitStatement("Table.nativeSetFloat(tableNativePtr, columnInfo.%sIndex, rowIndex, ((%s)object).%s(), false)", new Object[]{fieldName, interfaceName, getter});
        } else if ("java.lang.Float".equals(fieldType)) {
            writer.emitStatement("Float %s = ((%s)object).%s()", new Object[]{getter, interfaceName, getter}).beginControlFlow("if (%s != null)", new Object[]{getter}).emitStatement("Table.nativeSetFloat(tableNativePtr, columnInfo.%sIndex, rowIndex, %s, false)", new Object[]{fieldName, getter});
            if (isUpdate) {
                writer.nextControlFlow("else", new Object[0]).emitStatement("Table.nativeSetNull(tableNativePtr, columnInfo.%sIndex, rowIndex, false)", new Object[]{fieldName});
            }
            writer.endControlFlow();
        } else if ("boolean".equals(fieldType)) {
            writer.emitStatement("Table.nativeSetBoolean(tableNativePtr, columnInfo.%sIndex, rowIndex, ((%s)object).%s(), false)", new Object[]{fieldName, interfaceName, getter});
        } else if ("java.lang.Boolean".equals(fieldType)) {
            writer.emitStatement("Boolean %s = ((%s)object).%s()", new Object[]{getter, interfaceName, getter}).beginControlFlow("if (%s != null)", new Object[]{getter}).emitStatement("Table.nativeSetBoolean(tableNativePtr, columnInfo.%sIndex, rowIndex, %s, false)", new Object[]{fieldName, getter});
            if (isUpdate) {
                writer.nextControlFlow("else", new Object[0]).emitStatement("Table.nativeSetNull(tableNativePtr, columnInfo.%sIndex, rowIndex, false)", new Object[]{fieldName});
            }
            writer.endControlFlow();
        } else if ("byte[]".equals(fieldType)) {
            writer.emitStatement("byte[] %s = ((%s)object).%s()", new Object[]{getter, interfaceName, getter}).beginControlFlow("if (%s != null)", new Object[]{getter}).emitStatement("Table.nativeSetByteArray(tableNativePtr, columnInfo.%sIndex, rowIndex, %s, false)", new Object[]{fieldName, getter});
            if (isUpdate) {
                writer.nextControlFlow("else", new Object[0]).emitStatement("Table.nativeSetNull(tableNativePtr, columnInfo.%sIndex, rowIndex, false)", new Object[]{fieldName});
            }
            writer.endControlFlow();
        } else if ("java.util.Date".equals(fieldType)) {
            writer.emitStatement("java.util.Date %s = ((%s)object).%s()", new Object[]{getter, interfaceName, getter}).beginControlFlow("if (%s != null)", new Object[]{getter}).emitStatement("Table.nativeSetTimestamp(tableNativePtr, columnInfo.%sIndex, rowIndex, %s.getTime(), false)", new Object[]{fieldName, getter});
            if (isUpdate) {
                writer.nextControlFlow("else", new Object[0]).emitStatement("Table.nativeSetNull(tableNativePtr, columnInfo.%sIndex, rowIndex, false)", new Object[]{fieldName});
            }
            writer.endControlFlow();
        } else if ("java.lang.String".equals(fieldType)) {
            writer.emitStatement("String %s = ((%s)object).%s()", new Object[]{getter, interfaceName, getter}).beginControlFlow("if (%s != null)", new Object[]{getter}).emitStatement("Table.nativeSetString(tableNativePtr, columnInfo.%sIndex, rowIndex, %s, false)", new Object[]{fieldName, getter});
            if (isUpdate) {
                writer.nextControlFlow("else", new Object[0]).emitStatement("Table.nativeSetNull(tableNativePtr, columnInfo.%sIndex, rowIndex, false)", new Object[]{fieldName});
            }
            writer.endControlFlow();
        } else {
            throw new IllegalStateException("Unsupported type " + fieldType);
        }
    }

    private void emitInsertMethod(JavaWriter writer) throws IOException {
        writer.beginMethod("long", "insert", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC), new String[]{"Realm", "realm", this.qualifiedClassName, "object", "Map<RealmModel,Long>", "cache"});
        writer.beginControlFlow("if (object instanceof RealmObjectProxy && ((RealmObjectProxy)object).realmGet$proxyState().getRealm$realm() != null && ((RealmObjectProxy)object).realmGet$proxyState().getRealm$realm().getPath().equals(realm.getPath()))", new Object[0]).emitStatement("return ((RealmObjectProxy)object).realmGet$proxyState().getRow$realm().getIndex()", new Object[0]).endControlFlow();
        writer.emitStatement("Table table = realm.getTable(%s.class)", new Object[]{this.qualifiedClassName});
        writer.emitStatement("long tableNativePtr = table.getNativeTablePointer()", new Object[0]);
        writer.emitStatement("%s columnInfo = (%s) realm.schema.getColumnInfo(%s.class)", new Object[]{this.columnInfoClassName(), this.columnInfoClassName(), this.qualifiedClassName});
        if (this.metadata.hasPrimaryKey()) {
            writer.emitStatement("long pkColumnIndex = table.getPrimaryKey()", new Object[0]);
        }
        this.addPrimaryKeyCheckIfNeeded(this.metadata, true, writer);
        for (VariableElement field : this.metadata.getFields()) {
            String fieldName = field.getSimpleName().toString();
            String fieldType = field.asType().toString();
            String getter = this.metadata.getGetter(fieldName);
            if (Utils.isRealmModel(field)) {
                writer.emitEmptyLine().emitStatement("%s %sObj = ((%s) object).%s()", new Object[]{fieldType, fieldName, this.interfaceName, getter}).beginControlFlow("if (%sObj != null)", new Object[]{fieldName}).emitStatement("Long cache%1$s = cache.get(%1$sObj)", new Object[]{fieldName}).beginControlFlow("if (cache%s == null)", new Object[]{fieldName}).emitStatement("cache%s = %s.insert(realm, %sObj, cache)", new Object[]{fieldName, Utils.getProxyClassSimpleName(field), fieldName}).endControlFlow().emitStatement("Table.nativeSetLink(tableNativePtr, columnInfo.%1$sIndex, rowIndex, cache%1$s, false)", new Object[]{fieldName}).endControlFlow();
                continue;
            }
            if (Utils.isRealmList(field)) {
                String genericType = Utils.getGenericTypeQualifiedName(field);
                writer.emitEmptyLine().emitStatement("RealmList<%s> %sList = ((%s) object).%s()", new Object[]{genericType, fieldName, this.interfaceName, getter}).beginControlFlow("if (%sList != null)", new Object[]{fieldName}).emitStatement("long %1$sNativeLinkViewPtr = Table.nativeGetLinkView(tableNativePtr, columnInfo.%1$sIndex, rowIndex)", new Object[]{fieldName}).beginControlFlow("for (%1$s %2$sItem : %2$sList)", new Object[]{genericType, fieldName}).emitStatement("Long cacheItemIndex%1$s = cache.get(%1$sItem)", new Object[]{fieldName}).beginControlFlow("if (cacheItemIndex%s == null)", new Object[]{fieldName}).emitStatement("cacheItemIndex%1$s = %2$s.insert(realm, %1$sItem, cache)", new Object[]{fieldName, Utils.getProxyClassSimpleName(field)}).endControlFlow().emitStatement("LinkView.nativeAdd(%1$sNativeLinkViewPtr, cacheItemIndex%1$s)", new Object[]{fieldName}).endControlFlow().emitStatement("LinkView.nativeClose(%sNativeLinkViewPtr)", new Object[]{fieldName}).endControlFlow().emitEmptyLine();
                continue;
            }
            if (this.metadata.getPrimaryKey() == field) continue;
            this.setTableValues(writer, fieldType, fieldName, this.interfaceName, getter, false);
        }
        writer.emitStatement("return rowIndex", new Object[0]);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitInsertListMethod(JavaWriter writer) throws IOException {
        writer.beginMethod("void", "insert", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC), new String[]{"Realm", "realm", "Iterator<? extends RealmModel>", "objects", "Map<RealmModel,Long>", "cache"});
        writer.emitStatement("Table table = realm.getTable(%s.class)", new Object[]{this.qualifiedClassName});
        writer.emitStatement("long tableNativePtr = table.getNativeTablePointer()", new Object[0]);
        writer.emitStatement("%s columnInfo = (%s) realm.schema.getColumnInfo(%s.class)", new Object[]{this.columnInfoClassName(), this.columnInfoClassName(), this.qualifiedClassName});
        if (this.metadata.hasPrimaryKey()) {
            writer.emitStatement("long pkColumnIndex = table.getPrimaryKey()", new Object[0]);
        }
        writer.emitStatement("%s object = null", new Object[]{this.qualifiedClassName});
        writer.beginControlFlow("while (objects.hasNext())", new Object[0]);
        writer.emitStatement("object = (%s) objects.next()", new Object[]{this.qualifiedClassName});
        writer.beginControlFlow("if(!cache.containsKey(object))", new Object[0]);
        writer.beginControlFlow("if (object instanceof RealmObjectProxy && ((RealmObjectProxy)object).realmGet$proxyState().getRealm$realm() != null && ((RealmObjectProxy)object).realmGet$proxyState().getRealm$realm().getPath().equals(realm.getPath()))", new Object[0]);
        writer.emitStatement("cache.put(object, ((RealmObjectProxy)object).realmGet$proxyState().getRow$realm().getIndex())", new Object[0]).emitStatement("continue", new Object[0]);
        writer.endControlFlow();
        this.addPrimaryKeyCheckIfNeeded(this.metadata, true, writer);
        for (VariableElement field : this.metadata.getFields()) {
            String fieldName = field.getSimpleName().toString();
            String fieldType = field.asType().toString();
            String getter = this.metadata.getGetter(fieldName);
            if (Utils.isRealmModel(field)) {
                writer.emitEmptyLine().emitStatement("%s %sObj = ((%s) object).%s()", new Object[]{fieldType, fieldName, this.interfaceName, getter}).beginControlFlow("if (%sObj != null)", new Object[]{fieldName}).emitStatement("Long cache%1$s = cache.get(%1$sObj)", new Object[]{fieldName}).beginControlFlow("if (cache%s == null)", new Object[]{fieldName}).emitStatement("cache%s = %s.insert(realm, %sObj, cache)", new Object[]{fieldName, Utils.getProxyClassSimpleName(field), fieldName}).endControlFlow().emitStatement("table.setLink(columnInfo.%1$sIndex, rowIndex, cache%1$s, false)", new Object[]{fieldName}).endControlFlow();
                continue;
            }
            if (Utils.isRealmList(field)) {
                String genericType = Utils.getGenericTypeQualifiedName(field);
                writer.emitEmptyLine().emitStatement("RealmList<%s> %sList = ((%s) object).%s()", new Object[]{genericType, fieldName, this.interfaceName, getter}).beginControlFlow("if (%sList != null)", new Object[]{fieldName}).emitStatement("long %1$sNativeLinkViewPtr = Table.nativeGetLinkView(tableNativePtr, columnInfo.%1$sIndex, rowIndex)", new Object[]{fieldName}).beginControlFlow("for (%1$s %2$sItem : %2$sList)", new Object[]{genericType, fieldName}).emitStatement("Long cacheItemIndex%1$s = cache.get(%1$sItem)", new Object[]{fieldName}).beginControlFlow("if (cacheItemIndex%s == null)", new Object[]{fieldName}).emitStatement("cacheItemIndex%1$s = %2$s.insert(realm, %1$sItem, cache)", new Object[]{fieldName, Utils.getProxyClassSimpleName(field)}).endControlFlow().emitStatement("LinkView.nativeAdd(%1$sNativeLinkViewPtr, cacheItemIndex%1$s)", new Object[]{fieldName}).endControlFlow().emitStatement("LinkView.nativeClose(%sNativeLinkViewPtr)", new Object[]{fieldName}).endControlFlow().emitEmptyLine();
                continue;
            }
            if (this.metadata.getPrimaryKey() == field) continue;
            this.setTableValues(writer, fieldType, fieldName, this.interfaceName, getter, false);
        }
        writer.endControlFlow();
        writer.endControlFlow();
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitInsertOrUpdateMethod(JavaWriter writer) throws IOException {
        writer.beginMethod("long", "insertOrUpdate", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC), new String[]{"Realm", "realm", this.qualifiedClassName, "object", "Map<RealmModel,Long>", "cache"});
        writer.beginControlFlow("if (object instanceof RealmObjectProxy && ((RealmObjectProxy)object).realmGet$proxyState().getRealm$realm() != null && ((RealmObjectProxy)object).realmGet$proxyState().getRealm$realm().getPath().equals(realm.getPath()))", new Object[0]).emitStatement("return ((RealmObjectProxy)object).realmGet$proxyState().getRow$realm().getIndex()", new Object[0]).endControlFlow();
        writer.emitStatement("Table table = realm.getTable(%s.class)", new Object[]{this.qualifiedClassName});
        writer.emitStatement("long tableNativePtr = table.getNativeTablePointer()", new Object[0]);
        writer.emitStatement("%s columnInfo = (%s) realm.schema.getColumnInfo(%s.class)", new Object[]{this.columnInfoClassName(), this.columnInfoClassName(), this.qualifiedClassName});
        if (this.metadata.hasPrimaryKey()) {
            writer.emitStatement("long pkColumnIndex = table.getPrimaryKey()", new Object[0]);
        }
        this.addPrimaryKeyCheckIfNeeded(this.metadata, false, writer);
        for (VariableElement field : this.metadata.getFields()) {
            String fieldName = field.getSimpleName().toString();
            String fieldType = field.asType().toString();
            String getter = this.metadata.getGetter(fieldName);
            if (Utils.isRealmModel(field)) {
                writer.emitEmptyLine().emitStatement("%s %sObj = ((%s) object).%s()", new Object[]{fieldType, fieldName, this.interfaceName, getter}).beginControlFlow("if (%sObj != null)", new Object[]{fieldName}).emitStatement("Long cache%1$s = cache.get(%1$sObj)", new Object[]{fieldName}).beginControlFlow("if (cache%s == null)", new Object[]{fieldName}).emitStatement("cache%1$s = %2$s.insertOrUpdate(realm, %1$sObj, cache)", new Object[]{fieldName, Utils.getProxyClassSimpleName(field)}).endControlFlow().emitStatement("Table.nativeSetLink(tableNativePtr, columnInfo.%1$sIndex, rowIndex, cache%1$s, false)", new Object[]{fieldName}).nextControlFlow("else", new Object[0]).emitStatement("Table.nativeNullifyLink(tableNativePtr, columnInfo.%sIndex, rowIndex)", new Object[]{fieldName}).endControlFlow();
                continue;
            }
            if (Utils.isRealmList(field)) {
                String genericType = Utils.getGenericTypeQualifiedName(field);
                writer.emitEmptyLine().emitStatement("long %1$sNativeLinkViewPtr = Table.nativeGetLinkView(tableNativePtr, columnInfo.%1$sIndex, rowIndex)", new Object[]{fieldName}).emitStatement("LinkView.nativeClear(%sNativeLinkViewPtr)", new Object[]{fieldName}).emitStatement("RealmList<%s> %sList = ((%s) object).%s()", new Object[]{genericType, fieldName, this.interfaceName, getter}).beginControlFlow("if (%sList != null)", new Object[]{fieldName}).beginControlFlow("for (%1$s %2$sItem : %2$sList)", new Object[]{genericType, fieldName}).emitStatement("Long cacheItemIndex%1$s = cache.get(%1$sItem)", new Object[]{fieldName}).beginControlFlow("if (cacheItemIndex%s == null)", new Object[]{fieldName}).emitStatement("cacheItemIndex%1$s = %2$s.insertOrUpdate(realm, %1$sItem, cache)", new Object[]{fieldName, Utils.getProxyClassSimpleName(field)}).endControlFlow().emitStatement("LinkView.nativeAdd(%1$sNativeLinkViewPtr, cacheItemIndex%1$s)", new Object[]{fieldName}).endControlFlow().endControlFlow().emitStatement("LinkView.nativeClose(%sNativeLinkViewPtr)", new Object[]{fieldName}).emitEmptyLine();
                continue;
            }
            if (this.metadata.getPrimaryKey() == field) continue;
            this.setTableValues(writer, fieldType, fieldName, this.interfaceName, getter, true);
        }
        writer.emitStatement("return rowIndex", new Object[0]);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitInsertOrUpdateListMethod(JavaWriter writer) throws IOException {
        writer.beginMethod("void", "insertOrUpdate", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC), new String[]{"Realm", "realm", "Iterator<? extends RealmModel>", "objects", "Map<RealmModel,Long>", "cache"});
        writer.emitStatement("Table table = realm.getTable(%s.class)", new Object[]{this.qualifiedClassName});
        writer.emitStatement("long tableNativePtr = table.getNativeTablePointer()", new Object[0]);
        writer.emitStatement("%s columnInfo = (%s) realm.schema.getColumnInfo(%s.class)", new Object[]{this.columnInfoClassName(), this.columnInfoClassName(), this.qualifiedClassName});
        if (this.metadata.hasPrimaryKey()) {
            writer.emitStatement("long pkColumnIndex = table.getPrimaryKey()", new Object[0]);
        }
        writer.emitStatement("%s object = null", new Object[]{this.qualifiedClassName});
        writer.beginControlFlow("while (objects.hasNext())", new Object[0]);
        writer.emitStatement("object = (%s) objects.next()", new Object[]{this.qualifiedClassName});
        writer.beginControlFlow("if(!cache.containsKey(object))", new Object[0]);
        writer.beginControlFlow("if (object instanceof RealmObjectProxy && ((RealmObjectProxy)object).realmGet$proxyState().getRealm$realm() != null && ((RealmObjectProxy)object).realmGet$proxyState().getRealm$realm().getPath().equals(realm.getPath()))", new Object[0]);
        writer.emitStatement("cache.put(object, ((RealmObjectProxy)object).realmGet$proxyState().getRow$realm().getIndex())", new Object[0]).emitStatement("continue", new Object[0]);
        writer.endControlFlow();
        this.addPrimaryKeyCheckIfNeeded(this.metadata, false, writer);
        for (VariableElement field : this.metadata.getFields()) {
            String fieldName = field.getSimpleName().toString();
            String fieldType = field.asType().toString();
            String getter = this.metadata.getGetter(fieldName);
            if (Utils.isRealmModel(field)) {
                writer.emitEmptyLine().emitStatement("%s %sObj = ((%s) object).%s()", new Object[]{fieldType, fieldName, this.interfaceName, getter}).beginControlFlow("if (%sObj != null)", new Object[]{fieldName}).emitStatement("Long cache%1$s = cache.get(%1$sObj)", new Object[]{fieldName}).beginControlFlow("if (cache%s == null)", new Object[]{fieldName}).emitStatement("cache%1$s = %2$s.insertOrUpdate(realm, %1$sObj, cache)", new Object[]{fieldName, Utils.getProxyClassSimpleName(field)}).endControlFlow().emitStatement("Table.nativeSetLink(tableNativePtr, columnInfo.%1$sIndex, rowIndex, cache%1$s, false)", new Object[]{fieldName}).nextControlFlow("else", new Object[0]).emitStatement("Table.nativeNullifyLink(tableNativePtr, columnInfo.%sIndex, rowIndex)", new Object[]{fieldName}).endControlFlow();
                continue;
            }
            if (Utils.isRealmList(field)) {
                String genericType = Utils.getGenericTypeQualifiedName(field);
                writer.emitEmptyLine().emitStatement("long %1$sNativeLinkViewPtr = Table.nativeGetLinkView(tableNativePtr, columnInfo.%1$sIndex, rowIndex)", new Object[]{fieldName}).emitStatement("LinkView.nativeClear(%sNativeLinkViewPtr)", new Object[]{fieldName}).emitStatement("RealmList<%s> %sList = ((%s) object).%s()", new Object[]{genericType, fieldName, this.interfaceName, getter}).beginControlFlow("if (%sList != null)", new Object[]{fieldName}).beginControlFlow("for (%1$s %2$sItem : %2$sList)", new Object[]{genericType, fieldName}).emitStatement("Long cacheItemIndex%1$s = cache.get(%1$sItem)", new Object[]{fieldName}).beginControlFlow("if (cacheItemIndex%s == null)", new Object[]{fieldName}).emitStatement("cacheItemIndex%1$s = %2$s.insertOrUpdate(realm, %1$sItem, cache)", new Object[]{fieldName, Utils.getProxyClassSimpleName(field)}).endControlFlow().emitStatement("LinkView.nativeAdd(%1$sNativeLinkViewPtr, cacheItemIndex%1$s)", new Object[]{fieldName}).endControlFlow().endControlFlow().emitStatement("LinkView.nativeClose(%sNativeLinkViewPtr)", new Object[]{fieldName}).emitEmptyLine();
                continue;
            }
            if (this.metadata.getPrimaryKey() == field) continue;
            this.setTableValues(writer, fieldType, fieldName, this.interfaceName, getter, true);
        }
        writer.endControlFlow();
        writer.endControlFlow();
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void addPrimaryKeyCheckIfNeeded(ClassMetaData metadata, boolean throwIfPrimaryKeyDuplicate, JavaWriter writer) throws IOException {
        if (metadata.hasPrimaryKey()) {
            String primaryKeyGetter = metadata.getPrimaryKeyGetter();
            VariableElement primaryKeyElement = metadata.getPrimaryKey();
            if (metadata.isNullable(primaryKeyElement)) {
                if (Utils.isString(primaryKeyElement)) {
                    writer.emitStatement("String primaryKeyValue = ((%s) object).%s()", new Object[]{this.interfaceName, primaryKeyGetter}).emitStatement("long rowIndex = TableOrView.NO_MATCH", new Object[0]).beginControlFlow("if (primaryKeyValue == null)", new Object[0]).emitStatement("rowIndex = Table.nativeFindFirstNull(tableNativePtr, pkColumnIndex)", new Object[0]).nextControlFlow("else", new Object[0]).emitStatement("rowIndex = Table.nativeFindFirstString(tableNativePtr, pkColumnIndex, primaryKeyValue)", new Object[0]).endControlFlow();
                } else {
                    writer.emitStatement("Object primaryKeyValue = ((%s) object).%s()", new Object[]{this.interfaceName, primaryKeyGetter}).emitStatement("long rowIndex = TableOrView.NO_MATCH", new Object[0]).beginControlFlow("if (primaryKeyValue == null)", new Object[0]).emitStatement("rowIndex = Table.nativeFindFirstNull(tableNativePtr, pkColumnIndex)", new Object[0]).nextControlFlow("else", new Object[0]).emitStatement("rowIndex = Table.nativeFindFirstInt(tableNativePtr, pkColumnIndex, ((%s) object).%s())", new Object[]{this.interfaceName, primaryKeyGetter}).endControlFlow();
                }
            } else {
                writer.emitStatement("long rowIndex = TableOrView.NO_MATCH", new Object[0]);
                writer.emitStatement("Object primaryKeyValue = ((%s) object).%s()", new Object[]{this.interfaceName, primaryKeyGetter});
                writer.beginControlFlow("if (primaryKeyValue != null)", new Object[0]);
                if (Utils.isString(metadata.getPrimaryKey())) {
                    writer.emitStatement("rowIndex = Table.nativeFindFirstString(tableNativePtr, pkColumnIndex, (String)primaryKeyValue)", new Object[0]);
                } else {
                    writer.emitStatement("rowIndex = Table.nativeFindFirstInt(tableNativePtr, pkColumnIndex, ((%s) object).%s())", new Object[]{this.interfaceName, primaryKeyGetter});
                }
                writer.endControlFlow();
            }
            writer.beginControlFlow("if (rowIndex == TableOrView.NO_MATCH)", new Object[0]);
            if (Utils.isString(metadata.getPrimaryKey())) {
                writer.emitStatement("rowIndex = table.addEmptyRowWithPrimaryKey(primaryKeyValue, false)", new Object[0]);
            } else {
                writer.emitStatement("rowIndex = table.addEmptyRowWithPrimaryKey(((%s) object).%s(), false)", new Object[]{this.interfaceName, primaryKeyGetter});
            }
            if (throwIfPrimaryKeyDuplicate) {
                writer.nextControlFlow("else", new Object[0]);
                writer.emitStatement("Table.throwDuplicatePrimaryKeyException(primaryKeyValue)", new Object[0]);
            }
            writer.endControlFlow();
            writer.emitStatement("cache.put(object, rowIndex)", new Object[0]);
        } else {
            writer.emitStatement("long rowIndex = Table.nativeAddEmptyRow(tableNativePtr, 1)", new Object[0]);
            writer.emitStatement("cache.put(object, rowIndex)", new Object[0]);
        }
    }

    private void emitCopyMethod(JavaWriter writer) throws IOException {
        writer.beginMethod(this.qualifiedClassName, "copy", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC), new String[]{"Realm", "realm", this.qualifiedClassName, "newObject", "boolean", "update", "Map<RealmModel,RealmObjectProxy>", "cache"});
        writer.emitStatement("RealmObjectProxy cachedRealmObject = cache.get(newObject)", new Object[0]);
        writer.beginControlFlow("if (cachedRealmObject != null)", new Object[0]).emitStatement("return (%s) cachedRealmObject", new Object[]{this.qualifiedClassName}).nextControlFlow("else", new Object[0]);
        writer.emitSingleLineComment("rejecting default values to avoid creating unexpected objects from RealmModel/RealmList fields.", new Object[0]);
        if (this.metadata.hasPrimaryKey()) {
            writer.emitStatement("%s realmObject = realm.createObjectInternal(%s.class, ((%s) newObject).%s(), false, Collections.<String>emptyList())", new Object[]{this.qualifiedClassName, this.qualifiedClassName, this.interfaceName, this.metadata.getPrimaryKeyGetter()});
        } else {
            writer.emitStatement("%s realmObject = realm.createObjectInternal(%s.class, false, Collections.<String>emptyList())", new Object[]{this.qualifiedClassName, this.qualifiedClassName});
        }
        writer.emitStatement("cache.put(newObject, (RealmObjectProxy) realmObject)", new Object[0]);
        for (VariableElement field : this.metadata.getFields()) {
            String fieldName = field.getSimpleName().toString();
            String fieldType = field.asType().toString();
            String setter = this.metadata.getSetter(fieldName);
            String getter = this.metadata.getGetter(fieldName);
            if (this.metadata.isPrimaryKey(field)) continue;
            if (Utils.isRealmModel(field)) {
                writer.emitEmptyLine().emitStatement("%s %sObj = ((%s) newObject).%s()", new Object[]{fieldType, fieldName, this.interfaceName, getter}).beginControlFlow("if (%sObj != null)", new Object[]{fieldName}).emitStatement("%s cache%s = (%s) cache.get(%sObj)", new Object[]{fieldType, fieldName, fieldType, fieldName}).beginControlFlow("if (cache%s != null)", new Object[]{fieldName}).emitStatement("((%s) realmObject).%s(cache%s)", new Object[]{this.interfaceName, setter, fieldName}).nextControlFlow("else", new Object[0]).emitStatement("((%s) realmObject).%s(%s.copyOrUpdate(realm, %sObj, update, cache))", new Object[]{this.interfaceName, setter, Utils.getProxyClassSimpleName(field), fieldName}).endControlFlow().nextControlFlow("else", new Object[0]).emitStatement("((%s) realmObject).%s(null)", new Object[]{this.interfaceName, setter}).endControlFlow();
                continue;
            }
            if (Utils.isRealmList(field)) {
                String genericType = Utils.getGenericTypeQualifiedName(field);
                writer.emitEmptyLine().emitStatement("RealmList<%s> %sList = ((%s) newObject).%s()", new Object[]{genericType, fieldName, this.interfaceName, getter}).beginControlFlow("if (%sList != null)", new Object[]{fieldName}).emitStatement("RealmList<%s> %sRealmList = ((%s) realmObject).%s()", new Object[]{genericType, fieldName, this.interfaceName, getter}).beginControlFlow("for (int i = 0; i < %sList.size(); i++)", new Object[]{fieldName}).emitStatement("%s %sItem = %sList.get(i)", new Object[]{genericType, fieldName, fieldName}).emitStatement("%s cache%s = (%s) cache.get(%sItem)", new Object[]{genericType, fieldName, genericType, fieldName}).beginControlFlow("if (cache%s != null)", new Object[]{fieldName}).emitStatement("%sRealmList.add(cache%s)", new Object[]{fieldName, fieldName}).nextControlFlow("else", new Object[0]).emitStatement("%sRealmList.add(%s.copyOrUpdate(realm, %sList.get(i), update, cache))", new Object[]{fieldName, Utils.getProxyClassSimpleName(field), fieldName}).endControlFlow().endControlFlow().endControlFlow().emitEmptyLine();
                continue;
            }
            writer.emitStatement("((%s) realmObject).%s(((%s) newObject).%s())", new Object[]{this.interfaceName, setter, this.interfaceName, getter});
        }
        writer.emitStatement("return realmObject", new Object[0]);
        writer.endControlFlow();
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitCreateDetachedCopyMethod(JavaWriter writer) throws IOException {
        writer.beginMethod(this.qualifiedClassName, "createDetachedCopy", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC), new String[]{this.qualifiedClassName, "realmObject", "int", "currentDepth", "int", "maxDepth", "Map<RealmModel, CacheData<RealmModel>>", "cache"});
        writer.beginControlFlow("if (currentDepth > maxDepth || realmObject == null)", new Object[0]).emitStatement("return null", new Object[0]).endControlFlow().emitStatement("CacheData<RealmModel> cachedObject = cache.get(realmObject)", new Object[0]).emitStatement("%s unmanagedObject", new Object[]{this.qualifiedClassName}).beginControlFlow("if (cachedObject != null)", new Object[0]).emitSingleLineComment("Reuse cached object or recreate it because it was encountered at a lower depth.", new Object[0]).beginControlFlow("if (currentDepth >= cachedObject.minDepth)", new Object[0]).emitStatement("return (%s)cachedObject.object", new Object[]{this.qualifiedClassName}).nextControlFlow("else", new Object[0]).emitStatement("unmanagedObject = (%s)cachedObject.object", new Object[]{this.qualifiedClassName}).emitStatement("cachedObject.minDepth = currentDepth", new Object[0]).endControlFlow().nextControlFlow("else", new Object[0]).emitStatement("unmanagedObject = new %s()", new Object[]{this.qualifiedClassName}).emitStatement("cache.put(realmObject, new RealmObjectProxy.CacheData(currentDepth, unmanagedObject))", new Object[0]).endControlFlow();
        for (VariableElement field : this.metadata.getFields()) {
            String fieldName = field.getSimpleName().toString();
            String setter = this.metadata.getSetter(fieldName);
            String getter = this.metadata.getGetter(fieldName);
            if (Utils.isRealmModel(field)) {
                writer.emitEmptyLine().emitSingleLineComment("Deep copy of %s", new Object[]{fieldName}).emitStatement("((%s) unmanagedObject).%s(%s.createDetachedCopy(((%s) realmObject).%s(), currentDepth + 1, maxDepth, cache))", new Object[]{this.interfaceName, setter, Utils.getProxyClassSimpleName(field), this.interfaceName, getter});
                continue;
            }
            if (Utils.isRealmList(field)) {
                writer.emitEmptyLine().emitSingleLineComment("Deep copy of %s", new Object[]{fieldName}).beginControlFlow("if (currentDepth == maxDepth)", new Object[0]).emitStatement("((%s) unmanagedObject).%s(null)", new Object[]{this.interfaceName, setter}).nextControlFlow("else", new Object[0]).emitStatement("RealmList<%s> managed%sList = ((%s) realmObject).%s()", new Object[]{Utils.getGenericTypeQualifiedName(field), fieldName, this.interfaceName, getter}).emitStatement("RealmList<%1$s> unmanaged%2$sList = new RealmList<%1$s>()", new Object[]{Utils.getGenericTypeQualifiedName(field), fieldName}).emitStatement("((%s) unmanagedObject).%s(unmanaged%sList)", new Object[]{this.interfaceName, setter, fieldName}).emitStatement("int nextDepth = currentDepth + 1", new Object[0]).emitStatement("int size = managed%sList.size()", new Object[]{fieldName}).beginControlFlow("for (int i = 0; i < size; i++)", new Object[0]).emitStatement("%s item = %s.createDetachedCopy(managed%sList.get(i), nextDepth, maxDepth, cache)", new Object[]{Utils.getGenericTypeQualifiedName(field), Utils.getProxyClassSimpleName(field), fieldName}).emitStatement("unmanaged%sList.add(item)", new Object[]{fieldName}).endControlFlow().endControlFlow();
                continue;
            }
            writer.emitStatement("((%s) unmanagedObject).%s(((%s) realmObject).%s())", new Object[]{this.interfaceName, setter, this.interfaceName, getter});
        }
        writer.emitStatement("return unmanagedObject", new Object[0]);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitUpdateMethod(JavaWriter writer) throws IOException {
        if (!this.metadata.hasPrimaryKey()) {
            return;
        }
        writer.beginMethod(this.qualifiedClassName, "update", EnumSet.of(Modifier.STATIC), new String[]{"Realm", "realm", this.qualifiedClassName, "realmObject", this.qualifiedClassName, "newObject", "Map<RealmModel, RealmObjectProxy>", "cache"});
        for (VariableElement field : this.metadata.getFields()) {
            String fieldName = field.getSimpleName().toString();
            String setter = this.metadata.getSetter(fieldName);
            String getter = this.metadata.getGetter(fieldName);
            if (Utils.isRealmModel(field)) {
                writer.emitStatement("%s %sObj = ((%s) newObject).%s()", new Object[]{Utils.getFieldTypeQualifiedName(field), fieldName, this.interfaceName, getter}).beginControlFlow("if (%sObj != null)", new Object[]{fieldName}).emitStatement("%s cache%s = (%s) cache.get(%sObj)", new Object[]{Utils.getFieldTypeQualifiedName(field), fieldName, Utils.getFieldTypeQualifiedName(field), fieldName}).beginControlFlow("if (cache%s != null)", new Object[]{fieldName}).emitStatement("((%s) realmObject).%s(cache%s)", new Object[]{this.interfaceName, setter, fieldName}).nextControlFlow("else", new Object[0]).emitStatement("((%s) realmObject).%s(%s.copyOrUpdate(realm, %sObj, true, cache))", new Object[]{this.interfaceName, setter, Utils.getProxyClassSimpleName(field), fieldName}).endControlFlow().nextControlFlow("else", new Object[0]).emitStatement("((%s) realmObject).%s(null)", new Object[]{this.interfaceName, setter}).endControlFlow();
                continue;
            }
            if (Utils.isRealmList(field)) {
                String genericType = Utils.getGenericTypeQualifiedName(field);
                writer.emitStatement("RealmList<%s> %sList = ((%s) newObject).%s()", new Object[]{genericType, fieldName, this.interfaceName, getter}).emitStatement("RealmList<%s> %sRealmList = ((%s) realmObject).%s()", new Object[]{genericType, fieldName, this.interfaceName, getter}).emitStatement("%sRealmList.clear()", new Object[]{fieldName}).beginControlFlow("if (%sList != null)", new Object[]{fieldName}).beginControlFlow("for (int i = 0; i < %sList.size(); i++)", new Object[]{fieldName}).emitStatement("%s %sItem = %sList.get(i)", new Object[]{genericType, fieldName, fieldName}).emitStatement("%s cache%s = (%s) cache.get(%sItem)", new Object[]{genericType, fieldName, genericType, fieldName}).beginControlFlow("if (cache%s != null)", new Object[]{fieldName}).emitStatement("%sRealmList.add(cache%s)", new Object[]{fieldName, fieldName}).nextControlFlow("else", new Object[0]).emitStatement("%sRealmList.add(%s.copyOrUpdate(realm, %sList.get(i), true, cache))", new Object[]{fieldName, Utils.getProxyClassSimpleName(field), fieldName}).endControlFlow().endControlFlow().endControlFlow();
                continue;
            }
            if (field == this.metadata.getPrimaryKey()) continue;
            writer.emitStatement("((%s) realmObject).%s(((%s) newObject).%s())", new Object[]{this.interfaceName, setter, this.interfaceName, getter});
        }
        writer.emitStatement("return realmObject", new Object[0]);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitToStringMethod(JavaWriter writer) throws IOException {
        if (this.metadata.containsToString()) {
            return;
        }
        writer.emitAnnotation("Override");
        writer.beginMethod("String", "toString", EnumSet.of(Modifier.PUBLIC), new String[0]);
        writer.beginControlFlow("if (!RealmObject.isValid(this))", new Object[0]);
        writer.emitStatement("return \"Invalid object\"", new Object[0]);
        writer.endControlFlow();
        writer.emitStatement("StringBuilder stringBuilder = new StringBuilder(\"%s = [\")", new Object[]{this.simpleClassName});
        List<VariableElement> fields = this.metadata.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            VariableElement field = fields.get(i);
            String fieldName = field.getSimpleName().toString();
            writer.emitStatement("stringBuilder.append(\"{%s:\")", new Object[]{fieldName});
            if (Utils.isRealmModel(field)) {
                String fieldTypeSimpleName = Utils.getFieldTypeSimpleName(field);
                writer.emitStatement("stringBuilder.append(%s() != null ? \"%s\" : \"null\")", new Object[]{this.metadata.getGetter(fieldName), fieldTypeSimpleName});
            } else if (Utils.isRealmList(field)) {
                String genericTypeSimpleName = Utils.getGenericTypeSimpleName(field);
                writer.emitStatement("stringBuilder.append(\"RealmList<%s>[\").append(%s().size()).append(\"]\")", new Object[]{genericTypeSimpleName, this.metadata.getGetter(fieldName)});
            } else if (this.metadata.isNullable(field)) {
                writer.emitStatement("stringBuilder.append(%s() != null ? %s() : \"null\")", new Object[]{this.metadata.getGetter(fieldName), this.metadata.getGetter(fieldName)});
            } else {
                writer.emitStatement("stringBuilder.append(%s())", new Object[]{this.metadata.getGetter(fieldName)});
            }
            writer.emitStatement("stringBuilder.append(\"}\")", new Object[0]);
            if (i >= fields.size() - 1) continue;
            writer.emitStatement("stringBuilder.append(\",\")", new Object[0]);
        }
        writer.emitStatement("stringBuilder.append(\"]\")", new Object[0]);
        writer.emitStatement("return stringBuilder.toString()", new Object[0]);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitHashcodeMethod(JavaWriter writer) throws IOException {
        if (this.metadata.containsHashCode()) {
            return;
        }
        writer.emitAnnotation("Override");
        writer.beginMethod("int", "hashCode", EnumSet.of(Modifier.PUBLIC), new String[0]);
        writer.emitStatement("String realmName = proxyState.getRealm$realm().getPath()", new Object[0]);
        writer.emitStatement("String tableName = proxyState.getRow$realm().getTable().getName()", new Object[0]);
        writer.emitStatement("long rowIndex = proxyState.getRow$realm().getIndex()", new Object[0]);
        writer.emitEmptyLine();
        writer.emitStatement("int result = 17", new Object[0]);
        writer.emitStatement("result = 31 * result + ((realmName != null) ? realmName.hashCode() : 0)", new Object[0]);
        writer.emitStatement("result = 31 * result + ((tableName != null) ? tableName.hashCode() : 0)", new Object[0]);
        writer.emitStatement("result = 31 * result + (int) (rowIndex ^ (rowIndex >>> 32))", new Object[0]);
        writer.emitStatement("return result", new Object[0]);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitEqualsMethod(JavaWriter writer) throws IOException {
        if (this.metadata.containsEquals()) {
            return;
        }
        String proxyClassName = Utils.getProxyClassName(this.simpleClassName);
        String otherObjectVarName = "a" + this.simpleClassName;
        writer.emitAnnotation("Override");
        writer.beginMethod("boolean", "equals", EnumSet.of(Modifier.PUBLIC), new String[]{"Object", "o"});
        writer.emitStatement("if (this == o) return true", new Object[0]);
        writer.emitStatement("if (o == null || getClass() != o.getClass()) return false", new Object[0]);
        writer.emitStatement("%s %s = (%s)o", new Object[]{proxyClassName, otherObjectVarName, proxyClassName});
        writer.emitEmptyLine();
        writer.emitStatement("String path = proxyState.getRealm$realm().getPath()", new Object[0]);
        writer.emitStatement("String otherPath = %s.proxyState.getRealm$realm().getPath()", new Object[]{otherObjectVarName});
        writer.emitStatement("if (path != null ? !path.equals(otherPath) : otherPath != null) return false", new Object[0]);
        writer.emitEmptyLine();
        writer.emitStatement("String tableName = proxyState.getRow$realm().getTable().getName()", new Object[0]);
        writer.emitStatement("String otherTableName = %s.proxyState.getRow$realm().getTable().getName()", new Object[]{otherObjectVarName});
        writer.emitStatement("if (tableName != null ? !tableName.equals(otherTableName) : otherTableName != null) return false", new Object[0]);
        writer.emitEmptyLine();
        writer.emitStatement("if (proxyState.getRow$realm().getIndex() != %s.proxyState.getRow$realm().getIndex()) return false", new Object[]{otherObjectVarName});
        writer.emitEmptyLine();
        writer.emitStatement("return true", new Object[0]);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitCreateOrUpdateUsingJsonObject(JavaWriter writer) throws IOException {
        writer.emitAnnotation("SuppressWarnings", (Object)"\"cast\"");
        writer.beginMethod(this.qualifiedClassName, "createOrUpdateUsingJsonObject", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC), Arrays.asList("Realm", "realm", "JSONObject", "json", "boolean", "update"), Collections.singletonList("JSONException"));
        int modelOrListCount = RealmProxyClassGenerator.countModelOrListFields(this.metadata.getFields());
        if (modelOrListCount == 0) {
            writer.emitStatement("final List<String> excludeFields = Collections.<String> emptyList()", new Object[0]);
        } else {
            writer.emitStatement("final List<String> excludeFields = new ArrayList<String>(%1$d)", new Object[]{modelOrListCount});
        }
        if (!this.metadata.hasPrimaryKey()) {
            this.buildExcludeFieldsList(writer, this.metadata.getFields());
            writer.emitStatement("%s obj = realm.createObjectInternal(%s.class, true, excludeFields)", new Object[]{this.qualifiedClassName, this.qualifiedClassName});
        } else {
            String pkType = Utils.isString(this.metadata.getPrimaryKey()) ? "String" : "Long";
            writer.emitStatement("%s obj = null", new Object[]{this.qualifiedClassName}).beginControlFlow("if (update)", new Object[0]).emitStatement("Table table = realm.getTable(%s.class)", new Object[]{this.qualifiedClassName}).emitStatement("long pkColumnIndex = table.getPrimaryKey()", new Object[0]).emitStatement("long rowIndex = TableOrView.NO_MATCH", new Object[0]);
            if (this.metadata.isNullable(this.metadata.getPrimaryKey())) {
                writer.beginControlFlow("if (json.isNull(\"%s\"))", new Object[]{this.metadata.getPrimaryKey().getSimpleName()}).emitStatement("rowIndex = table.findFirstNull(pkColumnIndex)", new Object[0]).nextControlFlow("else", new Object[0]).emitStatement("rowIndex = table.findFirst%s(pkColumnIndex, json.get%s(\"%s\"))", new Object[]{pkType, pkType, this.metadata.getPrimaryKey().getSimpleName()}).endControlFlow();
            } else {
                writer.beginControlFlow("if (!json.isNull(\"%s\"))", new Object[]{this.metadata.getPrimaryKey().getSimpleName()}).emitStatement("rowIndex = table.findFirst%s(pkColumnIndex, json.get%s(\"%s\"))", new Object[]{pkType, pkType, this.metadata.getPrimaryKey().getSimpleName()}).endControlFlow();
            }
            writer.beginControlFlow("if (rowIndex != TableOrView.NO_MATCH)", new Object[0]).emitStatement("final BaseRealm.RealmObjectContext objectContext = BaseRealm.objectContext.get()", new Object[0]).beginControlFlow("try", new Object[0]).emitStatement("objectContext.set(realm, table.getUncheckedRow(rowIndex), realm.schema.getColumnInfo(%s.class), false, Collections.<String> emptyList())", new Object[]{this.qualifiedClassName}).emitStatement("obj = new %s()", new Object[]{this.qualifiedGeneratedClassName}).nextControlFlow("finally", new Object[0]).emitStatement("objectContext.clear()", new Object[0]).endControlFlow().endControlFlow().endControlFlow();
            writer.beginControlFlow("if (obj == null)", new Object[0]);
            this.buildExcludeFieldsList(writer, this.metadata.getFields());
            String primaryKeyFieldType = this.metadata.getPrimaryKey().asType().toString();
            String primaryKeyFieldName = this.metadata.getPrimaryKey().getSimpleName().toString();
            RealmJsonTypeHelper.emitCreateObjectWithPrimaryKeyValue(this.qualifiedClassName, this.qualifiedGeneratedClassName, primaryKeyFieldType, primaryKeyFieldName, writer);
            writer.endControlFlow();
        }
        for (VariableElement field : this.metadata.getFields()) {
            String fieldName = field.getSimpleName().toString();
            String qualifiedFieldType = field.asType().toString();
            if (this.metadata.isPrimaryKey(field)) continue;
            if (Utils.isRealmModel(field)) {
                RealmJsonTypeHelper.emitFillRealmObjectWithJsonValue(this.interfaceName, this.metadata.getSetter(fieldName), fieldName, qualifiedFieldType, Utils.getProxyClassSimpleName(field), writer);
                continue;
            }
            if (Utils.isRealmList(field)) {
                RealmJsonTypeHelper.emitFillRealmListWithJsonValue(this.interfaceName, this.metadata.getGetter(fieldName), this.metadata.getSetter(fieldName), fieldName, ((DeclaredType)field.asType()).getTypeArguments().get(0).toString(), Utils.getProxyClassSimpleName(field), writer);
                continue;
            }
            RealmJsonTypeHelper.emitFillJavaTypeWithJsonValue(this.interfaceName, this.metadata.getSetter(fieldName), fieldName, qualifiedFieldType, writer);
        }
        writer.emitStatement("return obj", new Object[0]);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void buildExcludeFieldsList(JavaWriter writer, List<VariableElement> fields) throws IOException {
        for (VariableElement field : fields) {
            if (!Utils.isRealmModel(field) && !Utils.isRealmList(field)) continue;
            String fieldName = field.getSimpleName().toString();
            writer.beginControlFlow("if (json.has(\"%1$s\"))", new Object[]{fieldName}).emitStatement("excludeFields.add(\"%1$s\")", new Object[]{fieldName}).endControlFlow();
        }
    }

    private void emitCreateUsingJsonStream(JavaWriter writer) throws IOException {
        writer.emitAnnotation("SuppressWarnings", (Object)"\"cast\"");
        writer.emitAnnotation("TargetApi", (Object)"Build.VERSION_CODES.HONEYCOMB");
        writer.beginMethod(this.qualifiedClassName, "createUsingJsonStream", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC), Arrays.asList("Realm", "realm", "JsonReader", "reader"), Collections.singletonList("IOException"));
        if (this.metadata.hasPrimaryKey()) {
            writer.emitStatement("boolean jsonHasPrimaryKey = false", new Object[0]);
        }
        writer.emitStatement("%s obj = new %s()", new Object[]{this.qualifiedClassName, this.qualifiedClassName});
        writer.emitStatement("reader.beginObject()", new Object[0]);
        writer.beginControlFlow("while (reader.hasNext())", new Object[0]);
        writer.emitStatement("String name = reader.nextName()", new Object[0]);
        List<VariableElement> fields = this.metadata.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            VariableElement field = fields.get(i);
            String fieldName = field.getSimpleName().toString();
            String qualifiedFieldType = field.asType().toString();
            if (i == 0) {
                writer.beginControlFlow("if (name.equals(\"%s\"))", new Object[]{fieldName});
            } else {
                writer.nextControlFlow("else if (name.equals(\"%s\"))", new Object[]{fieldName});
            }
            if (Utils.isRealmModel(field)) {
                RealmJsonTypeHelper.emitFillRealmObjectFromStream(this.interfaceName, this.metadata.getSetter(fieldName), fieldName, qualifiedFieldType, Utils.getProxyClassSimpleName(field), writer);
                continue;
            }
            if (Utils.isRealmList(field)) {
                RealmJsonTypeHelper.emitFillRealmListFromStream(this.interfaceName, this.metadata.getGetter(fieldName), this.metadata.getSetter(fieldName), ((DeclaredType)field.asType()).getTypeArguments().get(0).toString(), Utils.getProxyClassSimpleName(field), writer);
                continue;
            }
            RealmJsonTypeHelper.emitFillJavaTypeFromStream(this.interfaceName, this.metadata, fieldName, qualifiedFieldType, writer);
        }
        if (fields.size() > 0) {
            writer.nextControlFlow("else", new Object[0]);
            writer.emitStatement("reader.skipValue()", new Object[0]);
            writer.endControlFlow();
        }
        writer.endControlFlow();
        writer.emitStatement("reader.endObject()", new Object[0]);
        if (this.metadata.hasPrimaryKey()) {
            writer.beginControlFlow("if (!jsonHasPrimaryKey)", new Object[0]);
            writer.emitStatement("throw new IllegalArgumentException(\"JSON object doesn't have the primary key field '%s'.\")", new Object[]{this.metadata.getPrimaryKey()});
            writer.endControlFlow();
        }
        writer.emitStatement("obj = realm.copyToRealm(obj)", new Object[0]);
        writer.emitStatement("return obj", new Object[0]);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private String columnInfoClassName() {
        return this.simpleClassName + "ColumnInfo";
    }

    private String columnIndexVarName(VariableElement variableElement) {
        return variableElement.getSimpleName().toString() + "Index";
    }

    private String fieldIndexVariableReference(VariableElement variableElement) {
        return "columnInfo." + this.columnIndexVarName(variableElement);
    }

    private static int countModelOrListFields(List<VariableElement> fields) {
        int count = 0;
        for (VariableElement f : fields) {
            if (!Utils.isRealmModel(f) && !Utils.isRealmList(f)) continue;
            ++count;
        }
        return count;
    }

    private static interface CodeEmitter {
        public void emit(JavaWriter var1) throws IOException;
    }
}

