/*
 * Decompiled with CFR 0.152.
 */
package io.realm.processor;

import com.squareup.javawriter.JavaWriter;
import io.realm.processor.ClassMetaData;
import io.realm.processor.Utils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class RealmJsonTypeHelper {
    private static final Map<String, JsonToRealmFieldTypeConverter> JAVA_TO_JSON_TYPES = new HashMap<String, JsonToRealmFieldTypeConverter>();

    public static void emitCreateObjectWithPrimaryKeyValue(String qualifiedRealmObjectClass, String qualifiedRealmObjectProxyClass, String qualifiedFieldType, String fieldName, JavaWriter writer) throws IOException {
        JsonToRealmFieldTypeConverter typeEmitter = JAVA_TO_JSON_TYPES.get(qualifiedFieldType);
        if (typeEmitter != null) {
            typeEmitter.emitGetObjectWithPrimaryKeyValue(qualifiedRealmObjectClass, qualifiedRealmObjectProxyClass, fieldName, writer);
        }
    }

    public static void emitFillJavaTypeWithJsonValue(String interfaceName, String setter, String fieldName, String qualifiedFieldType, JavaWriter writer) throws IOException {
        JsonToRealmFieldTypeConverter typeEmitter = JAVA_TO_JSON_TYPES.get(qualifiedFieldType);
        if (typeEmitter != null) {
            typeEmitter.emitTypeConversion(interfaceName, setter, fieldName, qualifiedFieldType, writer);
        }
    }

    public static void emitFillRealmObjectWithJsonValue(String interfaceName, String setter, String fieldName, String qualifiedFieldType, String proxyClass, JavaWriter writer) throws IOException {
        writer.beginControlFlow("if (json.has(\"%s\"))", new Object[]{fieldName}).beginControlFlow("if (json.isNull(\"%s\"))", new Object[]{fieldName}).emitStatement("((%s) obj).%s(null)", new Object[]{interfaceName, setter}).nextControlFlow("else", new Object[0]).emitStatement("%s %sObj = %s.createOrUpdateUsingJsonObject(realm, json.getJSONObject(\"%s\"), update)", new Object[]{qualifiedFieldType, fieldName, proxyClass, fieldName}).emitStatement("((%s) obj).%s(%sObj)", new Object[]{interfaceName, setter, fieldName}).endControlFlow().endControlFlow();
    }

    public static void emitFillRealmListWithJsonValue(String interfaceName, String getter, String setter, String fieldName, String fieldTypeCanonicalName, String proxyClass, JavaWriter writer) throws IOException {
        writer.beginControlFlow("if (json.has(\"%s\"))", new Object[]{fieldName}).beginControlFlow("if (json.isNull(\"%s\"))", new Object[]{fieldName}).emitStatement("((%s) obj).%s(null)", new Object[]{interfaceName, setter}).nextControlFlow("else", new Object[0]).emitStatement("((%s) obj).%s().clear()", new Object[]{interfaceName, getter}).emitStatement("JSONArray array = json.getJSONArray(\"%s\")", new Object[]{fieldName}).beginControlFlow("for (int i = 0; i < array.length(); i++)", new Object[0]).emitStatement("%s item = %s.createOrUpdateUsingJsonObject(realm, array.getJSONObject(i), update)", new Object[]{fieldTypeCanonicalName, proxyClass, fieldTypeCanonicalName}).emitStatement("((%s) obj).%s().add(item)", new Object[]{interfaceName, getter}).endControlFlow().endControlFlow().endControlFlow();
    }

    public static void emitFillJavaTypeFromStream(String interfaceName, ClassMetaData metaData, String fieldName, String fieldType, JavaWriter writer) throws IOException {
        String setter = metaData.getSetter(fieldName);
        boolean isPrimaryKey = false;
        if (metaData.hasPrimaryKey() && metaData.getPrimaryKey().getSimpleName().toString().equals(fieldName)) {
            isPrimaryKey = true;
        }
        if (JAVA_TO_JSON_TYPES.containsKey(fieldType)) {
            JAVA_TO_JSON_TYPES.get(fieldType).emitStreamTypeConversion(interfaceName, setter, fieldName, fieldType, writer, isPrimaryKey);
        }
    }

    public static void emitFillRealmObjectFromStream(String interfaceName, String setter, String fieldName, String fieldTypeCanonicalName, String proxyClass, JavaWriter writer) throws IOException {
        writer.beginControlFlow("if (reader.peek() == JsonToken.NULL)", new Object[0]).emitStatement("reader.skipValue()", new Object[0]).emitStatement("((%s) obj).%s(null)", new Object[]{interfaceName, setter}).nextControlFlow("else", new Object[0]).emitStatement("%s %sObj = %s.createUsingJsonStream(realm, reader)", new Object[]{fieldTypeCanonicalName, fieldName, proxyClass}).emitStatement("((%s) obj).%s(%sObj)", new Object[]{interfaceName, setter, fieldName}).endControlFlow();
    }

    public static void emitFillRealmListFromStream(String interfaceName, String getter, String setter, String fieldTypeCanonicalName, String proxyClass, JavaWriter writer) throws IOException {
        writer.beginControlFlow("if (reader.peek() == JsonToken.NULL)", new Object[0]).emitStatement("reader.skipValue()", new Object[0]).emitStatement("((%s) obj).%s(null)", new Object[]{interfaceName, setter}).nextControlFlow("else", new Object[0]).emitStatement("((%s) obj).%s(new RealmList<%s>())", new Object[]{interfaceName, setter, fieldTypeCanonicalName}).emitStatement("reader.beginArray()", new Object[0]).beginControlFlow("while (reader.hasNext())", new Object[0]).emitStatement("%s item = %s.createUsingJsonStream(realm, reader)", new Object[]{fieldTypeCanonicalName, proxyClass}).emitStatement("((%s) obj).%s().add(item)", new Object[]{interfaceName, getter}).endControlFlow().emitStatement("reader.endArray()", new Object[0]).endControlFlow();
    }

    static {
        JAVA_TO_JSON_TYPES.put("byte", new SimpleTypeConverter("byte", "Int"));
        JAVA_TO_JSON_TYPES.put("short", new SimpleTypeConverter("short", "Int"));
        JAVA_TO_JSON_TYPES.put("int", new SimpleTypeConverter("int", "Int"));
        JAVA_TO_JSON_TYPES.put("long", new SimpleTypeConverter("long", "Long"));
        JAVA_TO_JSON_TYPES.put("float", new SimpleTypeConverter("float", "Double"));
        JAVA_TO_JSON_TYPES.put("double", new SimpleTypeConverter("double", "Double"));
        JAVA_TO_JSON_TYPES.put("boolean", new SimpleTypeConverter("boolean", "Boolean"));
        JAVA_TO_JSON_TYPES.put("java.lang.Byte", new SimpleTypeConverter("byte", "Int"));
        JAVA_TO_JSON_TYPES.put("java.lang.Short", new SimpleTypeConverter("short", "Int"));
        JAVA_TO_JSON_TYPES.put("java.lang.Integer", new SimpleTypeConverter("int", "Int"));
        JAVA_TO_JSON_TYPES.put("java.lang.Long", new SimpleTypeConverter("long", "Long"));
        JAVA_TO_JSON_TYPES.put("java.lang.Float", new SimpleTypeConverter("float", "Double"));
        JAVA_TO_JSON_TYPES.put("java.lang.Double", new SimpleTypeConverter("double", "Double"));
        JAVA_TO_JSON_TYPES.put("java.lang.Boolean", new SimpleTypeConverter("boolean", "Boolean"));
        JAVA_TO_JSON_TYPES.put("java.lang.String", new SimpleTypeConverter("String", "String"));
        JAVA_TO_JSON_TYPES.put("java.util.Date", new JsonToRealmFieldTypeConverter(){

            @Override
            public void emitTypeConversion(String interfaceName, String setter, String fieldName, String fieldType, JavaWriter writer) throws IOException {
                writer.beginControlFlow("if (json.has(\"%s\"))", new Object[]{fieldName}).beginControlFlow("if (json.isNull(\"%s\"))", new Object[]{fieldName}).emitStatement("((%s) obj).%s(null)", new Object[]{interfaceName, setter}).nextControlFlow("else", new Object[0]).emitStatement("Object timestamp = json.get(\"%s\")", new Object[]{fieldName}).beginControlFlow("if (timestamp instanceof String)", new Object[0]).emitStatement("((%s) obj).%s(JsonUtils.stringToDate((String) timestamp))", new Object[]{interfaceName, setter}).nextControlFlow("else", new Object[0]).emitStatement("((%s) obj).%s(new Date(json.getLong(\"%s\")))", new Object[]{interfaceName, setter, fieldName}).endControlFlow().endControlFlow().endControlFlow();
            }

            @Override
            public void emitStreamTypeConversion(String interfaceName, String setter, String fieldName, String fieldType, JavaWriter writer, boolean isPrimaryKey) throws IOException {
                writer.beginControlFlow("if (reader.peek() == JsonToken.NULL)", new Object[0]).emitStatement("reader.skipValue()", new Object[0]).emitStatement("((%s) obj).%s(null)", new Object[]{interfaceName, setter}).nextControlFlow("else if (reader.peek() == JsonToken.NUMBER)", new Object[0]).emitStatement("long timestamp = reader.nextLong()", new Object[]{fieldName}).beginControlFlow("if (timestamp > -1)", new Object[0]).emitStatement("((%s) obj).%s(new Date(timestamp))", new Object[]{interfaceName, setter}).endControlFlow().nextControlFlow("else", new Object[0]).emitStatement("((%s) obj).%s(JsonUtils.stringToDate(reader.nextString()))", new Object[]{interfaceName, setter}).endControlFlow();
            }

            @Override
            public void emitGetObjectWithPrimaryKeyValue(String qualifiedRealmObjectClass, String qualifiedRealmObjectProxyClass, String fieldName, JavaWriter writer) throws IOException {
                throw new IllegalArgumentException("'Date' is not allowed as a primary key value.");
            }
        });
        JAVA_TO_JSON_TYPES.put("byte[]", new JsonToRealmFieldTypeConverter(){

            @Override
            public void emitTypeConversion(String interfaceName, String setter, String fieldName, String fieldType, JavaWriter writer) throws IOException {
                writer.beginControlFlow("if (json.has(\"%s\"))", new Object[]{fieldName}).beginControlFlow("if (json.isNull(\"%s\"))", new Object[]{fieldName}).emitStatement("((%s) obj).%s(null)", new Object[]{interfaceName, setter}).nextControlFlow("else", new Object[0]).emitStatement("((%s) obj).%s(JsonUtils.stringToBytes(json.getString(\"%s\")))", new Object[]{interfaceName, setter, fieldName}).endControlFlow().endControlFlow();
            }

            @Override
            public void emitStreamTypeConversion(String interfaceName, String setter, String fieldName, String fieldType, JavaWriter writer, boolean isPrimaryKey) throws IOException {
                writer.beginControlFlow("if (reader.peek() == JsonToken.NULL)", new Object[0]).emitStatement("reader.skipValue()", new Object[0]).emitStatement("((%s) obj).%s(null)", new Object[]{interfaceName, setter}).nextControlFlow("else", new Object[0]).emitStatement("((%s) obj).%s(JsonUtils.stringToBytes(reader.nextString()))", new Object[]{interfaceName, setter}).endControlFlow();
            }

            @Override
            public void emitGetObjectWithPrimaryKeyValue(String qualifiedRealmObjectClass, String qualifiedRealmObjectProxyClass, String fieldName, JavaWriter writer) throws IOException {
                throw new IllegalArgumentException("'byte[]' is not allowed as a primary key value.");
            }
        });
    }

    private static interface JsonToRealmFieldTypeConverter {
        public void emitTypeConversion(String var1, String var2, String var3, String var4, JavaWriter var5) throws IOException;

        public void emitStreamTypeConversion(String var1, String var2, String var3, String var4, JavaWriter var5, boolean var6) throws IOException;

        public void emitGetObjectWithPrimaryKeyValue(String var1, String var2, String var3, JavaWriter var4) throws IOException;
    }

    private static class SimpleTypeConverter
    implements JsonToRealmFieldTypeConverter {
        private final String castType;
        private final String jsonType;

        private SimpleTypeConverter(String castType, String jsonType) {
            this.castType = castType;
            this.jsonType = jsonType;
        }

        @Override
        public void emitTypeConversion(String interfaceName, String setter, String fieldName, String fieldType, JavaWriter writer) throws IOException {
            String statementSetNullOrThrow = Utils.isPrimitiveType(fieldType) ? String.format("throw new IllegalArgumentException(\"Trying to set non-nullable field '%s' to null.\")", fieldName) : String.format("((%s) obj).%s(null)", interfaceName, setter);
            writer.beginControlFlow("if (json.has(\"%s\"))", new Object[]{fieldName}).beginControlFlow("if (json.isNull(\"%s\"))", new Object[]{fieldName}).emitStatement(statementSetNullOrThrow, new Object[0]).nextControlFlow("else", new Object[0]).emitStatement("((%s) obj).%s((%s) json.get%s(\"%s\"))", new Object[]{interfaceName, setter, this.castType, this.jsonType, fieldName}).endControlFlow().endControlFlow();
        }

        @Override
        public void emitStreamTypeConversion(String interfaceName, String setter, String fieldName, String fieldType, JavaWriter writer, boolean isPrimaryKey) throws IOException {
            String statementSetNullOrThrow = Utils.isPrimitiveType(fieldType) ? String.format("throw new IllegalArgumentException(\"Trying to set non-nullable field '%s' to null.\")", fieldName) : String.format("((%s) obj).%s(null)", interfaceName, setter);
            writer.beginControlFlow("if (reader.peek() == JsonToken.NULL)", new Object[0]).emitStatement("reader.skipValue()", new Object[0]).emitStatement(statementSetNullOrThrow, new Object[0]).nextControlFlow("else", new Object[0]).emitStatement("((%s) obj).%s((%s) reader.next%s())", new Object[]{interfaceName, setter, this.castType, this.jsonType}).endControlFlow();
            if (isPrimaryKey) {
                writer.emitStatement("jsonHasPrimaryKey = true", new Object[0]);
            }
        }

        @Override
        public void emitGetObjectWithPrimaryKeyValue(String qualifiedRealmObjectClass, String qualifiedRealmObjectProxyClass, String fieldName, JavaWriter writer) throws IOException {
            writer.beginControlFlow("if (json.has(\"%s\"))", new Object[]{fieldName}).beginControlFlow("if (json.isNull(\"%s\"))", new Object[]{fieldName}).emitStatement("obj = (%1$s) realm.createObjectInternal(%2$s.class, null, true, excludeFields)", new Object[]{qualifiedRealmObjectProxyClass, qualifiedRealmObjectClass}).nextControlFlow("else", new Object[0]).emitStatement("obj = (%1$s) realm.createObjectInternal(%2$s.class, json.get%3$s(\"%4$s\"), true, excludeFields)", new Object[]{qualifiedRealmObjectProxyClass, qualifiedRealmObjectClass, this.jsonType, fieldName}).endControlFlow().nextControlFlow("else", new Object[0]).emitStatement("throw new IllegalArgumentException(\"JSON object doesn't have the primary key field '%s'.\")", new Object[]{fieldName}).endControlFlow();
        }
    }
}

