/*
 * Decompiled with CFR 0.152.
 */
package io.realm.processor;

import io.realm.annotations.Ignore;
import io.realm.annotations.Index;
import io.realm.annotations.PrimaryKey;
import io.realm.annotations.Required;
import io.realm.processor.Constants;
import io.realm.processor.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class ClassMetaData {
    private final TypeElement classType;
    private String className;
    private String packageName;
    private boolean hasDefaultConstructor;
    private VariableElement primaryKey;
    private List<VariableElement> fields = new ArrayList<VariableElement>();
    private List<VariableElement> indexedFields = new ArrayList<VariableElement>();
    private Set<VariableElement> nullableFields = new HashSet<VariableElement>();
    private boolean containsToString;
    private boolean containsEquals;
    private boolean containsHashCode;
    private final List<TypeMirror> validPrimaryKeyTypes;
    private final Types typeUtils;
    private final Elements elements;

    public ClassMetaData(ProcessingEnvironment env, TypeElement clazz) {
        this.classType = clazz;
        this.className = clazz.getSimpleName().toString();
        this.typeUtils = env.getTypeUtils();
        this.elements = env.getElementUtils();
        TypeMirror stringType = env.getElementUtils().getTypeElement("java.lang.String").asType();
        this.validPrimaryKeyTypes = Arrays.asList(stringType, this.typeUtils.getPrimitiveType(TypeKind.SHORT), this.typeUtils.getPrimitiveType(TypeKind.INT), this.typeUtils.getPrimitiveType(TypeKind.LONG), this.typeUtils.getPrimitiveType(TypeKind.BYTE));
        for (Element element : this.classType.getEnclosedElements()) {
            if (!(element instanceof ExecutableElement)) continue;
            Name name = element.getSimpleName();
            if (name.contentEquals("toString")) {
                this.containsToString = true;
                continue;
            }
            if (name.contentEquals("equals")) {
                this.containsEquals = true;
                continue;
            }
            if (!name.contentEquals("hashCode")) continue;
            this.containsHashCode = true;
        }
    }

    public boolean generate() {
        Element enclosingElement = this.classType.getEnclosingElement();
        if (!enclosingElement.getKind().equals((Object)ElementKind.PACKAGE)) {
            Utils.error("The RealmClass annotation does not support nested classes", this.classType);
            return false;
        }
        TypeElement parentElement = (TypeElement)Utils.getSuperClass(this.classType);
        if (!parentElement.toString().equals("java.lang.Object") && !parentElement.toString().equals("io.realm.RealmObject")) {
            Utils.error("Realm model classes must either extend RealmObject or implement RealmModel to be considered a valid model class", this.classType);
            return false;
        }
        PackageElement packageElement = (PackageElement)enclosingElement;
        this.packageName = packageElement.getQualifiedName().toString();
        if (!this.categorizeClassElements()) {
            return false;
        }
        if (!this.checkListTypes()) {
            return false;
        }
        if (!this.checkReferenceTypes()) {
            return false;
        }
        if (!this.checkDefaultConstructor()) {
            return false;
        }
        if (!this.checkForFinalFields()) {
            return false;
        }
        if (!this.checkForTransientFields()) {
            return false;
        }
        return this.checkForVolatileFields();
    }

    private boolean checkForTransientFields() {
        for (VariableElement field : this.fields) {
            if (!field.getModifiers().contains((Object)Modifier.TRANSIENT)) continue;
            Utils.error("Transient fields are not allowed. Class: " + this.className + ", Field: " + field.getSimpleName().toString());
            return false;
        }
        return true;
    }

    private boolean checkForVolatileFields() {
        for (VariableElement field : this.fields) {
            if (!field.getModifiers().contains((Object)Modifier.VOLATILE)) continue;
            Utils.error("Volatile fields are not allowed. Class: " + this.className + ", Field: " + field.getSimpleName().toString());
            return false;
        }
        return true;
    }

    private boolean checkForFinalFields() {
        for (VariableElement field : this.fields) {
            if (!field.getModifiers().contains((Object)Modifier.FINAL)) continue;
            Utils.error("Final fields are not allowed. Class: " + this.className + ", Field: " + field.getSimpleName().toString());
            return false;
        }
        return true;
    }

    private boolean checkListTypes() {
        for (VariableElement field : this.fields) {
            if (!Utils.isRealmList(field)) continue;
            if (Utils.getGenericTypeQualifiedName(field) == null) {
                Utils.error("No generic type supplied for field", field);
                return false;
            }
            TypeMirror fieldType = field.asType();
            List<? extends TypeMirror> typeArguments = ((DeclaredType)fieldType).getTypeArguments();
            String genericCanonicalType = typeArguments.get(0).toString();
            TypeElement typeElement = this.elements.getTypeElement(genericCanonicalType);
            if (typeElement.getSuperclass().getKind() != TypeKind.NONE) continue;
            Utils.error("Only concrete Realm classes are allowed in RealmLists. Neither interfaces nor abstract classes can be used.", field);
            return false;
        }
        return true;
    }

    private boolean checkReferenceTypes() {
        for (VariableElement field : this.fields) {
            TypeElement typeElement;
            if (!Utils.isRealmModel(field) || (typeElement = this.elements.getTypeElement(field.asType().toString())).getSuperclass().getKind() != TypeKind.NONE) continue;
            Utils.error("Only concrete Realm classes can be referenced in model classes. Neither interfaces nor abstract classes can be used.", field);
            return false;
        }
        return true;
    }

    private boolean checkDefaultConstructor() {
        if (!this.hasDefaultConstructor) {
            Utils.error("A default public constructor with no argument must be declared if a custom constructor is declared.");
            return false;
        }
        return true;
    }

    private boolean categorizeClassElements() {
        for (Element element : this.classType.getEnclosedElements()) {
            ElementKind elementKind = element.getKind();
            if (elementKind.equals((Object)ElementKind.FIELD)) {
                VariableElement variableElement = (VariableElement)element;
                Set<Modifier> modifiers = variableElement.getModifiers();
                if (modifiers.contains((Object)Modifier.STATIC) || variableElement.getAnnotation(Ignore.class) != null) continue;
                if (variableElement.getAnnotation(Index.class) != null) {
                    String elementTypeCanonicalName = variableElement.asType().toString();
                    String columnType = Constants.JAVA_TO_COLUMN_TYPES.get(elementTypeCanonicalName);
                    if (columnType != null && (columnType.equals("RealmFieldType.STRING") || columnType.equals("RealmFieldType.DATE") || columnType.equals("RealmFieldType.INTEGER") || columnType.equals("RealmFieldType.BOOLEAN"))) {
                        this.indexedFields.add(variableElement);
                    } else {
                        Utils.error("@Index is not applicable to this field " + element + ".");
                        return false;
                    }
                }
                if (variableElement.getAnnotation(Required.class) == null) {
                    if (!Utils.isPrimitiveType(variableElement) && !Utils.isRealmList(variableElement)) {
                        this.nullableFields.add(variableElement);
                    }
                } else if (Utils.isPrimitiveType(variableElement)) {
                    Utils.error("@Required is not needed for field " + element + " with the type " + element.asType());
                } else if (Utils.isRealmList(variableElement)) {
                    Utils.error("@Required is invalid for field " + element + " with the type " + element.asType());
                } else if (Utils.isRealmModel(variableElement)) {
                    Utils.error("@Required is invalid for field " + element + " with the type " + element.asType());
                } else if (this.nullableFields.contains(variableElement)) {
                    Utils.error("Annotated field " + element + " with type " + element.asType() + " has been added to the nullableFields before. Consider to remove @Required.");
                }
                if (variableElement.getAnnotation(PrimaryKey.class) != null) {
                    if (this.primaryKey != null) {
                        Utils.error(String.format("@PrimaryKey cannot be defined more than once. It was found here \"%s\" and here \"%s\"", this.primaryKey.getSimpleName().toString(), variableElement.getSimpleName().toString()));
                        return false;
                    }
                    TypeMirror fieldType = variableElement.asType();
                    if (!this.isValidPrimaryKeyType(fieldType)) {
                        Utils.error("\"" + variableElement.getSimpleName().toString() + "\" is not allowed as primary key. See @PrimaryKey for allowed types.");
                        return false;
                    }
                    this.primaryKey = variableElement;
                    if (!this.indexedFields.contains(variableElement)) {
                        this.indexedFields.add(variableElement);
                    }
                }
                this.fields.add(variableElement);
                continue;
            }
            if (!elementKind.equals((Object)ElementKind.CONSTRUCTOR)) continue;
            this.hasDefaultConstructor = this.hasDefaultConstructor || Utils.isDefaultConstructor(element);
        }
        if (this.fields.size() == 0) {
            Utils.error(this.className + " must contain at least 1 persistable field");
        }
        return true;
    }

    public String getSimpleClassName() {
        return this.className;
    }

    public boolean isModelClass() {
        String type = this.classType.toString();
        if (type.equals("io.realm.dynamic.DynamicRealmObject")) {
            return false;
        }
        return !type.endsWith(".RealmObject") && !type.endsWith("RealmProxy");
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getFullyQualifiedClassName() {
        return this.packageName + "." + this.className;
    }

    public List<VariableElement> getFields() {
        return this.fields;
    }

    public String getGetter(String fieldName) {
        return "realmGet$" + fieldName;
    }

    public String getSetter(String fieldName) {
        return "realmSet$" + fieldName;
    }

    public List<VariableElement> getIndexedFields() {
        return this.indexedFields;
    }

    public boolean hasPrimaryKey() {
        return this.primaryKey != null;
    }

    public VariableElement getPrimaryKey() {
        return this.primaryKey;
    }

    public String getPrimaryKeyGetter() {
        return this.getGetter(this.primaryKey.getSimpleName().toString());
    }

    public boolean isNullable(VariableElement variableElement) {
        return this.nullableFields.contains(variableElement);
    }

    public boolean isIndexed(VariableElement variableElement) {
        return this.indexedFields.contains(variableElement);
    }

    public boolean isPrimaryKey(VariableElement variableElement) {
        if (this.primaryKey == null) {
            return false;
        }
        return this.primaryKey.equals(variableElement);
    }

    private boolean isValidPrimaryKeyType(TypeMirror type) {
        for (TypeMirror validType : this.validPrimaryKeyTypes) {
            if (!this.typeUtils.isAssignable(type, validType)) continue;
            return true;
        }
        return false;
    }

    public boolean containsToString() {
        return this.containsToString;
    }

    public boolean containsEquals() {
        return this.containsEquals;
    }

    public boolean containsHashCode() {
        return this.containsHashCode;
    }
}

