/*
 * Decompiled with CFR 0.152.
 */
package io.realm.processor;

import io.realm.annotations.RealmClass;
import io.realm.annotations.RealmModule;
import io.realm.processor.Backlink;
import io.realm.processor.ClassCollection;
import io.realm.processor.ClassMetaData;
import io.realm.processor.DefaultModuleGenerator;
import io.realm.processor.ModuleMetaData;
import io.realm.processor.QualifiedClassName;
import io.realm.processor.RealmFieldElement;
import io.realm.processor.RealmProxyClassGenerator;
import io.realm.processor.RealmProxyInterfaceGenerator;
import io.realm.processor.RealmProxyMediatorGenerator;
import io.realm.processor.RealmVersionChecker;
import io.realm.processor.SimpleClassName;
import io.realm.processor.TypeMirrors;
import io.realm.processor.Utils;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SupportedAnnotationTypes(value={"io.realm.annotations.RealmClass", "io.realm.annotations.RealmField", "io.realm.annotations.Ignore", "io.realm.annotations.Index", "io.realm.annotations.PrimaryKey", "io.realm.annotations.RealmModule", "io.realm.annotations.Required"})
@SupportedOptions(value={"realm.suppressWarnings", "realm.ignoreKotlinNullability"})
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0012\u001a\u00020\u0004H\u0002J(\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u0004H\u0002J\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u0004H\u0002J\u0010\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020$H\u0002J\u001e\u0010%\u001a\u00020\u00042\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u00172\u0006\u0010#\u001a\u00020$H\u0016J\u0018\u0010(\u001a\u00020\u00042\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010)\u001a\u00020\u0004H\u0002J\b\u0010*\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006+"}, d2={"Lio/realm/processor/RealmProcessor;", "Ljavax/annotation/processing/AbstractProcessor;", "()V", "ABORT", "", "CONSUME_ANNOTATIONS", "backlinksToValidate", "Ljava/util/HashSet;", "Lio/realm/processor/Backlink;", "classCollection", "Lio/realm/processor/ClassCollection;", "hasProcessedModules", "moduleMetaData", "Lio/realm/processor/ModuleMetaData;", "realmModelSetsToValidate", "Lio/realm/processor/RealmFieldElement;", "round", "", "createDefaultModule", "createMediator", "moduleName", "Lio/realm/processor/SimpleClassName;", "moduleClasses", "", "Lio/realm/processor/ClassMetaData;", "createMediator-0LtIoU0", "(Ljava/lang/String;Ljava/util/Set;)Z", "createModuleFiles", "createProxyClassFiles", "typeMirrors", "Lio/realm/processor/TypeMirrors;", "getSupportedSourceVersion", "Ljavax/lang/model/SourceVersion;", "postProcessModules", "preProcessModules", "roundEnv", "Ljavax/annotation/processing/RoundEnvironment;", "process", "annotations", "Ljavax/lang/model/element/TypeElement;", "processClassAnnotations", "validateBacklinks", "validateRealmModelSets", "realm-annotations-processor"})
public final class RealmProcessor
extends AbstractProcessor {
    private final boolean CONSUME_ANNOTATIONS = false;
    private final boolean ABORT = true;
    private final ClassCollection classCollection = new ClassCollection();
    private ModuleMetaData moduleMetaData;
    private final HashSet<Backlink> backlinksToValidate = new HashSet();
    private final HashSet<RealmFieldElement> realmModelSetsToValidate = new HashSet();
    private boolean hasProcessedModules;
    private int round = -1;

    @Override
    @NotNull
    public SourceVersion getSupportedSourceVersion() {
        SourceVersion sourceVersion = SourceVersion.latestSupported();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)sourceVersion), (String)"SourceVersion.latestSupported()");
        return sourceVersion;
    }

    @Override
    public boolean process(@NotNull Set<? extends TypeElement> annotations, @NotNull RoundEnvironment roundEnv) {
        Intrinsics.checkParameterIsNotNull(annotations, (String)"annotations");
        Intrinsics.checkParameterIsNotNull((Object)roundEnv, (String)"roundEnv");
        int n = this.round;
        this.round = n + 1;
        if (this.round == 0) {
            ProcessingEnvironment processingEnvironment = this.processingEnv;
            Intrinsics.checkExpressionValueIsNotNull((Object)processingEnvironment, (String)"processingEnv");
            RealmVersionChecker.Companion.getInstance(processingEnvironment).executeRealmVersionUpdate();
        }
        if (roundEnv.errorRaised()) {
            return this.ABORT;
        }
        if (!this.hasProcessedModules) {
            ProcessingEnvironment processingEnvironment = this.processingEnv;
            Intrinsics.checkExpressionValueIsNotNull((Object)processingEnvironment, (String)"processingEnv");
            Utils.INSTANCE.initialize(processingEnvironment);
            ProcessingEnvironment processingEnvironment2 = this.processingEnv;
            Intrinsics.checkExpressionValueIsNotNull((Object)processingEnvironment2, (String)"processingEnv");
            TypeMirrors typeMirrors = new TypeMirrors(processingEnvironment2);
            if (!this.preProcessModules(roundEnv)) {
                return this.ABORT;
            }
            if (!this.processClassAnnotations(roundEnv, typeMirrors)) {
                return this.ABORT;
            }
            if (!this.postProcessModules()) {
                return this.ABORT;
            }
            if (!this.validateBacklinks()) {
                return this.ABORT;
            }
            if (!this.validateRealmModelSets()) {
                return this.ABORT;
            }
            this.hasProcessedModules = true;
            if (!this.createProxyClassFiles(typeMirrors)) {
                return this.ABORT;
            }
            if (!this.createModuleFiles()) {
                return this.ABORT;
            }
        }
        return this.CONSUME_ANNOTATIONS;
    }

    private final boolean processClassAnnotations(RoundEnvironment roundEnv, TypeMirrors typeMirrors) {
        Iterator<? extends Element> iterator = roundEnv.getElementsAnnotatedWith(RealmClass.class).iterator();
        while (iterator.hasNext()) {
            Element classElement;
            Element element = classElement = iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"classElement");
            if (!Utils.INSTANCE.isImplementingMarkerInterface(element)) {
                Utils.INSTANCE.error("A RealmClass annotated object must implement RealmModel or derive from RealmObject.", classElement);
                return false;
            }
            if (classElement.getKind() != ElementKind.CLASS) {
                Utils.INSTANCE.error("The RealmClass annotation can only be applied to classes.", classElement);
                return false;
            }
            ProcessingEnvironment processingEnvironment = this.processingEnv;
            Intrinsics.checkExpressionValueIsNotNull((Object)processingEnvironment, (String)"processingEnv");
            ClassMetaData metadata = new ClassMetaData(processingEnvironment, typeMirrors, (TypeElement)classElement);
            if (!metadata.isModelClass()) continue;
            Utils.INSTANCE.note("Processing class " + SimpleClassName.toString-impl(metadata.getSimpleJavaClassName()));
            ModuleMetaData moduleMetaData = this.moduleMetaData;
            if (moduleMetaData == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"moduleMetaData");
            }
            if (!metadata.generate(moduleMetaData)) {
                return false;
            }
            this.classCollection.addClass(metadata);
            this.backlinksToValidate.addAll((Collection<Backlink>)metadata.getBacklinkFields());
            this.realmModelSetsToValidate.addAll((Collection<RealmFieldElement>)metadata.getRealmModelSetFields());
        }
        return true;
    }

    private final boolean preProcessModules(RoundEnvironment roundEnv) {
        ModuleMetaData moduleMetaData = this.moduleMetaData = new ModuleMetaData();
        if (moduleMetaData == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"moduleMetaData");
        }
        Set<? extends Element> set = roundEnv.getElementsAnnotatedWith(RealmModule.class);
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"roundEnv.getElementsAnno\u2026(RealmModule::class.java)");
        return moduleMetaData.preProcess(set);
    }

    private final boolean postProcessModules() {
        ModuleMetaData moduleMetaData = this.moduleMetaData;
        if (moduleMetaData == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"moduleMetaData");
        }
        return moduleMetaData.postProcess(this.classCollection);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean createModuleFiles() {
        ModuleMetaData moduleMetaData = this.moduleMetaData;
        if (moduleMetaData == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"moduleMetaData");
        }
        if (moduleMetaData.shouldCreateDefaultModule() && !this.createDefaultModule()) {
            return false;
        }
        ModuleMetaData moduleMetaData2 = this.moduleMetaData;
        if (moduleMetaData2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"moduleMetaData");
        }
        Object object = moduleMetaData2.getAllModules();
        boolean bl = false;
        Iterator<Map.Entry<QualifiedClassName, Set<ClassMetaData>>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            void key;
            Map.Entry<QualifiedClassName, Set<ClassMetaData>> entry;
            Map.Entry<QualifiedClassName, Set<ClassMetaData>> entry2 = entry = iterator.next();
            boolean bl2 = false;
            object = entry2.getKey().unbox-impl();
            entry2 = entry;
            bl2 = false;
            Set<ClassMetaData> value = entry2.getValue();
            if (this.createMediator-0LtIoU0(QualifiedClassName.getSimpleName-impl((String)key), value)) continue;
            return false;
        }
        return true;
    }

    private final boolean createProxyClassFiles(TypeMirrors typeMirrors) {
        for (ClassMetaData metadata : this.classCollection.getClasses()) {
            ProcessingEnvironment processingEnvironment = this.processingEnv;
            Intrinsics.checkExpressionValueIsNotNull((Object)processingEnvironment, (String)"processingEnv");
            RealmProxyInterfaceGenerator interfaceGenerator = new RealmProxyInterfaceGenerator(processingEnvironment, metadata);
            try {
                interfaceGenerator.generate();
            }
            catch (IOException e) {
                Utils.INSTANCE.error(e.getMessage(), metadata.getClassElement());
                return false;
            }
            ProcessingEnvironment processingEnvironment2 = this.processingEnv;
            Intrinsics.checkExpressionValueIsNotNull((Object)processingEnvironment2, (String)"processingEnv");
            RealmProxyClassGenerator sourceCodeGenerator = new RealmProxyClassGenerator(processingEnvironment2, typeMirrors, metadata, this.classCollection);
            try {
                sourceCodeGenerator.generate();
            }
            catch (IOException e) {
                Utils.INSTANCE.error(e.getMessage(), metadata.getClassElement());
                return false;
            }
            catch (UnsupportedOperationException e) {
                Utils.INSTANCE.error(e.getMessage(), metadata.getClassElement());
                return false;
            }
        }
        return true;
    }

    private final boolean createDefaultModule() {
        Utils.INSTANCE.note("Creating DefaultRealmModule");
        ProcessingEnvironment processingEnvironment = this.processingEnv;
        Intrinsics.checkExpressionValueIsNotNull((Object)processingEnvironment, (String)"processingEnv");
        DefaultModuleGenerator defaultModuleGenerator = new DefaultModuleGenerator(processingEnvironment);
        try {
            defaultModuleGenerator.generate();
        }
        catch (IOException e) {
            Utils.INSTANCE.error(e.getMessage());
            return false;
        }
        return true;
    }

    private final boolean createMediator-0LtIoU0(String moduleName, Set<ClassMetaData> moduleClasses) {
        ProcessingEnvironment processingEnvironment = this.processingEnv;
        Intrinsics.checkExpressionValueIsNotNull((Object)processingEnvironment, (String)"processingEnv");
        RealmProxyMediatorGenerator mediatorImplGenerator = new RealmProxyMediatorGenerator(processingEnvironment, moduleName, moduleClasses, null);
        try {
            mediatorImplGenerator.generate();
        }
        catch (IOException e) {
            Utils.INSTANCE.error(e.getMessage());
            return false;
        }
        return true;
    }

    private final boolean validateBacklinks() {
        boolean allValid = true;
        for (Backlink backlink : this.backlinksToValidate) {
            ClassMetaData clazz;
            if (!this.classCollection.containsQualifiedClass-hqUMHY8(backlink.getSourceClass())) continue;
            String string = backlink.getSourceClass();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            if (backlink.validateTarget(clazz = this.classCollection.getClassFromQualifiedName-omp8SrQ(string)) || !allValid) continue;
            allValid = false;
        }
        return allValid;
    }

    private final boolean validateRealmModelSets() {
        boolean allValid = true;
        for (RealmFieldElement field : this.realmModelSetsToValidate) {
            TypeMirror genericType;
            TypeMirror typeMirror = field.asType();
            if (typeMirror == null) {
                throw new TypeCastException("null cannot be cast to non-null type javax.lang.model.type.DeclaredType");
            }
            String genericClassName = ((DeclaredType)typeMirror).getTypeArguments().toString();
            ProcessingEnvironment processingEnvironment = this.processingEnv;
            Intrinsics.checkExpressionValueIsNotNull((Object)processingEnvironment, (String)"processingEnv");
            TypeMirror typeMirror2 = genericType = processingEnvironment.getElementUtils().getTypeElement(genericClassName).asType();
            Intrinsics.checkExpressionValueIsNotNull((Object)typeMirror2, (String)"genericType");
            boolean embedded = Utils.INSTANCE.isFieldTypeEmbedded(typeMirror2, this.classCollection);
            if (!embedded || !allValid) continue;
            Utils.INSTANCE.error("RealmSets field " + field.getJavaName() + " at " + field.getFieldReference() + " do not support embedded objects.");
            allValid = false;
        }
        return allValid;
    }
}

