/*
 * Decompiled with CFR 0.152.
 */
package io.realm.processor;

import com.squareup.javawriter.JavaWriter;
import io.realm.annotations.Ignore;
import io.realm.processor.Backlink;
import io.realm.processor.ClassMetaData;
import io.realm.processor.RealmFieldElement;
import io.realm.processor.SimpleClassName;
import io.realm.processor.Utils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.tools.JavaFileObject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\n\u001a\u00020\u000bR\u0019\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\f"}, d2={"Lio/realm/processor/RealmProxyInterfaceGenerator;", "", "processingEnvironment", "Ljavax/annotation/processing/ProcessingEnvironment;", "metaData", "Lio/realm/processor/ClassMetaData;", "(Ljavax/annotation/processing/ProcessingEnvironment;Lio/realm/processor/ClassMetaData;)V", "className", "Lio/realm/processor/QualifiedClassName;", "Ljava/lang/String;", "generate", "", "realm-annotations-processor"})
public final class RealmProxyInterfaceGenerator {
    @NotNull
    private final ProcessingEnvironment processingEnvironment;
    @NotNull
    private final ClassMetaData metaData;
    @NotNull
    private final String className;

    public RealmProxyInterfaceGenerator(@NotNull ProcessingEnvironment processingEnvironment, @NotNull ClassMetaData metaData) {
        Intrinsics.checkNotNullParameter((Object)processingEnvironment, (String)"processingEnvironment");
        Intrinsics.checkNotNullParameter((Object)metaData, (String)"metaData");
        this.processingEnvironment = processingEnvironment;
        this.metaData = metaData;
        this.className = this.metaData.getQualifiedClassName-AzxYXdY();
    }

    public final void generate() throws IOException {
        Locale locale = Locale.US;
        String string = "%s.%s";
        Object[] objectArray = new Object[]{"io.realm", SimpleClassName.box-impl(Utils.INSTANCE.getProxyInterfaceName-V1j68-E(this.className))};
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, format, *args)");
        String qualifiedGeneratedInterfaceName = string2;
        JavaFileObject sourceFile = this.processingEnvironment.getFiler().createSourceFile(qualifiedGeneratedInterfaceName, new Element[0]);
        Writer writer = sourceFile.openWriter();
        Intrinsics.checkNotNull((Object)writer);
        JavaWriter writer2 = new JavaWriter((Writer)new BufferedWriter(writer));
        String $this$generate_u24lambda_u2d0 = string = writer2;
        boolean bl = false;
        $this$generate_u24lambda_u2d0.setIndent("    ");
        $this$generate_u24lambda_u2d0.emitPackage("io.realm");
        $this$generate_u24lambda_u2d0.emitEmptyLine();
        $this$generate_u24lambda_u2d0.beginType(qualifiedGeneratedInterfaceName, "interface", (Set)EnumSet.of((Enum)Modifier.PUBLIC));
        for (RealmFieldElement field : this.metaData.getFields()) {
            if (field.getModifiers().contains((Object)Modifier.STATIC) || field.getAnnotation(Ignore.class) != null) continue;
            String fieldName = field.getSimpleName().toString();
            String fieldTypeCanonicalName = ((Object)field.asType()).toString();
            $this$generate_u24lambda_u2d0.beginMethod(fieldTypeCanonicalName, this.metaData.getInternalGetter(fieldName), (Set)EnumSet.of((Enum)Modifier.PUBLIC), new String[0]);
            $this$generate_u24lambda_u2d0.endMethod();
            Intrinsics.checkNotNullExpressionValue((Object)field, (String)"field");
            if (Utils.INSTANCE.isMutableRealmInteger(field)) continue;
            String[] stringArray = new String[]{fieldTypeCanonicalName, "value"};
            $this$generate_u24lambda_u2d0.beginMethod("void", this.metaData.getInternalSetter(fieldName), (Set)EnumSet.of((Enum)Modifier.PUBLIC), stringArray);
            $this$generate_u24lambda_u2d0.endMethod();
        }
        for (Backlink backlink : this.metaData.getBacklinkFields()) {
            $this$generate_u24lambda_u2d0.beginMethod(backlink.getTargetFieldType(), this.metaData.getInternalGetter(backlink.getTargetField()), (Set)EnumSet.of((Enum)Modifier.PUBLIC), new String[0]);
            $this$generate_u24lambda_u2d0.endMethod();
        }
        $this$generate_u24lambda_u2d0.endType();
        $this$generate_u24lambda_u2d0.close();
    }
}

