/*
 * Decompiled with CFR 0.152.
 */
package io.realm.processor;

import io.realm.annotations.Ignore;
import io.realm.annotations.Index;
import io.realm.annotations.LinkingObjects;
import io.realm.annotations.PrimaryKey;
import io.realm.annotations.RealmClass;
import io.realm.annotations.RealmField;
import io.realm.annotations.RealmNamingPolicy;
import io.realm.annotations.Required;
import io.realm.processor.Backlink;
import io.realm.processor.Constants;
import io.realm.processor.ModuleMetaData;
import io.realm.processor.QualifiedClassName;
import io.realm.processor.RealmFieldElement;
import io.realm.processor.SimpleClassName;
import io.realm.processor.TypeMirrors;
import io.realm.processor.Utils;
import io.realm.processor.nameconverter.NameConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b$\n\u0002\u0018\u0002\n\u0002\b\u001a\u0018\u0000 \u0089\u00012\u00020\u0001:\u0002\u0089\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010P\u001a\u00020\u00192\u0006\u0010Q\u001a\u000208H\u0002J\b\u0010R\u001a\u00020\u0019H\u0002J\u0010\u0010S\u001a\u00020\u00192\u0006\u0010T\u001a\u00020\u0015H\u0002J\u0018\u0010U\u001a\u00020\u00192\u0006\u0010T\u001a\u00020\u00152\u0006\u0010V\u001a\u00020\u000bH\u0002J\u0010\u0010W\u001a\u00020\u00192\u0006\u0010X\u001a\u000208H\u0002J\u0010\u0010Y\u001a\u00020\u00192\u0006\u0010V\u001a\u00020\u000bH\u0002J.\u0010Z\u001a\u00020\u00192\u0006\u0010X\u001a\u0002082\u0006\u0010[\u001a\u00020I2\f\u0010\\\u001a\b\u0012\u0004\u0012\u00020I042\u0006\u0010]\u001a\u00020*H\u0002J\u0010\u0010^\u001a\u00020\u00192\u0006\u0010X\u001a\u000208H\u0002J\b\u0010_\u001a\u00020\u0019H\u0002J\b\u0010`\u001a\u00020\u0019H\u0002J\b\u0010a\u001a\u00020\u0019H\u0002J\u0010\u0010b\u001a\u00020\u00192\u0006\u0010X\u001a\u000208H\u0002J\b\u0010c\u001a\u00020\u0019H\u0002J\b\u0010d\u001a\u00020\u0019H\u0002J\u0010\u0010e\u001a\u00020\u00192\u0006\u0010X\u001a\u000208H\u0002J\u0010\u0010f\u001a\u00020\u00192\u0006\u0010X\u001a\u000208H\u0002J\u0012\u0010g\u001a\u0004\u0018\u00010I2\u0006\u0010X\u001a\u000208H\u0002J\b\u0010h\u001a\u00020\u0019H\u0002J\b\u0010i\u001a\u00020\u0019H\u0002J\u0010\u0010j\u001a\u00020\u00192\u0006\u0010X\u001a\u000208H\u0002J\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0019J\u0006\u0010\u001b\u001a\u00020\u0019J\u001e\u0010k\u001a\u00020\u00192\f\u0010l\u001a\b\u0012\u0004\u0012\u00020I042\u0006\u0010m\u001a\u00020IH\u0002J\u000e\u0010n\u001a\u00020\u00192\u0006\u0010o\u001a\u00020pJ\f\u0010q\u001a\b\u0012\u0004\u0012\u00020\u000b04J\u0012\u0010r\u001a\u0004\u0018\u0001082\b\u0010s\u001a\u0004\u0018\u00010*J\u0010\u0010t\u001a\u00020*2\u0006\u0010X\u001a\u000208H\u0002J\u0018\u0010u\u001a\u00020*2\u0006\u0010X\u001a\u0002082\u0006\u0010v\u001a\u00020\u001dH\u0002J\u000e\u0010u\u001a\u00020*2\u0006\u0010w\u001a\u00020*J\u000e\u0010x\u001a\u00020*2\u0006\u0010s\u001a\u00020*J\u000e\u0010y\u001a\u00020*2\u0006\u0010s\u001a\u00020*J\u0006\u0010z\u001a\u00020\u0019J\u0010\u0010{\u001a\u00020\u00192\u0006\u0010X\u001a\u000208H\u0002J\u000e\u0010|\u001a\u00020\u00192\u0006\u0010}\u001a\u000208J\u000e\u0010~\u001a\u00020\u00192\u0006\u0010\u007f\u001a\u000208J\u000f\u0010\u0080\u0001\u001a\u00020\u00192\u0006\u0010Q\u001a\u000208J\u000f\u0010\u0081\u0001\u001a\u00020\u00192\u0006\u0010Q\u001a\u000208J\u000f\u0010\u0082\u0001\u001a\u00020\u00192\u0006\u0010Q\u001a\u000208J\u0011\u0010\u0083\u0001\u001a\u00020\u00192\u0006\u0010X\u001a\u000208H\u0002J\u0010\u0010\u0084\u0001\u001a\u00020\u00192\u0007\u0010\u0085\u0001\u001a\u000208J\u0011\u0010\u0086\u0001\u001a\u00020\u00192\u0006\u0010m\u001a\u00020IH\u0002J\u0011\u0010\u0087\u0001\u001a\u00020\u00192\u0006\u0010m\u001a\u00020IH\u0002J\t\u0010\u0088\u0001\u001a\u00020*H\u0016R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010!\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u0019@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u000e\u0010'\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010+\u001a\u00020*2\u0006\u0010 \u001a\u00020*@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0011\u0010.\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b.\u0010#R\u0014\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00100\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00101\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00102\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u00103\u001a\b\u0012\u0004\u0012\u00020\u000b048F\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u000e\u00107\u001a\u00020*X\u0082.\u00a2\u0006\u0002\n\u0000R\"\u00109\u001a\u0004\u0018\u0001082\b\u0010 \u001a\u0004\u0018\u000108@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\u0011\u0010<\u001a\u00020*8F\u00a2\u0006\u0006\u001a\u0004\b=\u0010-R\u001a\u0010>\u001a\u00020?8F\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0006\u001a\u0004\b@\u0010-R\u0017\u0010A\u001a\b\u0012\u0004\u0012\u00020\u000b0\r8F\u00a2\u0006\u0006\u001a\u0004\bB\u0010\u0010R\u0014\u0010C\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010D\u001a\u00020E\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010G\u001a\u0004\bF\u0010-R\u000e\u0010H\u001a\u00020IX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010J\u001a\u00020KX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010L\u001a\b\u0012\u0004\u0012\u00020I04X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010M\u001a\b\u0012\u0004\u0012\u00020I04X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010N\u001a\b\u0012\u0004\u0012\u00020I04X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010O\u001a\b\u0012\u0004\u0012\u00020I04X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u008a\u0001"}, d2={"Lio/realm/processor/ClassMetaData;", "", "env", "Ljavax/annotation/processing/ProcessingEnvironment;", "typeMirrors", "Lio/realm/processor/TypeMirrors;", "classType", "Ljavax/lang/model/element/TypeElement;", "(Ljavax/annotation/processing/ProcessingEnvironment;Lio/realm/processor/TypeMirrors;Ljavax/lang/model/element/TypeElement;)V", "_objectReferenceFields", "Ljava/util/ArrayList;", "Lio/realm/processor/RealmFieldElement;", "backlinkFields", "", "Lio/realm/processor/Backlink;", "getBacklinkFields", "()Ljava/util/Set;", "backlinks", "Ljava/util/LinkedHashSet;", "basicTypeFields", "classElement", "Ljavax/lang/model/element/Element;", "getClassElement", "()Ljavax/lang/model/element/Element;", "containsEquals", "", "containsHashCode", "containsToString", "defaultFieldNameFormatter", "Lio/realm/processor/nameconverter/NameConverter;", "elements", "Ljavax/lang/model/util/Elements;", "<set-?>", "embedded", "getEmbedded", "()Z", "fields", "getFields", "()Ljava/util/ArrayList;", "hasDefaultConstructor", "ignoreKotlinNullability", "indexedFields", "", "internalClassName", "getInternalClassName", "()Ljava/lang/String;", "isModelClass", "nullableFields", "nullableValueListFields", "nullableValueMapFields", "nullableValueSetFields", "objectReferenceFields", "", "getObjectReferenceFields", "()Ljava/util/List;", "packageName", "Ljavax/lang/model/element/VariableElement;", "primaryKey", "getPrimaryKey", "()Ljavax/lang/model/element/VariableElement;", "primaryKeyGetter", "getPrimaryKeyGetter", "qualifiedClassName", "Lio/realm/processor/QualifiedClassName;", "getQualifiedClassName-AzxYXdY", "realmModelSetFields", "getRealmModelSetFields", "realmModelSets", "simpleJavaClassName", "Lio/realm/processor/SimpleClassName;", "getSimpleJavaClassName-tNQ4wF4", "Ljava/lang/String;", "stringType", "Ljavax/lang/model/type/TypeMirror;", "typeUtils", "Ljavax/lang/model/util/Types;", "validDictionaryTypes", "validListValueTypes", "validPrimaryKeyTypes", "validSetTypes", "categorizeBacklinkField", "variableElement", "categorizeClassElements", "categorizeField", "element", "categorizeIndexField", "fieldElement", "categorizeMutableRealmIntegerField", "field", "categorizePrimaryKeyField", "checkAcceptableClass", "elementTypeMirror", "validTypes", "specificFieldTypeMessage", "checkBasicRequiredAnnotationUsage", "checkCollectionTypes", "checkDefaultConstructor", "checkDictionaryTypes", "checkDictionaryValuesType", "checkForFinalFields", "checkForVolatileFields", "checkRealmListType", "checkRealmResultsType", "checkReferenceIsNotInterface", "checkReferenceTypes", "checkSetTypes", "checkSetValuesType", "containsType", "listOfTypes", "type", "generate", "moduleMetaData", "Lio/realm/processor/ModuleMetaData;", "getBasicTypeFields", "getDeclaredField", "fieldName", "getFieldErrorSuffix", "getInternalFieldName", "defaultConverter", "javaFieldName", "getInternalGetter", "getInternalSetter", "hasPrimaryKey", "hasRequiredAnnotation", "isDictionaryValueNullable", "realmDictionaryVariableElement", "isElementNullable", "realmListVariableElement", "isIndexed", "isNullable", "isPrimaryKey", "isRequiredField", "isSetValueNullable", "realmSetVariableElement", "isStringPrimaryKeyType", "isValidPrimaryKeyType", "toString", "Companion", "realm-annotations-processor"})
public final class ClassMetaData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TypeElement classType;
    @NotNull
    private final String simpleJavaClassName;
    @NotNull
    private final ArrayList<RealmFieldElement> fields;
    @NotNull
    private final ArrayList<RealmFieldElement> indexedFields;
    @NotNull
    private final ArrayList<RealmFieldElement> _objectReferenceFields;
    @NotNull
    private final ArrayList<RealmFieldElement> basicTypeFields;
    @NotNull
    private final LinkedHashSet<Backlink> backlinks;
    @NotNull
    private final LinkedHashSet<RealmFieldElement> nullableFields;
    @NotNull
    private final LinkedHashSet<RealmFieldElement> nullableValueListFields;
    @NotNull
    private final LinkedHashSet<RealmFieldElement> nullableValueMapFields;
    @NotNull
    private final LinkedHashSet<RealmFieldElement> nullableValueSetFields;
    @NotNull
    private final LinkedHashSet<RealmFieldElement> realmModelSets;
    private String packageName;
    private boolean hasDefaultConstructor;
    @Nullable
    private VariableElement primaryKey;
    private boolean containsToString;
    private boolean containsEquals;
    private boolean containsHashCode;
    private String internalClassName;
    @NotNull
    private final List<TypeMirror> validPrimaryKeyTypes;
    @NotNull
    private final List<TypeMirror> validListValueTypes;
    @NotNull
    private final List<TypeMirror> validDictionaryTypes;
    @NotNull
    private final List<TypeMirror> validSetTypes;
    @NotNull
    private final TypeMirror stringType;
    @NotNull
    private final Types typeUtils;
    @NotNull
    private final Elements elements;
    private NameConverter defaultFieldNameFormatter;
    private final boolean ignoreKotlinNullability;
    private boolean embedded;
    @NotNull
    private static final String OPTION_IGNORE_KOTLIN_NULLABILITY = "realm.ignoreKotlinNullability";
    private static final int MAX_CLASSNAME_LENGTH = 57;

    public ClassMetaData(@NotNull ProcessingEnvironment env, @NotNull TypeMirrors typeMirrors, @NotNull TypeElement classType) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)typeMirrors, (String)"typeMirrors");
        Intrinsics.checkNotNullParameter((Object)classType, (String)"classType");
        this.classType = classType;
        Name name = this.classType.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"classType.simpleName");
        this.simpleJavaClassName = SimpleClassName.constructor-impl(name);
        this.fields = new ArrayList();
        this.indexedFields = new ArrayList();
        this._objectReferenceFields = new ArrayList();
        this.basicTypeFields = new ArrayList();
        this.backlinks = new LinkedHashSet();
        this.nullableFields = new LinkedHashSet();
        this.nullableValueListFields = new LinkedHashSet();
        this.nullableValueMapFields = new LinkedHashSet();
        this.nullableValueSetFields = new LinkedHashSet();
        this.realmModelSets = new LinkedHashSet();
        Object object = new TypeMirror[]{typeMirrors.STRING_MIRROR, typeMirrors.PRIMITIVE_LONG_MIRROR, typeMirrors.PRIMITIVE_INT_MIRROR, typeMirrors.PRIMITIVE_SHORT_MIRROR, typeMirrors.PRIMITIVE_BYTE_MIRROR, typeMirrors.OBJECT_ID_MIRROR, typeMirrors.UUID_MIRROR};
        this.validPrimaryKeyTypes = CollectionsKt.listOf((Object[])object);
        object = new TypeMirror[]{typeMirrors.STRING_MIRROR, typeMirrors.BINARY_MIRROR, typeMirrors.BOOLEAN_MIRROR, typeMirrors.LONG_MIRROR, typeMirrors.INTEGER_MIRROR, typeMirrors.SHORT_MIRROR, typeMirrors.BYTE_MIRROR, typeMirrors.DOUBLE_MIRROR, typeMirrors.FLOAT_MIRROR, typeMirrors.DATE_MIRROR, typeMirrors.DECIMAL128_MIRROR, typeMirrors.OBJECT_ID_MIRROR, typeMirrors.UUID_MIRROR, typeMirrors.MIXED_MIRROR};
        this.validListValueTypes = CollectionsKt.listOf((Object[])object);
        object = new TypeMirror[]{typeMirrors.STRING_MIRROR, typeMirrors.BINARY_MIRROR, typeMirrors.BOOLEAN_MIRROR, typeMirrors.LONG_MIRROR, typeMirrors.INTEGER_MIRROR, typeMirrors.SHORT_MIRROR, typeMirrors.BYTE_MIRROR, typeMirrors.DOUBLE_MIRROR, typeMirrors.FLOAT_MIRROR, typeMirrors.DATE_MIRROR, typeMirrors.DECIMAL128_MIRROR, typeMirrors.OBJECT_ID_MIRROR, typeMirrors.UUID_MIRROR, typeMirrors.MIXED_MIRROR};
        this.validDictionaryTypes = CollectionsKt.listOf((Object[])object);
        object = new TypeMirror[]{typeMirrors.STRING_MIRROR, typeMirrors.BINARY_MIRROR, typeMirrors.BOOLEAN_MIRROR, typeMirrors.LONG_MIRROR, typeMirrors.INTEGER_MIRROR, typeMirrors.SHORT_MIRROR, typeMirrors.BYTE_MIRROR, typeMirrors.DOUBLE_MIRROR, typeMirrors.FLOAT_MIRROR, typeMirrors.DATE_MIRROR, typeMirrors.DECIMAL128_MIRROR, typeMirrors.OBJECT_ID_MIRROR, typeMirrors.UUID_MIRROR, typeMirrors.MIXED_MIRROR};
        this.validSetTypes = CollectionsKt.listOf((Object[])object);
        this.stringType = typeMirrors.STRING_MIRROR;
        Types types = env.getTypeUtils();
        Intrinsics.checkNotNullExpressionValue((Object)types, (String)"env.typeUtils");
        this.typeUtils = types;
        Elements elements = env.getElementUtils();
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"env.elementUtils");
        this.elements = elements;
        for (Element element : this.classType.getEnclosedElements()) {
            if (!(element instanceof ExecutableElement)) continue;
            Name name2 = element.getSimpleName();
            if (name2.contentEquals("toString")) {
                this.containsToString = true;
                continue;
            }
            if (name2.contentEquals("equals")) {
                this.containsEquals = true;
                continue;
            }
            if (!name2.contentEquals("hashCode")) continue;
            this.containsHashCode = true;
        }
        Map<String, String> map = env.getOptions();
        if (map == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.String>");
        }
        object = Boolean.valueOf(TypeIntrinsics.asMutableMap(map).getOrDefault(OPTION_IGNORE_KOTLIN_NULLABILITY, "false"));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"valueOf(\n               \u2026IN_NULLABILITY, \"false\"))");
        this.ignoreKotlinNullability = (Boolean)object;
    }

    @NotNull
    public final String getSimpleJavaClassName-tNQ4wF4() {
        return this.simpleJavaClassName;
    }

    @NotNull
    public final ArrayList<RealmFieldElement> getFields() {
        return this.fields;
    }

    @Nullable
    public final VariableElement getPrimaryKey() {
        return this.primaryKey;
    }

    @NotNull
    public final String getInternalClassName() {
        String string = this.internalClassName;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"internalClassName");
        return null;
    }

    @NotNull
    public final String getQualifiedClassName-AzxYXdY() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.packageName;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"packageName");
            string = null;
        }
        return QualifiedClassName.constructor-impl(stringBuilder.append(string).append('.').append((Object)SimpleClassName.toString-impl(this.simpleJavaClassName)).toString());
    }

    @NotNull
    public final Set<Backlink> getBacklinkFields() {
        return CollectionsKt.toSet((Iterable)this.backlinks);
    }

    @NotNull
    public final String getPrimaryKeyGetter() {
        VariableElement variableElement = this.primaryKey;
        Intrinsics.checkNotNull((Object)variableElement);
        return this.getInternalGetter(variableElement.getSimpleName().toString());
    }

    @NotNull
    public final Set<RealmFieldElement> getRealmModelSetFields() {
        return CollectionsKt.toSet((Iterable)this.realmModelSets);
    }

    public final boolean isModelClass() {
        String type = this.classType.toString();
        return !Intrinsics.areEqual((Object)type, (Object)"io.realm.DynamicRealmObject") && !StringsKt.endsWith$default((String)type, (String)".RealmObject", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)type, (String)"RealmProxy", (boolean)false, (int)2, null);
    }

    public final boolean getEmbedded() {
        return this.embedded;
    }

    @NotNull
    public final Element getClassElement() {
        return this.classType;
    }

    @NotNull
    public String toString() {
        return "class " + QualifiedClassName.toString-impl(this.getQualifiedClassName-AzxYXdY());
    }

    @NotNull
    public final String getInternalFieldName(@NotNull String javaFieldName) {
        Intrinsics.checkNotNullParameter((Object)javaFieldName, (String)"javaFieldName");
        for (RealmFieldElement field : this.fields) {
            if (!Intrinsics.areEqual((Object)field.getJavaName(), (Object)javaFieldName)) continue;
            return field.getInternalFieldName();
        }
        throw new IllegalArgumentException("Could not find fieldname: " + javaFieldName);
    }

    @NotNull
    public final List<RealmFieldElement> getObjectReferenceFields() {
        return CollectionsKt.toList((Iterable)this._objectReferenceFields);
    }

    @NotNull
    public final List<RealmFieldElement> getBasicTypeFields() {
        List<RealmFieldElement> list = Collections.unmodifiableList((List)this.basicTypeFields);
        Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(basicTypeFields)");
        return list;
    }

    @NotNull
    public final String getInternalGetter(@NotNull String fieldName) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        return "realmGet$" + fieldName;
    }

    @NotNull
    public final String getInternalSetter(@NotNull String fieldName) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        return "realmSet$" + fieldName;
    }

    public final boolean hasPrimaryKey() {
        return this.primaryKey != null;
    }

    public final boolean containsToString() {
        return this.containsToString;
    }

    public final boolean containsEquals() {
        return this.containsEquals;
    }

    public final boolean containsHashCode() {
        return this.containsHashCode;
    }

    public final boolean isNullable(@NotNull VariableElement variableElement) {
        Intrinsics.checkNotNullParameter((Object)variableElement, (String)"variableElement");
        return CollectionsKt.contains((Iterable)this.nullableFields, (Object)variableElement);
    }

    public final boolean isElementNullable(@NotNull VariableElement realmListVariableElement) {
        Intrinsics.checkNotNullParameter((Object)realmListVariableElement, (String)"realmListVariableElement");
        return CollectionsKt.contains((Iterable)this.nullableValueListFields, (Object)realmListVariableElement);
    }

    public final boolean isDictionaryValueNullable(@NotNull VariableElement realmDictionaryVariableElement) {
        Intrinsics.checkNotNullParameter((Object)realmDictionaryVariableElement, (String)"realmDictionaryVariableElement");
        return CollectionsKt.contains((Iterable)this.nullableValueMapFields, (Object)realmDictionaryVariableElement);
    }

    public final boolean isSetValueNullable(@NotNull VariableElement realmSetVariableElement) {
        Intrinsics.checkNotNullParameter((Object)realmSetVariableElement, (String)"realmSetVariableElement");
        return CollectionsKt.contains((Iterable)this.nullableValueSetFields, (Object)realmSetVariableElement);
    }

    public final boolean isIndexed(@NotNull VariableElement variableElement) {
        Intrinsics.checkNotNullParameter((Object)variableElement, (String)"variableElement");
        return CollectionsKt.contains((Iterable)this.indexedFields, (Object)variableElement);
    }

    public final boolean isPrimaryKey(@NotNull VariableElement variableElement) {
        Intrinsics.checkNotNullParameter((Object)variableElement, (String)"variableElement");
        return this.primaryKey != null && Intrinsics.areEqual((Object)this.primaryKey, (Object)variableElement);
    }

    @Nullable
    public final VariableElement getDeclaredField(@Nullable String fieldName) {
        if (fieldName == null) {
            return null;
        }
        for (RealmFieldElement field : this.fields) {
            if (!Intrinsics.areEqual((Object)field.getSimpleName().toString(), (Object)fieldName)) continue;
            return field;
        }
        return null;
    }

    public final boolean generate(@NotNull ModuleMetaData moduleMetaData) {
        Intrinsics.checkNotNullParameter((Object)moduleMetaData, (String)"moduleMetaData");
        Element enclosingElement = this.classType.getEnclosingElement();
        if (enclosingElement.getKind() != ElementKind.PACKAGE) {
            Utils.INSTANCE.error("The RealmClass annotation does not support nested classes.", this.classType);
            return false;
        }
        TypeElement parentElement = (TypeElement)Utils.INSTANCE.getSuperClass(this.classType);
        if (!Intrinsics.areEqual((Object)parentElement.toString(), (Object)"java.lang.Object") && !Intrinsics.areEqual((Object)parentElement.toString(), (Object)"io.realm.RealmObject")) {
            Utils.INSTANCE.error("Valid model classes must either extend RealmObject or implement RealmModel.", this.classType);
            return false;
        }
        Element element = enclosingElement;
        if (element == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.lang.model.element.PackageElement");
        }
        PackageElement packageElement = (PackageElement)element;
        this.packageName = packageElement.getQualifiedName().toString();
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.packageName;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"packageName");
            string = null;
        }
        String qualifiedClassName = QualifiedClassName.constructor-impl(stringBuilder.append(string).append('.').append((Object)SimpleClassName.toString-impl(this.simpleJavaClassName)).toString());
        NameConverter moduleClassNameFormatter = moduleMetaData.getClassNameFormatter-omp8SrQ(qualifiedClassName);
        this.defaultFieldNameFormatter = moduleMetaData.getFieldNameFormatter-omp8SrQ(qualifiedClassName);
        RealmClass realmClassAnnotation = this.classType.getAnnotation(RealmClass.class);
        String string2 = ((CharSequence)realmClassAnnotation.name()).length() > 0 ? realmClassAnnotation.name() : (this.internalClassName = ((CharSequence)realmClassAnnotation.value()).length() > 0 ? realmClassAnnotation.value() : moduleClassNameFormatter.convert(SimpleClassName.toString-impl(this.simpleJavaClassName)));
        if (this.getInternalClassName().length() > MAX_CLASSNAME_LENGTH) {
            Locale locale = Locale.US;
            String string3 = "Internal class name is too long. Class '%s' is converted to '%s', which is longer than the maximum allowed of %d characters";
            Object[] objectArray = new Object[]{SimpleClassName.box-impl(this.simpleJavaClassName), this.getInternalClassName(), MAX_CLASSNAME_LENGTH};
            String string4 = String.format(locale, string3, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(locale, format, *args)");
            Utils.INSTANCE.error(string4);
            return false;
        }
        if (realmClassAnnotation.fieldNamingPolicy() != RealmNamingPolicy.NO_POLICY) {
            this.defaultFieldNameFormatter = Utils.INSTANCE.getNameFormatter(realmClassAnnotation.fieldNamingPolicy());
        }
        this.embedded = realmClassAnnotation.embedded();
        if (!this.categorizeClassElements()) {
            return false;
        }
        if (!this.checkCollectionTypes()) {
            return false;
        }
        if (!this.checkDictionaryTypes()) {
            return false;
        }
        if (!this.checkSetTypes()) {
            return false;
        }
        if (!this.checkReferenceTypes()) {
            return false;
        }
        if (!this.checkDefaultConstructor()) {
            return false;
        }
        if (!this.checkForFinalFields()) {
            return false;
        }
        return this.checkForVolatileFields();
    }

    private final boolean categorizeClassElements() {
        block4: for (Element locale : this.classType.getEnclosedElements()) {
            ElementKind elementKind = locale.getKind();
            switch (elementKind == null ? -1 : WhenMappings.$EnumSwitchMapping$0[elementKind.ordinal()]) {
                case 1: {
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"element");
                    if (!Utils.INSTANCE.isDefaultConstructor(locale)) continue block4;
                    this.hasDefaultConstructor = true;
                    continue block4;
                }
                case 2: {
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"element");
                    if (this.categorizeField(locale)) continue block4;
                    return false;
                }
            }
        }
        if (this.fields.isEmpty()) {
            Locale locale = Locale.US;
            String string = "Class \"%s\" must contain at least 1 persistable field.";
            Object[] objectArray = new Object[]{SimpleClassName.box-impl(this.simpleJavaClassName)};
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, format, *args)");
            Utils.INSTANCE.error(string2);
        }
        return true;
    }

    private final boolean checkCollectionTypes() {
        for (RealmFieldElement field : this.fields) {
            Intrinsics.checkNotNullExpressionValue((Object)field, (String)"field");
            if (!(Utils.INSTANCE.isRealmList(field) ? !this.checkRealmListType(field) : Utils.INSTANCE.isRealmResults(field) && !this.checkRealmResultsType(field))) continue;
            return false;
        }
        return true;
    }

    private final boolean checkDictionaryTypes() {
        for (RealmFieldElement field : this.fields) {
            Intrinsics.checkNotNullExpressionValue((Object)field, (String)"field");
            if (!Utils.INSTANCE.isRealmDictionary(field) || this.checkDictionaryValuesType(field)) continue;
            return false;
        }
        return true;
    }

    private final boolean checkSetTypes() {
        for (RealmFieldElement field : this.fields) {
            Intrinsics.checkNotNullExpressionValue((Object)field, (String)"field");
            if (!Utils.INSTANCE.isRealmSet(field) || this.checkSetValuesType(field)) continue;
            return false;
        }
        return true;
    }

    private final boolean checkSetValuesType(VariableElement field) {
        if (Utils.INSTANCE.getGenericTypeQualifiedName-jfySWgk(field) == null) {
            Utils.INSTANCE.error(this.getFieldErrorSuffix(field) + "No generic type supplied for field", field);
            return false;
        }
        TypeMirror typeMirror = this.checkReferenceIsNotInterface(field);
        if (typeMirror == null) {
            return false;
        }
        TypeMirror elementTypeMirror = typeMirror;
        return this.checkAcceptableClass(field, elementTypeMirror, this.validSetTypes, "Element type RealmSet must be of type 'RealmAny' or any type that can be boxed inside 'RealmAny': ");
    }

    private final boolean checkDictionaryValuesType(VariableElement field) {
        if (Utils.INSTANCE.getGenericTypeQualifiedName-jfySWgk(field) == null) {
            Utils.INSTANCE.error(this.getFieldErrorSuffix(field) + "No generic type supplied for field", field);
            return false;
        }
        TypeMirror typeMirror = this.checkReferenceIsNotInterface(field);
        if (typeMirror == null) {
            return false;
        }
        TypeMirror elementTypeMirror = typeMirror;
        return this.checkAcceptableClass(field, elementTypeMirror, this.validDictionaryTypes, "Element type RealmDictionary must be of type 'RealmAny' or any type that can be boxed inside 'RealmAny': ");
    }

    private final boolean checkRealmListType(VariableElement field) {
        if (Utils.INSTANCE.getGenericTypeQualifiedName-jfySWgk(field) == null) {
            Utils.INSTANCE.error(this.getFieldErrorSuffix(field) + "No generic type supplied for field", field);
            return false;
        }
        TypeMirror typeMirror = this.checkReferenceIsNotInterface(field);
        if (typeMirror == null) {
            return false;
        }
        TypeMirror elementTypeMirror = typeMirror;
        return this.checkAcceptableClass(field, elementTypeMirror, this.validListValueTypes, "Element type of RealmList must be a class implementing 'RealmModel' or one of ");
    }

    private final boolean checkAcceptableClass(VariableElement field, TypeMirror elementTypeMirror, List<? extends TypeMirror> validTypes, String specificFieldTypeMessage) {
        if (!this.containsType(validTypes, elementTypeMirror) && !Utils.INSTANCE.isRealmModel(elementTypeMirror)) {
            StringBuilder messageBuilder = new StringBuilder(this.getFieldErrorSuffix(field) + "Type was '" + elementTypeMirror + "'. " + specificFieldTypeMessage);
            String separator = ", ";
            for (TypeMirror typeMirror : validTypes) {
                messageBuilder.append('\'').append(((Object)typeMirror).toString()).append('\'').append(separator);
            }
            messageBuilder.setLength(messageBuilder.length() - separator.length());
            messageBuilder.append('.');
            Utils.INSTANCE.error(messageBuilder.toString(), field);
            return false;
        }
        return true;
    }

    private final TypeMirror checkReferenceIsNotInterface(VariableElement field) {
        TypeMirror fieldType;
        TypeMirror typeMirror = fieldType = field.asType();
        if (typeMirror == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.lang.model.type.DeclaredType");
        }
        TypeMirror typeMirror2 = ((DeclaredType)typeMirror).getTypeArguments().get(0);
        Intrinsics.checkNotNullExpressionValue((Object)typeMirror2, (String)"(fieldType as DeclaredType).typeArguments[0]");
        TypeMirror elementTypeMirror = typeMirror2;
        if (elementTypeMirror.getKind() == TypeKind.DECLARED) {
            Element element = ((DeclaredType)elementTypeMirror).asElement();
            if (element == null) {
                throw new NullPointerException("null cannot be cast to non-null type javax.lang.model.element.TypeElement");
            }
            TypeElement elementTypeElement = (TypeElement)element;
            if (elementTypeElement.getSuperclass().getKind() == TypeKind.NONE) {
                Utils.INSTANCE.error(this.getFieldErrorSuffix(field) + "Only concrete Realm classes are allowed in field '" + field + "'. Neither interfaces nor abstract classes are allowed.", field);
                return null;
            }
        }
        return elementTypeMirror;
    }

    private final boolean checkRealmResultsType(VariableElement field) {
        TypeMirror fieldType;
        if (Utils.INSTANCE.getGenericTypeQualifiedName-jfySWgk(field) == null) {
            Utils.INSTANCE.error(this.getFieldErrorSuffix(field) + "No generic type supplied for field", field);
            return false;
        }
        TypeMirror typeMirror = fieldType = field.asType();
        if (typeMirror == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.lang.model.type.DeclaredType");
        }
        TypeMirror elementTypeMirror = ((DeclaredType)typeMirror).getTypeArguments().get(0);
        if (elementTypeMirror.getKind() == TypeKind.DECLARED) {
            TypeMirror typeMirror2 = elementTypeMirror;
            if (typeMirror2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type javax.lang.model.type.DeclaredType");
            }
            Element element = ((DeclaredType)typeMirror2).asElement();
            if (element == null) {
                throw new NullPointerException("null cannot be cast to non-null type javax.lang.model.element.TypeElement");
            }
            TypeElement elementTypeElement = (TypeElement)element;
            if (elementTypeElement.getSuperclass().getKind() == TypeKind.NONE) {
                Utils.INSTANCE.error("Only concrete Realm classes are allowed in RealmResults. Neither interfaces nor abstract classes are allowed.", field);
                return false;
            }
        }
        if (!Utils.INSTANCE.isRealmModel(elementTypeMirror)) {
            Utils.INSTANCE.error(this.getFieldErrorSuffix(field) + "Element type of RealmResults must be a class implementing 'RealmModel'.", field);
            return false;
        }
        return true;
    }

    private final String getFieldErrorSuffix(VariableElement field) {
        return SimpleClassName.toString-impl(this.simpleJavaClassName) + '.' + field.getSimpleName() + ": ";
    }

    private final boolean checkReferenceTypes() {
        for (RealmFieldElement field : this.fields) {
            TypeElement typeElement;
            Intrinsics.checkNotNullExpressionValue((Object)field, (String)"field");
            if (!Utils.INSTANCE.isRealmModel(field) || (typeElement = this.elements.getTypeElement(((Object)field.asType()).toString())).getSuperclass().getKind() != TypeKind.NONE) continue;
            Utils.INSTANCE.error("Only concrete Realm classes can be referenced from model classes. Neither interfaces nor abstract classes are allowed.", field);
            return false;
        }
        return true;
    }

    private final boolean checkDefaultConstructor() {
        boolean bl;
        if (!this.hasDefaultConstructor) {
            Locale locale = Locale.US;
            String string = "Class \"%s\" must declare a public constructor with no arguments if it contains custom constructors.";
            Object[] objectArray = new Object[]{SimpleClassName.box-impl(this.simpleJavaClassName)};
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, format, *args)");
            Utils.INSTANCE.error(string2);
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    private final boolean checkForFinalFields() {
        for (RealmFieldElement field : this.fields) {
            if (!field.getModifiers().contains((Object)Modifier.FINAL)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)field, (String)"field");
            if (Utils.INSTANCE.isRealmList(field) || Utils.INSTANCE.isMutableRealmInteger(field) || Utils.INSTANCE.isRealmDictionary(field) || Utils.INSTANCE.isRealmSet(field)) continue;
            Locale locale = Locale.US;
            String string = "Class \"%s\" contains illegal final/immutable field \"%s\".";
            Object[] objectArray = new Object[]{SimpleClassName.box-impl(this.simpleJavaClassName), field.getSimpleName().toString()};
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, format, *args)");
            Utils.INSTANCE.error(string2);
            return false;
        }
        return true;
    }

    private final boolean checkForVolatileFields() {
        for (RealmFieldElement field : this.fields) {
            if (!field.getModifiers().contains((Object)Modifier.VOLATILE)) continue;
            Locale locale = Locale.US;
            String string = "Class \"%s\" contains illegal volatile field \"%s\".";
            Object[] objectArray = new Object[]{SimpleClassName.box-impl(this.simpleJavaClassName), field.getSimpleName().toString()};
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, format, *args)");
            Utils.INSTANCE.error(string2);
            return false;
        }
        return true;
    }

    private final boolean categorizeField(Element element) {
        String internalFieldName;
        RealmFieldElement field;
        VariableElement fieldRef = (VariableElement)element;
        if (fieldRef.getModifiers().contains((Object)Modifier.STATIC)) {
            return true;
        }
        if (fieldRef.getAnnotation(Ignore.class) != null || fieldRef.getModifiers().contains((Object)Modifier.TRANSIENT)) {
            return true;
        }
        NameConverter nameConverter = this.defaultFieldNameFormatter;
        if (nameConverter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"defaultFieldNameFormatter");
            nameConverter = null;
        }
        if ((field = new RealmFieldElement(fieldRef, internalFieldName = this.getInternalFieldName(fieldRef, nameConverter))).getAnnotation(Index.class) != null && !this.categorizeIndexField(element, field)) {
            return false;
        }
        if (Utils.INSTANCE.isRealmList(field)) {
            boolean containsRealmAny;
            boolean hasRequiredAnnotation = this.hasRequiredAnnotation(field);
            List<? extends TypeMirror> listGenericType = ((DeclaredType)field.asType()).getTypeArguments();
            Intrinsics.checkNotNullExpressionValue(listGenericType, (String)"listGenericType");
            boolean containsRealmModelClasses = !((Collection)listGenericType).isEmpty() && Utils.INSTANCE.isRealmModel(listGenericType.get(0));
            boolean bl = containsRealmAny = !((Collection)listGenericType).isEmpty() && Utils.INSTANCE.isRealmAny(listGenericType.get(0));
            if (hasRequiredAnnotation && (containsRealmModelClasses || containsRealmAny)) {
                Utils.INSTANCE.error("@Required not allowed on RealmList's that contain other Realm model classes or RealmAny.");
                return false;
            }
            if (!hasRequiredAnnotation && !containsRealmModelClasses) {
                this.nullableValueListFields.add(field);
            }
        } else if (Utils.INSTANCE.isRealmDictionary(field)) {
            boolean containsRealmAny;
            boolean hasRequiredAnnotation = this.hasRequiredAnnotation(field);
            List<? extends TypeMirror> listGenericType = ((DeclaredType)field.asType()).getTypeArguments();
            Intrinsics.checkNotNullExpressionValue(listGenericType, (String)"listGenericType");
            boolean containsRealmModelClasses = !((Collection)listGenericType).isEmpty() && Utils.INSTANCE.isRealmModel(listGenericType.get(0));
            boolean bl = containsRealmAny = !((Collection)listGenericType).isEmpty() && Utils.INSTANCE.isRealmAny(listGenericType.get(0));
            if (hasRequiredAnnotation && (containsRealmModelClasses || containsRealmAny)) {
                Utils.INSTANCE.error("@Required not allowed on RealmDictionaries that contain other Realm model classes and RealmAny.");
                return false;
            }
            if (!hasRequiredAnnotation && !containsRealmModelClasses) {
                this.nullableValueMapFields.add(field);
            }
        } else if (Utils.INSTANCE.isRealmSet(field)) {
            boolean containsRealmAny;
            boolean hasRequiredAnnotation = this.hasRequiredAnnotation(field);
            List<? extends TypeMirror> setGenericType = ((DeclaredType)field.asType()).getTypeArguments();
            Intrinsics.checkNotNullExpressionValue(setGenericType, (String)"setGenericType");
            boolean containsRealmModelClasses = !((Collection)setGenericType).isEmpty() && Utils.INSTANCE.isRealmModel(setGenericType.get(0));
            boolean bl = containsRealmAny = !((Collection)setGenericType).isEmpty() && Utils.INSTANCE.isRealmAny(setGenericType.get(0));
            if (hasRequiredAnnotation && (containsRealmModelClasses || containsRealmAny)) {
                Utils.INSTANCE.error("@Required not allowed on RealmSets that contain other Realm model classes and RealmAny.");
                return false;
            }
            if (!hasRequiredAnnotation && !containsRealmModelClasses) {
                this.nullableValueSetFields.add(field);
            }
            if (containsRealmModelClasses) {
                this.realmModelSets.add(field);
            }
        } else if (this.isRequiredField(field)) {
            if (!this.checkBasicRequiredAnnotationUsage(field)) {
                return false;
            }
        } else if (!Utils.INSTANCE.isPrimitiveType(field) && !Utils.INSTANCE.isRealmResults(field)) {
            this.nullableFields.add(field);
        }
        if (field.getAnnotation(PrimaryKey.class) != null && !this.categorizePrimaryKeyField(field)) {
            return false;
        }
        if (field.getAnnotation(LinkingObjects.class) != null) {
            return this.categorizeBacklinkField(field);
        }
        if (Utils.INSTANCE.isMutableRealmInteger(field) && !this.categorizeMutableRealmIntegerField(field)) {
            return false;
        }
        this.fields.add(field);
        if (Utils.INSTANCE.isRealmModel(field) || Utils.INSTANCE.isRealmModelList(field) || Utils.INSTANCE.isRealmAnyList(field) || Utils.INSTANCE.isRealmAny(field) || Utils.INSTANCE.isRealmModelDictionary(field) || Utils.INSTANCE.isRealmModelSet(field) || Utils.INSTANCE.isRealmAnyDictionary(field) || Utils.INSTANCE.isRealmAnySet(field)) {
            this._objectReferenceFields.add(field);
        } else {
            this.basicTypeFields.add(field);
        }
        return true;
    }

    private final String getInternalFieldName(VariableElement field, NameConverter defaultConverter) {
        RealmField nameAnnotation = field.getAnnotation(RealmField.class);
        if (nameAnnotation != null) {
            if (((CharSequence)nameAnnotation.name()).length() > 0) {
                return nameAnnotation.name();
            }
            if (((CharSequence)nameAnnotation.value()).length() > 0) {
                return nameAnnotation.value();
            }
            String string = "Empty internal name defined on @RealmField. Falling back to named used by Java model class: %s";
            Object[] objectArray = new Object[]{field.getSimpleName()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            Utils.INSTANCE.note(string2, field);
            return field.getSimpleName().toString();
        }
        return defaultConverter.convert(field.getSimpleName().toString());
    }

    private final boolean hasRequiredAnnotation(VariableElement field) {
        return field.getAnnotation(Required.class) != null;
    }

    private final boolean isRequiredField(VariableElement field) {
        if (this.hasRequiredAnnotation(field)) {
            return true;
        }
        if (this.ignoreKotlinNullability) {
            return false;
        }
        for (AnnotationMirror annotationMirror : field.getAnnotationMirrors()) {
            if (!Intrinsics.areEqual((Object)annotationMirror.getAnnotationType().toString(), (Object)"org.jetbrains.annotations.NotNull")) continue;
            return true;
        }
        return false;
    }

    private final boolean categorizeIndexField(Element element, RealmFieldElement fieldElement) {
        boolean indexable = false;
        if (Utils.INSTANCE.isMutableRealmInteger(fieldElement) || Utils.INSTANCE.isRealmAny(fieldElement)) {
            indexable = true;
        } else {
            Constants.RealmFieldType realmFieldType = Constants.INSTANCE.getJAVA_TO_REALM_TYPES().get(((Object)fieldElement.asType()).toString());
            switch (realmFieldType == null ? -1 : WhenMappings.$EnumSwitchMapping$1[realmFieldType.ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    indexable = true;
                }
            }
        }
        if (indexable) {
            this.indexedFields.add(fieldElement);
            return true;
        }
        Locale locale = Locale.US;
        String string = "Field \"%s\" of type \"%s\" cannot be an @Index.";
        Object[] objectArray = new Object[]{element, element.asType()};
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, format, *args)");
        Utils.INSTANCE.error(string2);
        return false;
    }

    private final boolean checkBasicRequiredAnnotationUsage(VariableElement field) {
        if (Utils.INSTANCE.isPrimitiveType(field)) {
            Locale locale = Locale.US;
            String string = "@Required or @NotNull annotation is unnecessary for primitive field \"%s\".";
            Object[] objectArray = new Object[]{field};
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, format, *args)");
            Utils.INSTANCE.error(string2);
            return false;
        }
        if (Utils.INSTANCE.isRealmModel(field) && (!this.embedded || field.getAnnotation(LinkingObjects.class) == null)) {
            Locale locale = Locale.US;
            String string = "Field \"%s\" with type \"%s\" cannot be @Required or @NotNull.";
            Object[] objectArray = new Object[]{field, field.asType()};
            String string3 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(locale, format, *args)");
            Utils.INSTANCE.error(string3);
            return false;
        }
        if (Utils.INSTANCE.isRealmAny(field)) {
            Locale locale = Locale.US;
            String string = "RealmAny field \"" + field + "\" cannot be @Required or @NotNull.";
            Object[] objectArray = new Object[]{};
            String string4 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(locale, format, *args)");
            Utils.INSTANCE.error(string4);
            return false;
        }
        if (CollectionsKt.contains((Iterable)this.nullableFields, (Object)field)) {
            Locale locale = Locale.US;
            String string = "Field \"%s\" with type \"%s\" appears to be nullable. Consider removing @Required.";
            Object[] objectArray = new Object[]{field, field.asType()};
            String string5 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(locale, format, *args)");
            Utils.INSTANCE.error(string5);
            return false;
        }
        return true;
    }

    private final boolean categorizePrimaryKeyField(RealmFieldElement fieldElement) {
        if (this.embedded) {
            Locale locale = Locale.US;
            String string = "A model class marked as embedded cannot contain a @PrimaryKey. One was defined for: %s";
            Object[] objectArray = new Object[]{fieldElement.getSimpleName().toString()};
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, format, *args)");
            Utils.INSTANCE.error(string2);
            return false;
        }
        if (this.primaryKey != null) {
            Locale locale = Locale.US;
            String string = "A class cannot have more than one @PrimaryKey. Both \"%s\" and \"%s\" are annotated as @PrimaryKey.";
            Object[] objectArray = new Object[2];
            VariableElement variableElement = this.primaryKey;
            Intrinsics.checkNotNull((Object)variableElement);
            objectArray[0] = variableElement.getSimpleName().toString();
            objectArray[1] = fieldElement.getSimpleName().toString();
            String string3 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(locale, format, *args)");
            Utils.INSTANCE.error(string3);
            return false;
        }
        TypeMirror fieldType = fieldElement.asType();
        if (!this.isValidPrimaryKeyType(fieldType)) {
            Locale locale = Locale.US;
            String string = "Field \"%s\" with type \"%s\" cannot be used as primary key. See @PrimaryKey for legal types.";
            Object[] objectArray = new Object[]{fieldElement.getSimpleName().toString(), fieldType};
            String string4 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(locale, format, *args)");
            Utils.INSTANCE.error(string4);
            return false;
        }
        this.primaryKey = fieldElement;
        return true;
    }

    private final boolean categorizeBacklinkField(VariableElement variableElement) {
        Backlink backlink = new Backlink(this, variableElement);
        if (!backlink.validateSource()) {
            return false;
        }
        this.backlinks.add(backlink);
        return true;
    }

    private final boolean categorizeMutableRealmIntegerField(VariableElement field) {
        if (field.getModifiers().contains((Object)Modifier.FINAL)) {
            return true;
        }
        Locale locale = Locale.US;
        String string = "Field \"%s\", a MutableRealmInteger, must be final.";
        Object[] objectArray = new Object[]{field.getSimpleName().toString()};
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, format, *args)");
        Utils.INSTANCE.error(string2);
        return false;
    }

    private final boolean isValidPrimaryKeyType(TypeMirror type) {
        for (TypeMirror validType : this.validPrimaryKeyTypes) {
            if (!this.typeUtils.isAssignable(type, validType)) continue;
            return true;
        }
        return false;
    }

    private final boolean isStringPrimaryKeyType(TypeMirror type) {
        return this.typeUtils.isAssignable(type, this.stringType);
    }

    private final boolean containsType(List<? extends TypeMirror> listOfTypes, TypeMirror type) {
        int n = listOfTypes.size();
        for (int i = 0; i < n; ++i) {
            if (!this.typeUtils.isSameType(listOfTypes.get(i), type)) continue;
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/realm/processor/ClassMetaData$Companion;", "", "()V", "MAX_CLASSNAME_LENGTH", "", "OPTION_IGNORE_KOTLIN_NULLABILITY", "", "realm-annotations-processor"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ElementKind.values().length];
            nArray[ElementKind.CONSTRUCTOR.ordinal()] = 1;
            nArray[ElementKind.FIELD.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Constants.RealmFieldType.values().length];
            nArray[Constants.RealmFieldType.STRING.ordinal()] = 1;
            nArray[Constants.RealmFieldType.DATE.ordinal()] = 2;
            nArray[Constants.RealmFieldType.INTEGER.ordinal()] = 3;
            nArray[Constants.RealmFieldType.BOOLEAN.ordinal()] = 4;
            nArray[Constants.RealmFieldType.OBJECT_ID.ordinal()] = 5;
            nArray[Constants.RealmFieldType.UUID.ordinal()] = 6;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

