/*
 * Decompiled with CFR 0.152.
 */
package io.realm.processor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import javax.annotation.processing.ProcessingEnvironment;
import javax.tools.Diagnostic;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\tH\u0002J\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\tH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/realm/processor/RealmVersionChecker;", "", "processingEnvironment", "Ljavax/annotation/processing/ProcessingEnvironment;", "(Ljavax/annotation/processing/ProcessingEnvironment;)V", "CONNECT_TIMEOUT", "", "READ_TIMEOUT", "REALM_ANDROID_DOWNLOAD_URL", "", "REALM_VERSION", "REALM_VERSION_PATTERN", "VERSION_URL", "checkLatestVersion", "executeRealmVersionUpdate", "", "launchRealmCheck", "printMessage", "message", "Companion", "realm-annotations-processor"})
public final class RealmVersionChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProcessingEnvironment processingEnvironment;
    @NotNull
    private final String REALM_ANDROID_DOWNLOAD_URL;
    @NotNull
    private final String VERSION_URL;
    @NotNull
    private final String REALM_VERSION;
    @NotNull
    private final String REALM_VERSION_PATTERN;
    private final int READ_TIMEOUT;
    private final int CONNECT_TIMEOUT;
    @Nullable
    private static RealmVersionChecker instance;

    private RealmVersionChecker(ProcessingEnvironment processingEnvironment) {
        this.processingEnvironment = processingEnvironment;
        this.REALM_ANDROID_DOWNLOAD_URL = "https://static.realm.io/downloads/java/latest";
        this.VERSION_URL = "https://static.realm.io/update/java?";
        this.REALM_VERSION = "10.10.0";
        this.REALM_VERSION_PATTERN = "\\d+\\.\\d+\\.\\d+";
        this.READ_TIMEOUT = 2000;
        this.CONNECT_TIMEOUT = 4000;
    }

    public final void executeRealmVersionUpdate() {
        Thread backgroundThread = new Thread(() -> RealmVersionChecker.executeRealmVersionUpdate$lambda-0(this));
        backgroundThread.start();
        try {
            backgroundThread.join(this.CONNECT_TIMEOUT + this.READ_TIMEOUT);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private final void launchRealmCheck() {
        String latestVersionStr = this.checkLatestVersion();
        if (!Intrinsics.areEqual((Object)latestVersionStr, (Object)this.REALM_VERSION)) {
            this.printMessage("Version " + latestVersionStr + " of Realm is now available: " + this.REALM_ANDROID_DOWNLOAD_URL);
        }
    }

    private final String checkLatestVersion() {
        String result = this.REALM_VERSION;
        try {
            URL url = new URL(Intrinsics.stringPlus((String)this.VERSION_URL, (Object)this.REALM_VERSION));
            URLConnection uRLConnection = url.openConnection();
            if (uRLConnection == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
            }
            HttpURLConnection conn = (HttpURLConnection)uRLConnection;
            conn.setConnectTimeout(this.CONNECT_TIMEOUT);
            conn.setReadTimeout(this.READ_TIMEOUT);
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String latestVersion = rd.readLine();
            Intrinsics.checkNotNullExpressionValue((Object)latestVersion, (String)"latestVersion");
            CharSequence charSequence = latestVersion;
            String string = this.REALM_VERSION_PATTERN;
            boolean bl = false;
            string = new Regex(string);
            bl = false;
            if (string.matches(charSequence)) {
                result = latestVersion;
            }
            rd.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private final void printMessage(String message) {
        this.processingEnvironment.getMessager().printMessage(Diagnostic.Kind.OTHER, message);
    }

    private static final void executeRealmVersionUpdate$lambda-0(RealmVersionChecker this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.launchRealmCheck();
    }

    public /* synthetic */ RealmVersionChecker(ProcessingEnvironment processingEnvironment, DefaultConstructorMarker $constructor_marker) {
        this(processingEnvironment);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/realm/processor/RealmVersionChecker$Companion;", "", "()V", "instance", "Lio/realm/processor/RealmVersionChecker;", "getInstance", "env", "Ljavax/annotation/processing/ProcessingEnvironment;", "realm-annotations-processor"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final RealmVersionChecker getInstance(@NotNull ProcessingEnvironment env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            if (instance == null) {
                Class<RealmVersionChecker> clazz = RealmVersionChecker.class;
                boolean bl = false;
                boolean bl2 = false;
                synchronized (clazz) {
                    boolean bl3 = false;
                    if (instance == null) {
                        instance = new RealmVersionChecker(env, null);
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
            RealmVersionChecker realmVersionChecker = instance;
            Intrinsics.checkNotNull((Object)realmVersionChecker);
            return realmVersionChecker;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

