/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.internal.ColumnType;
import java.util.ArrayList;
import java.util.List;

public class TableSpec {
    private List<ColumnInfo> columnInfos = new ArrayList<ColumnInfo>();

    public void addColumn(ColumnType type, String name) {
        if (name.length() > 63) {
            throw new IllegalArgumentException("Column names are currently limited to max 63 characters.");
        }
        this.columnInfos.add(new ColumnInfo(type, name));
    }

    protected void addColumn(int colTypeIndex, String name) {
        this.addColumn(ColumnType.fromNativeValue(colTypeIndex), name);
    }

    public TableSpec addSubtableColumn(String name) {
        if (name.length() > 63) {
            throw new IllegalArgumentException("Column names are currently limited to max 63 characters.");
        }
        ColumnInfo columnInfo = new ColumnInfo(ColumnType.TABLE, name);
        this.columnInfos.add(columnInfo);
        return columnInfo.tableSpec;
    }

    public TableSpec getSubtableSpec(long columnIndex) {
        return this.columnInfos.get((int)((int)columnIndex)).tableSpec;
    }

    public long getColumnCount() {
        return this.columnInfos.size();
    }

    public ColumnType getColumnType(long columnIndex) {
        return this.columnInfos.get((int)((int)columnIndex)).type;
    }

    public String getColumnName(long columnIndex) {
        return this.columnInfos.get((int)((int)columnIndex)).name;
    }

    public long getColumnIndex(String name) {
        for (int i = 0; i < this.columnInfos.size(); ++i) {
            ColumnInfo columnInfo = this.columnInfos.get(i);
            if (!columnInfo.name.equals(name)) continue;
            return i;
        }
        return -1L;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.columnInfos == null ? 0 : this.columnInfos.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TableSpec other = (TableSpec)obj;
        return !(this.columnInfos == null ? other.columnInfos != null : !this.columnInfos.equals(other.columnInfos));
    }

    public static class ColumnInfo {
        protected final ColumnType type;
        protected final String name;
        protected final TableSpec tableSpec;

        public ColumnInfo(ColumnType type, String name) {
            this.name = name;
            this.type = type;
            this.tableSpec = type == ColumnType.TABLE ? new TableSpec() : null;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.tableSpec == null ? 0 : this.tableSpec.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ColumnInfo other = (ColumnInfo)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.tableSpec == null ? other.tableSpec != null : !this.tableSpec.equals(other.tableSpec)) {
                return false;
            }
            return this.type == other.type;
        }
    }
}

