/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.exceptions.RealmException;
import io.realm.internal.CheckedRow;
import io.realm.internal.ColumnType;
import io.realm.internal.Context;
import io.realm.internal.Group;
import io.realm.internal.Mixed;
import io.realm.internal.RealmCore;
import io.realm.internal.SubtableSchema;
import io.realm.internal.TableOrView;
import io.realm.internal.TableQuery;
import io.realm.internal.TableSchema;
import io.realm.internal.TableSpec;
import io.realm.internal.TableView;
import io.realm.internal.UncheckedRow;
import java.io.Closeable;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;

public class Table
implements TableOrView,
TableSchema,
Closeable {
    public static final String TABLE_PREFIX = "class_";
    public static final long INFINITE = -1L;
    public static final String STRING_DEFAULT_VALUE = "";
    public static final long INTEGER_DEFAULT_VALUE = 0L;
    private static final String PRIMARY_KEY_TABLE_NAME = "pk";
    private static final String PRIMARY_KEY_CLASS_COLUMN_NAME = "pk_table";
    private static final long PRIMARY_KEY_CLASS_COLUMN_INDEX = 0L;
    private static final String PRIMARY_KEY_FIELD_COLUMN_NAME = "pk_property";
    private static final long PRIMARY_KEY_FIELD_COLUMN_INDEX = 1L;
    private static final long NO_PRIMARY_KEY = -2L;
    protected long nativePtr;
    protected final Object parent;
    private final Context context;
    private long cachedPrimaryKeyColumnIndex = -1L;
    protected int tableNo;
    protected boolean DEBUG = false;
    static AtomicInteger tableCount = new AtomicInteger(0);
    private InternalMethods internal = new InternalMethods();

    public Table() {
        this.parent = null;
        this.context = new Context();
        this.nativePtr = this.createNative();
        if (this.nativePtr == 0L) {
            throw new OutOfMemoryError("Out of native memory.");
        }
        if (this.DEBUG) {
            this.tableNo = tableCount.incrementAndGet();
            System.err.println("====== New Tablebase " + this.tableNo + " : ptr = " + this.nativePtr);
        }
    }

    protected native long createNative();

    Table(Context context, Object parent, long nativePointer) {
        this.context = context;
        this.parent = parent;
        this.nativePtr = nativePointer;
        if (this.DEBUG) {
            this.tableNo = tableCount.incrementAndGet();
            System.err.println("===== New Tablebase(ptr) " + this.tableNo + " : ptr = " + this.nativePtr);
        }
    }

    @Override
    public Table getTable() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Context context = this.context;
        synchronized (context) {
            if (this.nativePtr != 0L) {
                Table.nativeClose(this.nativePtr);
                if (this.DEBUG) {
                    tableCount.decrementAndGet();
                    System.err.println("==== CLOSE " + this.tableNo + " ptr= " + this.nativePtr + " remaining " + tableCount.get());
                }
                this.nativePtr = 0L;
            }
        }
    }

    protected static native void nativeClose(long var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        Context context = this.context;
        synchronized (context) {
            if (this.nativePtr != 0L) {
                boolean isRoot = this.parent == null;
                this.context.asyncDisposeTable(this.nativePtr, isRoot);
                this.nativePtr = 0L;
            }
        }
        if (this.DEBUG) {
            System.err.println("==== FINALIZE " + this.tableNo + "...");
        }
    }

    public boolean isValid() {
        return this.nativePtr != 0L && this.nativeIsValid(this.nativePtr);
    }

    protected native boolean nativeIsValid(long var1);

    private void verifyColumnName(String name) {
        if (name.length() > 63) {
            throw new IllegalArgumentException("Column names are currently limited to max 63 characters.");
        }
    }

    @Override
    public TableSchema getSubtableSchema(long columnIndex) {
        if (!this.nativeIsRootTable(this.nativePtr)) {
            throw new UnsupportedOperationException("This is a subtable. Can only be called on root table.");
        }
        long[] newPath = new long[]{columnIndex};
        return new SubtableSchema(this.nativePtr, newPath);
    }

    protected native boolean nativeIsRootTable(long var1);

    @Override
    public long addColumn(ColumnType type, String name) {
        this.verifyColumnName(name);
        return this.nativeAddColumn(this.nativePtr, type.getValue(), name);
    }

    protected native long nativeAddColumn(long var1, int var3, String var4);

    public long addColumnLink(ColumnType type, String name, Table table) {
        this.verifyColumnName(name);
        return this.nativeAddColumnLink(this.nativePtr, type.getValue(), name, table.nativePtr);
    }

    protected native long nativeAddColumnLink(long var1, int var3, String var4, long var5);

    @Override
    public void removeColumn(long columnIndex) {
        this.nativeRemoveColumn(this.nativePtr, columnIndex);
    }

    protected native void nativeRemoveColumn(long var1, long var3);

    @Override
    public void renameColumn(long columnIndex, String newName) {
        this.verifyColumnName(newName);
        this.nativeRenameColumn(this.nativePtr, columnIndex, newName);
    }

    protected native void nativeRenameColumn(long var1, long var3, String var5);

    public void updateFromSpec(TableSpec tableSpec) {
        this.checkImmutable();
        this.nativeUpdateFromSpec(this.nativePtr, tableSpec);
    }

    protected native void nativeUpdateFromSpec(long var1, TableSpec var3);

    @Override
    public long size() {
        return this.nativeSize(this.nativePtr);
    }

    protected native long nativeSize(long var1);

    @Override
    public boolean isEmpty() {
        return this.size() == 0L;
    }

    @Override
    public void clear() {
        this.checkImmutable();
        this.nativeClear(this.nativePtr);
    }

    protected native void nativeClear(long var1);

    @Override
    public long getColumnCount() {
        return this.nativeGetColumnCount(this.nativePtr);
    }

    protected native long nativeGetColumnCount(long var1);

    public TableSpec getTableSpec() {
        return this.nativeGetTableSpec(this.nativePtr);
    }

    protected native TableSpec nativeGetTableSpec(long var1);

    @Override
    public String getColumnName(long columnIndex) {
        return this.nativeGetColumnName(this.nativePtr, columnIndex);
    }

    protected native String nativeGetColumnName(long var1, long var3);

    @Override
    public long getColumnIndex(String columnName) {
        if (columnName == null) {
            throw new IllegalArgumentException("Column name can not be null.");
        }
        return this.nativeGetColumnIndex(this.nativePtr, columnName);
    }

    protected native long nativeGetColumnIndex(long var1, String var3);

    @Override
    public ColumnType getColumnType(long columnIndex) {
        return ColumnType.fromNativeValue(this.nativeGetColumnType(this.nativePtr, columnIndex));
    }

    protected native int nativeGetColumnType(long var1, long var3);

    @Override
    public void remove(long rowIndex) {
        this.checkImmutable();
        this.nativeRemove(this.nativePtr, rowIndex);
    }

    protected native void nativeRemove(long var1, long var3);

    @Override
    public void removeLast() {
        this.checkImmutable();
        this.nativeRemoveLast(this.nativePtr);
    }

    protected native void nativeRemoveLast(long var1);

    public void moveLastOver(long rowIndex) {
        this.checkImmutable();
        this.nativeMoveLastOver(this.nativePtr, rowIndex);
    }

    protected native void nativeMoveLastOver(long var1, long var3);

    public long addEmptyRow() {
        this.checkImmutable();
        if (this.hasPrimaryKey()) {
            long primaryKeyColumnIndex = this.getPrimaryKey();
            ColumnType type = this.getColumnType(primaryKeyColumnIndex);
            switch (type) {
                case STRING: {
                    if (this.findFirstString(primaryKeyColumnIndex, STRING_DEFAULT_VALUE) == -1L) break;
                    this.throwDuplicatePrimaryKeyException(STRING_DEFAULT_VALUE);
                    break;
                }
                case INTEGER: {
                    if (this.findFirstLong(primaryKeyColumnIndex, 0L) == -1L) break;
                    this.throwDuplicatePrimaryKeyException(0L);
                    break;
                }
                default: {
                    throw new RealmException("Cannot check for duplicate rows for unsupported primary key type: " + (Object)((Object)type));
                }
            }
        }
        return this.nativeAddEmptyRow(this.nativePtr, 1L);
    }

    public long addEmptyRowWithPrimaryKey(Object primaryKeyValue) {
        long rowIndex;
        this.checkImmutable();
        this.checkHasPrimaryKey();
        long primaryKeyColumnIndex = this.getPrimaryKey();
        ColumnType type = this.getColumnType(primaryKeyColumnIndex);
        switch (type) {
            case STRING: {
                if (!(primaryKeyValue instanceof String)) {
                    throw new IllegalArgumentException("Primary key value is not a String: " + primaryKeyValue);
                }
                if (this.findFirstString(primaryKeyColumnIndex, (String)primaryKeyValue) != -1L) {
                    this.throwDuplicatePrimaryKeyException(primaryKeyValue);
                }
                rowIndex = this.nativeAddEmptyRow(this.nativePtr, 1L);
                UncheckedRow row = this.getUncheckedRow(rowIndex);
                row.setString(primaryKeyColumnIndex, (String)primaryKeyValue);
                break;
            }
            case INTEGER: {
                long pkValue;
                try {
                    pkValue = Long.parseLong(primaryKeyValue.toString());
                }
                catch (RuntimeException e) {
                    throw new IllegalArgumentException("Primary key value is not a long: " + primaryKeyValue);
                }
                if (this.findFirstLong(primaryKeyColumnIndex, pkValue) != -1L) {
                    this.throwDuplicatePrimaryKeyException(pkValue);
                }
                rowIndex = this.nativeAddEmptyRow(this.nativePtr, 1L);
                UncheckedRow row = this.getUncheckedRow(rowIndex);
                row.setLong(primaryKeyColumnIndex, pkValue);
                break;
            }
            default: {
                throw new RealmException("Cannot check for duplicate rows for unsupported primary key type: " + (Object)((Object)type));
            }
        }
        return rowIndex;
    }

    public long addEmptyRows(long rows) {
        this.checkImmutable();
        if (rows < 1L) {
            throw new IllegalArgumentException("'rows' must be > 0.");
        }
        if (this.hasPrimaryKey()) {
            if (rows > 1L) {
                throw new RealmException("Multiple empty rows cannot be created if a primary key is defined for the table.");
            }
            return this.addEmptyRow();
        }
        return this.nativeAddEmptyRow(this.nativePtr, rows);
    }

    protected native long nativeAddEmptyRow(long var1, long var3);

    public long add(Object ... values) {
        long rowIndex = this.size();
        this.addAt(rowIndex, values);
        return rowIndex;
    }

    public void addAt(long rowIndex, Object ... values) {
        this.checkImmutable();
        long size = this.size();
        if (rowIndex > size) {
            throw new IllegalArgumentException("rowIndex " + String.valueOf(rowIndex) + " must be <= table.size() " + String.valueOf(size) + ".");
        }
        int columns = (int)this.getColumnCount();
        if (columns != values.length) {
            throw new IllegalArgumentException("The number of value parameters (" + String.valueOf(values.length) + ") does not match the number of columns in the table (" + String.valueOf(columns) + ").");
        }
        ColumnType[] colTypes = new ColumnType[columns];
        for (int columnIndex = 0; columnIndex < columns; ++columnIndex) {
            ColumnType colType;
            Object value = values[columnIndex];
            colTypes[columnIndex] = colType = this.getColumnType(columnIndex);
            if (colType.matchObject(value)) continue;
            String providedType = value == null ? "null" : value.getClass().toString();
            throw new IllegalArgumentException("Invalid argument no " + String.valueOf(1 + columnIndex) + ". Expected a value compatible with column type " + (Object)((Object)colType) + ", but got " + providedType + ".");
        }
        block12: for (long columnIndex = 0L; columnIndex < (long)columns; ++columnIndex) {
            Object value = values[(int)columnIndex];
            switch (colTypes[(int)columnIndex]) {
                case BOOLEAN: {
                    this.nativeInsertBoolean(this.nativePtr, columnIndex, rowIndex, (Boolean)value);
                    continue block12;
                }
                case INTEGER: {
                    long intValue = ((Number)value).longValue();
                    this.checkIntValueIsLegal(columnIndex, rowIndex, intValue);
                    this.nativeInsertLong(this.nativePtr, columnIndex, rowIndex, intValue);
                    continue block12;
                }
                case FLOAT: {
                    this.nativeInsertFloat(this.nativePtr, columnIndex, rowIndex, ((Float)value).floatValue());
                    continue block12;
                }
                case DOUBLE: {
                    this.nativeInsertDouble(this.nativePtr, columnIndex, rowIndex, (Double)value);
                    continue block12;
                }
                case STRING: {
                    String stringValue = (String)value;
                    this.checkStringValueIsLegal(columnIndex, rowIndex, stringValue);
                    this.nativeInsertString(this.nativePtr, columnIndex, rowIndex, (String)value);
                    continue block12;
                }
                case DATE: {
                    this.nativeInsertDate(this.nativePtr, columnIndex, rowIndex, ((Date)value).getTime() / 1000L);
                    continue block12;
                }
                case MIXED: {
                    this.nativeInsertMixed(this.nativePtr, columnIndex, rowIndex, Mixed.mixedValue(value));
                    continue block12;
                }
                case BINARY: {
                    this.nativeInsertByteArray(this.nativePtr, columnIndex, rowIndex, (byte[])value);
                    continue block12;
                }
                case TABLE: {
                    this.nativeInsertSubtable(this.nativePtr, columnIndex, rowIndex);
                    this.insertSubtableValues(rowIndex, columnIndex, value);
                    continue block12;
                }
                default: {
                    throw new RuntimeException("Unexpected columnType: " + String.valueOf((Object)colTypes[(int)columnIndex]));
                }
            }
        }
        this.nativeInsertDone(this.nativePtr);
    }

    private boolean isPrimaryKeyColumn(long columnIndex) {
        return columnIndex == this.getPrimaryKey();
    }

    private void insertSubtableValues(long rowIndex, long columnIndex, Object value) {
        if (value != null) {
            Table subtable = this.getSubtableDuringInsert(columnIndex, rowIndex);
            int rows = ((Object[])value).length;
            for (int i = 0; i < rows; ++i) {
                Object rowArr = ((Object[])value)[i];
                subtable.addAt(i, (Object[])rowArr);
            }
        }
    }

    public void insertLinkList(long columnIndex, long rowIndex) {
        this.nativeInsertLinkList(this.nativePtr, columnIndex, rowIndex);
        this.getInternalMethods().insertDone();
    }

    private native void nativeInsertLinkList(long var1, long var3, long var5);

    public TableView getSortedView(long columnIndex, TableView.Order order) {
        this.context.executeDelayedDisposal();
        long nativeViewPtr = this.nativeGetSortedView(this.nativePtr, columnIndex, order == TableView.Order.ascending);
        try {
            return new TableView(this.context, this, nativeViewPtr);
        }
        catch (RuntimeException e) {
            TableView.nativeClose(nativeViewPtr);
            throw e;
        }
    }

    public TableView getSortedView(long columnIndex) {
        this.context.executeDelayedDisposal();
        long nativeViewPtr = this.nativeGetSortedView(this.nativePtr, columnIndex, true);
        return new TableView(this.context, this, nativeViewPtr);
    }

    protected native long nativeGetSortedView(long var1, long var3, boolean var5);

    public TableView getSortedView(long[] columnIndices, boolean[] orders) {
        this.context.executeDelayedDisposal();
        long nativeViewPtr = this.nativeGetSortedViewMulti(this.nativePtr, columnIndices, orders);
        return new TableView(this.context, this, nativeViewPtr);
    }

    protected native long nativeGetSortedViewMulti(long var1, long[] var3, boolean[] var4);

    public void set(long rowIndex, Object ... values) {
        this.checkImmutable();
        long size = this.size();
        if (rowIndex >= size) {
            throw new IllegalArgumentException("rowIndex " + String.valueOf(rowIndex) + " must be < table.size() " + String.valueOf(size) + ".");
        }
        int columns = (int)this.getColumnCount();
        if (columns != values.length) {
            throw new IllegalArgumentException("The number of value parameters (" + String.valueOf(values.length) + ") does not match the number of columns in the table (" + String.valueOf(columns) + ").");
        }
        for (int columnIndex = 0; columnIndex < columns; ++columnIndex) {
            Object value = values[columnIndex];
            ColumnType colType = this.getColumnType(columnIndex);
            if (colType.matchObject(value)) continue;
            throw new IllegalArgumentException("Invalid argument no " + String.valueOf(1 + columnIndex) + ". Expected a value compatible with column type " + (Object)((Object)colType) + ", but got " + value.getClass() + ".");
        }
        this.remove(rowIndex);
        this.addAt(rowIndex, values);
    }

    public InternalMethods getInternalMethods() {
        return this.internal;
    }

    public long getPrimaryKey() {
        if (this.cachedPrimaryKeyColumnIndex >= 0L || this.cachedPrimaryKeyColumnIndex == -2L) {
            return this.cachedPrimaryKeyColumnIndex;
        }
        Table pkTable = this.getPrimaryKeyTable();
        if (pkTable == null) {
            return -2L;
        }
        long rowIndex = pkTable.findFirstString(0L, this.getName());
        if (rowIndex != -1L) {
            String pkColumnName = pkTable.getUncheckedRow(rowIndex).getString(1L);
            this.cachedPrimaryKeyColumnIndex = this.getColumnIndex(pkColumnName);
        } else {
            this.cachedPrimaryKeyColumnIndex = -2L;
        }
        return this.cachedPrimaryKeyColumnIndex;
    }

    public boolean isPrimaryKey(long columnIndex) {
        return columnIndex >= 0L && columnIndex == this.getPrimaryKey();
    }

    public boolean hasPrimaryKey() {
        return this.getPrimaryKey() >= 0L;
    }

    void checkStringValueIsLegal(long columnIndex, long rowToUpdate, String value) {
        long rowIndex;
        if (value == null) {
            throw new IllegalArgumentException("Null String is not allowed.");
        }
        if (this.isPrimaryKey(columnIndex) && (rowIndex = this.findFirstString(columnIndex, value)) != rowToUpdate && rowIndex != -1L) {
            this.throwDuplicatePrimaryKeyException(value);
        }
    }

    void checkIntValueIsLegal(long columnIndex, long rowToUpdate, long value) {
        long rowIndex;
        if (this.isPrimaryKeyColumn(columnIndex) && (rowIndex = this.findFirstLong(columnIndex, value)) != rowToUpdate && rowIndex != -1L) {
            this.throwDuplicatePrimaryKeyException(value);
        }
    }

    private void throwDuplicatePrimaryKeyException(Object value) {
        throw new RealmException("Primary key constraint broken. Value already exists: " + value);
    }

    protected native void nativeInsertFloat(long var1, long var3, long var5, float var7);

    protected native void nativeInsertDouble(long var1, long var3, long var5, double var7);

    protected native void nativeInsertLong(long var1, long var3, long var5, long var7);

    protected native void nativeInsertBoolean(long var1, long var3, long var5, boolean var7);

    protected native void nativeInsertDate(long var1, long var3, long var5, long var7);

    protected native void nativeInsertString(long var1, long var3, long var5, String var7);

    protected native void nativeInsertMixed(long var1, long var3, long var5, Mixed var7);

    protected native void nativeInsertByteArray(long var1, long var3, long var5, byte[] var7);

    protected native void nativeInsertSubtable(long var1, long var3, long var5);

    protected native void nativeInsertDone(long var1);

    @Override
    public long getLong(long columnIndex, long rowIndex) {
        return this.nativeGetLong(this.nativePtr, columnIndex, rowIndex);
    }

    protected native long nativeGetLong(long var1, long var3, long var5);

    @Override
    public boolean getBoolean(long columnIndex, long rowIndex) {
        return this.nativeGetBoolean(this.nativePtr, columnIndex, rowIndex);
    }

    protected native boolean nativeGetBoolean(long var1, long var3, long var5);

    @Override
    public float getFloat(long columnIndex, long rowIndex) {
        return this.nativeGetFloat(this.nativePtr, columnIndex, rowIndex);
    }

    protected native float nativeGetFloat(long var1, long var3, long var5);

    @Override
    public double getDouble(long columnIndex, long rowIndex) {
        return this.nativeGetDouble(this.nativePtr, columnIndex, rowIndex);
    }

    protected native double nativeGetDouble(long var1, long var3, long var5);

    @Override
    public Date getDate(long columnIndex, long rowIndex) {
        return new Date(this.nativeGetDateTime(this.nativePtr, columnIndex, rowIndex) * 1000L);
    }

    protected native long nativeGetDateTime(long var1, long var3, long var5);

    @Override
    public String getString(long columnIndex, long rowIndex) {
        return this.nativeGetString(this.nativePtr, columnIndex, rowIndex);
    }

    protected native String nativeGetString(long var1, long var3, long var5);

    @Override
    public byte[] getBinaryByteArray(long columnIndex, long rowIndex) {
        return this.nativeGetByteArray(this.nativePtr, columnIndex, rowIndex);
    }

    protected native byte[] nativeGetByteArray(long var1, long var3, long var5);

    @Override
    public Mixed getMixed(long columnIndex, long rowIndex) {
        return this.nativeGetMixed(this.nativePtr, columnIndex, rowIndex);
    }

    @Override
    public ColumnType getMixedType(long columnIndex, long rowIndex) {
        return ColumnType.fromNativeValue(this.nativeGetMixedType(this.nativePtr, columnIndex, rowIndex));
    }

    protected native int nativeGetMixedType(long var1, long var3, long var5);

    protected native Mixed nativeGetMixed(long var1, long var3, long var5);

    @Override
    public long getLink(long columnIndex, long rowIndex) {
        return this.nativeGetLink(this.nativePtr, columnIndex, rowIndex);
    }

    protected native long nativeGetLink(long var1, long var3, long var5);

    public Table getLinkTarget(long columnIndex) {
        this.context.executeDelayedDisposal();
        long nativeTablePointer = this.nativeGetLinkTarget(this.nativePtr, columnIndex);
        try {
            return new Table(this.context, this.parent, nativeTablePointer);
        }
        catch (RuntimeException e) {
            Table.nativeClose(nativeTablePointer);
            throw e;
        }
    }

    protected native long nativeGetLinkTarget(long var1, long var3);

    @Override
    public Table getSubtable(long columnIndex, long rowIndex) {
        this.context.executeDelayedDisposal();
        long nativeSubtablePtr = this.nativeGetSubtable(this.nativePtr, columnIndex, rowIndex);
        try {
            return new Table(this.context, this, nativeSubtablePtr);
        }
        catch (RuntimeException e) {
            Table.nativeClose(nativeSubtablePtr);
            throw e;
        }
    }

    protected native long nativeGetSubtable(long var1, long var3, long var5);

    private Table getSubtableDuringInsert(long columnIndex, long rowIndex) {
        this.context.executeDelayedDisposal();
        long nativeSubtablePtr = this.nativeGetSubtableDuringInsert(this.nativePtr, columnIndex, rowIndex);
        try {
            return new Table(this.context, this, nativeSubtablePtr);
        }
        catch (RuntimeException e) {
            Table.nativeClose(nativeSubtablePtr);
            throw e;
        }
    }

    private native long nativeGetSubtableDuringInsert(long var1, long var3, long var5);

    @Override
    public long getSubtableSize(long columnIndex, long rowIndex) {
        return this.nativeGetSubtableSize(this.nativePtr, columnIndex, rowIndex);
    }

    protected native long nativeGetSubtableSize(long var1, long var3, long var5);

    @Override
    public void clearSubtable(long columnIndex, long rowIndex) {
        this.checkImmutable();
        this.nativeClearSubtable(this.nativePtr, columnIndex, rowIndex);
    }

    protected native void nativeClearSubtable(long var1, long var3, long var5);

    public UncheckedRow getUncheckedRow(long index) {
        return UncheckedRow.get(this.context, this, index);
    }

    public CheckedRow getCheckedRow(long index) {
        return CheckedRow.get(this.context, this, index);
    }

    protected native long nativeGetRowPtr(long var1, long var3);

    @Override
    public void setLong(long columnIndex, long rowIndex, long value) {
        this.checkImmutable();
        this.checkIntValueIsLegal(columnIndex, rowIndex, value);
        this.nativeSetLong(this.nativePtr, columnIndex, rowIndex, value);
    }

    protected native void nativeSetLong(long var1, long var3, long var5, long var7);

    @Override
    public void setBoolean(long columnIndex, long rowIndex, boolean value) {
        this.checkImmutable();
        this.nativeSetBoolean(this.nativePtr, columnIndex, rowIndex, value);
    }

    protected native void nativeSetBoolean(long var1, long var3, long var5, boolean var7);

    @Override
    public void setFloat(long columnIndex, long rowIndex, float value) {
        this.checkImmutable();
        this.nativeSetFloat(this.nativePtr, columnIndex, rowIndex, value);
    }

    protected native void nativeSetFloat(long var1, long var3, long var5, float var7);

    @Override
    public void setDouble(long columnIndex, long rowIndex, double value) {
        this.checkImmutable();
        this.nativeSetDouble(this.nativePtr, columnIndex, rowIndex, value);
    }

    protected native void nativeSetDouble(long var1, long var3, long var5, double var7);

    @Override
    public void setDate(long columnIndex, long rowIndex, Date date) {
        if (date == null) {
            throw new IllegalArgumentException("Null Date is not allowed.");
        }
        this.checkImmutable();
        this.nativeSetDate(this.nativePtr, columnIndex, rowIndex, date.getTime() / 1000L);
    }

    protected native void nativeSetDate(long var1, long var3, long var5, long var7);

    @Override
    public void setString(long columnIndex, long rowIndex, String value) {
        this.checkImmutable();
        this.checkStringValueIsLegal(columnIndex, rowIndex, value);
        this.nativeSetString(this.nativePtr, columnIndex, rowIndex, value);
    }

    protected native void nativeSetString(long var1, long var3, long var5, String var7);

    @Override
    public void setBinaryByteArray(long columnIndex, long rowIndex, byte[] data) {
        this.checkImmutable();
        if (data == null) {
            throw new IllegalArgumentException("Null Array");
        }
        this.nativeSetByteArray(this.nativePtr, columnIndex, rowIndex, data);
    }

    protected native void nativeSetByteArray(long var1, long var3, long var5, byte[] var7);

    @Override
    public void setMixed(long columnIndex, long rowIndex, Mixed data) {
        this.checkImmutable();
        if (data == null) {
            throw new IllegalArgumentException();
        }
        this.nativeSetMixed(this.nativePtr, columnIndex, rowIndex, data);
    }

    protected native void nativeSetMixed(long var1, long var3, long var5, Mixed var7);

    @Override
    public void setLink(long columnIndex, long rowIndex, long value) {
        this.checkImmutable();
        this.nativeSetLink(this.nativePtr, columnIndex, rowIndex, value);
    }

    protected native void nativeSetLink(long var1, long var3, long var5, long var7);

    @Override
    public void adjust(long columnIndex, long value) {
        this.checkImmutable();
        this.nativeAddInt(this.nativePtr, columnIndex, value);
    }

    protected native void nativeAddInt(long var1, long var3, long var5);

    public void addSearchIndex(long columnIndex) {
        this.checkImmutable();
        this.nativeAddSearchIndex(this.nativePtr, columnIndex);
    }

    public void removeSearchIndex(long columnIndex) {
        this.checkImmutable();
        this.nativeRemoveSearchIndex(this.nativePtr, columnIndex);
    }

    public void setPrimaryKey(String columnName) {
        Table pkTable = this.getPrimaryKeyTable();
        if (pkTable == null) {
            throw new RealmException("Primary keys are only supported if Table is part of a Group");
        }
        this.cachedPrimaryKeyColumnIndex = this.nativeSetPrimaryKey(pkTable.nativePtr, this.nativePtr, columnName);
    }

    private native long nativeSetPrimaryKey(long var1, long var3, String var5);

    private Table getPrimaryKeyTable() {
        Group group = this.getTableGroup();
        if (group == null) {
            return null;
        }
        Table pkTable = group.getTable(PRIMARY_KEY_TABLE_NAME);
        if (pkTable.getColumnCount() == 0L) {
            pkTable.addColumn(ColumnType.STRING, PRIMARY_KEY_CLASS_COLUMN_NAME);
            pkTable.addColumn(ColumnType.STRING, PRIMARY_KEY_FIELD_COLUMN_NAME);
        } else {
            this.migratePrimaryKeyTableIfNeeded(group, pkTable);
        }
        return pkTable;
    }

    private void migratePrimaryKeyTableIfNeeded(Group group, Table pkTable) {
        this.nativeMigratePrimaryKeyTableIfNeeded(group.nativePtr, pkTable.nativePtr);
    }

    private native void nativeMigratePrimaryKeyTableIfNeeded(long var1, long var3);

    Group getTableGroup() {
        if (this.parent instanceof Group) {
            return (Group)this.parent;
        }
        if (this.parent instanceof Table) {
            return ((Table)this.parent).getTableGroup();
        }
        return null;
    }

    protected native void nativeAddSearchIndex(long var1, long var3);

    protected native void nativeRemoveSearchIndex(long var1, long var3);

    public boolean hasSearchIndex(long columnIndex) {
        return this.nativeHasSearchIndex(this.nativePtr, columnIndex);
    }

    protected native boolean nativeHasSearchIndex(long var1, long var3);

    @Override
    public boolean isNullLink(long columnIndex, long rowIndex) {
        return this.nativeIsNullLink(this.nativePtr, columnIndex, rowIndex);
    }

    protected native boolean nativeIsNullLink(long var1, long var3, long var5);

    @Override
    public void nullifyLink(long columnIndex, long rowIndex) {
        this.nativeNullifyLink(this.nativePtr, columnIndex, rowIndex);
    }

    protected native void nativeNullifyLink(long var1, long var3, long var5);

    boolean isImmutable() {
        if (!(this.parent instanceof Table)) {
            return this.parent != null && ((Group)this.parent).immutable;
        }
        return ((Table)this.parent).isImmutable();
    }

    void checkImmutable() {
        if (this.isImmutable()) {
            this.throwImmutable();
        }
    }

    private void checkHasPrimaryKey() {
        if (!this.hasPrimaryKey()) {
            throw new IllegalStateException(this.getName() + " has no primary key defined");
        }
    }

    @Override
    public long sumLong(long columnIndex) {
        return this.nativeSumInt(this.nativePtr, columnIndex);
    }

    protected native long nativeSumInt(long var1, long var3);

    @Override
    public long maximumLong(long columnIndex) {
        return this.nativeMaximumInt(this.nativePtr, columnIndex);
    }

    protected native long nativeMaximumInt(long var1, long var3);

    @Override
    public long minimumLong(long columnIndex) {
        return this.nativeMinimumInt(this.nativePtr, columnIndex);
    }

    protected native long nativeMinimumInt(long var1, long var3);

    @Override
    public double averageLong(long columnIndex) {
        return this.nativeAverageInt(this.nativePtr, columnIndex);
    }

    protected native double nativeAverageInt(long var1, long var3);

    @Override
    public double sumFloat(long columnIndex) {
        return this.nativeSumFloat(this.nativePtr, columnIndex);
    }

    protected native double nativeSumFloat(long var1, long var3);

    @Override
    public float maximumFloat(long columnIndex) {
        return this.nativeMaximumFloat(this.nativePtr, columnIndex);
    }

    protected native float nativeMaximumFloat(long var1, long var3);

    @Override
    public float minimumFloat(long columnIndex) {
        return this.nativeMinimumFloat(this.nativePtr, columnIndex);
    }

    protected native float nativeMinimumFloat(long var1, long var3);

    @Override
    public double averageFloat(long columnIndex) {
        return this.nativeAverageFloat(this.nativePtr, columnIndex);
    }

    protected native double nativeAverageFloat(long var1, long var3);

    @Override
    public double sumDouble(long columnIndex) {
        return this.nativeSumDouble(this.nativePtr, columnIndex);
    }

    protected native double nativeSumDouble(long var1, long var3);

    @Override
    public double maximumDouble(long columnIndex) {
        return this.nativeMaximumDouble(this.nativePtr, columnIndex);
    }

    protected native double nativeMaximumDouble(long var1, long var3);

    @Override
    public double minimumDouble(long columnIndex) {
        return this.nativeMinimumDouble(this.nativePtr, columnIndex);
    }

    protected native double nativeMinimumDouble(long var1, long var3);

    @Override
    public double averageDouble(long columnIndex) {
        return this.nativeAverageDouble(this.nativePtr, columnIndex);
    }

    protected native double nativeAverageDouble(long var1, long var3);

    @Override
    public Date maximumDate(long columnIndex) {
        return new Date(this.nativeMaximumDate(this.nativePtr, columnIndex) * 1000L);
    }

    protected native long nativeMaximumDate(long var1, long var3);

    @Override
    public Date minimumDate(long columnIndex) {
        return new Date(this.nativeMinimumDate(this.nativePtr, columnIndex) * 1000L);
    }

    protected native long nativeMinimumDate(long var1, long var3);

    public long count(long columnIndex, long value) {
        return this.nativeCountLong(this.nativePtr, columnIndex, value);
    }

    protected native long nativeCountLong(long var1, long var3, long var5);

    public long count(long columnIndex, float value) {
        return this.nativeCountFloat(this.nativePtr, columnIndex, value);
    }

    protected native long nativeCountFloat(long var1, long var3, float var5);

    public long count(long columnIndex, double value) {
        return this.nativeCountDouble(this.nativePtr, columnIndex, value);
    }

    protected native long nativeCountDouble(long var1, long var3, double var5);

    @Override
    public long count(long columnIndex, String value) {
        return this.nativeCountString(this.nativePtr, columnIndex, value);
    }

    protected native long nativeCountString(long var1, long var3, String var5);

    @Override
    public TableQuery where() {
        this.context.executeDelayedDisposal();
        long nativeQueryPtr = this.nativeWhere(this.nativePtr);
        try {
            return new TableQuery(this.context, this, nativeQueryPtr);
        }
        catch (RuntimeException e) {
            TableQuery.nativeClose(nativeQueryPtr);
            throw e;
        }
    }

    protected native long nativeWhere(long var1);

    @Override
    public long findFirstLong(long columnIndex, long value) {
        return this.nativeFindFirstInt(this.nativePtr, columnIndex, value);
    }

    protected native long nativeFindFirstInt(long var1, long var3, long var5);

    @Override
    public long findFirstBoolean(long columnIndex, boolean value) {
        return this.nativeFindFirstBool(this.nativePtr, columnIndex, value);
    }

    protected native long nativeFindFirstBool(long var1, long var3, boolean var5);

    @Override
    public long findFirstFloat(long columnIndex, float value) {
        return this.nativeFindFirstFloat(this.nativePtr, columnIndex, value);
    }

    protected native long nativeFindFirstFloat(long var1, long var3, float var5);

    @Override
    public long findFirstDouble(long columnIndex, double value) {
        return this.nativeFindFirstDouble(this.nativePtr, columnIndex, value);
    }

    protected native long nativeFindFirstDouble(long var1, long var3, double var5);

    @Override
    public long findFirstDate(long columnIndex, Date date) {
        if (date == null) {
            throw new IllegalArgumentException("null is not supported");
        }
        return this.nativeFindFirstDate(this.nativePtr, columnIndex, date.getTime() / 1000L);
    }

    protected native long nativeFindFirstDate(long var1, long var3, long var5);

    @Override
    public long findFirstString(long columnIndex, String value) {
        if (value == null) {
            throw new IllegalArgumentException("null is not supported");
        }
        return this.nativeFindFirstString(this.nativePtr, columnIndex, value);
    }

    protected native long nativeFindFirstString(long var1, long var3, String var5);

    @Override
    public TableView findAllLong(long columnIndex, long value) {
        this.context.executeDelayedDisposal();
        long nativeViewPtr = this.nativeFindAllInt(this.nativePtr, columnIndex, value);
        try {
            return new TableView(this.context, this, nativeViewPtr);
        }
        catch (RuntimeException e) {
            TableView.nativeClose(nativeViewPtr);
            throw e;
        }
    }

    protected native long nativeFindAllInt(long var1, long var3, long var5);

    @Override
    public TableView findAllBoolean(long columnIndex, boolean value) {
        this.context.executeDelayedDisposal();
        long nativeViewPtr = this.nativeFindAllBool(this.nativePtr, columnIndex, value);
        try {
            return new TableView(this.context, this, nativeViewPtr);
        }
        catch (RuntimeException e) {
            TableView.nativeClose(nativeViewPtr);
            throw e;
        }
    }

    protected native long nativeFindAllBool(long var1, long var3, boolean var5);

    @Override
    public TableView findAllFloat(long columnIndex, float value) {
        this.context.executeDelayedDisposal();
        long nativeViewPtr = this.nativeFindAllFloat(this.nativePtr, columnIndex, value);
        try {
            return new TableView(this.context, this, nativeViewPtr);
        }
        catch (RuntimeException e) {
            TableView.nativeClose(nativeViewPtr);
            throw e;
        }
    }

    protected native long nativeFindAllFloat(long var1, long var3, float var5);

    @Override
    public TableView findAllDouble(long columnIndex, double value) {
        this.context.executeDelayedDisposal();
        long nativeViewPtr = this.nativeFindAllDouble(this.nativePtr, columnIndex, value);
        try {
            return new TableView(this.context, this, nativeViewPtr);
        }
        catch (RuntimeException e) {
            TableView.nativeClose(nativeViewPtr);
            throw e;
        }
    }

    protected native long nativeFindAllDouble(long var1, long var3, double var5);

    @Override
    public TableView findAllDate(long columnIndex, Date date) {
        this.context.executeDelayedDisposal();
        long nativeViewPtr = this.nativeFindAllDate(this.nativePtr, columnIndex, date.getTime() / 1000L);
        try {
            return new TableView(this.context, this, nativeViewPtr);
        }
        catch (RuntimeException e) {
            TableView.nativeClose(nativeViewPtr);
            throw e;
        }
    }

    protected native long nativeFindAllDate(long var1, long var3, long var5);

    @Override
    public TableView findAllString(long columnIndex, String value) {
        this.context.executeDelayedDisposal();
        long nativeViewPtr = this.nativeFindAllString(this.nativePtr, columnIndex, value);
        try {
            return new TableView(this.context, this, nativeViewPtr);
        }
        catch (RuntimeException e) {
            TableView.nativeClose(nativeViewPtr);
            throw e;
        }
    }

    protected native long nativeFindAllString(long var1, long var3, String var5);

    @Override
    public long lowerBoundLong(long columnIndex, long value) {
        return this.nativeLowerBoundInt(this.nativePtr, columnIndex, value);
    }

    @Override
    public long upperBoundLong(long columnIndex, long value) {
        return this.nativeUpperBoundInt(this.nativePtr, columnIndex, value);
    }

    protected native long nativeLowerBoundInt(long var1, long var3, long var5);

    protected native long nativeUpperBoundInt(long var1, long var3, long var5);

    @Override
    public Table pivot(long stringCol, long intCol, TableOrView.PivotType pivotType) {
        if (!this.getColumnType(stringCol).equals((Object)ColumnType.STRING)) {
            throw new UnsupportedOperationException("Group by column must be of type String");
        }
        if (!this.getColumnType(intCol).equals((Object)ColumnType.INTEGER)) {
            throw new UnsupportedOperationException("Aggregation column must be of type Int");
        }
        Table result = new Table();
        this.nativePivot(this.nativePtr, stringCol, intCol, pivotType.value, result.nativePtr);
        return result;
    }

    protected native void nativePivot(long var1, long var3, long var5, int var7, long var8);

    public TableView getDistinctView(long columnIndex) {
        this.context.executeDelayedDisposal();
        long nativeViewPtr = this.nativeGetDistinctView(this.nativePtr, columnIndex);
        try {
            return new TableView(this.context, this, nativeViewPtr);
        }
        catch (RuntimeException e) {
            TableView.nativeClose(nativeViewPtr);
            throw e;
        }
    }

    protected native long nativeGetDistinctView(long var1, long var3);

    public String getName() {
        return this.nativeGetName(this.nativePtr);
    }

    protected native String nativeGetName(long var1);

    public void optimize() {
        this.checkImmutable();
        this.nativeOptimize(this.nativePtr);
    }

    protected native void nativeOptimize(long var1);

    @Override
    public String toJson() {
        return this.nativeToJson(this.nativePtr);
    }

    protected native String nativeToJson(long var1);

    @Override
    public String toString() {
        return this.nativeToString(this.nativePtr, -1L);
    }

    @Override
    public String toString(long maxRows) {
        return this.nativeToString(this.nativePtr, maxRows);
    }

    protected native String nativeToString(long var1, long var3);

    @Override
    public String rowToString(long rowIndex) {
        return this.nativeRowToString(this.nativePtr, rowIndex);
    }

    protected native String nativeRowToString(long var1, long var3);

    @Override
    public long sync() {
        throw new RuntimeException("Not supported for tables");
    }

    private void throwImmutable() {
        throw new IllegalStateException("Changing Realm data can only be done from inside a transaction.");
    }

    public boolean hasSameSchema(Table table) {
        if (table == null) {
            throw new IllegalArgumentException("The argument cannot be null");
        }
        return this.nativeHasSameSchema(this.nativePtr, table.nativePtr);
    }

    protected native boolean nativeHasSameSchema(long var1, long var3);

    static {
        RealmCore.loadLibrary();
    }

    public class InternalMethods {
        public void insertLong(long columnIndex, long rowIndex, long value) {
            Table.this.checkImmutable();
            Table.this.nativeInsertLong(Table.this.nativePtr, columnIndex, rowIndex, value);
        }

        public void insertDouble(long columnIndex, long rowIndex, double value) {
            Table.this.checkImmutable();
            Table.this.nativeInsertDouble(Table.this.nativePtr, columnIndex, rowIndex, value);
        }

        public void insertFloat(long columnIndex, long rowIndex, float value) {
            Table.this.checkImmutable();
            Table.this.nativeInsertFloat(Table.this.nativePtr, columnIndex, rowIndex, value);
        }

        public void insertBoolean(long columnIndex, long rowIndex, boolean value) {
            Table.this.checkImmutable();
            Table.this.nativeInsertBoolean(Table.this.nativePtr, columnIndex, rowIndex, value);
        }

        public void insertDate(long columnIndex, long rowIndex, Date date) {
            Table.this.checkImmutable();
            Table.this.nativeInsertDate(Table.this.nativePtr, columnIndex, rowIndex, date.getTime() / 1000L);
        }

        public void insertString(long columnIndex, long rowIndex, String value) {
            Table.this.checkImmutable();
            Table.this.nativeInsertString(Table.this.nativePtr, columnIndex, rowIndex, value);
        }

        public void insertMixed(long columnIndex, long rowIndex, Mixed data) {
            Table.this.checkImmutable();
            Table.this.nativeInsertMixed(Table.this.nativePtr, columnIndex, rowIndex, data);
        }

        public void insertBinary(long columnIndex, long rowIndex, byte[] data) {
            Table.this.checkImmutable();
            if (data == null) {
                throw new IllegalArgumentException("byte[] must not be null. Alternatively insert empty array.");
            }
            Table.this.nativeInsertByteArray(Table.this.nativePtr, columnIndex, rowIndex, data);
        }

        public void insertSubtable(long columnIndex, long rowIndex, Object[][] values) {
            Table.this.checkImmutable();
            Table.this.nativeInsertSubtable(Table.this.nativePtr, columnIndex, rowIndex);
            Table.this.insertSubtableValues(rowIndex, columnIndex, values);
        }

        public void insertDone() {
            Table.this.checkImmutable();
            Table.this.nativeInsertDone(Table.this.nativePtr);
        }
    }
}

