/*
 * Decompiled with CFR 0.152.
 */
package io.realm.dynamic;

import io.realm.Realm;
import io.realm.dynamic.DynamicRealmObject;
import io.realm.internal.LinkView;
import java.util.AbstractList;

public class DynamicRealmList
extends AbstractList<DynamicRealmObject> {
    private final LinkView linkView;
    private final Realm realm;

    DynamicRealmList(LinkView linkView, Realm realm) {
        this.linkView = linkView;
        this.realm = realm;
    }

    @Override
    public boolean add(DynamicRealmObject object) {
        this.checkIsValidObject(object);
        this.linkView.add(object.row.getIndex());
        return true;
    }

    @Override
    public void clear() {
        this.linkView.clear();
    }

    @Override
    public DynamicRealmObject get(int location) {
        this.checkValidIndex(location);
        return new DynamicRealmObject(this.realm, this.linkView.getCheckedRow(location));
    }

    @Override
    public DynamicRealmObject remove(int location) {
        DynamicRealmObject removedItem = this.get(location);
        this.linkView.remove(location);
        return removedItem;
    }

    @Override
    public DynamicRealmObject set(int location, DynamicRealmObject object) {
        this.checkIsValidObject(object);
        this.checkValidIndex(location);
        this.linkView.set(location, object.row.getIndex());
        return object;
    }

    @Override
    public int size() {
        long size = this.linkView.size();
        return size < Integer.MAX_VALUE ? (int)size : Integer.MAX_VALUE;
    }

    private void checkIsValidObject(DynamicRealmObject object) {
        if (object == null) {
            throw new IllegalArgumentException("DynamicRealmList does not accept null values");
        }
        if (!this.realm.getConfiguration().equals(object.realm.getConfiguration())) {
            throw new IllegalArgumentException("Cannot add an object belonging to another Realm");
        }
        if (!this.linkView.getTable().hasSameSchema(object.row.getTable())) {
            String expectedClass = this.linkView.getTable().getName();
            String objectClassName = object.row.getTable().getName();
            throw new IllegalArgumentException("Object is of type " + objectClassName + ". Expected " + expectedClass);
        }
    }

    private void checkValidIndex(int index) {
        long size = this.linkView.size();
        if (index < 0 || (long)index >= size) {
            throw new IndexOutOfBoundsException(String.format("Invalid index: %d. Valid range is [%d, %d]", index, 0, size - 1L));
        }
    }
}

