/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import android.content.Context;
import android.view.LayoutInflater;
import android.widget.BaseAdapter;
import io.realm.RealmChangeListener;
import io.realm.RealmObject;
import io.realm.RealmResults;

public abstract class RealmBaseAdapter<T extends RealmObject>
extends BaseAdapter {
    protected LayoutInflater inflater;
    protected RealmResults<T> realmResults;
    protected Context context;
    private final RealmChangeListener listener;

    public RealmBaseAdapter(Context context, RealmResults<T> realmResults, boolean automaticUpdate) {
        if (context == null) {
            throw new IllegalArgumentException("Context cannot be null");
        }
        this.context = context;
        this.realmResults = realmResults;
        this.inflater = LayoutInflater.from((Context)context);
        RealmChangeListener realmChangeListener = this.listener = !automaticUpdate ? null : new RealmChangeListener(){

            @Override
            public void onChange() {
                RealmBaseAdapter.this.notifyDataSetChanged();
            }
        };
        if (this.listener != null && realmResults != null) {
            realmResults.getRealm().addChangeListener(this.listener);
        }
    }

    public int getCount() {
        if (this.realmResults == null) {
            return 0;
        }
        return this.realmResults.size();
    }

    public T getItem(int i) {
        if (this.realmResults == null) {
            return null;
        }
        return (T)this.realmResults.get(i);
    }

    public long getItemId(int i) {
        return i;
    }

    public void updateRealmResults(RealmResults<T> queryResults) {
        if (this.listener != null) {
            if (this.realmResults != null) {
                this.realmResults.getRealm().removeChangeListener(this.listener);
            }
            if (queryResults != null) {
                queryResults.getRealm().addChangeListener(this.listener);
            }
        }
        this.realmResults = queryResults;
        this.notifyDataSetChanged();
    }
}

