/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.JsonReader;
import io.realm.RealmChangeListener;
import io.realm.RealmConfiguration;
import io.realm.RealmMigration;
import io.realm.RealmObject;
import io.realm.RealmQuery;
import io.realm.RealmResults;
import io.realm.exceptions.RealmException;
import io.realm.exceptions.RealmMigrationNeededException;
import io.realm.internal.ColumnIndices;
import io.realm.internal.ColumnType;
import io.realm.internal.ImplicitTransaction;
import io.realm.internal.RealmObjectProxy;
import io.realm.internal.RealmProxyMediator;
import io.realm.internal.SharedGroup;
import io.realm.internal.Table;
import io.realm.internal.TableView;
import io.realm.internal.UncheckedRow;
import io.realm.internal.Util;
import io.realm.internal.android.ReleaseAndroidLogger;
import io.realm.internal.log.RealmLog;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class Realm
implements Closeable {
    public static final String DEFAULT_REALM_NAME = "default.realm";
    protected static final ThreadLocal<Map<RealmConfiguration, Realm>> realmsCache = new ThreadLocal<Map<RealmConfiguration, Realm>>(){

        @Override
        protected Map<RealmConfiguration, Realm> initialValue() {
            return new HashMap<RealmConfiguration, Realm>();
        }
    };
    private static final ThreadLocal<Map<RealmConfiguration, Integer>> referenceCount = new ThreadLocal<Map<RealmConfiguration, Integer>>(){

        @Override
        protected Map<RealmConfiguration, Integer> initialValue() {
            return new HashMap<RealmConfiguration, Integer>();
        }
    };
    private static final Map<String, List<RealmConfiguration>> globalPathConfigurationCache = new HashMap<String, List<RealmConfiguration>>();
    private static final Map<String, AtomicInteger> globalOpenInstanceCounter = new ConcurrentHashMap<String, AtomicInteger>();
    protected static final Map<Handler, String> handlers = new ConcurrentHashMap<Handler, String>();
    private static final int REALM_CHANGED = 14930352;
    private static RealmConfiguration defaultConfiguration;
    private final Map<Class<? extends RealmObject>, Table> classToTable = new HashMap<Class<? extends RealmObject>, Table>();
    private static final String INCORRECT_THREAD_MESSAGE = "Realm access from incorrect thread. Realm objects can only be accessed on the thread they were created.";
    private static final String INCORRECT_THREAD_CLOSE_MESSAGE = "Realm access from incorrect thread. Realm instance can only be closed on the thread it was created.";
    private static final String CLOSED_REALM_MESSAGE = "This Realm instance has already been closed, making it unusable.";
    private static final String DIFFERENT_KEY_MESSAGE = "Wrong key used to decrypt Realm.";
    private static SharedGroup.Durability defaultDurability;
    private boolean autoRefresh;
    private Handler handler;
    private long threadId;
    private RealmConfiguration configuration;
    private SharedGroup sharedGroup;
    private final ImplicitTransaction transaction;
    private final List<WeakReference<RealmChangeListener>> changeListeners = new CopyOnWriteArrayList<WeakReference<RealmChangeListener>>();
    private static final long UNVERSIONED = -1L;
    final ColumnIndices columnIndices = new ColumnIndices();

    protected void checkIfValid() {
        if (this.sharedGroup == null) {
            throw new IllegalStateException(CLOSED_REALM_MESSAGE);
        }
        if (this.threadId != Thread.currentThread().getId()) {
            throw new IllegalStateException(INCORRECT_THREAD_MESSAGE);
        }
    }

    private Realm(RealmConfiguration configuration, boolean autoRefresh) {
        this.threadId = Thread.currentThread().getId();
        this.configuration = configuration;
        this.sharedGroup = new SharedGroup(configuration.getPath(), true, configuration.getDurability(), configuration.getEncryptionKey());
        this.transaction = this.sharedGroup.beginImplicitTransaction();
        this.setAutoRefresh(autoRefresh);
    }

    protected void finalize() throws Throwable {
        if (this.sharedGroup != null) {
            RealmLog.w("Remember to call close() on all Realm instances. Realm " + this.configuration.getPath() + " is being finalized without being closed, " + "this can lead to running out of native memory.");
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void close() {
        int refCount;
        if (this.threadId != Thread.currentThread().getId()) {
            throw new IllegalStateException(INCORRECT_THREAD_CLOSE_MESSAGE);
        }
        Map<RealmConfiguration, Integer> localRefCount = referenceCount.get();
        String canonicalPath = this.configuration.getPath();
        Integer references = localRefCount.get(this.configuration);
        if (references == null) {
            references = 0;
        }
        if (this.sharedGroup != null && references == 1) {
            AtomicInteger counter;
            realmsCache.get().remove(this.configuration);
            this.sharedGroup.close();
            this.sharedGroup = null;
            Class<Realm> clazz = Realm.class;
            // MONITORENTER : io.realm.Realm.class
            List<RealmConfiguration> pathConfigurationCache = globalPathConfigurationCache.get(canonicalPath);
            pathConfigurationCache.remove(this.configuration);
            if (pathConfigurationCache.isEmpty()) {
                globalPathConfigurationCache.remove(canonicalPath);
            }
            if ((counter = globalOpenInstanceCounter.get(canonicalPath)).decrementAndGet() == 0) {
                globalOpenInstanceCounter.remove(canonicalPath);
            }
            // MONITOREXIT : clazz
        }
        if ((refCount = references - 1) < 0) {
            RealmLog.w("Calling close() on a Realm that is already closed: " + canonicalPath);
        }
        localRefCount.put(this.configuration, Math.max(0, refCount));
        if (this.handler == null) return;
        if (refCount > 0) return;
        this.removeHandler(this.handler);
    }

    private void removeHandler(Handler handler) {
        handler.removeCallbacksAndMessages(null);
        handlers.remove(handler);
    }

    public boolean isAutoRefresh() {
        return this.autoRefresh;
    }

    public void setAutoRefresh(boolean autoRefresh) {
        if (autoRefresh && Looper.myLooper() == null) {
            throw new IllegalStateException("Cannot set auto-refresh in a Thread without a Looper");
        }
        if (autoRefresh && !this.autoRefresh) {
            this.handler = new Handler((Handler.Callback)new RealmCallback());
            handlers.put(this.handler, this.configuration.getPath());
        } else if (!autoRefresh && this.autoRefresh && this.handler != null) {
            this.removeHandler(this.handler);
        }
        this.autoRefresh = autoRefresh;
    }

    public Table getTable(Class<? extends RealmObject> clazz) {
        Table table = this.classToTable.get(clazz);
        if (table == null) {
            clazz = Util.getOriginalModelClass(clazz);
            table = this.transaction.getTable(this.configuration.getSchemaMediator().getTableName(clazz));
            this.classToTable.put(clazz, table);
        }
        return table;
    }

    public static Realm getInstance(Context context) {
        return Realm.getInstance(context, DEFAULT_REALM_NAME);
    }

    @Deprecated
    public static Realm getInstance(Context context, String fileName) {
        return Realm.getInstance(context, fileName, null);
    }

    @Deprecated
    public static Realm getInstance(Context context, byte[] key) {
        return Realm.getInstance(context, DEFAULT_REALM_NAME, key);
    }

    @Deprecated
    public static Realm getInstance(Context context, String fileName, byte[] key) {
        RealmConfiguration.Builder builder = new RealmConfiguration.Builder(context).name(fileName);
        if (key != null) {
            builder.encryptionKey(key);
        }
        return Realm.create(builder.build());
    }

    @Deprecated
    public static Realm getInstance(File writableFolder) {
        return Realm.create(new RealmConfiguration.Builder(writableFolder).name(DEFAULT_REALM_NAME).build());
    }

    @Deprecated
    public static Realm getInstance(File writableFolder, String fileName) {
        return Realm.create(new RealmConfiguration.Builder(writableFolder).name(fileName).build());
    }

    @Deprecated
    public static Realm getInstance(File writableFolder, byte[] key) {
        return Realm.create(new RealmConfiguration.Builder(writableFolder).name(DEFAULT_REALM_NAME).encryptionKey(key).build());
    }

    @Deprecated
    public static Realm getInstance(File writableFolder, String fileName, byte[] key) {
        return Realm.create(new RealmConfiguration.Builder(writableFolder).name(fileName).encryptionKey(key).build());
    }

    public static Realm getDefaultInstance() {
        if (defaultConfiguration == null) {
            throw new NullPointerException("No default RealmConfiguration was found. Call setDefaultConfiguration() first");
        }
        return Realm.create(defaultConfiguration);
    }

    public static Realm getInstance(RealmConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("A non-null RealmConfiguration must be provided");
        }
        return Realm.create(configuration);
    }

    public static void setDefaultConfiguration(RealmConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("A non-null RealmConfiguration must be provided");
        }
        defaultConfiguration = configuration;
    }

    public static void removeDefaultConfiguration() {
        defaultConfiguration = null;
    }

    private static Realm create(RealmConfiguration configuration) {
        boolean autoRefresh = Looper.myLooper() != null;
        try {
            return Realm.createAndValidate(configuration, true, autoRefresh);
        }
        catch (RealmMigrationNeededException e) {
            if (configuration.shouldDeleteRealmIfMigrationNeeded()) {
                Realm.deleteRealm(configuration);
            } else {
                Realm.migrateRealm(configuration);
            }
            return Realm.createAndValidate(configuration, true, autoRefresh);
        }
    }

    private static synchronized Realm createAndValidate(RealmConfiguration configuration, boolean validateSchema, boolean autoRefresh) {
        Map<RealmConfiguration, Realm> realms;
        Realm realm;
        String canonicalPath = configuration.getPath();
        Map<RealmConfiguration, Integer> localRefCount = referenceCount.get();
        Integer references = localRefCount.get(configuration);
        if (references == null) {
            references = 0;
        }
        if ((realm = (realms = realmsCache.get()).get(configuration)) != null) {
            localRefCount.put(configuration, references + 1);
            return realm;
        }
        Realm.validateAgainstExistingConfigurations(configuration);
        realm = new Realm(configuration, autoRefresh);
        List<RealmConfiguration> pathConfigurationCache = globalPathConfigurationCache.get(canonicalPath);
        if (pathConfigurationCache == null) {
            pathConfigurationCache = new CopyOnWriteArrayList<RealmConfiguration>();
            globalPathConfigurationCache.put(canonicalPath, pathConfigurationCache);
        }
        pathConfigurationCache.add(configuration);
        realms.put(configuration, realm);
        localRefCount.put(configuration, references + 1);
        if (references == 0) {
            AtomicInteger counter = globalOpenInstanceCounter.get(canonicalPath);
            if (counter == null) {
                globalOpenInstanceCounter.put(canonicalPath, new AtomicInteger(1));
            } else {
                counter.incrementAndGet();
            }
        }
        long currentVersion = realm.getVersion();
        long requiredVersion = configuration.getSchemaVersion();
        if (currentVersion != -1L && currentVersion < requiredVersion && validateSchema) {
            realm.close();
            throw new RealmMigrationNeededException(canonicalPath, String.format("Realm on disc need to migrate from v%s to v%s", currentVersion, requiredVersion));
        }
        if (currentVersion != -1L && requiredVersion < currentVersion && validateSchema) {
            realm.close();
            throw new IllegalArgumentException(String.format("Realm on disc is newer than the one specified: v%s vs. v%s", currentVersion, requiredVersion));
        }
        if (validateSchema) {
            try {
                Realm.initializeRealm(realm);
            }
            catch (RuntimeException e) {
                realm.close();
                throw e;
            }
        }
        return realm;
    }

    private static void validateAgainstExistingConfigurations(RealmConfiguration newConfiguration) {
        String realmPath = newConfiguration.getPath();
        List<RealmConfiguration> pathConfigurationCache = globalPathConfigurationCache.get(realmPath);
        if (pathConfigurationCache != null && pathConfigurationCache.size() > 0) {
            SharedGroup.Durability newDurability;
            RealmProxyMediator schema;
            RealmConfiguration cachedConfiguration = pathConfigurationCache.get(0);
            if (!Arrays.equals(cachedConfiguration.getEncryptionKey(), newConfiguration.getEncryptionKey())) {
                throw new IllegalArgumentException(DIFFERENT_KEY_MESSAGE);
            }
            if (cachedConfiguration.getSchemaVersion() != newConfiguration.getSchemaVersion()) {
                throw new IllegalArgumentException(String.format("Configurations cannot have different schema versions if used to open the same file. %d vs. %d", cachedConfiguration.getSchemaVersion(), newConfiguration.getSchemaVersion()));
            }
            RealmProxyMediator cachedSchema = cachedConfiguration.getSchemaMediator();
            if (!cachedSchema.equals(schema = newConfiguration.getSchemaMediator())) {
                throw new IllegalArgumentException("Two configurations with different schemas are trying to open the same Realm file. Their schema must be the same: " + newConfiguration.getPath());
            }
            SharedGroup.Durability cachedDurability = cachedConfiguration.getDurability();
            if (!cachedDurability.equals((Object)(newDurability = newConfiguration.getDurability()))) {
                throw new IllegalArgumentException("A Realm cannot be both in-memory and persisted. Two conflicting configurations pointing to " + newConfiguration.getPath() + " are being used.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeRealm(Realm realm) {
        long version = realm.getVersion();
        boolean commitNeeded = false;
        try {
            realm.beginTransaction();
            if (version == -1L) {
                commitNeeded = true;
                realm.setVersion(realm.configuration.getSchemaVersion());
            }
            RealmProxyMediator mediator = realm.configuration.getSchemaMediator();
            for (Class<? extends RealmObject> modelClass : mediator.getModelClasses()) {
                if (version == -1L) {
                    mediator.createTable(modelClass, realm.transaction);
                }
                mediator.validateTable(modelClass, realm.transaction);
                realm.columnIndices.addClass(modelClass, mediator.getColumnIndices(modelClass));
            }
        }
        finally {
            if (commitNeeded) {
                realm.commitTransaction();
            } else {
                realm.cancelTransaction();
            }
        }
    }

    public <E extends RealmObject> void createAllFromJson(Class<E> clazz, JSONArray json) {
        if (clazz == null || json == null) {
            return;
        }
        for (int i = 0; i < json.length(); ++i) {
            try {
                this.configuration.getSchemaMediator().createOrUpdateUsingJsonObject(clazz, this, json.getJSONObject(i), false);
                continue;
            }
            catch (Exception e) {
                throw new RealmException("Could not map Json", e);
            }
        }
    }

    public <E extends RealmObject> void createOrUpdateAllFromJson(Class<E> clazz, JSONArray json) {
        if (clazz == null || json == null) {
            return;
        }
        this.checkHasPrimaryKey(clazz);
        for (int i = 0; i < json.length(); ++i) {
            try {
                this.configuration.getSchemaMediator().createOrUpdateUsingJsonObject(clazz, this, json.getJSONObject(i), true);
                continue;
            }
            catch (Exception e) {
                throw new RealmException("Could not map Json", e);
            }
        }
    }

    public <E extends RealmObject> void createAllFromJson(Class<E> clazz, String json) {
        JSONArray arr;
        if (clazz == null || json == null || json.length() == 0) {
            return;
        }
        try {
            arr = new JSONArray(json);
        }
        catch (Exception e) {
            throw new RealmException("Could not create JSON array from string", e);
        }
        this.createAllFromJson(clazz, arr);
    }

    public <E extends RealmObject> void createOrUpdateAllFromJson(Class<E> clazz, String json) {
        JSONArray arr;
        if (clazz == null || json == null || json.length() == 0) {
            return;
        }
        this.checkHasPrimaryKey(clazz);
        try {
            arr = new JSONArray(json);
        }
        catch (JSONException e) {
            throw new RealmException("Could not create JSON array from string", e);
        }
        this.createOrUpdateAllFromJson(clazz, arr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=11)
    public <E extends RealmObject> void createAllFromJson(Class<E> clazz, InputStream inputStream) throws IOException {
        if (clazz == null || inputStream == null) {
            return;
        }
        JsonReader reader = new JsonReader((Reader)new InputStreamReader(inputStream, "UTF-8"));
        try {
            reader.beginArray();
            while (reader.hasNext()) {
                this.configuration.getSchemaMediator().createUsingJsonStream(clazz, this, reader);
            }
            reader.endArray();
        }
        finally {
            reader.close();
        }
    }

    @TargetApi(value=11)
    public <E extends RealmObject> void createOrUpdateAllFromJson(Class<E> clazz, InputStream in) throws IOException {
        if (clazz == null || in == null) {
            return;
        }
        this.checkHasPrimaryKey(clazz);
        Scanner scanner = null;
        try {
            scanner = this.getFullStringScanner(in);
            JSONArray json = new JSONArray(scanner.next());
            for (int i = 0; i < json.length(); ++i) {
                this.configuration.getSchemaMediator().createOrUpdateUsingJsonObject(clazz, this, json.getJSONObject(i), true);
            }
        }
        catch (JSONException e) {
            throw new RealmException("Failed to read JSON", e);
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
    }

    public <E extends RealmObject> E createObjectFromJson(Class<E> clazz, JSONObject json) {
        if (clazz == null || json == null) {
            return null;
        }
        try {
            return this.configuration.getSchemaMediator().createOrUpdateUsingJsonObject(clazz, this, json, false);
        }
        catch (Exception e) {
            throw new RealmException("Could not map Json", e);
        }
    }

    public <E extends RealmObject> E createOrUpdateObjectFromJson(Class<E> clazz, JSONObject json) {
        if (clazz == null || json == null) {
            return null;
        }
        this.checkHasPrimaryKey(clazz);
        try {
            return this.configuration.getSchemaMediator().createOrUpdateUsingJsonObject(clazz, this, json, true);
        }
        catch (JSONException e) {
            throw new RealmException("Could not map Json", e);
        }
    }

    public <E extends RealmObject> E createObjectFromJson(Class<E> clazz, String json) {
        JSONObject obj;
        if (clazz == null || json == null || json.length() == 0) {
            return null;
        }
        try {
            obj = new JSONObject(json);
        }
        catch (Exception e) {
            throw new RealmException("Could not create Json object from string", e);
        }
        return this.createObjectFromJson(clazz, obj);
    }

    public <E extends RealmObject> E createOrUpdateObjectFromJson(Class<E> clazz, String json) {
        JSONObject obj;
        if (clazz == null || json == null || json.length() == 0) {
            return null;
        }
        this.checkHasPrimaryKey(clazz);
        try {
            obj = new JSONObject(json);
        }
        catch (Exception e) {
            throw new RealmException("Could not create Json object from string", e);
        }
        return this.createOrUpdateObjectFromJson(clazz, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=11)
    public <E extends RealmObject> E createObjectFromJson(Class<E> clazz, InputStream inputStream) throws IOException {
        if (clazz == null || inputStream == null) {
            return null;
        }
        JsonReader reader = new JsonReader((Reader)new InputStreamReader(inputStream, "UTF-8"));
        try {
            E e = this.configuration.getSchemaMediator().createUsingJsonStream(clazz, this, reader);
            return e;
        }
        finally {
            reader.close();
        }
    }

    @TargetApi(value=11)
    public <E extends RealmObject> E createOrUpdateObjectFromJson(Class<E> clazz, InputStream in) throws IOException {
        if (clazz == null || in == null) {
            return null;
        }
        this.checkHasPrimaryKey(clazz);
        Scanner scanner = null;
        try {
            scanner = this.getFullStringScanner(in);
            JSONObject json = new JSONObject(scanner.next());
            E e = this.configuration.getSchemaMediator().createOrUpdateUsingJsonObject(clazz, this, json, true);
            return e;
        }
        catch (JSONException e) {
            throw new RealmException("Failed to read JSON", e);
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
    }

    private Scanner getFullStringScanner(InputStream in) {
        return new Scanner(in, "UTF-8").useDelimiter("\\A");
    }

    public void writeCopyTo(File destination) throws IOException {
        this.writeEncryptedCopyTo(destination, null);
    }

    public void writeEncryptedCopyTo(File destination, byte[] key) throws IOException {
        if (destination == null) {
            throw new IllegalArgumentException("The destination argument cannot be null");
        }
        this.checkIfValid();
        this.transaction.writeToFile(destination, key);
    }

    public <E extends RealmObject> E createObject(Class<E> clazz) {
        Table table = this.getTable(clazz);
        long rowIndex = table.addEmptyRow();
        return this.get(clazz, rowIndex);
    }

    <E extends RealmObject> E createObject(Class<E> clazz, Object primaryKeyValue) {
        Table table = this.getTable(clazz);
        long rowIndex = table.addEmptyRowWithPrimaryKey(primaryKeyValue);
        return this.get(clazz, rowIndex);
    }

    void remove(Class<? extends RealmObject> clazz, long objectIndex) {
        this.getTable(clazz).moveLastOver(objectIndex);
    }

    <E extends RealmObject> E get(Class<E> clazz, long rowIndex) {
        Table table = this.getTable(clazz);
        UncheckedRow row = table.getUncheckedRow(rowIndex);
        E result = this.configuration.getSchemaMediator().newInstance(clazz);
        ((RealmObject)result).row = row;
        ((RealmObject)result).realm = this;
        return result;
    }

    public <E extends RealmObject> E copyToRealm(E object) {
        this.checkNotNullObject(object);
        return this.copyOrUpdate(object, false);
    }

    public <E extends RealmObject> E copyToRealmOrUpdate(E object) {
        this.checkNotNullObject(object);
        this.checkHasPrimaryKey(object.getClass());
        return this.copyOrUpdate(object, true);
    }

    public <E extends RealmObject> List<E> copyToRealm(Iterable<E> objects) {
        if (objects == null) {
            return new ArrayList();
        }
        ArrayList<RealmObject> realmObjects = new ArrayList<RealmObject>();
        for (RealmObject object : objects) {
            realmObjects.add(this.copyToRealm(object));
        }
        return realmObjects;
    }

    public <E extends RealmObject> List<E> copyToRealmOrUpdate(Iterable<E> objects) {
        if (objects == null) {
            return new ArrayList();
        }
        ArrayList<RealmObject> realmObjects = new ArrayList<RealmObject>();
        for (RealmObject object : objects) {
            realmObjects.add(this.copyToRealmOrUpdate(object));
        }
        return realmObjects;
    }

    boolean contains(Class<? extends RealmObject> clazz) {
        return this.configuration.getSchemaMediator().getModelClasses().contains(clazz);
    }

    public <E extends RealmObject> RealmQuery<E> where(Class<E> clazz) {
        this.checkIfValid();
        return new RealmQuery<E>(this, clazz);
    }

    public <E extends RealmObject> RealmResults<E> allObjects(Class<E> clazz) {
        return this.where(clazz).findAll();
    }

    public <E extends RealmObject> RealmResults<E> allObjectsSorted(Class<E> clazz, String fieldName, boolean sortAscending) {
        this.checkIfValid();
        Table table = this.getTable(clazz);
        TableView.Order order = sortAscending ? TableView.Order.ascending : TableView.Order.descending;
        long columnIndex = this.columnIndices.getColumnIndex(clazz, fieldName);
        if (columnIndex < 0L) {
            throw new IllegalArgumentException(String.format("Field name '%s' does not exist.", fieldName));
        }
        TableView tableView = table.getSortedView(columnIndex, order);
        return new RealmResults<E>(this, tableView, clazz);
    }

    public <E extends RealmObject> RealmResults<E> allObjectsSorted(Class<E> clazz, String fieldName1, boolean sortAscending1, String fieldName2, boolean sortAscending2) {
        return this.allObjectsSorted(clazz, new String[]{fieldName1, fieldName2}, new boolean[]{sortAscending1, sortAscending2});
    }

    public <E extends RealmObject> RealmResults<E> allObjectsSorted(Class<E> clazz, String fieldName1, boolean sortAscending1, String fieldName2, boolean sortAscending2, String fieldName3, boolean sortAscending3) {
        return this.allObjectsSorted(clazz, new String[]{fieldName1, fieldName2, fieldName3}, new boolean[]{sortAscending1, sortAscending2, sortAscending3});
    }

    public <E extends RealmObject> RealmResults<E> allObjectsSorted(Class<E> clazz, String[] fieldNames, boolean[] sortAscending) {
        if (fieldNames == null) {
            throw new IllegalArgumentException("fieldNames must be provided.");
        }
        if (sortAscending == null) {
            throw new IllegalArgumentException("sortAscending must be provided.");
        }
        Table table = this.getTable(clazz);
        long[] columnIndices = new long[fieldNames.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            String fieldName = fieldNames[i];
            long columnIndex = table.getColumnIndex(fieldName);
            if (columnIndex == -1L) {
                throw new IllegalArgumentException(String.format("Field name '%s' does not exist.", fieldName));
            }
            columnIndices[i] = columnIndex;
        }
        TableView tableView = table.getSortedView(columnIndices, sortAscending);
        return new RealmResults<E>(this, tableView, clazz);
    }

    public void addChangeListener(RealmChangeListener listener) {
        this.checkIfValid();
        for (WeakReference<RealmChangeListener> ref : this.changeListeners) {
            if (ref.get() != listener) continue;
            return;
        }
        this.changeListeners.add(new WeakReference<RealmChangeListener>(listener));
    }

    public void removeChangeListener(RealmChangeListener listener) {
        this.checkIfValid();
        WeakReference<RealmChangeListener> weakRefToRemove = null;
        for (WeakReference<RealmChangeListener> weakRef : this.changeListeners) {
            if (listener != weakRef.get()) continue;
            weakRefToRemove = weakRef;
            break;
        }
        if (weakRefToRemove != null) {
            this.changeListeners.remove(weakRefToRemove);
        }
    }

    public void removeAllChangeListeners() {
        this.checkIfValid();
        this.changeListeners.clear();
    }

    protected List<WeakReference<RealmChangeListener>> getChangeListeners() {
        return this.changeListeners;
    }

    private void sendNotifications() {
        Iterator<WeakReference<RealmChangeListener>> iterator = this.changeListeners.iterator();
        ArrayList<WeakReference<RealmChangeListener>> toRemoveList = null;
        while (iterator.hasNext()) {
            WeakReference<RealmChangeListener> weakRef = iterator.next();
            RealmChangeListener listener = (RealmChangeListener)weakRef.get();
            if (listener == null) {
                if (toRemoveList == null) {
                    toRemoveList = new ArrayList<WeakReference<RealmChangeListener>>(this.changeListeners.size());
                }
                toRemoveList.add(weakRef);
                continue;
            }
            listener.onChange();
        }
        if (toRemoveList != null) {
            this.changeListeners.removeAll(toRemoveList);
        }
    }

    boolean hasChanged() {
        return this.sharedGroup.hasChanged();
    }

    public void refresh() {
        this.checkIfValid();
        this.transaction.advanceRead();
    }

    public void beginTransaction() {
        this.checkIfValid();
        this.transaction.promoteToWrite();
    }

    public void commitTransaction() {
        this.checkIfValid();
        this.transaction.commitAndContinueAsRead();
        for (Map.Entry<Handler, String> handlerIntegerEntry : handlers.entrySet()) {
            Handler handler = handlerIntegerEntry.getKey();
            String realmPath = handlerIntegerEntry.getValue();
            if (handler.equals(this.handler)) {
                this.sendNotifications();
                continue;
            }
            if (!realmPath.equals(this.configuration.getPath()) || handler.hasMessages(14930352) || !handler.getLooper().getThread().isAlive()) continue;
            handler.sendEmptyMessage(14930352);
        }
    }

    public void cancelTransaction() {
        this.checkIfValid();
        this.transaction.rollbackAndContinueAsRead();
    }

    public void executeTransaction(Transaction transaction) {
        if (transaction == null) {
            return;
        }
        this.beginTransaction();
        try {
            transaction.execute(this);
            this.commitTransaction();
        }
        catch (RuntimeException e) {
            this.cancelTransaction();
            throw new RealmException("Error during transaction.", e);
        }
        catch (Error e) {
            this.cancelTransaction();
            throw e;
        }
    }

    public void clear(Class<? extends RealmObject> clazz) {
        this.getTable(clazz).clear();
    }

    Handler getHandler() {
        String realmPath = this.configuration.getPath();
        for (Map.Entry<Handler, String> entry : handlers.entrySet()) {
            if (!entry.getValue().equals(realmPath)) continue;
            return entry.getKey();
        }
        return null;
    }

    long getVersion() {
        if (!this.transaction.hasTable("metadata")) {
            return -1L;
        }
        Table metadataTable = this.transaction.getTable("metadata");
        return metadataTable.getLong(0L, 0L);
    }

    void setVersion(long version) {
        Table metadataTable = this.transaction.getTable("metadata");
        if (metadataTable.getColumnCount() == 0L) {
            metadataTable.addColumn(ColumnType.INTEGER, "version");
            metadataTable.addEmptyRow();
        }
        metadataTable.setLong(0L, 0L, version);
    }

    private <E extends RealmObject> Class<? extends RealmObject> getRealmClassFromObject(E object) {
        if (object.realm != null) {
            return object.getClass().getSuperclass();
        }
        return object.getClass();
    }

    private <E extends RealmObject> E copyOrUpdate(E object, boolean update) {
        return this.configuration.getSchemaMediator().copyOrUpdate(this, object, update, new HashMap<RealmObject, RealmObjectProxy>());
    }

    private <E extends RealmObject> void checkNotNullObject(E object) {
        if (object == null) {
            throw new IllegalArgumentException("Null objects cannot be copied into Realm.");
        }
    }

    private <E extends RealmObject> void checkHasPrimaryKey(E object) {
        Class<?> objectClass = object.getClass();
        if (!this.getTable(objectClass).hasPrimaryKey()) {
            throw new IllegalArgumentException("RealmObject has no @PrimaryKey defined: " + objectClass.getSimpleName());
        }
    }

    private void checkHasPrimaryKey(Class<? extends RealmObject> clazz) {
        if (!this.getTable(clazz).hasPrimaryKey()) {
            throw new IllegalArgumentException("A RealmObject with no @PrimaryKey cannot be updated: " + clazz.toString());
        }
    }

    @Deprecated
    public static void migrateRealmAtPath(String realmPath, RealmMigration migration) {
        Realm.migrateRealmAtPath(realmPath, null, migration, true);
    }

    @Deprecated
    public static void migrateRealmAtPath(String realmPath, byte[] key, RealmMigration migration) {
        Realm.migrateRealmAtPath(realmPath, key, migration, true);
    }

    @Deprecated
    public static void migrateRealmAtPath(String realmPath, RealmMigration migration, boolean autoRefresh) {
        Realm.migrateRealmAtPath(realmPath, null, migration, autoRefresh);
    }

    @Deprecated
    public static synchronized void migrateRealmAtPath(String realmPath, byte[] key, RealmMigration migration, boolean autoUpdate) {
        File file = new File(realmPath);
        RealmConfiguration.Builder configuration = new RealmConfiguration.Builder(file.getParentFile()).name(file.getName()).migration(migration);
        if (key != null) {
            configuration.encryptionKey(key);
        }
        Realm.migrateRealm(configuration.build());
    }

    public static synchronized void migrateRealm(RealmConfiguration configuration) {
        Realm.migrateRealm(configuration, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void migrateRealm(RealmConfiguration configuration, RealmMigration migration) {
        if (configuration == null) {
            throw new IllegalArgumentException("RealmConfiguration must be provided");
        }
        if (migration == null && configuration.getMigration() == null) {
            throw new RealmMigrationNeededException(configuration.getPath(), "RealmMigration must be provided");
        }
        RealmMigration realmMigration = migration == null ? configuration.getMigration() : migration;
        Realm realm = null;
        try {
            realm = Realm.createAndValidate(configuration, false, Looper.myLooper() != null);
            realm.beginTransaction();
            realm.setVersion(realmMigration.execute(realm, realm.getVersion()));
            realm.commitTransaction();
        }
        finally {
            if (realm != null) {
                realm.close();
                realmsCache.remove();
            }
        }
    }

    @Deprecated
    public static boolean deleteRealmFile(Context context) {
        return Realm.deleteRealmFile(context, DEFAULT_REALM_NAME);
    }

    @Deprecated
    public static boolean deleteRealmFile(Context context, String fileName) {
        return Realm.deleteRealm(new RealmConfiguration.Builder(context).name(fileName).build());
    }

    public static synchronized boolean deleteRealm(RealmConfiguration configuration) {
        boolean realmDeleted = true;
        String id = configuration.getPath();
        AtomicInteger counter = globalOpenInstanceCounter.get(id);
        if (counter != null && counter.get() > 0) {
            throw new IllegalStateException("It's not allowed to delete the file associated with an open Realm. Remember to close() all the instances of the Realm before deleting its file.");
        }
        File realmFolder = configuration.getRealmFolder();
        String realmFileName = configuration.getRealmFileName();
        List<File> filesToDelete = Arrays.asList(new File(configuration.getPath()), new File(realmFolder, realmFileName + ".lock"), new File(realmFolder, realmFileName + ".lock_a"), new File(realmFolder, realmFileName + ".lock_b"), new File(realmFolder, realmFileName + ".log"));
        for (File fileToDelete : filesToDelete) {
            boolean deleteResult;
            if (!fileToDelete.exists() || (deleteResult = fileToDelete.delete())) continue;
            realmDeleted = false;
            RealmLog.w("Could not delete the file " + fileToDelete);
        }
        return realmDeleted;
    }

    @Deprecated
    public static synchronized boolean compactRealmFile(Context context, String fileName) {
        return Realm.compactRealm(new RealmConfiguration.Builder(context).name(fileName).build());
    }

    @Deprecated
    public static boolean compactRealmFile(Context context) {
        return Realm.compactRealm(new RealmConfiguration.Builder(context).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compactRealm(RealmConfiguration configuration) {
        if (configuration.getEncryptionKey() != null) {
            throw new IllegalArgumentException("Cannot currently compact an encrypted Realm.");
        }
        String canonicalPath = configuration.getPath();
        AtomicInteger openInstances = globalOpenInstanceCounter.get(canonicalPath);
        if (openInstances != null && openInstances.get() > 0) {
            throw new IllegalStateException("Cannot compact an open Realm");
        }
        SharedGroup sharedGroup = null;
        boolean result = false;
        try {
            sharedGroup = new SharedGroup(canonicalPath, false, SharedGroup.Durability.FULL, configuration.getEncryptionKey());
            result = sharedGroup.compact();
        }
        finally {
            if (sharedGroup != null) {
                sharedGroup.close();
            }
        }
        return result;
    }

    public String getPath() {
        return this.configuration.getPath();
    }

    public RealmConfiguration getConfiguration() {
        return this.configuration;
    }

    static String getCanonicalPath(File realmFile) {
        try {
            return realmFile.getCanonicalPath();
        }
        catch (IOException e) {
            throw new RealmException("Could not resolve the canonical path to the Realm file: " + realmFile.getAbsolutePath());
        }
    }

    public static Object getDefaultModule() {
        String moduleName = "io.realm.DefaultRealmModule";
        try {
            Class<?> clazz = Class.forName(moduleName);
            Constructor<?> constructor = clazz.getDeclaredConstructors()[0];
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            throw new RealmException("Could not create an instance of " + moduleName, e);
        }
        catch (InstantiationException e) {
            throw new RealmException("Could not create an instance of " + moduleName, e);
        }
        catch (IllegalAccessException e) {
            throw new RealmException("Could not create an instance of " + moduleName, e);
        }
    }

    static {
        defaultDurability = SharedGroup.Durability.FULL;
        RealmLog.add(new ReleaseAndroidLogger());
    }

    public static interface Transaction {
        public void execute(Realm var1);
    }

    private class RealmCallback
    implements Handler.Callback {
        private RealmCallback() {
        }

        public boolean handleMessage(Message message) {
            if (message.what == 14930352) {
                Realm.this.transaction.advanceRead();
                Realm.this.sendNotifications();
            }
            return true;
        }
    }
}

