/*
 * Decompiled with CFR 0.152.
 */
package io.realm.processor;

import io.realm.processor.ClassMetaData;
import io.realm.processor.Utils;
import io.realm.processor.javawriter.JavaWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.tools.JavaFileObject;

public class RealmJSonImplGenerator {
    private final ProcessingEnvironment processingEnvironment;
    private List<String> qualifiedModelClasses = new ArrayList<String>();
    private List<String> simpleModelClasses = new ArrayList<String>();
    private List<String> proxyClasses = new ArrayList<String>();
    private static final String REALM_PACKAGE_NAME = "io.realm";
    private static final String CLASS_NAME = "RealmJsonImpl";
    private static final String EXCEPTION_MSG = "Could not find the generated proxy class for ";

    public RealmJSonImplGenerator(ProcessingEnvironment processingEnv, Set<ClassMetaData> classesToValidate) {
        this.processingEnvironment = processingEnv;
        for (ClassMetaData metadata : classesToValidate) {
            this.qualifiedModelClasses.add(metadata.getFullyQualifiedClassName());
            this.simpleModelClasses.add(metadata.getSimpleClassName());
            this.proxyClasses.add(Utils.getProxyClassName(metadata.getSimpleClassName()));
        }
    }

    public void generate() throws IOException {
        String qualifiedGeneratedClassName = String.format("%s.%s", REALM_PACKAGE_NAME, CLASS_NAME);
        JavaFileObject sourceFile = this.processingEnvironment.getFiler().createSourceFile(qualifiedGeneratedClassName, new Element[0]);
        JavaWriter writer = new JavaWriter(new BufferedWriter(sourceFile.openWriter()));
        writer.setIndent("    ");
        writer.emitPackage(REALM_PACKAGE_NAME);
        writer.emitEmptyLine();
        writer.emitImports("android.util.JsonReader", "io.realm.exceptions.RealmException", "io.realm.internal.RealmJson", "java.io.IOException", "java.util.ArrayList", "java.util.Collections", "java.util.List", "org.json.JSONException", "org.json.JSONObject");
        writer.emitImports(this.qualifiedModelClasses);
        writer.emitEmptyLine();
        writer.beginType(qualifiedGeneratedClassName, "class", Collections.<Modifier>emptySet(), null, "RealmJson");
        writer.emitEmptyLine();
        this.emitCreateOrUpdateUsingJsonObject(writer);
        this.emitCreateUsingJsonStream(writer);
        writer.endType();
        writer.close();
    }

    private void emitCreateOrUpdateUsingJsonObject(JavaWriter writer) throws IOException {
        writer.emitAnnotation("Override");
        writer.beginMethod("<E extends RealmObject> E", "createOrUpdateUsingJsonObject", EnumSet.of(Modifier.PUBLIC), Arrays.asList("Class<E>", "clazz", "Realm", "realm", "JSONObject", "json", "boolean", "update"), Arrays.asList("JSONException"));
        this.emitProxySwitch("return (E) %s.createOrUpdateUsingJsonObject(realm, json, update)", writer);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitCreateUsingJsonStream(JavaWriter writer) throws IOException {
        writer.emitAnnotation("Override");
        writer.beginMethod("<E extends RealmObject> E", "createUsingJsonStream", EnumSet.of(Modifier.PUBLIC), Arrays.asList("Class<E>", "clazz", "Realm", "realm", "JsonReader", "reader"), Arrays.asList("IOException"));
        this.emitProxySwitch("return (E) %s.createUsingJsonStream(realm, reader)", writer);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitProxySwitch(String proxyStatement, JavaWriter writer) throws IOException {
        if (this.simpleModelClasses.size() == 0) {
            writer.emitStatement("throw new RealmException(\"%s\" + clazz)", EXCEPTION_MSG);
        } else {
            writer.beginControlFlow("if (clazz.equals(%s.class))", this.simpleModelClasses.get(0));
            writer.emitStatement(proxyStatement, this.proxyClasses.get(0));
            for (int i = 1; i < this.simpleModelClasses.size(); ++i) {
                writer.nextControlFlow("else if (clazz.equals(%s.class))", this.simpleModelClasses.get(i));
                writer.emitStatement(proxyStatement, this.proxyClasses.get(i));
            }
            writer.nextControlFlow("else", new Object[0]);
            writer.emitStatement("throw new RealmException(\"%s\" + clazz)", EXCEPTION_MSG);
            writer.endControlFlow();
        }
    }
}

