/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal.android;

import android.util.Log;
import io.realm.internal.log.Logger;

public class AndroidLogger
implements Logger {
    private static final int LOG_ENTRY_MAX_LENGTH = 4000;
    private int minimumLogLevel = 2;
    private String logTag = "REALM";

    public void setTag(String tag) {
        this.logTag = tag;
    }

    public void setMinimumLogLevel(int logLevel) {
        this.minimumLogLevel = logLevel;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void log(int logLevel, String message, Throwable t) {
        if (logLevel < this.minimumLogLevel) {
            return;
        }
        if (message == null || message.length() == 0) {
            if (t == null) return;
            message = Log.getStackTraceString((Throwable)t);
        } else if (t != null) {
            message = message + "\n" + Log.getStackTraceString((Throwable)t);
        }
        if (message.length() < 4000) {
            Log.println((int)logLevel, (String)this.logTag, (String)message);
            return;
        } else {
            this.logMessageIgnoringLimit(logLevel, this.logTag, message);
        }
    }

    private void logMessageIgnoringLimit(int logLevel, String tag, String message) {
        while (message.length() != 0) {
            int nextNewLineIndex = message.indexOf(10);
            int chunkLength = nextNewLineIndex != -1 ? nextNewLineIndex : message.length();
            chunkLength = Math.min(chunkLength, 4000);
            String messageChunk = message.substring(0, chunkLength);
            Log.println((int)logLevel, (String)tag, (String)messageChunk);
            if (nextNewLineIndex != -1 && nextNewLineIndex == chunkLength) {
                message = message.substring(chunkLength + 1);
                continue;
            }
            message = message.substring(chunkLength);
        }
    }

    @Override
    public void v(String message) {
        this.log(2, message, null);
    }

    @Override
    public void v(String message, Throwable t) {
        this.log(2, message, t);
    }

    @Override
    public void d(String message) {
        this.log(3, message, null);
    }

    @Override
    public void d(String message, Throwable t) {
        this.log(3, message, t);
    }

    @Override
    public void i(String message) {
        this.log(4, message, null);
    }

    @Override
    public void i(String message, Throwable t) {
        this.log(4, message, t);
    }

    @Override
    public void w(String message) {
        this.log(5, message, null);
    }

    @Override
    public void w(String message, Throwable t) {
        this.log(5, message, t);
    }

    @Override
    public void e(String message) {
        this.log(6, message, null);
    }

    @Override
    public void e(String message, Throwable t) {
        this.log(6, message, t);
    }
}

