/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.internal.ColumnType;
import io.realm.internal.IllegalMixedTypeException;
import java.nio.ByteBuffer;
import java.util.Date;

public class Mixed {
    public static final int BINARY_TYPE_BYTE_ARRAY = 0;
    public static final int BINARY_TYPE_BYTE_BUFFER = 1;
    private Object value;

    public Mixed(long value) {
        this.value = value;
    }

    public Mixed(float value) {
        this.value = Float.valueOf(value);
    }

    public Mixed(double value) {
        this.value = value;
    }

    public Mixed(ColumnType columnType) {
        if (columnType == null || columnType == ColumnType.TABLE) {
            throw new AssertionError();
        }
        this.value = null;
    }

    public Mixed(boolean value) {
        this.value = value ? Boolean.TRUE : Boolean.FALSE;
    }

    public Mixed(Date value) {
        assert (value != null);
        this.value = value;
    }

    public Mixed(String value) {
        assert (value != null);
        this.value = value;
    }

    public Mixed(ByteBuffer value) {
        assert (value != null);
        this.value = value;
    }

    public Mixed(byte[] value) {
        assert (value != null);
        this.value = value;
    }

    public boolean equals(Object second) {
        if (second == null) {
            return false;
        }
        if (!(second instanceof Mixed)) {
            return false;
        }
        Mixed secondMixed = (Mixed)second;
        if (this.value == null) {
            return secondMixed.value == null;
        }
        if (!this.getType().equals((Object)secondMixed.getType())) {
            return false;
        }
        if (this.value instanceof byte[]) {
            if (!(secondMixed.value instanceof byte[])) {
                return false;
            }
            byte[] firstBytes = (byte[])this.value;
            byte[] secondBytes = (byte[])secondMixed.value;
            if (firstBytes.length != secondBytes.length) {
                return false;
            }
            for (int i = 0; i < firstBytes.length; ++i) {
                if (firstBytes[i] == secondBytes[i]) continue;
                return false;
            }
            return true;
        }
        if (this.value instanceof ByteBuffer) {
            ByteBuffer firstByteBuffer = (ByteBuffer)this.value;
            ByteBuffer secondByteBuffer = (ByteBuffer)secondMixed.value;
            if (firstByteBuffer.capacity() != secondByteBuffer.capacity()) {
                return false;
            }
            for (int i = 0; i < firstByteBuffer.capacity(); ++i) {
                if (firstByteBuffer.get(i) == secondByteBuffer.get(i)) continue;
                return false;
            }
            return true;
        }
        return this.value.equals(secondMixed.value);
    }

    public ColumnType getType() {
        if (this.value == null) {
            return ColumnType.TABLE;
        }
        if (this.value instanceof String) {
            return ColumnType.STRING;
        }
        if (this.value instanceof Long) {
            return ColumnType.INTEGER;
        }
        if (this.value instanceof Float) {
            return ColumnType.FLOAT;
        }
        if (this.value instanceof Double) {
            return ColumnType.DOUBLE;
        }
        if (this.value instanceof Date) {
            return ColumnType.DATE;
        }
        if (this.value instanceof Boolean) {
            return ColumnType.BOOLEAN;
        }
        if (this.value instanceof ByteBuffer || this.value instanceof byte[]) {
            return ColumnType.BINARY;
        }
        throw new IllegalStateException("Unknown column type!");
    }

    public static Mixed mixedValue(Object value) {
        if (value instanceof String) {
            return new Mixed((String)value);
        }
        if (value instanceof Long) {
            return new Mixed((Long)value);
        }
        if (value instanceof Integer) {
            return new Mixed(((Integer)value).longValue());
        }
        if (value instanceof Boolean) {
            return new Mixed((Boolean)value);
        }
        if (value instanceof Float) {
            return new Mixed(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return new Mixed((Double)value);
        }
        if (value instanceof Date) {
            return new Mixed((Date)value);
        }
        if (value instanceof ByteBuffer) {
            return new Mixed((ByteBuffer)value);
        }
        if (value instanceof byte[]) {
            return new Mixed((byte[])value);
        }
        if (value instanceof Mixed) {
            return (Mixed)value;
        }
        throw new IllegalArgumentException("The value is of unsupported type: " + value.getClass());
    }

    public long getLongValue() {
        if (!(this.value instanceof Long)) {
            throw new IllegalMixedTypeException("Can't get a long from a Mixed containg a " + (Object)((Object)this.getType()));
        }
        return (Long)this.value;
    }

    public boolean getBooleanValue() {
        if (!(this.value instanceof Boolean)) {
            throw new IllegalMixedTypeException("Can't get a boolean from a Mixed containg a " + (Object)((Object)this.getType()));
        }
        return (Boolean)this.value;
    }

    public float getFloatValue() {
        if (!(this.value instanceof Float)) {
            throw new IllegalMixedTypeException("Can't get a float from a Mixed containg a " + (Object)((Object)this.getType()));
        }
        return ((Float)this.value).floatValue();
    }

    public double getDoubleValue() {
        if (!(this.value instanceof Double)) {
            throw new IllegalMixedTypeException("Can't get a double from a Mixed containg a " + (Object)((Object)this.getType()));
        }
        return (Double)this.value;
    }

    public String getStringValue() {
        if (!(this.value instanceof String)) {
            throw new IllegalMixedTypeException("Can't get a String from a Mixed containg a " + (Object)((Object)this.getType()));
        }
        return (String)this.value;
    }

    public Date getDateValue() {
        if (!(this.value instanceof Date)) {
            throw new IllegalMixedTypeException("Can't get a Date from a Mixed containg a " + (Object)((Object)this.getType()));
        }
        return (Date)this.value;
    }

    protected long getDateTimeValue() {
        return this.getDateValue().getTime();
    }

    public ByteBuffer getBinaryValue() {
        if (!(this.value instanceof ByteBuffer)) {
            throw new IllegalMixedTypeException("Can't get a ByteBuffer from a Mixed containg a " + (Object)((Object)this.getType()));
        }
        return (ByteBuffer)this.value;
    }

    public byte[] getBinaryByteArray() {
        if (!(this.value instanceof byte[])) {
            throw new IllegalMixedTypeException("Can't get a byte[] from a Mixed containg a " + (Object)((Object)this.getType()));
        }
        return (byte[])this.value;
    }

    public int getBinaryType() {
        if (this.value instanceof byte[]) {
            return 0;
        }
        if (this.value instanceof ByteBuffer) {
            return 1;
        }
        return -1;
    }

    public Object getValue() {
        return this.value;
    }

    public String getReadableValue() {
        ColumnType type = this.getType();
        try {
            switch (type) {
                case BINARY: {
                    return "Binary";
                }
                case BOOLEAN: {
                    return String.valueOf(this.getBooleanValue());
                }
                case DATE: {
                    return String.valueOf(this.getDateValue());
                }
                case DOUBLE: {
                    return String.valueOf(this.getDoubleValue());
                }
                case FLOAT: {
                    return String.valueOf(this.getFloatValue());
                }
                case INTEGER: {
                    return String.valueOf(this.getLongValue());
                }
                case STRING: {
                    return String.valueOf(this.getStringValue());
                }
                case TABLE: {
                    return "Subtable";
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "ERROR";
    }
}

