/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.internal.Group;
import io.realm.internal.Row;
import io.realm.internal.SharedGroup;
import io.realm.internal.Table;
import io.realm.internal.TableQuery;
import io.realm.internal.TableView;
import java.util.ArrayList;
import java.util.List;

class Context {
    private List<Long> abandonedTables = new ArrayList<Long>();
    private List<Long> abandonedTableViews = new ArrayList<Long>();
    private List<Long> abandonedQueries = new ArrayList<Long>();
    private List<Long> abandonedRows = new ArrayList<Long>();
    private boolean isFinalized = false;

    Context() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeDelayedDisposal() {
        Context context = this;
        synchronized (context) {
            for (long nativePointer : this.abandonedTables) {
                Table.nativeClose(nativePointer);
            }
            this.abandonedTables.clear();
            for (long nativePointer : this.abandonedRows) {
                Row.nativeClose(nativePointer);
            }
            this.abandonedRows.clear();
            for (long nativePointer : this.abandonedTableViews) {
                TableView.nativeClose(nativePointer);
            }
            this.abandonedTableViews.clear();
            for (long nativePointer : this.abandonedQueries) {
                TableQuery.nativeClose(nativePointer);
            }
            this.abandonedQueries.clear();
        }
    }

    public void asyncDisposeTable(long nativePointer, boolean isRoot) {
        if (isRoot || this.isFinalized) {
            Table.nativeClose(nativePointer);
        } else {
            this.abandonedTables.add(nativePointer);
        }
    }

    public void asyncDisposeRow(long nativePointer) {
        if (this.isFinalized) {
            Row.nativeClose(nativePointer);
        } else {
            this.abandonedRows.add(nativePointer);
        }
    }

    public void asyncDisposeTableView(long nativePointer) {
        if (this.isFinalized) {
            TableView.nativeClose(nativePointer);
        } else {
            this.abandonedTableViews.add(nativePointer);
        }
    }

    public void asyncDisposeQuery(long nativePointer) {
        if (this.isFinalized) {
            TableQuery.nativeClose(nativePointer);
        } else {
            this.abandonedQueries.add(nativePointer);
        }
    }

    public void asyncDisposeGroup(long nativePointer) {
        Group.nativeClose(nativePointer);
    }

    public void asyncDisposeSharedGroup(long nativePointer) {
        SharedGroup.nativeClose(nativePointer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        Context context = this;
        synchronized (context) {
            this.isFinalized = true;
        }
        this.executeDelayedDisposal();
    }
}

