/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.Realm;
import io.realm.RealmObject;
import io.realm.RealmResults;
import io.realm.internal.ColumnType;
import io.realm.internal.LinkView;
import io.realm.internal.Table;
import io.realm.internal.TableQuery;
import io.realm.internal.TableView;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class RealmQuery<E extends RealmObject> {
    private Realm realm;
    private Table table;
    private LinkView view;
    private TableQuery query;
    private Map<String, Long> columns = new HashMap<String, Long>();
    private Class<E> clazz;
    private static final String LINK_NOT_SUPPORTED_METHOD = "'%s' is not supported for link queries";
    public static final boolean CASE_SENSITIVE = true;
    public static final boolean CASE_INSENSITIVE = false;

    public RealmQuery(Realm realm, Class<E> clazz) {
        this.realm = realm;
        this.clazz = clazz;
        this.table = realm.getTable(clazz);
        this.query = this.table.where();
        this.columns = realm.columnIndices.getClassFields(clazz);
    }

    public RealmQuery(RealmResults realmList, Class<E> clazz) {
        this.realm = realmList.getRealm();
        this.clazz = clazz;
        this.table = this.realm.getTable(clazz);
        this.query = realmList.getTable().where();
        this.columns = this.realm.columnIndices.getClassFields(clazz);
    }

    RealmQuery(Realm realm, LinkView view, Class<E> clazz) {
        this.realm = realm;
        this.clazz = clazz;
        this.query = view.where();
        this.view = view;
        this.table = realm.getTable(clazz);
        this.columns = realm.columnIndices.getClassFields(clazz);
    }

    private boolean containsDot(String s) {
        return s.indexOf(46) != -1;
    }

    private String[] splitString(String s) {
        int i;
        int n = 0;
        for (i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != '.') continue;
            ++n;
        }
        String[] arr = new String[n + 1];
        i = 0;
        n = 0;
        int j = s.indexOf(46);
        while (j != -1) {
            arr[n] = s.substring(i, j);
            i = j + 1;
            j = s.indexOf(46, i);
            ++n;
        }
        arr[n] = s.substring(s.lastIndexOf(46) + 1);
        return arr;
    }

    private long[] getColumnIndices(String fieldName, ColumnType fieldType) {
        Table table = this.table;
        if (this.containsDot(fieldName)) {
            String[] names = this.splitString(fieldName);
            long[] columnIndices = new long[names.length];
            for (int i = 0; i < names.length - 1; ++i) {
                long index = table.getColumnIndex(names[i]);
                if (index < 0L) {
                    throw new IllegalArgumentException("Invalid query: " + names[i] + " does not refer to a class.");
                }
                ColumnType type = table.getColumnType(index);
                if (type != ColumnType.LINK && type != ColumnType.LINK_LIST) {
                    throw new IllegalArgumentException("Invalid query: " + names[i] + " does not refer to a class.");
                }
                table = table.getLinkTarget(index);
                columnIndices[i] = index;
            }
            columnIndices[names.length - 1] = table.getColumnIndex(names[names.length - 1]);
            if (fieldType != table.getColumnType(columnIndices[names.length - 1])) {
                throw new IllegalArgumentException(String.format("Field '%s': type mismatch.", names[names.length - 1]));
            }
            return columnIndices;
        }
        if (this.columns.get(fieldName) == null) {
            throw new IllegalArgumentException(String.format("Field '%s' does not exist.", fieldName));
        }
        ColumnType tableColumnType = table.getColumnType(this.columns.get(fieldName));
        if (fieldType != tableColumnType) {
            throw new IllegalArgumentException(String.format("Field '%s': type mismatch. Was %s, expected %s.", new Object[]{fieldName, fieldType, tableColumnType}));
        }
        return new long[]{this.columns.get(fieldName)};
    }

    public RealmQuery<E> isNull(String fieldName) {
        if (this.containsDot(fieldName)) {
            throw new IllegalArgumentException("Checking for null in nested objects is not supported.");
        }
        this.query.isNull(this.columns.get(fieldName));
        return this;
    }

    public RealmQuery<E> isNotNull(String fieldName) {
        return this.beginGroup().not().isNull(fieldName).endGroup();
    }

    public RealmQuery<E> equalTo(String fieldName, String value) {
        return this.equalTo(fieldName, value, true);
    }

    public RealmQuery<E> equalTo(String fieldName, String value, boolean caseSensitive) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.STRING);
        this.query.equalTo(columnIndices, value, caseSensitive);
        return this;
    }

    public RealmQuery<E> equalTo(String fieldName, int value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.INTEGER);
        this.query.equalTo(columnIndices, value);
        return this;
    }

    public RealmQuery<E> equalTo(String fieldName, long value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.INTEGER);
        this.query.equalTo(columnIndices, value);
        return this;
    }

    public RealmQuery<E> equalTo(String fieldName, double value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.DOUBLE);
        this.query.equalTo(columnIndices, value);
        return this;
    }

    public RealmQuery<E> equalTo(String fieldName, float value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.FLOAT);
        this.query.equalTo(columnIndices, value);
        return this;
    }

    public RealmQuery<E> equalTo(String fieldName, boolean value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.BOOLEAN);
        this.query.equalTo(columnIndices, value);
        return this;
    }

    public RealmQuery<E> equalTo(String fieldName, Date value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.DATE);
        this.query.equalTo(columnIndices, value);
        return this;
    }

    public RealmQuery<E> notEqualTo(String fieldName, String value) {
        return this.notEqualTo(fieldName, value, true);
    }

    public RealmQuery<E> notEqualTo(String fieldName, String value, boolean caseSensitive) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.STRING);
        if (columnIndices.length > 1 && !caseSensitive) {
            throw new IllegalArgumentException("Link queries cannot be case insensitive - coming soon.");
        }
        this.query.notEqualTo(columnIndices, value, caseSensitive);
        return this;
    }

    public RealmQuery<E> notEqualTo(String fieldName, int value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.INTEGER);
        this.query.notEqualTo(columnIndices, value);
        return this;
    }

    public RealmQuery<E> notEqualTo(String fieldName, long value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.INTEGER);
        this.query.notEqualTo(columnIndices, value);
        return this;
    }

    public RealmQuery<E> notEqualTo(String fieldName, double value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.DOUBLE);
        this.query.notEqualTo(columnIndices, value);
        return this;
    }

    public RealmQuery<E> notEqualTo(String fieldName, float value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.FLOAT);
        this.query.notEqualTo(columnIndices, value);
        return this;
    }

    public RealmQuery<E> notEqualTo(String fieldName, boolean value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.BOOLEAN);
        this.query.equalTo(columnIndices, !value);
        return this;
    }

    public RealmQuery<E> notEqualTo(String fieldName, Date value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.DATE);
        this.query.notEqualTo(columnIndices, value);
        return this;
    }

    public RealmQuery<E> greaterThan(String fieldName, int value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.INTEGER);
        this.query.greaterThan(columnIndices, value);
        return this;
    }

    public RealmQuery<E> greaterThan(String fieldName, long value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.INTEGER);
        this.query.greaterThan(columnIndices, value);
        return this;
    }

    public RealmQuery<E> greaterThan(String fieldName, double value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.DOUBLE);
        this.query.greaterThan(columnIndices, value);
        return this;
    }

    public RealmQuery<E> greaterThan(String fieldName, float value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.FLOAT);
        this.query.greaterThan(columnIndices, value);
        return this;
    }

    public RealmQuery<E> greaterThan(String fieldName, Date value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.DATE);
        this.query.greaterThan(columnIndices, value);
        return this;
    }

    public RealmQuery<E> greaterThanOrEqualTo(String fieldName, int value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.INTEGER);
        this.query.greaterThanOrEqual(columnIndices, value);
        return this;
    }

    public RealmQuery<E> greaterThanOrEqualTo(String fieldName, long value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.INTEGER);
        this.query.greaterThanOrEqual(columnIndices, value);
        return this;
    }

    public RealmQuery<E> greaterThanOrEqualTo(String fieldName, double value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.DOUBLE);
        this.query.greaterThanOrEqual(columnIndices, value);
        return this;
    }

    public RealmQuery<E> greaterThanOrEqualTo(String fieldName, float value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.FLOAT);
        this.query.greaterThanOrEqual(columnIndices, value);
        return this;
    }

    public RealmQuery<E> greaterThanOrEqualTo(String fieldName, Date value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.DATE);
        this.query.greaterThanOrEqual(columnIndices, value);
        return this;
    }

    public RealmQuery<E> lessThan(String fieldName, int value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.INTEGER);
        this.query.lessThan(columnIndices, value);
        return this;
    }

    public RealmQuery<E> lessThan(String fieldName, long value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.INTEGER);
        this.query.lessThan(columnIndices, value);
        return this;
    }

    public RealmQuery<E> lessThan(String fieldName, double value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.DOUBLE);
        this.query.lessThan(columnIndices, value);
        return this;
    }

    public RealmQuery<E> lessThan(String fieldName, float value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.FLOAT);
        this.query.lessThan(columnIndices, value);
        return this;
    }

    public RealmQuery<E> lessThan(String fieldName, Date value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.DATE);
        this.query.lessThan(columnIndices, value);
        return this;
    }

    public RealmQuery<E> lessThanOrEqualTo(String fieldName, int value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.INTEGER);
        this.query.lessThanOrEqual(columnIndices, value);
        return this;
    }

    public RealmQuery<E> lessThanOrEqualTo(String fieldName, long value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.INTEGER);
        this.query.lessThanOrEqual(columnIndices, value);
        return this;
    }

    public RealmQuery<E> lessThanOrEqualTo(String fieldName, double value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.DOUBLE);
        this.query.lessThanOrEqual(columnIndices, value);
        return this;
    }

    public RealmQuery<E> lessThanOrEqualTo(String fieldName, float value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.FLOAT);
        this.query.lessThanOrEqual(columnIndices, value);
        return this;
    }

    public RealmQuery<E> lessThanOrEqualTo(String fieldName, Date value) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.DATE);
        this.query.lessThanOrEqual(columnIndices, value);
        return this;
    }

    public RealmQuery<E> between(String fieldName, int from, int to) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.INTEGER);
        this.query.between(columnIndices, from, to);
        return this;
    }

    public RealmQuery<E> between(String fieldName, long from, long to) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.INTEGER);
        this.query.between(columnIndices, from, to);
        return this;
    }

    public RealmQuery<E> between(String fieldName, double from, double to) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.DOUBLE);
        this.query.between(columnIndices, from, to);
        return this;
    }

    public RealmQuery<E> between(String fieldName, float from, float to) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.FLOAT);
        this.query.between(columnIndices, from, to);
        return this;
    }

    public RealmQuery<E> between(String fieldName, Date from, Date to) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.DATE);
        this.query.between(columnIndices, from, to);
        return this;
    }

    public RealmQuery<E> contains(String fieldName, String value) {
        return this.contains(fieldName, value, true);
    }

    public RealmQuery<E> contains(String fieldName, String value, boolean caseSensitive) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.STRING);
        this.query.contains(columnIndices, value, caseSensitive);
        return this;
    }

    public RealmQuery<E> beginsWith(String fieldName, String value) {
        return this.beginsWith(fieldName, value, true);
    }

    public RealmQuery<E> beginsWith(String fieldName, String value, boolean caseSensitive) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.STRING);
        this.query.beginsWith(columnIndices, value, caseSensitive);
        return this;
    }

    public RealmQuery<E> endsWith(String fieldName, String value) {
        return this.endsWith(fieldName, value, true);
    }

    public RealmQuery<E> endsWith(String fieldName, String value, boolean caseSensitive) {
        long[] columnIndices = this.getColumnIndices(fieldName, ColumnType.STRING);
        this.query.endsWith(columnIndices, value, caseSensitive);
        return this;
    }

    public RealmQuery<E> beginGroup() {
        this.query.group();
        return this;
    }

    public RealmQuery<E> endGroup() {
        this.query.endGroup();
        return this;
    }

    public RealmQuery<E> or() {
        this.query.or();
        return this;
    }

    public RealmQuery<E> not() {
        this.query.not();
        return this;
    }

    public long sumInt(String fieldName) {
        long columnIndex = this.columns.get(fieldName);
        return this.query.sumInt(columnIndex);
    }

    public double sumDouble(String fieldName) {
        long columnIndex = this.columns.get(fieldName);
        return this.query.sumDouble(columnIndex);
    }

    public double sumFloat(String fieldName) {
        long columnIndex = this.columns.get(fieldName);
        return this.query.sumFloat(columnIndex);
    }

    public double averageInt(String fieldName) {
        long columnIndex = this.columns.get(fieldName);
        return this.query.averageInt(columnIndex);
    }

    public double averageDouble(String fieldName) {
        long columnIndex = this.columns.get(fieldName);
        return this.query.averageDouble(columnIndex);
    }

    public double averageFloat(String fieldName) {
        long columnIndex = this.columns.get(fieldName);
        return this.query.averageFloat(columnIndex);
    }

    public long minimumInt(String fieldName) {
        long columnIndex = this.columns.get(fieldName);
        return this.query.minimumInt(columnIndex);
    }

    public double minimumDouble(String fieldName) {
        long columnIndex = this.columns.get(fieldName);
        return this.query.minimumDouble(columnIndex);
    }

    public float minimumFloat(String fieldName) {
        long columnIndex = this.columns.get(fieldName);
        return this.query.minimumFloat(columnIndex);
    }

    public Date minimumDate(String fieldName) {
        long columnIndex = this.columns.get(fieldName);
        return this.query.minimumDate(columnIndex);
    }

    public long maximumInt(String fieldName) {
        long columnIndex = this.columns.get(fieldName);
        return this.query.maximumInt(columnIndex);
    }

    public double maximumDouble(String fieldName) {
        long columnIndex = this.columns.get(fieldName);
        return this.query.maximumDouble(columnIndex);
    }

    public float maximumFloat(String fieldName) {
        long columnIndex = this.columns.get(fieldName);
        return this.query.maximumFloat(columnIndex);
    }

    public Date maximumDate(String fieldName) {
        long columnIndex = this.columns.get(fieldName);
        return this.query.maximumDate(columnIndex);
    }

    public long count() {
        return this.query.count();
    }

    public RealmResults<E> findAll() {
        return new RealmResults<E>(this.realm, this.query.findAll(), this.clazz);
    }

    public RealmResults<E> findAllSorted(String fieldName, boolean sortAscending) {
        TableView tableView = this.query.findAll();
        TableView.Order order = sortAscending ? TableView.Order.ascending : TableView.Order.descending;
        Long columnIndex = this.columns.get(fieldName);
        if (columnIndex == null || columnIndex < 0L) {
            throw new IllegalArgumentException(String.format("Field name '%s' does not exist.", fieldName));
        }
        tableView.sort(columnIndex, order);
        return new RealmResults<E>(this.realm, tableView, this.clazz);
    }

    public RealmResults<E> findAllSorted(String fieldName) {
        return this.findAllSorted(fieldName, true);
    }

    public RealmResults<E> findAllSorted(String[] fieldNames, boolean[] sortAscending) {
        int i;
        if (fieldNames == null) {
            throw new IllegalArgumentException("fieldNames cannot be 'null'.");
        }
        if (sortAscending == null) {
            throw new IllegalArgumentException("sortAscending cannot be 'null'.");
        }
        if (fieldNames.length == 0) {
            throw new IllegalArgumentException("At least one field name must be specified.");
        }
        if (fieldNames.length != sortAscending.length) {
            throw new IllegalArgumentException(String.format("Number of field names (%d) and sort orders (%d) does not match.", fieldNames.length, sortAscending.length));
        }
        if (fieldNames.length == 1 && sortAscending.length == 1) {
            return this.findAllSorted(fieldNames[0], sortAscending[0]);
        }
        TableView tableView = this.query.findAll();
        ArrayList<Long> columnIndices = new ArrayList<Long>();
        ArrayList<TableView.Order> orders = new ArrayList<TableView.Order>();
        for (i = 0; i < fieldNames.length; ++i) {
            String fieldName = fieldNames[i];
            Long columnIndex = this.columns.get(fieldName);
            if (columnIndex == null || columnIndex < 0L) {
                throw new IllegalArgumentException(String.format("Field name '%s' does not exist.", fieldName));
            }
            columnIndices.add(columnIndex);
        }
        for (i = 0; i < sortAscending.length; ++i) {
            orders.add(sortAscending[i] ? TableView.Order.ascending : TableView.Order.descending);
        }
        tableView.sort(columnIndices, orders);
        return new RealmResults<E>(this.realm, tableView, this.clazz);
    }

    public RealmResults<E> findAllSorted(String fieldName1, boolean sortAscending1, String fieldName2, boolean sortAscending2) {
        return this.findAllSorted(new String[]{fieldName1, fieldName2}, new boolean[]{sortAscending1, sortAscending2});
    }

    public RealmResults<E> findAllSorted(String fieldName1, boolean sortAscending1, String fieldName2, boolean sortAscending2, String fieldName3, boolean sortAscending3) {
        return this.findAllSorted(new String[]{fieldName1, fieldName2, fieldName3}, new boolean[]{sortAscending1, sortAscending2, sortAscending3});
    }

    public E findFirst() {
        long rowIndex = this.query.find();
        if (rowIndex >= 0L) {
            return this.realm.get(this.clazz, this.view != null ? this.view.getTargetRowIndex(rowIndex) : rowIndex);
        }
        return null;
    }
}

